//#preprocess
/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.component.SeparatorField;

import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.system.Bitmap;

import org.bbweather.data.ForecastData;
import org.bbweather.data.WindData;

import org.bbutils.ColorLabelField;

import net.rim.device.api.system.Display;
import net.rim.device.api.ui.Graphics;
//JDE 4.6 import net.rim.device.api.ui.decor.Background;
//JDE 4.6 import net.rim.device.api.ui.decor.BackgroundFactory;
import net.rim.device.api.system.Characters;

//#ifdef OS_COMPILE_ATLEAST_4_70
import net.rim.device.api.ui.FieldChangeListener;
//#endif

public class ForecastScreen extends AbstractWeatherScreen {

    private static final int MAX_FORECAST_DAYS = 10;

    private static ForecastScreen screen = null;

    private VerticalFieldManager forecastFieldManager = new VerticalFieldManager()/* {
            // Added 2006-04-16, v0.76
            // Page Up/Down
            protected int nextFocus(int direction, boolean alt) {
                int index = this.getFieldWithFocusIndex();
                if (alt) {
                    /*if(direction > 0) {
                        // Action to perform if trackwheel is rolled up.
                        //forecastData.numberDays
                        //holder.headerField
                        String test;
                        test = "g";
                    }
                    else {
                        // Action to perform if trackwheel is rolled down.
                        String test;
                        test = "g";
                    }*
                    /*int idx = -1;
                    while ((idx = super.nextFocus(direction, alt)) != -1) {
                        Field field = super.getField(idx);
                        if (field instanceof LabelField) {
                            String test;
                            test = "g";
                        }
                    }*
                    int idx = -1;
                    idx = getVerticalScroll();
                    idx = getVirtualHeight();
                    idx = getVisibleHeight();
                    idx = 5;
                    index+=1;
                }
                if (index == this.getFieldWithFocusIndex())
                    return super.nextFocus(direction, alt);
                else
                    return index;
            }
        }*/;

    private ForecastFieldHolder[] forecastFieldHolder = new ForecastFieldHolder[MAX_FORECAST_DAYS];

    private LabelField spacerField1 = null;

    private LabelField spacerField2 = null;

    public static ForecastScreen getInstance() {

        if (screen == null)
            screen = new ForecastScreen();

        return screen;
    }

//#ifdef OS_COMPILE_ATLEAST_4_70
    protected FieldChangeListener button1Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            displayScreen(2); //Hourly
        }
    };
    protected FieldChangeListener button2Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            displayScreen(0); //Current
        }
    };
//#endif

    private ForecastScreen() {
        super();

        setTitle("BBWeather Forecast");

        screenID = 1;
        
//#ifdef OS_COMPILE_ATLEAST_4_70
        button1.setLabel("Hourly");
        button2.setLabel("Current");
        button1.setChangeListener(button1Press);
        button2.setChangeListener(button2Press);
//#endif

        for (int i = 0; i < MAX_FORECAST_DAYS; i++) {
            forecastFieldHolder[i] = getForecastFieldHolder(i % 2 == 0);
        }
    }

    public void cleanup() {
        synchronized (UiApplication.getEventLock()) {
            if (managerRoot != null)
                removeManagerRoot();
            if (defaultFontLess4 != null)
                locationNameField.setFont(defaultFontLess4);
        }
    }

    public void updateData() {
        //System.out.println("*** Updating Forecast display data...");

        ForecastData forecastData = null;

        BBWeatherOptions options = BBWeatherOptions.load(false);
        String locationId = options.getCurrentLocationId();
        if (locationId != null)
            forecastData = WeatherDataManager.getInstance().getForecastByLocationId(locationId);
        //System.out.println("*** locationId=" + locationId + " forcastData=" + forecastData);

        if (forecastData != null) {

            synchronized (UiApplication.getEventLock()) {

                if (!initFonts()) {
                    if (managerRoot != null)
                        removeManagerRoot();
                    locationNameField.setText("Severe Error getting fonts for: " + options.mainFont);
                    return;
                }

                if (managerRoot == null)
                    createManagerRoot(forecastData);

                hideManagerRoot();

                locationNameField.setText(forecastData.locationData.name);
                locationNameField.setFont(defaultFontBold);
                lastUpdateField.setText("Updated " + forecastData.lastUpdate);
                lastUpdateField.setFont(defaultFontLess4);

                // Initialize the forecast day fields
                initForecastManager(forecastData);

                spacerField1.setFont(defaultFontLess4);
                attributionField.setFont(defaultFontLess4);

                displayManagerRoot();
            }

        } else {
            synchronized (UiApplication.getEventLock()) {
                if (managerRoot != null)
                    removeManagerRoot();
                locationNameField.setText("Retrieving Weather, please wait...");
                if (defaultFont != null)
                    locationNameField.setFont(defaultFont);
            }
            WeatherThreadManager.getInstance().forecastForceUpdate();
        }
    }

    /*protected void makeMenu(Menu menu, int instance) {
        super.makeMenu(menu, instance);

        MenuItem item = new MenuItem("Current Conditions", 800000000, 100) {

            public void run() {

            }
        };
        menu.add(item);
        item = new MenuItem("Hourly Conditions", 800000000, 100) {

            public void run() {
                displayHourlyScreen();
            }
        };
        menu.add(item);
        item = new MenuItem("Update Now", 900000000, 100) {

            public void run() {
                WeatherThreadManager.getInstance().forecastForceUpdate();
            }
        };
        menu.add(item);
    }*/

    public void goToField(int idx, boolean down) {
        Manager mgr; // = (Manager)forecastFieldManager.getField(0);
        int start = 0;

        if (idx == 1) {
            //Top
            //mgr = (Manager)managerRoot.getField(0);
            managerRoot.getField(0).setFocus();
        } else if (idx == -1) {
            mgr = (Manager)managerRoot.getField(4);
            mgr.getField(1).setFocus();
        } else {
            int focus = managerRoot.getFieldWithFocusIndex();
            mgr = (Manager)forecastFieldManager.getField(0);

            if (down) {
                //Next
                if (focus == 0)
                    start = 2;
                else if (focus == 4) {
                    managerRoot.getField(0).setFocus();
                    return;
                } else
                    start = mgr.getFieldWithFocusIndex() + 2;

                for (int i = start; i < mgr.getFieldCount() + 10; i++) {
                    if (i >= mgr.getFieldCount()) {
                        ((Manager)managerRoot.getField(4)).getField(1).setFocus();
                        break;
                    } else {
                        Field f = mgr.getField(i);
                        if (f.isFocusable()) {
                            f.setFocus();
                            break;
                        }
                    }
                }
            } else {
                //Previous
                if (focus == 4)
                    start = mgr.getFieldCount() - 2;
                else if (focus == 0) {
                    ((Manager)managerRoot.getField(4)).getField(1).setFocus();
                    return;
                } else
                    start = mgr.getFieldWithFocusIndex() - 1;

                for (int i = start; i >= -10; i--) {
                     if (i < 0) {
                        managerRoot.getField(0).setFocus();
                        break;
                    } else {
                        Field f = mgr.getField(i);
                        if (f.isFocusable()) {
                            f.setFocus();
                            break;
                        }
                    }
                }
            }
        }
    }

    //reorganize function and add shortcut to open hourly screen and next, top, bottom and previous
    protected boolean keyDown(int keycode, int time) {
        if (!isProcessingKey) {
            int iStatus = Keypad.status(keycode);
            char keyChar = Keypad.map(keycode);

            switch (keyChar) {
                case Characters.SPACE:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        WeatherThreadManager.getInstance().forecastForceUpdate();
                    } else {
                        displayScreen(2);
                    }
                    isProcessingKey = false;
                    return true;
                case Characters.COLON:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        displayScreen(2);
                    }/* else {
                    }*/
                    isProcessingKey = false;
                    return true;
                case Characters.DIGIT_NINE:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        displayScreen(0);
                    }/* else {
                    }*/
                    isProcessingKey = false;
                    return true;
                case Characters.LEFT_PARENTHESIS:
                //case Characters.LATIN_CAPITAL_LETTER_T:
                //case Characters.LATIN_SMALL_LETTER_T:
                    isProcessingKey = true;
                    goToField(1, true);
                    isProcessingKey = false;
                    return true;
                case Characters.EXCLAMATION_MARK:
                //case Characters.LATIN_CAPITAL_LETTER_B:
                //case Characters.LATIN_SMALL_LETTER_B:
                    isProcessingKey = true;
                    goToField(-1, false);
                    isProcessingKey = false;
                    return true;
                case Characters.COMMA:
                //case Characters.LATIN_CAPITAL_LETTER_N:
                //case Characters.LATIN_SMALL_LETTER_N:
                    isProcessingKey = true;
                    goToField(0, true);
                    isProcessingKey = false;
                    return true;
                case Characters.COMMERCIAL_AT:
                //case Characters.LATIN_CAPITAL_LETTER_P:
                //case Characters.LATIN_SMALL_LETTER_P:
                    isProcessingKey = true;
                    goToField(0, false);
                    isProcessingKey = false;
                    return true;
                default:
                    break;
            }
        }

        return super.keyDown(keycode, time);
    }

    /*//handle top, bottom, next & previous pages
    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        int idx;
        if (status == 1) {
            switch (key) {
                case Characters.LEFT_PARENTHESIS:
                //case Characters.LATIN_CAPITAL_LETTER_T:
                //case Characters.LATIN_SMALL_LETTER_T:
                    goToField(1, true);
                    return true;
                case Characters.EXCLAMATION_MARK:
                //case Characters.LATIN_CAPITAL_LETTER_B:
                //case Characters.LATIN_SMALL_LETTER_B:
                    goToField(-1, false);
                    return true;
                case Characters.COMMA:
                //case Characters.LATIN_CAPITAL_LETTER_N:
                //case Characters.LATIN_SMALL_LETTER_N:
                    goToField(0, true);
                    return true;
                case Characters.COMMERCIAL_AT:
                //case Characters.LATIN_CAPITAL_LETTER_P:
                //case Characters.LATIN_SMALL_LETTER_P:
                    goToField(0, false);
                    return true;
                case Characters.COLON:
                    displayHourlyScreen();
                    return true;
                default:
                    retval = super.keyChar(key, status, time);
                    break;
            }
        } else {
            retval = super.keyChar(key, status, time);
        }

        return retval;
    }
    */

    /*private void displayCurrentConditionsScreen() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(ForecastScreen.this);
                UiApplication.getUiApplication().pushScreen(CurrentConditionsScreen.getInstance());
                isProcessingKey = false;
            }
        });
    }

    private void displayHourlyScreen() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(ForecastScreen.this);
                //2009-02-20 for some reason, if you are on hourly screen, switch to another app, then switch back to BBWeather
                // it would be on the CurrentConditions Screen or the Forecast Screen and would crash trying to go back to the hourly screen
                if (!HourlyScreen.getInstance().isDisplayed())
                    UiApplication.getUiApplication().pushScreen(HourlyScreen.getInstance());
                isProcessingKey = false;
            }
        });
    }*/

    private void createManagerRoot(ForecastData forecastData) {

        managerRoot = new VerticalFieldManager(VerticalFieldManager.VERTICAL_SCROLL
            | VerticalFieldManager.VERTICAL_SCROLLBAR | VerticalFieldManager.HORIZONTAL_SCROLL) { //added Manager.HORIZONTAL_SCROLL to fix a bug with the Storm that allowed horizontal scroll past edge of page
            // Added 2006-04-16, v0.76
            // Page Up/Down
            protected int nextFocus(int direction, boolean alt) {
                int index = this.getFieldWithFocusIndex();
                if (alt) {
                    /*if(direction > 0) {
                        // Action to perform if trackwheel is rolled up.
                        //forecastData.numberDays
                        //holder.headerField
                        String test;
                        test = "g";
                    }
                    else {
                        // Action to perform if trackwheel is rolled down.
                        String test;
                        test = "g";
                    }*/
                    /*int idx = -1;
                    while ((idx = super.nextFocus(direction, alt)) != -1) {
                        Field field = super.getField(idx);
                        if (field instanceof LabelField) {
                            String test;
                            test = "g";
                        }
                    }*/
                }
                if (index == this.getFieldWithFocusIndex())
                    return super.nextFocus(direction, alt);
                else
                    return index;
            }
        };

        lastUpdateField = new LabelField(null, Field.FOCUSABLE) {
            protected void layout(int width, int height) {
                super.layout(Display.getWidth(), defaultFontLess4Bold.getHeight());
                setExtent(Display.getWidth(), defaultFontLess4Bold.getHeight());
            }
        };// FOCUSABLE NON_FOCUSABLE
        managerRoot.add(lastUpdateField);
        // Just used for spacing
        spacerField1 = new LabelField(" ");
        managerRoot.add(spacerField1);

        // The manager that dynamically handles part info
        managerRoot.add(forecastFieldManager);

        // Just used for spacing
        spacerField2 = new LabelField(" ");
        managerRoot.add(spacerField2);

        managerRoot.add(getAttributionInfo());
    }

    private ForecastFieldHolder getForecastFieldHolder(boolean changeBG) {

        ForecastFieldHolder holder = new ForecastFieldHolder();

        if (changeBG) {
            holder.headerField = new ColorLabelField(null, Field.FOCUSABLE) {
                boolean lostFocus = false;
                protected void layout(int width, int height) {
                    super.layout(Display.getWidth(), defaultFontBold.getHeight());
                    setExtent(Display.getWidth(), defaultFontBold.getHeight());
                }

                protected void onUnfocus() {
                    //Graphics graphics = getGraphics();
                    //graphics.setBackgroundColor(0x00ECECEC); //0x00F0F0F0
                    //graphics.clear();
                    //paint(graphics);
                    lostFocus = true;
                    invalidate();
                }

                public void paint(Graphics graphics) {
                    if (!isFocus() || lostFocus) {
                        lostFocus = false;
                        // Sets the BackgroundColor
                        graphics.setBackgroundColor(0x00ECECEC); //0x00F0F0F0
                        // Clears the entire graphic area to the current background
                        graphics.clear();
                    }

                    super.paint(graphics);
                }
            };
        } else {
            holder.headerField = new ColorLabelField(null, Field.FOCUSABLE) {
                protected void layout(int width, int height) {
                    super.layout(Display.getWidth(), defaultFontBold.getHeight());
                    setExtent(Display.getWidth(), defaultFontBold.getHeight());
                }
            };
        }
        holder.dayPartHolder = getPartFieldHolder("d", changeBG);
        holder.nightPartHolder = getPartFieldHolder("n", changeBG);

        return holder;
    }

    private PartFieldHolder getPartFieldHolder(String dayType, boolean changeBG) {

        PartFieldHolder holder = new PartFieldHolder();

        if (changeBG) {
            holder.manager = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_VCENTER) { //Width
                protected void sublayout(int width, int height) {
                    HorizontalFieldManager mgr1 = (HorizontalFieldManager)getField(0); //managerSummary
                    VerticalFieldManager mgr2 = (VerticalFieldManager)mgr1.getField(0); //manager1
                    RichTextField rf = (RichTextField)mgr2.getField(1);

                    String fieldText = rf.getText();

                    int count = 1;
                    int startIdx = 0;
                    int charIdx = fieldText.indexOf('\n', startIdx);

                    while (charIdx != -1) {
                        count++;
                        startIdx = charIdx + 1;
                        charIdx = fieldText.indexOf('\n', startIdx);
                    }

                    super.sublayout(Display.getWidth(), 36 + defaultFontLess4Bold.getHeight() * count);
                    setExtent(Display.getWidth(), 36 + defaultFontLess4Bold.getHeight() * count);
                }

                public void paint(Graphics graphics) {
                    // Sets the BackgroundColor
                    graphics.setBackgroundColor(0x00ECECEC);
                    // Clears the entire graphic area to the current background
                    graphics.clear();

                    super.paint(graphics);
                }
            };
        } else {
            holder.manager = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_VCENTER) { //Width
                protected void sublayout(int width, int height) {
                    HorizontalFieldManager mgr1 = (HorizontalFieldManager)getField(0); //managerSummary
                    VerticalFieldManager mgr2 = (VerticalFieldManager)mgr1.getField(0); //manager1
                    RichTextField rf = (RichTextField)mgr2.getField(1);

                    String fieldText = rf.getText();

                    int count = 1;
                    int startIdx = 0;
                    int charIdx = fieldText.indexOf('\n', startIdx);

                    while (charIdx != -1) {
                        count++;
                        startIdx = charIdx + 1;
                        charIdx = fieldText.indexOf('\n', startIdx);
                    }

                    super.sublayout(Display.getWidth(), 36 + defaultFontLess4Bold.getHeight() * count);
                    setExtent(Display.getWidth(), 36 + defaultFontLess4Bold.getHeight() * count);
                }
            };
        }

        HorizontalFieldManager managerSummary = new HorizontalFieldManager(Field.FIELD_HCENTER | Field.FIELD_VCENTER);
        VerticalFieldManager manager1 = new VerticalFieldManager(Field.FIELD_VCENTER);
        holder.bitmapField = new BitmapField(null, Field.FIELD_HCENTER);
        manager1.add(holder.bitmapField);
        holder.descriptionField = new RichTextField(null,
                                                    RichTextField.USE_TEXT_WIDTH
                                                    | RichTextField.TEXT_ALIGN_HCENTER
                                                    | Field.FIELD_HCENTER | Field.NON_FOCUSABLE);
        manager1.add(holder.descriptionField);

        VerticalFieldManager manager2 = new VerticalFieldManager(Field.FIELD_VCENTER);
        holder.temperatureField = new ColorLabelField(null, Field.FIELD_HCENTER | Field.NON_FOCUSABLE); // Field.FOCUSABLE
        manager2.add(holder.temperatureField);
        holder.temperatureStaticField = new LabelField((dayType == "d" ? "High"
                : "Low"), Field.FIELD_HCENTER | Field.NON_FOCUSABLE);
        manager2.add(holder.temperatureStaticField);

        managerSummary.add(manager1);
        managerSummary.add(new LabelField(" "));
        managerSummary.add(manager2);

        holder.manager.add(managerSummary);

        // Just used for spacing
        holder.manager.add(new LabelField("  "));

        HorizontalFieldManager managerDetail = new HorizontalFieldManager(Field.FIELD_HCENTER | Field.FIELD_VCENTER);

        VerticalFieldManager manager3 = new VerticalFieldManager(Field.FIELD_VCENTER);
        holder.precipLabelField = new LabelField("Precip: ", Field.FIELD_LEFT);
        manager3.add(holder.precipLabelField);
        holder.windLabelField = new LabelField("Wind: ", Field.FIELD_LEFT);
        manager3.add(holder.windLabelField);
        holder.humidityLabelField = new LabelField("Humidity: ", Field.FIELD_LEFT);
        manager3.add(holder.humidityLabelField);

        VerticalFieldManager manager4 = new VerticalFieldManager(Field.FIELD_VCENTER);
        holder.precipValueField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE); // Field.FOCUSABLE
        manager4.add(holder.precipValueField);
        holder.windValueField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE); // Field.FOCUSABLE
        manager4.add(holder.windValueField);
        holder.humidityValueField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE); // Field.FOCUSABLE
        manager4.add(holder.humidityValueField);

        managerDetail.add(manager3);
        managerDetail.add(manager4);

        holder.manager.add(managerDetail);

        return holder;
    }

    private void initForecastManager(ForecastData forecastData) {

        // Remove previous entries
        if (forecastFieldManager.getFieldCount() > 0)
            ((Manager) forecastFieldManager.getField(0)).deleteAll();
        forecastFieldManager.deleteAll();

        BBWeatherOptions options = BBWeatherOptions.load(false);

        // Create new entries
        VerticalFieldManager manager = new VerticalFieldManager();

        //LabelField spacer1 = null;
        //LabelField spacer2 = null;

        for (int i = 0; i < forecastData.numberDays; i++) {
            ForecastFieldHolder holder = forecastFieldHolder[i];

            if (i == 0) {
                manager.add(new SeparatorField() {
                    protected void layout(int width, int height) {
                        super.layout(Display.getWidth(), getPreferredHeight());
                        setExtent(Display.getWidth(), getPreferredHeight());
                    }
                });
            }

            manager.add(holder.headerField);

            // See if we are past the time to display day data (around 2PM)
            if (!forecastData.dayData[i].hiTemp.equals("N/A")) {
                manager.add(holder.dayPartHolder.manager);

                /*//add sublayout code
                spacer2 = new LabelField(" ") {
                    protected void sublayout(int width, int height) {
                        super.layout(Display.getWidth(), defaultFontLess4.getHeight());
                        setExtent(Display.getWidth(), defaultFontLess4.getHeight());
                    }
                };
                spacer2.setFont(defaultFontLess4);
                manager.add(spacer2);*/
            }
            manager.add(holder.nightPartHolder.manager);
            manager.add(new SeparatorField() {
                protected void layout(int width, int height) {
                    super.layout(Display.getWidth(), getPreferredHeight());
                    setExtent(Display.getWidth(), getPreferredHeight());
                }
            });

            /*//add sublayout code
            spacer1 = new LabelField(" ") {
                protected void sublayout(int width, int height) {
                    super.layout(Display.getWidth(), defaultFontLess4.getHeight());
                    setExtent(Display.getWidth(), defaultFontLess4.getHeight());
                }
            };
            spacer1.setFont(defaultFontLess4);
            manager.add(spacer1);*/

            holder.headerField.setText(forecastData.dayData[i].dayName + " " + forecastData.dayData[i].date);
            //holder.headerField.setColor(options.lowTempColor);
            holder.headerField.setFont(defaultFontBold);

            holder.dayPartHolder.bitmapField.setBitmap(forecastData.dayData[i].dayPartData.bitmap);

            holder.dayPartHolder.descriptionField.setText(stackString(forecastData.dayData[i].dayPartData.description));
            holder.dayPartHolder.descriptionField.setFont(defaultFontLess4Bold);

            holder.dayPartHolder.temperatureField.setText(forecastData.dayData[i].hiTemp
                + forecastData.unitData.temperature);
            holder.dayPartHolder.temperatureField.setFont(defaultFontMore6Bold);
            holder.dayPartHolder.temperatureField.setColor(options.highTempColor);
            holder.dayPartHolder.temperatureStaticField.setFont(defaultFontLess4Bold);

            holder.dayPartHolder.precipLabelField.setFont(defaultFontLess4Bold);
            holder.dayPartHolder.precipValueField.setText(forecastData.dayData[i].dayPartData.precipitation+ "%");
            holder.dayPartHolder.precipValueField.setFont(defaultFontLess4);

            holder.dayPartHolder.windLabelField.setFont(defaultFontLess4Bold);
            WindData windData = forecastData.dayData[i].dayPartData.windData;
            if (windData.speed.equalsIgnoreCase("calm")) {
                holder.dayPartHolder.windValueField.setText(windData.description);
            } else {
                holder.dayPartHolder.windValueField.setText(windData.description
                    + " at " + windData.speed + forecastData.unitData.speed);
            }
            holder.dayPartHolder.windValueField.setFont(defaultFontLess4);

            holder.dayPartHolder.humidityLabelField.setFont(defaultFontLess4Bold);
            holder.dayPartHolder.humidityValueField.setText(forecastData.dayData[i].dayPartData.humidity + "%");
            holder.dayPartHolder.humidityValueField.setFont(defaultFontLess4);

            holder.nightPartHolder.bitmapField.setBitmap(forecastData.dayData[i].nightPartData.bitmap);

            holder.nightPartHolder.descriptionField.setText(stackString(forecastData.dayData[i].nightPartData.description));
            holder.nightPartHolder.descriptionField.setFont(defaultFontLess4Bold);

            holder.nightPartHolder.temperatureField.setText(forecastData.dayData[i].lowTemp
                + forecastData.unitData.temperature);
            holder.nightPartHolder.temperatureField.setFont(defaultFontMore6Bold);
            holder.nightPartHolder.temperatureField.setColor(options.lowTempColor);
            holder.nightPartHolder.temperatureStaticField.setFont(defaultFontLess4Bold);

            holder.nightPartHolder.precipLabelField.setFont(defaultFontLess4Bold);
            holder.nightPartHolder.precipValueField.setText(forecastData.dayData[i].nightPartData.precipitation + "%");
            holder.nightPartHolder.precipValueField.setFont(defaultFontLess4);

            holder.nightPartHolder.windLabelField.setFont(defaultFontLess4Bold);
            windData = forecastData.dayData[i].nightPartData.windData;
            if (windData.speed.equalsIgnoreCase("calm")) {
                holder.nightPartHolder.windValueField.setText(windData.description);
            } else {
                holder.nightPartHolder.windValueField.setText(windData.description
                    + " at " + windData.speed + forecastData.unitData.speed);
            }
            holder.nightPartHolder.windValueField.setFont(defaultFontLess4);

            holder.nightPartHolder.humidityLabelField.setFont(defaultFontLess4Bold);
            holder.nightPartHolder.humidityValueField.setText(forecastData.dayData[i].nightPartData.humidity + "%");
            holder.nightPartHolder.humidityValueField.setFont(defaultFontLess4);

            /*JDE4.6 only if (i % 2 == 0) {
                Background bg;
                bg = BackgroundFactory.createSolidBackground(0x00ECECEC);
                holder.headerField.setBackground(bg);
                holder.dayPartHolder.manager.setBackground(bg);
                holder.nightPartHolder.manager.setBackground(bg);
                spacer1.setBackground(bg);
                if (spacer2 != null)
                    spacer2.setBackground(bg);
            }*/
        }

        forecastFieldManager.add(manager);
    }

    private static class ForecastFieldHolder {

        public ColorLabelField headerField = null;

        public PartFieldHolder dayPartHolder = null;

        public PartFieldHolder nightPartHolder = null;
    }

    private static class PartFieldHolder {

        public Manager manager = null;

        public BitmapField bitmapField = null;

        public RichTextField descriptionField = null;

        public ColorLabelField temperatureField = null;

        public LabelField temperatureStaticField = null;

        public LabelField precipLabelField = null;

        public LabelField windLabelField = null;

        public LabelField humidityLabelField = null;

        public LabelField precipValueField = null;

        public LabelField windValueField = null;

        public LabelField humidityValueField = null;
    }
}
