///////////////////////////////////////////////////////////////////////////
// C++ code generated with wxFormBuilder (version Sep  8 2010)
// http://www.wxformbuilder.org/
//
// PLEASE DO "NOT" EDIT THIS FILE!
///////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>

#include <vector>

#include "DevicesDlg.h"
#include "Utilities.h"

using namespace std;


///////////////////////////////////////////////////////////////////////////

DevicesDlg::DevicesDlg( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxSize( -1,-1 ), wxDefaultSize );
	
	wxBoxSizer* bSizer27;
	bSizer27 = new wxBoxSizer( wxHORIZONTAL );
	
	wxBoxSizer* bSizer28;
	bSizer28 = new wxBoxSizer( wxVERTICAL );
	
	devicesListCtrl = new wxListCtrl( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_HRULES|wxLC_REPORT|wxLC_SINGLE_SEL|wxLC_VRULES );
	bSizer28->Add( devicesListCtrl, 1, wxALL|wxEXPAND, 5 );
	
	bSizer27->Add( bSizer28, 1, wxEXPAND, 5 );
	
	wxBoxSizer* bSizer29;
	bSizer29 = new wxBoxSizer( wxVERTICAL );
	
	okBtn = new wxButton( this, wxID_ANY, wxT("OK"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer29->Add( okBtn, 0, wxALL, 5 );
	
	cancelBtn = new wxButton( this, wxID_ANY, wxT("Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer29->Add( cancelBtn, 0, wxALL, 5 );
	
	bSizer27->Add( bSizer29, 0, wxEXPAND, 5 );
	
	this->SetSizer( bSizer27 );
	this->Layout();
	
	this->Centre( wxBOTH );
	
	// Connect Events
	//devicesListCtrl->Connect( wxEVT_KEY_UP, wxKeyEventHandler( DevicesDlg::OnListKeyUp ), NULL, this );
	devicesListCtrl->Connect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( DevicesDlg::onListItemActive ), NULL, this );
	devicesListCtrl->Connect( wxEVT_COMMAND_LIST_ITEM_DESELECTED, wxListEventHandler( DevicesDlg::onListItemDeselected ), NULL, this );
	devicesListCtrl->Connect( wxEVT_COMMAND_LIST_ITEM_SELECTED, wxListEventHandler( DevicesDlg::onListItemSelected ), NULL, this );
	okBtn->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( DevicesDlg::onOK ), NULL, this );
	cancelBtn->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( DevicesDlg::onCancel ), NULL, this );

	wxRect r = devicesListCtrl->GetRect();
	devicesListCtrl->InsertColumn(0, wxT("Device Name"), wxLIST_FORMAT_LEFT, r.width - 30 - 40 - 80);
	devicesListCtrl->InsertColumn(1, wxT("Drive"), wxLIST_FORMAT_LEFT, 40);
	devicesListCtrl->InsertColumn(2, wxT("Size"), wxLIST_FORMAT_RIGHT, 80);

	okBtn->Enable(false);

	LoadDevicesList();
}

void DevicesDlg::LoadDevicesList()
{
	BOOL bResult;
	DWORD dwResult;
	HANDLE m_hVolume;
	char devPath[MAX_PATH];
	PARTITION_INFORMATION_EX diskInfo;
	STORAGE_DEVICE_NUMBER storageDevNum;
	int count = 0;
	wxString s;

	vector<string> volumeIds;
	vector<int> diskNums;
	vector<int> partNums;

	//Logical Drive Letters
	int bufLen = GetLogicalDriveStrings(0, 0) + 1;
	char* buffer = new char[bufLen];

	bufLen = GetLogicalDriveStrings(bufLen, buffer);

	char* bufPtr = buffer;
	while (bufPtr < buffer + bufLen - 1) {
		if (*bufPtr == L'\0' || bufPtr == buffer) {
			if (*bufPtr == L'\0') {
				++bufPtr;
			}

			UINT driveType = GetDriveType(bufPtr);
			if (driveType != DRIVE_NO_ROOT_DIR) {
				if (driveType == DRIVE_FIXED) {
					m_hVolume = CreateFile(std::string("\\\\.\\" + std::string(bufPtr).substr(0,2)).c_str(), GENERIC_READ,
						FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
						OPEN_EXISTING, FILE_ATTRIBUTE_READONLY,
						NULL);

					if (m_hVolume == INVALID_HANDLE_VALUE) {
						continue;
					}
					if (GetFileType(m_hVolume) != FILE_TYPE_DISK) {
						CloseHandle(m_hVolume);
						continue;
					}

					bResult = DeviceIoControl(m_hVolume, IOCTL_STORAGE_GET_DEVICE_NUMBER, NULL, 0, &storageDevNum, sizeof(storageDevNum), &dwResult, NULL);
					CloseHandle(m_hVolume);

					if (!bResult) {
						continue;
					}

					volumeIds.push_back(std::string(bufPtr).substr(0,2));
					diskNums.push_back(storageDevNum.DeviceNumber);
					partNums.push_back(storageDevNum.PartitionNumber);
				}
			}

			if (bufPtr == buffer) {
				++bufPtr;
			}
		} else {
			++bufPtr;
		}
	}
	
	delete [] buffer;

	
	//Drives and partitions
	for (int i = 0; i < 64; i++) {
		bool foundDrive = false;
		for (int j = 0; j <= 32; j++) {
			_snprintf(devPath, sizeof(devPath), "\\\\?\\GLOBALROOT\\Device\\Harddisk%d\\Partition%d", i, j);
			m_hVolume = CreateFile(devPath, GENERIC_READ,
				FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_READONLY,
				NULL);

			if (m_hVolume == INVALID_HANDLE_VALUE) {
				continue;
			}

			bResult = DeviceIoControl(m_hVolume, IOCTL_DISK_GET_PARTITION_INFO_EX, NULL, 0, &diskInfo, sizeof(diskInfo), &dwResult, NULL);
			CloseHandle(m_hVolume);

			if (!bResult) {
				continue;
			}

			foundDrive = true;

			if (devicesListCtrl->InsertItem(count, wxT("")) == -1) {
				continue;
			}

			devicesListCtrl->SetItem(count, 0, devPath); //&devPath[14]
			devicesListCtrl->SetItem(count, 2, FormatBytes(diskInfo.PartitionLength.QuadPart));

			for (int k = 0; k < diskNums.size(); k++) {
				if (i == diskNums[k] && j == partNums[k]) {
					devicesListCtrl->SetItem(count, 1, volumeIds[k]);
				}
			}
			count++;
		}

		if (foundDrive) {
			if (devicesListCtrl->InsertItem(count, wxT("")) == -1) {
				continue;
			}

			count++;
		}
	}
}

DevicesDlg::~DevicesDlg()
{
	// Disconnect Events
	//devicesListCtrl->Disconnect( wxEVT_KEY_UP, wxKeyEventHandler( DevicesDlg::OnListKeyUp ), NULL, this );
	devicesListCtrl->Disconnect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( DevicesDlg::onListItemActive ), NULL, this );
	devicesListCtrl->Disconnect( wxEVT_COMMAND_LIST_ITEM_DESELECTED, wxListEventHandler( DevicesDlg::onListItemDeselected ), NULL, this );
	devicesListCtrl->Disconnect( wxEVT_COMMAND_LIST_ITEM_SELECTED, wxListEventHandler( DevicesDlg::onListItemSelected ), NULL, this );
	okBtn->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( DevicesDlg::onOK ), NULL, this );
	cancelBtn->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( DevicesDlg::onCancel ), NULL, this );
}

void DevicesDlg::DeleteSelected()
{
	long itemIndex = -1;
 
	vector<int> id;
	for (;;) {
		itemIndex = devicesListCtrl->GetNextItem(itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
		if (itemIndex == -1)
			break;

		id.push_back(itemIndex);
	}

	for (int i = id.size() - 1; i >= 0; i--) {
		devicesListCtrl->DeleteItem(id[i]);
	}
}

void DevicesDlg::OnListKeyUp( wxKeyEvent& event )
{
}

void DevicesDlg::onListItemActive( wxListEvent& event )
{
	if (devicesListCtrl->GetItemText(event.GetIndex()).IsEmpty()) {
		return;
	}

	this->AcceptAndClose();
}


void DevicesDlg::onListItemDeselected( wxListEvent& event )
{
	if (devicesListCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED) == -1) {
		okBtn->Enable(false);
	}
}

void DevicesDlg::onListItemSelected( wxListEvent& event )
{
	if (devicesListCtrl->GetItemText(event.GetIndex()).IsEmpty()) {
		return;
	}

	okBtn->Enable();
}

void DevicesDlg::onOK( wxCommandEvent& event )
{
	this->AcceptAndClose();
}

void DevicesDlg::onCancel( wxCommandEvent& event )
{
	this->Close();
}

void DevicesDlg::onDeleteAll( wxCommandEvent& event )
{
}

void DevicesDlg::onDelete( wxCommandEvent& event )
{
}


