/*
 Legal Notice: Some portions of the source code contained in this file were
 derived from the source code of Encryption for the Masses 2.02a, which is
 Copyright (c) 1998-2000 Paul Le Roux and which is governed by the 'License
 Agreement for Encryption for the Masses'. Modifications and additions to
 the original source code (contained in this file) and all other portions
 of this file are Copyright (c) 2003-2010 TrueCrypt Developers Association
 and are governed by the TrueCrypt License 3.0 the full text of which is
 contained in the file License.txt included in TrueCrypt binary and source
 code distribution packages. */

#ifndef TC_HEADER_DLGCODE
#define TC_HEADER_DLGCODE


#ifdef __cplusplus
extern "C" {
#endif

#include "Common.h"


extern OSVersionEnum nCurrentOS;
extern int CurrentOSMajor;
extern int CurrentOSMinor;
extern int CurrentOSServicePack;
extern BOOL RemoteSession;
extern BOOL UacElevated;


DWORD handleWin32Error ( HWND hwndDlg );
void AbortProcess ( char *stringId );
void AbortProcessSilent ( void );
void InitOSVersionInfo ();
BOOL IsOSAtLeast (OSVersionEnum reqMinOS);
BOOL IsOSVersionAtLeast (OSVersionEnum reqMinOS, int reqMinServicePack);
BOOL Is64BitOs ();
BOOL IsServerOS ();
BOOL IsUacSupported ();
int Info (char *stringId);
int InfoTopMost (char *stringId);
int InfoDirect (const wchar_t *msg);
int Warning (char *stringId);
int WarningTopMost (char *stringId);
int WarningDirect (const wchar_t *warnMsg);
int Error (char *stringId);
int ErrorDirect (const wchar_t *errMsg);
int ErrorTopMost (char *stringId);

#ifdef __cplusplus
}

#include <vector>
#include <string>

std::wstring SingleStringToWide (const std::string &singleString);
std::wstring Utf8StringToWide (const std::string &utf8String);
std::string WideToSingleString (const std::wstring &wideString);
std::string WideToUtf8String (const std::wstring &wideString);
std::string StringToUpperCase (const std::string &str);

#endif // __cplusplus

#endif // TC_HEADER_DLGCODE
