#include <windows.h>

#include "Utilities.h"

int factorial(int num) {
	int val;

	if (num <= 1) {
		return 1;
	}

	val = num * factorial(num - 1);
	return val;
}


wxString FormatBytes(INT64 size)
{
	double val;
	wxString s;

	if (size < 1024LL) {
		val = size;
		s = wxT("B");
	} else {
		val = size / 1024.0;
		if (val < 1024LL) {
			s = wxT("KB");
		} else if (val < 1024LL * 1024LL) {
			val /= (1024LL);
			s = wxT("MB");
		} else if (val < 1024LL * 1024LL * 1024LL) {
			val /= (1024LL * 1024LL);
			s = wxT("GB");
		} else {
			val /= (1024LL * 1024LL * 1024LL);
			s = wxT("TB");
		}
	}

	return wxString::Format(wxT("%.2f %s"), val, s);
}

size_t FileRead(FILE *is, char *buff, int size)
{
	return fread(buff, 1, size, is);
}

unsigned int CountLines(const char *buff, int sz, FILE *is, INT64 byteCount, INT64 curLine, INT64 startLine, INT64 *startByteLoc)
{
	int newlines = 0;
	const char *p = &buff[0];
	for (int i = 0; i < sz; i++) {
		if (p[i] == '\n') {
			newlines++;
			if (newlines + curLine == startLine - 1) {
				*startByteLoc = byteCount - (sz - i - 1);
			}
		}
	}
	return newlines;
}

char *timeFormatted(double sec, char *ret, int width = 8)
{
	//char ret[34];

	if (width < 8) {
		width = 8;
	} else if (width > 32) {
		width = 32;
	}

	INT64 days = INT64(sec / 60 / 60 / 24);
	INT64 hrs = INT64(sec / 60 / 60) % 24;
	INT64 mns = INT64(sec / 60) % 60;
	INT64 scs = INT64(sec) % 60;

	//sprintf(ret, "%*s%02d:%02d:%02d", width - 8, " ", hrs, mns, scs);
	sprintf(ret, "%*I64d:%02I64d:%02I64d:%02I64d", width - 9, days, hrs, mns, scs);
	//sprintf(ret, "%02d:%02d:%02d", hrs, mns, scs);
	//ret[width] = 0;
	return ret;
}

DWORD canAccessFile(char *fileName, bool bReadOnly, TCHAR *szErr)
{
	int openFlags = GENERIC_READ;
	int shareFlags = FILE_SHARE_READ;
	DWORD dwSize = 0, dwHigh = 0;
	if (!bReadOnly) {
		openFlags |= GENERIC_WRITE;
		shareFlags |= FILE_SHARE_WRITE;
	}

	HANDLE hFile = CreateFile(
					   fileName,
					   openFlags,
					   shareFlags,
					   NULL,
					   OPEN_EXISTING,
					   0,
					   NULL);

	if (hFile != INVALID_HANDLE_VALUE) {
		dwSize = GetFileSize(hFile, &dwHigh);
	} else {
		//DWORD dwError = GetLastError();

		/*if (!szErr) {
			szErr = new TCHAR[128];
		}

		if (dwError == ERROR_FILE_NOT_FOUND) {
			_stprintf_s(szErr, 128, _T("File Error: File Not Found"));
		}
		else if (dwError == ERROR_PATH_NOT_FOUND) {
			_stprintf_s(szErr, 128, _T("File Error: Path Not Found"));
		}
		else if (dwError == ERROR_ACCESS_DENIED) {
			_stprintf_s(szErr, 128, _T("File Error: Access Denied"));
		}
		else {
			_stprintf_s(szErr, 128, _T("File Error: Unkown Error"));
		}*/
	}

	CloseHandle(hFile);
	return dwSize;
}
