/***************************************************************
 * Name:      OTFBrutus.h
 * Author:    Josh Harris (tateu@tateu.net)
 * Created:   2010-12-01
 * Copyright: Josh Harris (www.tateu.net)
 * License:
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **************************************************************/

//v7.0a
//v7.0
//v6.3a
//v6.3
//v6.2a
//v6.2
//v6.1a
//v6.1: +Security Tokens
//v6.0a
//v6.0: +Backup Header, -HEADER_SIZE 512, +HEADER_SIZE 64 * 1024
//v5.1a
//v5.1
//v5.0a
//v5.0: +XTS, -LRW, +SHA512, -SHA1, +System Encryption
//v4.3a
//v4.3: -Blowfish, -Cast, -3DES
//v4.2a
//v4.2
//v4.1: +LRW, -CBC
//v4.0: +Keyfiles, +Whirlpool
//v3.1a
//v3.1
//v3.0: +Serpent, +Twofish, +Cascades, +Hidden Volumes
//v2.1a: -IDEA
//v2.1: +RipeMD
//v2.0: +AES
//v1.0:

#ifndef OTFBrutus_H
#define OTFBrutus_H

#include <windows.h>

#define OTF_ERROR					WM_APP + 1
#define OTF_LOG						WM_APP + 2
#define OTF_STATUS					WM_APP + 3

#define BACKUP_H_SIZE_LEGACY		2 * TC_VOLUME_HEADER_SIZE_LEGACY    //Legacy Backup header 512 + 512
#define BACKUP_H_SIZE				2 * TC_VOLUME_HEADER_SIZE //v6.0 and greater backup header 65536 * 2
#define BOOT_ISO_OFFSET				84992   // Location of head in the the rescue disc ISO
#define ISO_SIZE					1835008 // Size of rescue disc iso

#define TC_HASH_COUNT				4
#define TC_MODE_COUNT				3
#define TC_CIPHER_COUNT				7
#define TC_MULTICIPHER_COUNT		7

#define OTF_VOL_TYPE_STD			0
#define OTF_VOL_HIDDEN				1
#define OTF_VOL_BOOT				2
#define OTF_VOL_HIDDEN_LEGACY1		3

#define OTF_RIPEMD160				0
#define OTF_SHA512					1
#define OTF_WHIRLPOOL				2
#define OTF_SHA1					3
#define OTF_ALL_HASHES				-1
#define OTF_CUR_HASHES				-2
#define OTF_DEP_HASHES				-3
#define OTF_HASHES_V50				-4 //v7.0a, v7.0, v6.3a, v6.3, v6.2a, v6.2, v6.1a, v6.1, v6.0a, v6.0, v5.1a, v5.1, v5.0a, v5.0
#define OTF_HASHES_V40				-5 //v4.3a, v4.3, v4.2a, v4.2, v4.1, v4.0
#define OTF_HASHES_V21				-6 //v3.1a, v3.1, v3.0a, v3.0, v2.1a, v2.1
#define OTF_HASHES_V10				-7 //v2.0, v1.0

#define OTF_XTS						0
#define OTF_LRW						1
#define OTF_CBC						2
#define OTF_ALL_MODES				-1
#define OTF_CUR_MODES				-2
#define OTF_DEP_MODES				-3
#define OTF_MODES_V50				-4 //v7.0a, v7.0, v6.3a, v6.3, v6.2a, v6.2, v6.1a, v6.1, v6.0a, v6.0, v5.1a, v5.1, v5.0a, v5.0
#define OTF_MODES_V41				-5 //v4.3a, v4.3, v4.2a, v4.2, v4.1
#define OTF_MODES_V10				-6 //v4.0, v3.1a, v3.1, v3.0a, v3.0, v2.1a, v2.1, v2.0, v1.0

#define OTF_AES						0
#define OTF_SERPENT					1
#define OTF_TWOFISH					2
#define OTF_AES_TWOFISH				3
#define OTF_AES_TWOFISH_SERPENT		4
#define OTF_SERPENT_AES				5
#define OTF_SERPENT_TWOFISH_AES		6
#define OTF_TWOFISH_SERPENT			7
#define OTF_BLOWFISH				8
#define OTF_CAST5					9
#define OTF_DES3					10
#define OTF_AES_BLOWFISH			11
#define OTF_AES_BLOWFISH_SERPENT	12
#define OTF_IDEA					13
#define OTF_ALL_CIPHERS				-1
#define OTF_CUR_CIPHERS				-2
#define OTF_DEP_CIPHERS				-3
#define OTF_CIPHERS_V43				-4 //v7.0a, v7.0, v6.3a, v6.3, v6.2a, v6.2, v6.1a, v6.1, v6.0a, v6.0, v5.1a, v5.1, v5.0a, v5.0, v4.3a, v4.3
#define OTF_CIPHERS_V30				-5 //v4.2a, v4.2, v4.1, v4.0, v3.1a, v3.1, v3.0a, v3.0
#define OTF_CIPHERS_V21				-6 //v2.1a
#define OTF_CIPHERS_V20				-7 //v2.1, v2.0
#define OTF_CIPHERS_V10				-8 //v1.0

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
//
char *timeFormatted(double sec, char *ret, int width);
DWORD canAccessFile(char *fileName, bool bReadOnly, TCHAR *szErr);
void passwordThread(void *arg);
void dictionaryThread(void *arg);
void encryptionThread(void *arg);
void runThread(void *arg);
//
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

#endif // OTFBrutus_H
