/*
 CryptoCC.cpp
 Wrapper library around Crypto++ PKCS5_PBKDF2_HMAC functions for use with OTFBrutus

 Copyright (c) 2010 Josh Harris (tateu)

 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	2010-12-11 - JHH
		* v0.1.0.0 - Original release
*/

#include <windows.h>

#include "CryptoCC.h"

#include "config.h"
#include "cpu.h"
#include "ripemd.h"
#include "sha.h"
#include "whrlpool.h"
#include "pwdbased.h"

USING_NAMESPACE(CryptoPP)
USING_NAMESPACE(std)

#pragma comment(lib,"cryptlib")

/*extern "C" */
void CryptoPP_PKCS5_PBKDF2_HMAC(char *pwd, int pwd_len, char *salt, int salt_len, int iterations, char *dk, int dklen, int hash)
{
	PKCS5_PBKDF2_HMAC<RIPEMD160> pbkdf_rmd160;
	PKCS5_PBKDF2_HMAC<SHA512> pbkdf_sha512;
	PKCS5_PBKDF2_HMAC<Whirlpool> pbkdf_whr;
	PKCS5_PBKDF2_HMAC<SHA1> pbkdf_sha1;

	if (hash == 1)
		pbkdf_rmd160.DeriveKey((byte *)dk, dklen, 0, (byte *)pwd, pwd_len, (byte *)salt, salt_len, iterations);
	else if (hash == 2)
		pbkdf_sha512.DeriveKey((byte *)dk, dklen, 0, (byte *)pwd, pwd_len, (byte *)salt, salt_len, iterations);
	else if (hash == 3)
		pbkdf_whr.DeriveKey((byte *)dk, dklen, 0, (byte *)pwd, pwd_len, (byte *)salt, salt_len, iterations);
	else if (hash == 4)
		pbkdf_sha1.DeriveKey((byte *)dk, dklen, 0, (byte *)pwd, pwd_len, (byte *)salt, salt_len, iterations);
}
