/***************************************************************
 * Name:      OTFBrutusMain.cpp
 * Author:    Josh Harris (tateu@tateu.net)
 * Created:   2010-12-01
 * Copyright: Josh Harris (www.tateu.net)
 * License:
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **************************************************************/

#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include <process.h>
#include <vector>
#include <string>
#include <algorithm>

#include "version.h"
#include "OTFBrutus.h"
#include "OTFBrutusMain.h"
#include "DragDrop.h"
#include "KeyFilesDlg.h"
#include "DevicesDlg.h"

using namespace std;

extern char *OTFFile;
extern bool isRunning;

extern vector<int> user_cipher, user_hash, user_mode;
extern vector<string> keyFiles;
extern bool useKeyFiles;
extern BOOL externalPKCS;

extern string found_pwd;
//INT64 actual_pwds_tried = 0;

extern INT64 idxStart;
extern INT64 idxEnd;

//DWORD dwEvent = 0;
extern int iVolType;
extern BOOL bSuccess;
extern char *pwd_pattern, *dictionary;
//size_t pwd_pattern_len = 0;
//INT64 pwd_count = 0, pwd_count_dict = 0, print_count = 0;
//INT64 pwd_idx = 0, pwd_idx_dict = 0;
//INT64 counter = 0;

//string pwd;
//vector<PWD_PARTS> m_vpwdParts;
//PWD_PARTS pwdParts;
//CHAR_SET charSet;

//DWORD size_MB;

//BOOL bVerbose = FALSE;
extern BOOL bSaveWordList;
extern BOOL bOverwrite;
extern wxString wordListFile;
extern BOOL bComplete;
extern int threads;

extern HANDLE hRunEvent;
extern HANDLE hRunThread;

extern wxString err, logString, status;

HWND hwndMain;

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__WXMAC__)
        wxbuild << _T("-Mac");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}

OTFBrutusFrame::OTFBrutusFrame(wxWindow* parent)
    : GUIFrame(parent)
{
#if wxUSE_STATUSBAR
    //statusBar->SetStatusText(_(""), 0);
    //statusBar->SetStatusText(wxbuildinfo(short_f), 1);
#endif
}

WXLRESULT OTFBrutusFrame::MSWWindowProc(WXUINT nMsg, WXWPARAM wParam, WXLPARAM lParam)
{
	wxString s;

	switch (nMsg) {
		case OTF_ERROR:
			isRunning = false;
			wxMessageBox(err);

			runBtn->Disable();
			WaitForSingleObject(hRunEvent, 1000);
			runBtn->SetLabel(wxT("Start"));
			genWordListBtn->SetLabel(wxT("Save Word List"));
			statusBar->SetStatusText(wxT(""));

			if (OTFFile) {
				delete OTFFile;
				OTFFile = NULL;
			}
			if (pwd_pattern) {
				delete pwd_pattern;
				pwd_pattern = NULL;
			}
			if (dictionary) {
				delete dictionary;
				dictionary = NULL;
			}

			if (hRunEvent) {
				CloseHandle(hRunEvent);
				hRunEvent = NULL;
			}
			//if (hRunThread) {
			//	CloseHandle(hRunThread);
			//	hRunThread = NULL;
			//}

			SetCursor(wxCURSOR_DEFAULT);
			runBtn->Enable();
			break;
		case OTF_LOG:
			//s = statusCtrl->GetValue();
			//s.append(logString);
			//statusCtrl->SetValue(s);
			statusCtrl->AppendText(logString);

			if (bComplete) {
				isRunning = false;
				runBtn->Disable();
				WaitForSingleObject(hRunEvent, 1000);
				runBtn->SetLabel(wxT("Start"));
				genWordListBtn->SetLabel(wxT("Save Word List"));
				statusBar->SetStatusText(wxT(""));
				
				if (OTFFile) {
					delete OTFFile;
					OTFFile = NULL;
				}
				if (pwd_pattern) {
					delete pwd_pattern;
					pwd_pattern = NULL;
				}
				if (dictionary) {
					delete dictionary;
					dictionary = NULL;
				}

				if (hRunEvent) {
					CloseHandle(hRunEvent);
					hRunEvent = NULL;
				}
				//if (hRunThread) {
				//	CloseHandle(hRunThread);
				//	hRunThread = NULL;
				//}

				SetCursor(wxCURSOR_DEFAULT);
				runBtn->Enable();				
			}
			break;
		case OTF_STATUS:
			statusBar->SetStatusText(status);
			break;
		default:
			break;
	}

	return wxFrame::MSWWindowProc(nMsg, wParam, lParam);
}

bool OTFBrutusFrame::init()
{
	SYSTEM_INFO sysinfo;
	GetSystemInfo(&sysinfo);

    //this->SetDropTarget(new DndDialog(this));
    fileNameCtrl->SetDropTarget(new DndDialog(fileNameCtrl));
    passwordCtrl->SetDropTarget(new DndDialog(passwordCtrl));
	passwordCtrl->SetToolTip( wxT("Precomputed word list (This is a plaintext file with one password per line)"));

	/*passwordCtrl->GetToolTip()->SetDelay(100);
	passwordCtrl->GetToolTip()->SetReshow(2500);
	passwordCtrl->GetToolTip()->SetAutoPop(20000);*/

	if (sysinfo.dwNumberOfProcessors <= MAX_THREADS) {
		comboThreads->SetSelection(sysinfo.dwNumberOfProcessors - 1);
	} else {
		comboThreads->SetSelection(MAX_THREADS - 1);
	}

	hashMSelect->Hide();
	isRunning = false;
	hwndMain = (HWND)this->GetHandle();

	sysFixedFont = wxSystemSettings::GetFont(wxSYS_ANSI_FIXED_FONT);
	statusCtrl->SetFont(sysFixedFont);
	statusBar->SetFont(sysFixedFont);

	genWordListBtn->Enable(false);

	wxToolTip *t = passwordCtrl->GetToolTip();
	if (t) {
		HANDLE hwnd = t->GetWindow()->GetHWND();//passwordCtrl->GetHWND();
		::SendMessage((HWND)hwnd, WM_USER + 3, 1, 10);
		::SendMessage((HWND)hwnd, WM_USER + 3, 2, 50000);
		::SendMessage((HWND)hwnd, WM_USER + 3, 3, 10);
	}

	////
	checkRipeMD->SetValue   (true);
	checkSHA512->SetValue   (true);
	checkWhirlpool->SetValue(true);
	checkSHA1->SetValue     (false);

	/*checkRipeMD->Enable     (false);
	checkSHA512->Enable     (false);
	checkWhirlpool->Enable  (false);
	checkSHA1->Enable       (false);*/

	////
	checkXTS->SetValue      (true);
	checkLRW->SetValue      (false);
	checkCBC->SetValue      (false);

	/*checkXTS->Enable       (false);
	checkLRW->Enable       (false);
	checkCBC->Enable       (false);*/

	////
	checkAES->SetValue                 (true);
	checkSerpent->SetValue             (true);
	checkTwofish->SetValue             (true);
	checkAES_Twofish->SetValue         (true);
	checkAES_Twofish_Serpent->SetValue (true);
	checkSerpent_AES->SetValue         (true);
	checkSerpent_Twofish_AES->SetValue (true);
	checkTwofish_Serpent->SetValue     (true);
	checkBlowfish->SetValue            (false);
	checkCast5->SetValue               (false);
	checkDES3->SetValue                (false);
	checkAES_Blowfish->SetValue        (false);
	checkAES_Blowfish_Serpent->SetValue(false);
	checkIDEA->SetValue                (false);

	/*checkAES->Enable                   (false);
	checkSerpent->Enable               (false);
	checkTwofish->Enable               (false);
	checkAES_Twofish->Enable           (false);
	checkAES_Twofish_Serpent->Enable   (false);
	checkSerpent_AES->Enable           (false);
	checkSerpent_Twofish_AES->Enable   (false);
	checkTwofish_Serpent->Enable       (false);
	checkBlowfish->Enable              (false);
	checkCast5->Enable                 (false);
	checkDES3->Enable                  (false);
	checkAES_Blowfish->Enable          (false);
	checkAES_Blowfish_Serpent->Enable  (false);
	checkIDEA->Enable                  (false);*/

	return true;
}

OTFBrutusFrame::~OTFBrutusFrame()
{
}

void OTFBrutusFrame::OnClose(wxCloseEvent &event)
{
    Destroy();
}

void OTFBrutusFrame::OnQuit(wxCommandEvent &event)
{
    Destroy();
}

void OTFBrutusFrame::OnAbout(wxCommandEvent &event)
{
    //wxString msg = wxT(" 2010 Josh Harris (www.tateu.net)"); //wxbuildinfo(long_f);
    //wxMessageBox(msg, _("OTFBrutusGUI v0.1.0.0"));

	wxDialog *dlg;

	dlg = new wxDialog(this, wxID_ANY, wxT("OTFBrutusGUI"), wxDefaultPosition,
					   wxDefaultSize, wxCAPTION | wxSYSTEM_MENU | wxCLOSE_BOX | wxOK | wxCENTRE);

	dlg->SetIcon(wxICON(aaaa));

	wxHyperlinkCtrl *m_hyperlink = new wxHyperlinkCtrl(dlg, NULL, wxT("http://www.tateu.net"), wxT("http://www.tateu.net"));

	wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *sizer1 = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer *sizer2 = new wxBoxSizer(wxVERTICAL);
	wxSizer *buttonSizer = dlg->CreateButtonSizer(wxOK);

	wxSizerFlags flagsBorder2;
	flagsBorder2.DoubleBorder();

	wxStaticBitmap *icon = new wxStaticBitmap(dlg, wxID_ANY, wxICON(aaaa));

	sizer1->Add(icon, 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	sizer1->Add(dlg->CreateTextSizer(wxString::Format(wxT("OTFBrutusGUI v%s"), __FILEVERSION__)),
		0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);

	sizer2->Add(dlg->CreateTextSizer(wxT("2010 Josh Harris")), 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	sizer2->Add(m_hyperlink, 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);

	topsizer->Add(sizer1, flagsBorder2);
	topsizer->Add(sizer2, flagsBorder2);

	if (buttonSizer) {
		topsizer->Add(buttonSizer, wxSizerFlags(flagsBorder2).Center());
	}

	dlg->SetAutoLayout(true);
	dlg->SetSizer(topsizer);

	topsizer->SetSizeHints(dlg);
	topsizer->Fit(dlg);

	dlg->Centre(wxBOTH);

	dlg->ShowModal();
	dlg->Destroy();
}

void OTFBrutusFrame::onOpenFileBtn( wxCommandEvent& event )
{
	wxFileDialog dlg( NULL, wxT("Select a Header File"), wxT(""), wxT(""), wxT("All Files(*.*)|*.*||"), wxOPEN );

	if (dlg.ShowModal() == wxID_OK) {
		fileNameCtrl->SetValue(dlg.GetPath());
	}
}

void OTFBrutusFrame::onOpenDeviceBtn( wxCommandEvent& event )
{
	DevicesDlg *dlg = new DevicesDlg(this);
	dlg->SetIcon(wxICON(aaaa));

	wxRect r = this->GetRect();
	wxPoint p;
	p.x = r.x;
	p.y = r.y;
	dlg->SetPosition(p);

	if (dlg->ShowModal() == wxID_OK) {
		long itemIndex = -1;
 
		for (;;) {
			itemIndex = dlg->devicesListCtrl->GetNextItem(itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
			if (itemIndex == -1)
				break;

			fileNameCtrl->SetValue(dlg->devicesListCtrl->GetItemText(itemIndex));
			break;
		}
	}
}

void OTFBrutusFrame::onDictionaryChoice( wxCommandEvent& event )
{
    int id = ((wxChoice *)event.GetEventObject())->GetSelection();

    if (id == 0) {
		pwdPatternSave = passwordCtrl->GetValue();
		passwordCtrl->SetValue(dictionarySave);
        openDictBtn->Enable(true);
		genWordListBtn->Enable(false);
        //passwordCtrl->DragAcceptFiles(true);
        passwordCtrl->SetDropTarget(new DndDialog(passwordCtrl));
		passwordCtrl->SetToolTip( wxT("Precomputed word list (This is a plaintext file with one password per line)") );
    } else {
		dictionarySave = passwordCtrl->GetValue();
		passwordCtrl->SetValue(pwdPatternSave);
        openDictBtn->Enable(false);
		genWordListBtn->Enable(true);
        //passwordCtrl->DragAcceptFiles(false);
        passwordCtrl->SetDropTarget(NULL);
		//passwordCtrl->SetToolTip( wxT("Password pattern\n  use [] to specify a character pattern type\n    [1234]{2} will build a 2 character pattern using all of the available characters inside the brackets\n      11  12  13  14  21  22  23  34  31  32  33  34  41  42  43  44\n  use () to specify a string pattern type, with each string separated by |\n    (red|blue|black){2} will build a 2 string pattern using all of the available strings inside the parentheses\n      redred  redblue  redblack  bluered  blueblue  blueblack  blackred  blackblue  blackblack\n  If you know the first 16 characters (vUEgSRL745dPr2YM) of your password but forgot the last 4, your pattern might look like this:\n    vUEgSRL745dPr2YM[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789]{4}") );
		passwordCtrl->SetToolTip( wxT("Read the help file OTFBrutusGUI.txt for details") );
    }
}

void OTFBrutusFrame::onAddKeyFiles( wxCommandEvent& event )
{
	keyFilesDlg *dlg = new keyFilesDlg(this);
	dlg->SetIcon(wxICON(aaaa));

	wxRect r = this->GetRect();
	wxPoint p;
	p.x = r.x;
	p.y = r.y;
	dlg->SetPosition(p);

	for (int i = 0; i < keyFiles.size(); i++) {
		dlg->keyFileListCtrl->InsertItem(i, keyFiles[i]);
	}

	if (dlg->ShowModal() == wxID_OK) {
		keyFiles.clear();
		long itemIndex = -1;
 
		for (;;) {
			itemIndex = dlg->keyFileListCtrl->GetNextItem(itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_DONTCARE);
			if (itemIndex == -1)
				break;

			keyFiles.push_back(dlg->keyFileListCtrl->GetItemText(itemIndex).c_str());
		}
	}

	if (keyFiles.size() > 0) {
		sort(keyFiles.begin(), keyFiles.end());
		checkKeyFiles->SetValue(true);
		addKeyFilesBtn->Enable();
	} else {
		checkKeyFiles->SetValue(false);
		addKeyFilesBtn->Enable(false);
	}
}

void OTFBrutusFrame::onKeyFilesCheck( wxCommandEvent& event )
{
	if (checkKeyFiles->GetValue()) {
		onAddKeyFiles(wxCommandEvent(wxEVT_NULL));
	} else {
		addKeyFilesBtn->Enable(false);
	}
}

void OTFBrutusFrame::onOpenDictBtn( wxCommandEvent& event )
{
	wxFileDialog dlg( NULL, wxT("Select a Dictionary File"), wxT(""), wxT(""), wxT("All Files(*.*)|*.*||"), wxOPEN );

	if (dlg.ShowModal() == wxID_OK) {
		passwordCtrl->SetValue(dlg.GetPath());
	}
}

void OTFBrutusFrame::onHashCheck( wxCommandEvent& event )
{
	hashVSelect->SetSelection(hashVSelect->GetCount() - 1);
}

void OTFBrutusFrame::onModeCheck( wxCommandEvent& event )
{
	modeVSelect->SetSelection(modeVSelect->GetCount() - 1);
}

void OTFBrutusFrame::onCipherCheck( wxCommandEvent& event )
{
	encVSelect->SetSelection(encVSelect->GetCount() - 1);
}

void OTFBrutusFrame::onHashVChoice( wxCommandEvent& event )
{
    int id = ((wxChoice *)event.GetEventObject())->GetSelection();

	if (id == idHashV50) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (true);
		checkWhirlpool->SetValue(true);
		checkSHA1->SetValue     (false);
	} else if (id == idHashV40) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(true);
		checkSHA1->SetValue     (true);
	} else if (id == idHashV21) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (true);
	} else if (id == idHashV10) {
		checkRipeMD->SetValue   (false);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (true);
	} else if (id == idHashVAll) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (true);
		checkWhirlpool->SetValue(true);
		checkSHA1->SetValue     (true);
	} else if (id == idHashVCustom) {
		checkRipeMD->SetValue   (false);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (false);
	}

	/*if (id == idHashVCustom) {
		checkRipeMD->SetValue   (false);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (false);

		checkRipeMD->Enable     (true);
		checkSHA512->Enable     (true);
		checkWhirlpool->Enable  (true);
		checkSHA1->Enable       (true);
	} else {
		checkRipeMD->Enable     (false);
		checkSHA512->Enable     (false);
		checkWhirlpool->Enable  (false);
		checkSHA1->Enable       (false);
	}*/
}

void OTFBrutusFrame::onModeVChoice( wxCommandEvent& event )
{
	int id = ((wxChoice *)event.GetEventObject())->GetSelection();

	if (id == idModeV50) {
		checkXTS->SetValue      (true);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (false);
	} else if (id == idModeV41) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (true);
		checkCBC->SetValue      (false);
	} else if (id == idModeV10) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (true);
	} else if (id == idModeVAll) {
		checkXTS->SetValue      (true);
		checkLRW->SetValue      (true);
		checkCBC->SetValue      (true);
	} else if (id == idModeVCustom) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (false);
	}

	/*if (id == idModeVCustom) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (false);

		checkXTS->Enable       (true);
		checkLRW->Enable       (true);
		checkCBC->Enable       (true);
	} else {
		checkXTS->Enable       (false);
		checkLRW->Enable       (false);
		checkCBC->Enable       (false);
	}*/
}

void OTFBrutusFrame::onEncVChoice( wxCommandEvent& event )
{
	int id = ((wxChoice *)event.GetEventObject())->GetSelection();

	if (id == idEncV43) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (true);
		checkTwofish->SetValue             (true);
		checkAES_Twofish->SetValue         (true);
		checkAES_Twofish_Serpent->SetValue (true);
		checkSerpent_AES->SetValue         (true);
		checkSerpent_Twofish_AES->SetValue (true);
		checkTwofish_Serpent->SetValue     (true);
		checkBlowfish->SetValue            (false);
		checkCast5->SetValue               (false);
		checkDES3->SetValue                (false);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);
	} else if (id == idEncV30) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (true);
		checkTwofish->SetValue             (true);
		checkAES_Twofish->SetValue         (true);
		checkAES_Twofish_Serpent->SetValue (true);
		checkSerpent_AES->SetValue         (true);
		checkSerpent_Twofish_AES->SetValue (true);
		checkTwofish_Serpent->SetValue     (true);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (true);
		checkAES_Blowfish_Serpent->SetValue(true);
		checkIDEA->SetValue                (false);
	} else if (id == idEncV21) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);
	} else if (id == idEncV20) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (true);
	} else if (id == idEncV10) {
		checkAES->SetValue                 (false);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (true);
	} else if (id == idEncVAll) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (true);
		checkTwofish->SetValue             (true);
		checkAES_Twofish->SetValue         (true);
		checkAES_Twofish_Serpent->SetValue (true);
		checkSerpent_AES->SetValue         (true);
		checkSerpent_Twofish_AES->SetValue (true);
		checkTwofish_Serpent->SetValue     (true);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (true);
		checkAES_Blowfish_Serpent->SetValue(true);
		checkIDEA->SetValue                (true);
	} else if (id == idEncVCustom) {
		checkAES->SetValue                 (false);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (false);
		checkCast5->SetValue               (false);
		checkDES3->SetValue                (false);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);
	}

	/*if (id == idEncVCustom) {
		checkAES->SetValue                 (false);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (false);
		checkCast5->SetValue               (false);
		checkDES3->SetValue                (false);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);

		checkAES->Enable                   (true);
		checkSerpent->Enable               (true);
		checkTwofish->Enable               (true);
		checkAES_Twofish->Enable           (true);
		checkAES_Twofish_Serpent->Enable   (true);
		checkSerpent_AES->Enable           (true);
		checkSerpent_Twofish_AES->Enable   (true);
		checkTwofish_Serpent->Enable       (true);
		checkBlowfish->Enable              (true);
		checkCast5->Enable                 (true);
		checkDES3->Enable                  (true);
		checkAES_Blowfish->Enable          (true);
		checkAES_Blowfish_Serpent->Enable  (true);
		checkIDEA->Enable                  (true);
	} else {
		checkAES->Enable                   (false);
		checkSerpent->Enable               (false);
		checkTwofish->Enable               (false);
		checkAES_Twofish->Enable           (false);
		checkAES_Twofish_Serpent->Enable   (false);
		checkSerpent_AES->Enable           (false);
		checkSerpent_Twofish_AES->Enable   (false);
		checkTwofish_Serpent->Enable       (false);
		checkBlowfish->Enable              (false);
		checkCast5->Enable                 (false);
		checkDES3->Enable                  (false);
		checkAES_Blowfish->Enable          (false);
		checkAES_Blowfish_Serpent->Enable  (false);
		checkIDEA->Enable                  (false);
	}*/
}

void OTFBrutusFrame::onStart( wxCommandEvent& event )
{
	if (isRunning) {
		isRunning = false;

		SetCursor(wxCURSOR_ARROWWAIT);
		WaitForSingleObject(hRunEvent, 10000);
		SetCursor(wxCURSOR_DEFAULT);

		runBtn->SetLabel(wxT("Start"));
		genWordListBtn->SetLabel(wxT("Save Word List"));
		statusBar->SetStatusText(wxT(""));

		if (OTFFile) {
			delete OTFFile;
			OTFFile = NULL;
		}
		if (pwd_pattern) {
			delete pwd_pattern;
			pwd_pattern = NULL;
		}
		if (dictionary) {
			delete dictionary;
			dictionary = NULL;
		}

		if (hRunEvent) {
			CloseHandle(hRunEvent);
			hRunEvent = NULL;
		}
		//if (hRunThread) {
		//	CloseHandle(hRunThread);
		//	hRunThread = NULL;
		//}
	} else {
		bSaveWordList = event.GetEventObject() == genWordListBtn;

		err.clear();
		logString.clear();
		status.clear();
		user_hash.clear();
		user_mode.clear();
		user_cipher.clear();
		statusCtrl->SetValue(err);

		if (fileNameCtrl->IsEmpty() && !bSaveWordList) {
			wxMessageBox(_("Please select a TrueCrypt file or header"));
			fileNameCtrl->SetFocus();
			return;
		}
		if (passwordCtrl->IsEmpty()) {
			wxMessageBox(_("Please select a dictionary or enter a password pattern"));
			passwordCtrl->SetFocus();
			return;
		}

		wxString s = fileNameCtrl->GetValue();
		OTFFile = new char[s.Length() + 1];
		memcpy(OTFFile, s.c_str(), s.Length());
		OTFFile[s.Length()] = 0;

		externalPKCS = hashMSelect->GetSelection() == 0 ? TRUE : FALSE;

		s = passwordCtrl->GetValue();
		if (dictionarySelect->GetSelection() == 0) {
			dictionary = new char[s.Length() + 1];
			memcpy(dictionary, s.c_str(), s.Length());
			dictionary[s.Length()] = 0;
		} else {
			pwd_pattern = new char[s.Length() + 1];
			memcpy(pwd_pattern, s.c_str(), s.Length());
			pwd_pattern[s.Length()] = 0;
		}

		if (checkRipeMD->GetValue()) {
			user_hash.push_back(OTF_RIPEMD160);
		}
		if (checkSHA512->GetValue()) {
			user_hash.push_back(OTF_SHA512);
		}
		if (checkWhirlpool->GetValue()) {
			user_hash.push_back(OTF_WHIRLPOOL);
		}
		if (checkSHA1->GetValue()) {
			user_hash.push_back(OTF_SHA1);
		}

		if (checkXTS->GetValue()) {
			user_mode.push_back(OTF_XTS);
		}
		if (checkLRW->GetValue()) {
			user_mode.push_back(OTF_LRW);
		}
		if (checkCBC->GetValue()) {
			user_mode.push_back(OTF_CBC);
		}

		if (checkAES->GetValue()) {
			user_cipher.push_back(OTF_AES);
		}
		if (checkSerpent->GetValue()) {
			user_cipher.push_back(OTF_SERPENT);
		}
		if (checkTwofish->GetValue()) {
			user_cipher.push_back(OTF_TWOFISH);
		}
		if (checkAES_Twofish->GetValue()) {
			user_cipher.push_back(OTF_AES_TWOFISH);
		}
		if (checkAES_Twofish_Serpent->GetValue()) {
			user_cipher.push_back(OTF_AES_TWOFISH_SERPENT);
		}
		if (checkSerpent_AES->GetValue()) {
			user_cipher.push_back(OTF_SERPENT_AES);
		}
		if (checkSerpent_Twofish_AES->GetValue()) {
			user_cipher.push_back(OTF_SERPENT_TWOFISH_AES);
		}
		if (checkTwofish_Serpent->GetValue()) {
			user_cipher.push_back(OTF_TWOFISH_SERPENT);
		}
		if (checkBlowfish->GetValue()) {
			user_cipher.push_back(OTF_BLOWFISH);
		}
		if (checkCast5->GetValue()) {
			user_cipher.push_back(OTF_CAST5);
		}
		if (checkDES3->GetValue()) {
			user_cipher.push_back(OTF_DES3);
		}
		if (checkAES_Blowfish->GetValue()) {
			user_cipher.push_back(OTF_AES_BLOWFISH);
		}
		if (checkAES_Blowfish_Serpent->GetValue()) {
			user_cipher.push_back(OTF_AES_BLOWFISH_SERPENT);
		}
		if (checkIDEA->GetValue()) {
			user_cipher.push_back(OTF_IDEA);
		}

		iVolType = volumeTypeSelect->GetCurrentSelection();
		threads = comboThreads->GetCurrentSelection() + 1;
		useKeyFiles = checkKeyFiles->GetValue() && keyFiles.size() > 0;

		idxStart = idxEnd = 0;
		s = startIdxCtrl->GetValue();
		if (s.IsNumber()) {
			idxStart = _atoi64(s.c_str());
		}
		if (idxStart < 1)
			idxStart = 1;

		s = endIdxCtrl->GetValue();
		if (s.IsNumber()) {
			idxEnd = _atoi64(s.c_str());
		}
		if (idxEnd < 0)
			idxEnd = 0;

		if (bSaveWordList) {
			wxFileDialog dlg( NULL, wxT("Select a File to save as"), wxT(""), wxT(""), wxT("Text Files(*.txt)|*.txt||"), wxSAVE);

			if (dlg.ShowModal() == wxID_OK) {
				wordListFile = dlg.GetPath();
				if (wxFileExists(wordListFile)) {
					/* only works in wxWidgets v2.9+
					wxMessageDialog dlg(wxGetActiveWindow(),
						wxT("Overwrite the file? Press Yes\nAppend to the file? Press No\nChoose another file? Press Cancel"),
						wxT("File Exists - Overwrite?"),  wxYES_NO | wxCANCEL | wxICON_EXCLAMATION);
					dlg.se(_("&Overwrite"), _("&Append"));
					int ans = dlg.ShowModal();*/
					int ans = wxMessageBox("Overwrite the file? Press Yes\nAppend to the file? Press No\nChoose another file? Press Cancel",
						"File Exists - Overwrite?", wxYES_NO | wxCANCEL | wxICON_EXCLAMATION);
					if (ans == wxYES) {
						bOverwrite = TRUE;
					} else if (ans == wxNO) {
						bOverwrite = FALSE;
					} else {
						wordListFile = wxT("");
						return;
					}
				}
			} else {
				wordListFile = wxT("");
				return;
			}

			genWordListBtn->SetLabel(wxT("Stop"));
		}

		SetCursor(wxCURSOR_ARROWWAIT);

		hRunEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
			if (hRunEvent == INVALID_HANDLE_VALUE) {
				wxMessageBox(_("Error :: Failed to create Run Thread Event"));
				SetCursor(wxCURSOR_DEFAULT);
				return;
			}
		hRunThread = (HANDLE) _beginthread(runThread, 0, (void*)0);
			if (hRunThread == INVALID_HANDLE_VALUE) {
				wxMessageBox(_("Error :: Failed to create Run Thread"));
				SetCursor(wxCURSOR_DEFAULT);
				return;
			}

		isRunning = true;
		runBtn->SetLabel(wxT("Stop"));
	}
}
