// QTHint.cpp : Defines the entry point for the console application.
//

#include <Windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <tchar.h>

//Quicktime
#include <qtml.h>
#include <movies.h>
#include <QuickTimeComponents.h>
#include <GXMath.h>

OSErr GetMovieInfo(TCHAR *szInputFileName)
{
	OSErr							mErr = noErr;
	Movie							mMovie = NULL;

	Track							mTrack = NULL;
	Media							mMedia = NULL;
	int								mTrackCountV = 0;
	int								mTrackCountA = 0;
	OSType							mMediaType;
	ImageDescriptionHandle			mImageDesc;
	long							mTrackCount;
	float							mMediaSampleDuration;

	MovieAudioExtractionRef			mAudioExtractor;
	AudioStreamBasicDescription		mASBD;
	AudioChannelLayout				*mLayout = NULL;
	UInt32							mSize = 0;


	Str255		mName;
	FSSpec		mInputSpec;
	short		mRefNum = 0;
	long		mFlags = 0;
	int			i, j;

	c2pstrcpy(mName, szInputFileName);
	FSMakeFSSpec(0, 0, mName, &mInputSpec);
	if (mErr != noErr && mErr != fnfErr) {
		_tprintf("\nError with FSMakeFSSpec: err = %d\n\t%s\n", mErr, szInputFileName);
		return mErr;
	}

	mErr = OpenMovieFile(&mInputSpec, &mRefNum, fsRdPerm);
	if(mErr != noErr) {
		_tprintf("\nOpenMovieFile Error: err = %d\n\t%s\n\t%s\n", mErr, szInputFileName, mInputSpec.name);
		return mErr;
	}

	mErr = NewMovieFromFile(&mMovie, mRefNum, nil, nil, newMovieActive, nil);
	if(mErr != noErr) {
		_tprintf("\nNewMovieFromFile Error: err = %d\n\t%s\n\t%s\n", mErr, szInputFileName, mInputSpec.name);
		return mErr;
	}

	mTrackCount = GetMovieTrackCount(mMovie);

	_tprintf("\n%s\n", szInputFileName);
	//_tprintf("\tMovieTimeBase = %d\n", GetMovieTimeBase(mMovie));
	_tprintf("\tMovieDuration = %d\n", GetMovieDuration(mMovie));
	_tprintf("\tMovieTimeScale = %d\n", GetMovieTimeScale(mMovie));
	_tprintf("\tMovieDuration = %0.3f seconds\n", (float)GetMovieDuration(mMovie) / (float)GetMovieTimeScale(mMovie));
	_tprintf("\tMovieRate = %0.3f\n", FixedToFloat(GetMovieRate(mMovie)));
	_tprintf("\tMovie has %d tracks\n", mTrackCount);

	for (i = 1; i <= mTrackCount; i++) {
		mTrack = GetMovieIndTrack(mMovie, i);
		mMedia = GetTrackMedia(mTrack);

		GetMediaHandlerDescription(mMedia, &mMediaType, nil, nil);
		if (1) { //(mMediaType == VideoMediaType || mMediaType == AudioMediaType) {
			if (mMediaType == VideoMediaType) {
				_tprintf("\tTrack %d is Video\n", i);
				mTrackCountV++;
			} else if (mMediaType == SoundMediaType) {
				_tprintf("\tTrack %d is Audio\n", i);
				mTrackCountA++;
			} else {
				_tprintf("\tTrack %d is Unknown\n", i);
			}

			_tprintf("\t  SampleCount = %d\n", GetMediaSampleCount(mMedia));
			_tprintf("\t  TrackDuration = %d\n", GetTrackDuration(mTrack));
			_tprintf("\t  MediaDuration = %d\n", GetMediaDuration(mMedia));
			_tprintf("\t  MediaTimeScale = %d\n", GetMediaTimeScale(mMedia));
			_tprintf("\t  MediaDuration = %0.3f seconds\n", (float)GetMediaDuration(mMedia) / (float)GetMediaTimeScale(mMedia));
			mMediaSampleDuration = (float)GetMediaDecodeDuration(mMedia) / (float)GetMediaSampleCount(mMedia);
			_tprintf("\t  MediaSampleDuration = %f\n", mMediaSampleDuration);
			_tprintf("\t  TrackStartTime = %d\n", GetTrackOffset(mTrack));
			_tprintf("\t  TrackIncrement = %f\n", 
				(float)GetMovieTimeScale(mMovie)
					* mMediaSampleDuration
					/ (float)GetMediaTimeScale(mMedia));

			mImageDesc = (ImageDescriptionHandle)NewHandleClear(sizeof(ImageDescription));
			GetMediaSampleDescription(mMedia, 1, (SampleDescriptionHandle)mImageDesc);

			if (mMediaType == VideoMediaType) {
				_tprintf("\t  Width = %d\n", (**mImageDesc).width);
				_tprintf("\t  Height = %d\n", (**mImageDesc).height);
			}
			_tprintf("\t  Codec = (%c%c%c%c)%s\n",
				(**mImageDesc).cType >> 24 & 0x000000FF,
				(**mImageDesc).cType >> 16 & 0x000000FF,
				(**mImageDesc).cType >>  8 & 0x000000FF,
				(**mImageDesc).cType >>  0 & 0x000000FF,
				(**mImageDesc).name);
			if (mMediaType == VideoMediaType) {
				_tprintf("\t  fps: %0.3f\n", GetMediaTimeScale(mMedia) / mMediaSampleDuration);
			}

			if (mMediaType == SoundMediaType) {
				mErr = MovieAudioExtractionBegin(mMovie, 0, &mAudioExtractor);
				if (mErr != noErr) {
					_tprintf("\t  Unable to get detailed audio info\n");
					continue;
				}

				mErr = MovieAudioExtractionGetPropertyInfo(mAudioExtractor,
					kQTPropertyClass_MovieAudioExtraction_Audio,
					kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
					NULL, &mSize, NULL);
				if (mErr != noErr) {
					_tprintf("\t  Unable to get detailed audio info: mLayout size\n");
				} else {
					// Allocate memory for the channel layout
					mLayout = (AudioChannelLayout *)calloc(1, mSize);
					if (mLayout == nil) {
						_tprintf("\t  Unable to get detailed audio info: mLayout calloc\n");
					} else {
						mErr = MovieAudioExtractionGetProperty(mAudioExtractor,
							kQTPropertyClass_MovieAudioExtraction_Audio,
							kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
							mSize, mLayout, nil);
						if (mErr != noErr) {
							_tprintf("\t  Unable to get detailed audio info: mLayout\n");
						} else {
							_tprintf("\t  Has %d Audio Channels\n",
								AudioChannelLayoutTag_GetNumberOfChannels(mLayout->mChannelLayoutTag));

							//for (j = 0; j < mLayout->mNumberChannelDescriptions; j++) {
				
							//}
						}

						free(mLayout);
					}
				}

				mErr = MovieAudioExtractionGetProperty(mAudioExtractor,
					kQTPropertyClass_MovieAudioExtraction_Audio,
					kQTMovieAudioExtractionAudioPropertyID_AudioStreamBasicDescription,
					sizeof(mASBD), &mASBD, nil);
				if (mErr != noErr) {
					_tprintf("\t  Unable to get detailed audio info: mLayout\n");
				} else {
					_tprintf("\t  SampleCount = %d\n", 
						(int)(mASBD.mSampleRate * (Float64)GetMediaDuration(mMedia) / (Float64)GetMediaTimeScale(mMedia)));
					_tprintf("\t  BitsPerChannel = %d\n", mASBD.mBitsPerChannel);
					_tprintf("\t  BytesPerFrame = %d\n", mASBD.mBytesPerFrame);
					_tprintf("\t  BytesPerPacket = %d\n", mASBD.mBytesPerPacket);
					_tprintf("\t  ChannelsPerFrame = %d\n", mASBD.mChannelsPerFrame);
					_tprintf("\t  FramesPerPacket = %d\n", mASBD.mFramesPerPacket);
					_tprintf("\t  SampleRate = %0.0f\n", mASBD.mSampleRate);
					_tprintf("\t  FormatID = %d\n", mASBD.mFormatID);
				}

				MovieAudioExtractionEnd(mAudioExtractor);
			}

			DisposeHandle((Handle)mImageDesc);
		} else {
			_tprintf("\tTrack %d is Unknown\n", i);
		}
	}

	if (mRefNum)
		CloseMovieFile(mRefNum);

	if (mMovie)
		DisposeMovie(mMovie);

	return mErr;
}

OSErr CreateFSSPec(TCHAR *szFileName, FSSpec *mSpec)
{
	OSErr		mErr = noErr;
	Str255		mName;

	c2pstrcpy(mName, szFileName);
	FSMakeFSSpec(0, 0, mName, mSpec);
	if (mErr != noErr && mErr != fnfErr)
		_tprintf("\nFSMakeFSSpec Error: err = %d\n\t%s\n", mErr, szFileName);

	return mErr;
}

OSErr OpenMovie(TCHAR *szFileName, bool bWrite, Movie *theMovie, FSSpec *mSpec, short *mRefNum)
{
	OSErr		mErr = noErr;
	SInt8		mPermissions;

	CreateFSSPec(szFileName, mSpec);

	if (bWrite)
		mPermissions = fsRdWrPerm;
	else
		mPermissions = fsRdPerm;

	mErr = OpenMovieFile(mSpec, mRefNum, mPermissions);
	if (mErr != noErr) {
		_tprintf("\nOpenMovieFile Error: err = %d\n\t%s\n\t%s\n", mErr, szFileName, mSpec->name);
		return mErr;
	}

	mErr = NewMovieFromFile(theMovie, *mRefNum, nil, nil, newMovieActive, nil);
	if (mErr != noErr) {
		_tprintf("\nNewMovieFromFile Error: err = %d\n\t%s\n\t%s\n", mErr, szFileName, mSpec->name);
		return mErr;
	}

	return mErr;
}

OSErr ExportMovie(TCHAR *szInputFileName, TCHAR *szOutputFileName, TCHAR *szSettingsFileName)
{
	OSErr					mErr = noErr;
	Movie					mMovie = NULL;
	FSSpec					mInputSpec, mOuputSpec, mSettingsSpec;
	short					mRefNum = 0, mRefNumSettings = 0;
	ComponentDescription	mCompDesc;
	MovieExportComponent	theExporter = NULL;
	long					mFlags = 0;
	FILE					*atomSettings = NULL;
	Handle					mAtomSettings;
	long					mSize;
	Boolean					mCancelled = false;

	mFlags = movieFileSpecValid;

	mErr = OpenMovie(szInputFileName, false, &mMovie, &mInputSpec, &mRefNum);
	if (mErr != noErr) {
		goto CleanUp;
	}

	if (_tcslen(szOutputFileName) > 0) {
		mErr = CreateFSSPec(szOutputFileName, &mOuputSpec);
	}
	else {
		mErr = CreateFSSPec("NewMovie.mov", &mOuputSpec);
		mFlags |= showUserSettingsDialog;
	}
	if (mErr != noErr && mErr != fnfErr) {
		goto CleanUp;
	}

	if (_tcslen(szOutputFileName) > 0) {
		if (_tcslen(szSettingsFileName) > 0) {
			mErr = CreateFSSPec(szSettingsFileName, &mSettingsSpec);
			if (mErr == noErr) {
				atomSettings = fopen(szSettingsFileName, "rb");
			}
		}

		if (atomSettings) {
			// Settings file exists, read the settings and apply them
			mCompDesc.componentType = MovieExportType;
			mCompDesc.componentSubType = MovieFileType;
			mCompDesc.componentManufacturer = FOUR_CHAR_CODE('hint');
			mCompDesc.componentFlags = 0;
			mCompDesc.componentFlagsMask = 0;
			theExporter = OpenComponent(FindNextComponent(NULL, &mCompDesc));

			if (theExporter == NULL)
				goto HintDialog;

			fseek(atomSettings, 0, SEEK_END);
			mSize = ftell(atomSettings);
			fclose(atomSettings);

			mAtomSettings = NewHandleClear(mSize);

			mErr = FSpOpenDF(&mSettingsSpec, fsRdPerm, &mRefNumSettings);

			if (mErr == noErr)
				mErr = FSRead(mRefNumSettings, &mSize, *mAtomSettings);

			if (mRefNumSettings != 0)		
				mErr = FSClose(mRefNumSettings);

			if (mErr == noErr)
				mErr = MovieExportSetSettingsFromAtomContainer(theExporter, (QTAtomContainer)mAtomSettings);

			if (mErr != noErr)
				theExporter = NULL;

			if (mAtomSettings) {
				DisposeHandle(mAtomSettings);
				mAtomSettings = NULL;
			}
		}

HintDialog:
		if (theExporter == NULL) {
			// Settings file did not exist, so open the dialog for the user		
			mCompDesc.componentType = MovieExportType;
			mCompDesc.componentSubType = MovieFileType;
			mCompDesc.componentManufacturer = FOUR_CHAR_CODE('hint');
			mCompDesc.componentFlags = 0;
			mCompDesc.componentFlagsMask = 0;
			theExporter = OpenComponent(FindNextComponent(NULL, &mCompDesc));
			if (theExporter == NULL)
				goto Export;

			mErr = MovieExportDoUserDialog(theExporter, mMovie, NULL, 0, 0, &mCancelled);
			if (mCancelled)
				goto CleanUp;

			if (mErr != noErr) {
				_tprintf("MovieExportDoUserDialog Error: err = %d\n", mErr);
				goto CleanUp;
			}

			if (_tcslen(szSettingsFileName) > 0) {
				// Now save the settings to a file
				FSpDelete(&mSettingsSpec);

				mErr = MovieExportGetSettingsAsAtomContainer(theExporter, (QTAtomContainer *)&mAtomSettings);
				if (mErr != noErr) {
					_tprintf("MovieExportGetSettingsAsAtomContainer Error: err = %d\n", mErr);
				}

				mSize = GetHandleSize(mAtomSettings);
				if (mSize == 0)
					mErr = -1;

				if (mErr == noErr)
					mErr = FSpCreate(&mSettingsSpec, FOUR_CHAR_CODE('RTM '), FOUR_CHAR_CODE('Pref'), smSystemScript);

				if (mErr == noErr)
					mErr = FSpOpenDF(&mSettingsSpec, fsWrPerm, &mRefNumSettings);

				if (mErr == noErr)
					mErr = FSWrite(mRefNumSettings, &mSize, *mAtomSettings);

				if (mRefNumSettings != 0)		
					mErr = FSClose(mRefNumSettings);

				if (mAtomSettings) {
					DisposeHandle(mAtomSettings);
					mAtomSettings = NULL;
				}
			}
		} //if (theExporter != NULL) {
	} //if (bHint) {

Export:
	// default progress procedure
	SetMovieProgressProc(mMovie, (MovieProgressUPP)-1L, 0);

	mErr = ConvertMovieToFile(  mMovie,
								NULL, // NULL = all tracks
								&mOuputSpec,
								MovieFileType,
								FOUR_CHAR_CODE('TVOD'),
								smSystemScript,	
								NULL,
								mFlags,
								theExporter);

CleanUp:
	if (mRefNum)
		CloseMovieFile(mRefNum);

	if (mMovie)
		DisposeMovie(mMovie);

	return mErr;
}

int _tmain(int argc, _TCHAR* argv[])
{
	TCHAR szVideoFile[MAX_PATH];
	TCHAR szOutputFile[MAX_PATH];
	TCHAR szSettingsFile[MAX_PATH];

	BOOL bExport = FALSE;
	BOOL bInfo = FALSE;

	_tprintf("\nQTHint v0.2.0 (2007-10-19) (c) Josh Harris (tateu)\n\n");
	DWORD dwStartTime = GetTickCount();

	memset(szVideoFile, 0, MAX_PATH);
	memset(szOutputFile, 0, MAX_PATH);
	memset(szSettingsFile, 0, MAX_PATH);

	if (argc < 2) {
	} else if (argc == 2) {
		bExport = TRUE;
		_tcsncpy(szVideoFile, argv[1], MAX_PATH);
	} else {
		for (int i = 1; i+1 < argc; i++) {
			if (_tcscmp(argv[i], "-f") == 0) {
				_tcsncpy(szVideoFile, argv[++i], MAX_PATH);
				bExport = TRUE;
			} else if (_tcscmp(argv[i], "-info") == 0) {
				//Print info about source movies but do not create new movie
				_tcsncpy(szVideoFile, argv[++i], MAX_PATH);
				bInfo = TRUE;
			} else if (_tcscmp(argv[i], "-s") == 0) {
				_tcsncpy(szSettingsFile, argv[++i], MAX_PATH);
			} else if (_tcscmp(argv[i], "-o") == 0) {
				_tcsncpy(szOutputFile, argv[++i], MAX_PATH);
			}
		}
	}

	if (_tcslen(szVideoFile) == 0) {
		_tprintf("Usage:\n");
		_tprintf("\nQTHint.exe -f \"X:\\path\\Movie.mov\"\n");
			_tprintf("\n  To open the movie Export dialog (this will allow you to choose an output"
					"\n   movie file and you can add hints or re-encode the video to a different"
					"\n   format). Do not supply an output filename.\n");
			_tprintf("  To add hints to the movie without re-encoding, choose Movie to Hinted"
					"\n   Movie\n");
			_tprintf("  To re-encode the movie, choose Movie to QuickTime Movie\n\n");

		_tprintf("\nQTHint.exe -f \"X:\\path\\Movie.mov\" -s \"QTHint.rtm\" -o \"X:\\path\\Hinted.mov\"\n");
			_tprintf("\n  To add hints to a movie without opening a dialog box, you need a "
					"\n   settings file (-s \"QTHint.rtm\") and an output movie (-o) \n\n");
		return 1;
	}

	if(InitializeQTML(kInitializeQTMLDisableDirectSound)!=noErr) {
		_tprintf("\nUnable to Initialize Quicktime Environment\n\n");
		return 1;
	}

	if (EnterMovies() != noErr) {
		TerminateQTML();
		_tprintf("\nUnable to Initialize Quicktime EnterMovies\n\n");
		return 1;
	}

	if (bExport) {
		ExportMovie(szVideoFile, szOutputFile, szSettingsFile);
	} else if (bInfo) {
		GetMovieInfo(szVideoFile);
	}

	ExitMovies();
	TerminateQTML();

	_tprintf("\nCompleted in %0.2f seconds\n\n", ((GetTickCount() - dwStartTime) / 1000.0));

	return 0;
}

