///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include "QTSource.h"

unsigned long codecQuality[6] = { codecMinQuality, codecLowQuality, codecNormalQuality,
    codecHighQuality, codecMaxQuality, codecLosslessQuality
};

static char *GetWorkingDir(char *buf, size_t bufSize)
{
    //assert(buf != NULL);
    DWORD len = GetCurrentDirectory(bufSize - 1, buf);

    // if the retrieved directory name doesn't end in a trailing slash, add one
    if (len > 0 && len < bufSize - 1 && buf[len - 1] != '\\') {
        buf[len] = '\\';
        buf[len + 1] = '\0';
        ++len;
    }
    return buf;
}

static bool IsAbsolutePath(const char *path)
{
    //assert(path != NULL);
    return strchr(path, ':') != NULL
        // Allow UNC paths too
        || (path[0] == '\\' && path[1] == '\\')
        || (path[0] == '/' && path[1] == '/');
}

///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////

QTInput::QTInput
#ifdef QT_VFW
    (const char name[], const int _color, const int quality, const int fAudio,
     const int _mode, const char _raw[], const int _info, const int _dither,
     const char _vfw[], const float _gamma, const float _vfrFPS, IScriptEnvironment * env)
#else
    (const char name[], const int _color, const int quality, const int fAudio,
     const int _mode, const char _raw[], const int _info, const int _dither,
     const float _gamma, const float _vfrFPS, IScriptEnvironment * env)
#endif
{
    char sBuf[512];
    strStatus = new char[1024];
    bool bReadMedia = true;
    m_iRaw = 0;

    bInfo = _info;
    m_iInfoLevel = 1;
    m_iMode = _mode;
    m_fGamma = _gamma;
    m_fvfrFPS = _vfrFPS;

    if (m_iMode == 1) {
        if (stricmp(_raw, "uyvy") == 0 || stricmp(_raw, "2vuy") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_UYVY;
        } else if (stricmp(_raw, "v210") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_V210;
        } else if (stricmp(_raw, "yuyv") == 0 || stricmp(_raw, "yuy2") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_YUYV;
        } else if (stricmp(_raw, "yvyu") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_YVYU;
        } else if (stricmp(_raw, "vyuy") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_VYUY;
        } else if (stricmp(_raw, "yuv2") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_YUV2;
        } else if (stricmp(_raw, "yv12") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_YV12;
        } else if (stricmp(_raw, "rgb") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_RGB;
        } else if (stricmp(_raw, "argb") == 0) {
            m_iRaw = QTMOVIE_RAW_MODE_ARGB;
            /*} else if (stricmp(_raw, "uyvya") == 0) {
               m_iRaw = QTMOVIE_RAW_MODE_UYVYA; */
        } else {
            sprintf(strStatus, "\nInvalid raw format string: %s\n"
                    "Choose uyvy (2vuy), yuyv (yuy2), yvyu, vyuy, yuv2, v210, rgb or argb\n", _raw);
            env->ThrowError(strStatus);
        }
        /* else if (stricmp(_raw, "ayuv") == 0) {
           m_iRaw = QTMOVIE_RAW_MODE_AYUV;
           } else if (stricmp(_raw, "yuva") == 0) {
           m_iRaw = QTMOVIE_RAW_MODE_YUVA;
           } */
    }
    
        // Generate full name
        if (IsAbsolutePath(name)) {
        sBuf[0] = '\0';
        strncat(sBuf, name, sizeof sBuf);
    } else {
        char cwd[MAX_PATH + 1];
        GetWorkingDir(cwd, sizeof cwd);
        _snprintf(sBuf, sizeof sBuf, "%s%s", cwd, name);
    }
    strcpy(FileName, sBuf);

    m_QTMovie = new CQTMovieDec;

    if (!m_QTMovie->ISQTInitialized()) {
        sprintf(strStatus, "\n%s\n", m_QTMovie->GetErrorMessage());
        delete m_QTMovie;
        env->ThrowError(strStatus);
    }

    char strVFW[5];
    memset(strVFW, 0, 5);

#ifdef QT_VFW
    if (strlen(_vfw) > 4) {
        sprintf(strStatus, "Invalid VFW codec: %s", _vfw);
        delete m_QTMovie;
        env->ThrowError(strStatus);
    } else if (strlen(_vfw) < 4) {
        strcpy(strVFW, _vfw);
        memcpy(&strVFW[strlen(strVFW)], " ", 4 - strlen(strVFW));
    } else
        strcpy(strVFW, _vfw);
#endif

    OSType m_pixelFormat;
    mCodec.quality = codecQuality[quality > 100 ? 5 : (quality < 0 ? 0 : (int)(quality / 20))];

    memset(mCodec.CodecName, 0, sizeof(mCodec.CodecName));
    memset(mCodec.strFourCC, 0, sizeof(mCodec.strFourCC));

    //2011-03-30 Add this here so that mode gets set.  It will get reset later with the correct m_pixelFormatArray and m_iRowOrer values.
    m_QTMovie->SetFormat(k24BGRPixelFormat, m_iRaw, _mode, m_fGamma, 0);

    if (m_QTMovie->OpenMovie(FileName, mCodec, 1, 1) == E_FAIL) {
        sprintf(strStatus, "\n%s\n", m_QTMovie->GetErrorMessage());
        delete m_QTMovie;
        env->ThrowError(strStatus);
    }

    mCodec = m_QTMovie->QTGetCodecInfo();
    OSType m_pixelFormatArray[4];
    if (m_iRaw != 0) {
        if (m_iRaw == QTMOVIE_RAW_MODE_RGB) {
            m_pixelFormatArray[0] = k24BGRPixelFormat;
            m_pixelFormatArray[1] = k24BGRPixelFormat;
            m_pixelFormatArray[2] = k24BGRPixelFormat;
            m_pixelFormatArray[3] = k24BGRPixelFormat;
        } else if (m_iRaw == QTMOVIE_RAW_MODE_ARGB) {
            m_pixelFormatArray[0] = k32BGRAPixelFormat;
            m_pixelFormatArray[1] = k32BGRAPixelFormat;
            m_pixelFormatArray[2] = k32BGRAPixelFormat;
            m_pixelFormatArray[3] = k32BGRAPixelFormat;
        } else if (m_iRaw == QTMOVIE_RAW_MODE_YV12) {
            m_pixelFormatArray[0] = kYUV420PixelFormat;
            m_pixelFormatArray[1] = kYUV420PixelFormat;
            m_pixelFormatArray[2] = kYUV420PixelFormat;
            m_pixelFormatArray[3] = kYUV420PixelFormat;
        } else {
            m_pixelFormatArray[0] = kYUVSPixelFormat;
            m_pixelFormatArray[1] = kYUVSPixelFormat;
            m_pixelFormatArray[2] = kYUVSPixelFormat;
            m_pixelFormatArray[3] = kYUVSPixelFormat;
        }
    } else if (_color == 1) {   //RGB32
        m_pixelFormatArray[0] = k32BGRAPixelFormat;
        m_pixelFormatArray[1] = k24BGRPixelFormat;
        m_pixelFormatArray[2] = kYUVSPixelFormat;
        m_pixelFormatArray[3] = kYUV420PixelFormat;
    } else if (_color == 2) {   //YUY2
        m_pixelFormatArray[0] = kYUVSPixelFormat;
        m_pixelFormatArray[1] = kYUV420PixelFormat;
        m_pixelFormatArray[2] = k24BGRPixelFormat;
        m_pixelFormatArray[3] = k32BGRAPixelFormat;
    } else if (_color == 3) {   //YV12
        m_pixelFormatArray[0] = kYUV420PixelFormat;     //kMpegYUV420CodecType
        m_pixelFormatArray[1] = kYUVSPixelFormat;
        m_pixelFormatArray[2] = k24BGRPixelFormat;
        m_pixelFormatArray[3] = k32BGRAPixelFormat;
    } else if (_color == 4) {   //2VUY
        m_pixelFormatArray[0] = k2vuyPixelFormat;
        m_pixelFormatArray[1] = kYUV420PixelFormat;
        m_pixelFormatArray[2] = k24BGRPixelFormat;
        m_pixelFormatArray[3] = k32BGRAPixelFormat;
    } else {                    //RGB24
        m_pixelFormatArray[0] = k24BGRPixelFormat;
        m_pixelFormatArray[1] = k32BGRAPixelFormat;
        m_pixelFormatArray[2] = kYUVSPixelFormat;
        m_pixelFormatArray[3] = kYUV420PixelFormat;
    }

    int m_iRowOrer = 0;
    vi.pixel_type = VideoInfo::CS_UNKNOWN;
    for (int i = 0; i < 4; i++) {
        if (m_QTMovie->SetFormat(m_pixelFormatArray[i], m_iRaw, _mode, m_fGamma, m_iRowOrer)) {
            if (m_pixelFormatArray[i] == kYUVSPixelFormat || m_pixelFormatArray[i] == k2vuyPixelFormat)
                vi.pixel_type = VideoInfo::CS_YUY2;
            else if (m_pixelFormatArray[i] == kYUV420PixelFormat)
                vi.pixel_type = VideoInfo::CS_YV12;
            else if (m_pixelFormatArray[i] == k32BGRAPixelFormat)
                vi.pixel_type = VideoInfo::CS_BGR32;
            else
                vi.pixel_type = VideoInfo::CS_BGR24;

            break;
        }
    }

    if (vi.pixel_type == VideoInfo::CS_UNKNOWN) {
        delete m_QTMovie;
        sprintf(strStatus, "\nCannot find a valid codec: %s\n", mCodec.CodecName);
        env->ThrowError(strStatus);
    }

    if (m_QTMovie->InitializeGraphics(fAudio, strVFW, false, _dither, m_fvfrFPS) == E_FAIL) {
        sprintf(strStatus, "\nCannot InitializeGraphics: %s\n%s", mCodec.CodecName, m_QTMovie->GetErrorMessage());
        delete m_QTMovie;
        env->ThrowError(strStatus);
    }
    //Make sure correct mode is set if using raw mode
    if (m_iRaw != 0) {
        if ((m_iRaw == QTMOVIE_RAW_MODE_RGB && vi.pixel_type != VideoInfo::CS_BGR24)
            || (m_iRaw == QTMOVIE_RAW_MODE_ARGB && vi.pixel_type != VideoInfo::CS_BGR32)
            || (m_iRaw > QTMOVIE_RAW_MODE_ARGB && vi.pixel_type != VideoInfo::CS_YUY2)) {
            delete m_QTMovie;
            sprintf(strStatus, "\nRaw mode %s is selected but output format is not Compatible: %s\n",
                    _raw, mCodec.CodecName);
            env->ThrowError(strStatus);
        }
    }

    frameCount = m_QTMovie->GetVideoDuration();
    depth = m_QTMovie->GetDepth();
    DisplayWidth = m_QTMovie->GetDisplayWidth();
    DisplayHeight = m_QTMovie->GetDisplayHeight();
    fpsInfo fpsI = m_QTMovie->GetFPS();
    fps = double (1.0 * fpsI.numerator / fpsI.denominator);
    pFrameBuffer = NULL;

#ifdef QT_VFW
    //Check to make sure pixel type of m_QTMovie is still the same
    //If using VFW or DShow, it may have changed
    m_pixelFormatArray[0] = m_QTMovie->GetColorSpace();
    if (m_pixelFormatArray[0] == kYUVSPixelFormat || m_pixelFormatArray[0] == k2vuyPixelFormat)
        vi.pixel_type = VideoInfo::CS_YUY2;
    else if (m_pixelFormatArray[0] == kYUV420PixelFormat)
        vi.pixel_type = VideoInfo::CS_YV12;
    else if (m_pixelFormatArray[0] == k32BGRAPixelFormat)
        vi.pixel_type = VideoInfo::CS_BGR32;
    else if (m_pixelFormatArray[0] == k24BGRPixelFormat)
        vi.pixel_type = VideoInfo::CS_BGR24;
    else
        vi.pixel_type == VideoInfo::CS_UNKNOWN;

    if (vi.pixel_type == VideoInfo::CS_UNKNOWN) {
        delete m_QTMovie;
        sprintf(strStatus, "\nCannot find a valid codec: %s\n", mCodec.CodecName);
        env->ThrowError(strStatus);
    }
#endif

    m_DecoderCodec = m_QTMovie->QTGetDecoderInfo();

    vi.width = DisplayWidth;
    vi.height = DisplayHeight;
    vi.num_frames = frameCount;
    vi.fps_numerator = fpsI.numerator;  //fps * 1000;
    vi.fps_denominator = fpsI.denominator;      //1000;
    vi.audio_samples_per_second = 0;
    vi.SetFieldBased(FALSE);

    pFrameBuffer = new byte[vi.RowSize() * vi.height * 1.5];
    memset(pFrameBuffer, 0, vi.RowSize() * vi.height * 1.5);

    if (fAudio && m_QTMovie->audio()) {
        vi.audio_samples_per_second = m_QTMovie->GetAudioSampleRate();
        vi.nchannels = m_QTMovie->GetAudioNumChannels();
        if (m_QTMovie->GetAudioSampleSize() == 16) {
            vi.sample_type = SAMPLE_INT16;
        } else if (m_QTMovie->GetAudioSampleSize() == 8) {
            vi.sample_type = SAMPLE_INT8;
        } else if (m_QTMovie->GetAudioSampleSize() == 24) {
            vi.sample_type = SAMPLE_INT24;
        } else if (m_QTMovie->GetAudioSampleSize() == 32) {
            vi.sample_type = SAMPLE_INT32;
            //vi.sample_type = SAMPLE_FLOAT;
        }

        vi.num_audio_samples = m_QTMovie->GetAudioSampleCount();
    }
}

QTInput::~QTInput()
{
    delete m_QTMovie;

    if (pFrameBuffer)
        delete[]pFrameBuffer;
    if (strStatus)
        delete[]strStatus;
}

PVideoFrame __stdcall QTInput::GetFrame(int n, IScriptEnvironment * env)
{
    if (bInfo && m_iInfoLevel > 0) {
        char text[255];

        if (m_iRaw != 0) {
            sprintf(text, "%s (%c%c%c%c), Raw Frame Size: %d, "
                    "%d x %d, rotation = %0.2f (%s)",
                    m_DecoderCodec.CodecName,
                    (m_DecoderCodec.m_iFourCC & 0xFF000000) >> 24,
                    (m_DecoderCodec.m_iFourCC & 0x00FF0000) >> 16,
                    (m_DecoderCodec.m_iFourCC & 0x0000FF00) >> 8,
                    (m_DecoderCodec.m_iFourCC & 0x000000FF),
                    m_QTMovie->GetRawFrameSize(),
                    m_QTMovie->GetDisplayWidth(),
                    m_QTMovie->GetDisplayHeight(),
                    m_QTMovie->GetDisplayRot(), m_iMode == 0 ? "Applied" : "Not Applied");
        } else {
            sprintf(text, "%s (%c%c%c%c), Mode=%s, "
                    "%d x %d, rotation = %0.2f (%s)",
                    m_DecoderCodec.CodecName,
                    (m_DecoderCodec.m_iFourCC & 0xFF000000) >> 24,
                    (m_DecoderCodec.m_iFourCC & 0x00FF0000) >> 16,
                    (m_DecoderCodec.m_iFourCC & 0x0000FF00) >> 8,
                    (m_DecoderCodec.m_iFourCC & 0x000000FF),
                    m_iMode == 0 ? "0, MoviesTask" :
                    m_iMode == 2 ? "2, DecompressSeq" :
                    m_iMode == 3 ? "3, ICMDecompress" : "4, VFW",
                    m_QTMovie->GetDisplayWidth(),
                    m_QTMovie->GetDisplayHeight(),
                    m_QTMovie->GetDisplayRot(), m_iMode == 0 ? "Applied" : "Not Applied");
        }

        const char *arg_names[8] = {
            0, 0, "x", "y", "font", "size", "text_color", "halo_color"
        };
        AVSValue args[8] = { this, AVSValue(text), 10, 10, "Arial", 14, 0xFFFFFF, 0x000000 };

        m_iInfoLevel = 0;
        PClip subbedClip = (env->Invoke("Subtitle", AVSValue(args, 8), arg_names)).AsClip();
        PVideoFrame subbedFrame = subbedClip->GetFrame(n, env);

        m_iInfoLevel = 1;
        return subbedFrame;
    }

    dst = env->NewVideoFrame(vi);

    unsigned char *dstp = NULL;
    const int dst_pitch = dst->GetPitch();
    const int dst_pitch_dbl = 2 * dst_pitch;
    const int dst_width = dst->GetRowSize();
    const int dst_height = dst->GetHeight();

    dstp = dst->GetWritePtr();
    int len = m_QTMovie->ReadVideoFrame(n, dstp, dst_pitch);

    return dst;
}
void __stdcall QTInput::GetAudio(void *buf, __int64 start, __int64 count, IScriptEnvironment * env)
{
    __int64 bytes_read = 0, samples_read = 0;

    samples_read = (__int64) m_QTMovie->ReadAudioFrame((byte *) buf, start, count, (unsigned long *)&bytes_read);

}

bool __stdcall QTInput::GetParity(int n)
{
    return false;
}

const VideoInfo & __stdcall QTInput::GetVideoInfo()
{
    return vi;
}
void __stdcall SetCacheHints(int cachehints, int frame_range);

///////////////////////////////////////////////////////////////////////
// QTOutput
//
///////////////////////////////////////////////////////////////////////

QTOutput::QTOutput(PClip _child, const char name[], const char format[], const int _quality,
                   const int _datarate, const int _keyframerate, const char _raw[],
                   const char _settings[], const int fAudio, IScriptEnvironment * env)
:GenericVideoFilter(_child)
{
    char sBuf[MAX_PATH];
    char strSettings[MAX_PATH];
    int m_iRaw = 0;
    frameCount = 0;
    bComplete = false;
    m_iAudio = fAudio;

    // Generate full name
    if (IsAbsolutePath(name)) {
        sBuf[0] = '\0';
        strncat(sBuf, name, sizeof sBuf);
    } else {
        char cwd[MAX_PATH + 1];
        GetWorkingDir(cwd, sizeof cwd);
        _snprintf(sBuf, sizeof sBuf, "%s%s", cwd, name);
    }

    strcpy(FileName, sBuf);

    memset(strSettings, 0, sizeof(strSettings));
    if (_settings) {
        if (strlen(_settings) > 0) {
            memset(sBuf, 0, sizeof(sBuf));
            if (IsAbsolutePath(_settings)) {
                sBuf[0] = '\0';
                strncat(sBuf, _settings, sizeof sBuf);
            } else {
                char cwd[MAX_PATH + 1];
                GetWorkingDir(cwd, sizeof cwd);
                _snprintf(sBuf, sizeof sBuf, "%s%s", cwd, _settings);
            }

            strcpy(strSettings, sBuf);
        }
    }

    if (strlen(format) > 4) {
        sprintf(strStatus, "Invalid output codec: %s", format);
        env->ThrowError(strStatus);
    } else if (strlen(format) < 4) {
        strcpy(strFormat, format);
        memcpy(&strFormat[strlen(strFormat)], " ", 4 - strlen(strFormat));
    } else
        strcpy(strFormat, format);

    vi = child->GetVideoInfo();
    PVideoFrame src = child->GetFrame(0, env);

    if (strlen(_raw) > 0) {
        if (!vi.IsYUY2()) {
            env->ThrowError("\nInvalid input Colorspace for raw output\nOnly YUY2 is supported\n");
        }

        if ((stricmp(_raw, "uyvy") == 0 || stricmp(_raw, "2vuy") == 0)) {
            //&& (stricmp(format, "2Vuy") == 0) ) {
            m_iRaw = QTMOVIE_RAW_MODE_UYVY;
            /*} else if (stricmp(_raw, "yuyv") == 0 || stricmp(_raw, "yuy2") == 0) {
               m_iRaw = QTMOVIE_RAW_MODE_YUYV;
               } else if (stricmp(_raw, "yvyu") == 0) {
               m_iRaw = QTMOVIE_RAW_MODE_YVYU;
               } else if (stricmp(_raw, "vyuy") == 0) {
               m_iRaw = QTMOVIE_RAW_MODE_VYUY;
               } else if ((stricmp(_raw, "yuv2") == 0) && (stricmp(format, "yuv2") == 0)) {
               m_iRaw = QTMOVIE_RAW_MODE_YUV2; */
        } else {
            sprintf(strStatus, "\nInvalid format and/or raw string: %s, %s\n"
                    "Choose format=\"2Vuy\", raw=\"uyvy\" (2vuy)\n", format, _raw);
            //"Choose format=2Vuy, raw=uyvy (2vuy) or format=yuv2, raw=yuv2\n", format, _raw);
            env->ThrowError(strStatus);
        }
    }

    m_QTMovie = new CQTMovieEnc;

    if (vi.IsRGB32()) {
        pitch = src->GetPitch();
        rowsize = src->GetRowSize();
        height = src->GetHeight();
        width = vi.width;

        m_QTMovie->SetFormat(k32BGRAPixelFormat, RowOrderBottomUp);
    } else if (vi.IsRGB24()) {
        pitch = src->GetPitch();
        rowsize = src->GetRowSize();
        height = src->GetHeight();
        width = rowsize / 3;

        m_QTMovie->SetFormat(k24BGRPixelFormat, RowOrderBottomUp);
    } else if (vi.IsYUY2()) {
        pitch = src->GetPitch();
        rowsize = src->GetRowSize();
        height = src->GetHeight();
        width = rowsize / 2;

        m_QTMovie->SetFormat(kYUVSPixelFormat, RowOrderTopDown);
    }                           /*else if (vi.IsYV12()) {
                                   //env->ThrowError("Only RGB modes are supported. Add ConvertToRGB24() or ConvertToRGB32()");
                                   pitch = src->GetPitch(PLANAR_U);
                                   rowsize = src->GetRowSize(PLANAR_U_ALIGNED);
                                   height = src->GetHeight(PLANAR_U);
                                   width = rowsize * 2;

                                   m_QTMovie->SetFormat(kYUV420PixelFormat, RowOrderTopDown);
                                   } */
    else {
        delete m_QTMovie;
        env->ThrowError("Invalid input Colorspace\nOnly RGB24, RGB32 and YUY2 are supported");
    }

    if (_quality == 333)
        m_QTMovie->PrintCodecList("Quicktime_CodecList.txt");

    QTCodecInfo mCodec;
    if (strlen(format) == 0)
        mCodec.m_iFourCC = 0;
    else {
        mCodec.m_iFourCC = 1;
        strcpy(mCodec.strFourCC, strFormat);
    }

    mCodec.m_iDataRate = _datarate * 1024;
    mCodec.m_iKeyframeRate = _keyframerate;

    mCodec.quality = codecQuality[_quality > 100 ? 5 : (_quality < 0 ? 0 : (int)(_quality / 20))];

    //Fix some odd rounding errors, especially with blank clip
    //BlankClip(29.97 is 15712911 / 524288 which is 29.9699993133544921875
    //This gets it back to 29.97
    vi.SetFPS(int (0.5 + 1000.0 * (float)vi.fps_numerator / vi.fps_denominator), 1000);

    if (m_QTMovie->Initialize(FileName, vi.width, vi.height, vi.fps_numerator,
                              vi.fps_denominator, rowsize, mCodec, m_iRaw, strSettings) == E_FAIL) {
        sprintf(strStatus, "%s", m_QTMovie->GetErrorMessage());
        delete m_QTMovie;
        env->ThrowError(strStatus);
    }

    if (m_QTMovie->CreateMovie() == E_FAIL) {
        sprintf(strStatus, "%s", m_QTMovie->GetErrorMessage());
        delete m_QTMovie;
        env->ThrowError(strStatus);
    }

    if (m_QTMovie->CreateVideoTrack() == E_FAIL) {
        sprintf(strStatus, "%s", m_QTMovie->GetErrorMessage());
        delete m_QTMovie;
        env->ThrowError(strStatus);
    }

    if (vi.HasAudio() && m_iAudio != 0) {
        if (m_QTMovie->
            CreateAudioTrack(vi.AudioChannels(), vi.audio_samples_per_second,
                             vi.BytesPerAudioSample() * 8 / vi.AudioChannels(), vi.SampleType() == 16) == E_FAIL) {
            sprintf(strStatus, "%s", m_QTMovie->GetErrorMessage());
            delete m_QTMovie;
            env->ThrowError(strStatus);
        }
    }

    audio_stream_pos = 0;
}

QTOutput::~QTOutput()
{
    if (!bComplete)
        delete m_QTMovie;
}

PVideoFrame __stdcall QTOutput::GetFrame(int n, IScriptEnvironment * env)
{
    PVideoFrame src = child->GetFrame(n, env);

    if (n < vi.num_frames) {
        pData = (char *)src->GetReadPtr();

        const int src_pitch = src->GetPitch();

        if (m_QTMovie->EncodeVideoFrame(pData, src_pitch) == E_FAIL) {
            //Failed to get Data
        }

        if (vi.HasAudio() && m_iAudio != 0) {
            char *read_buffer;
            audio_stream_pos = vi.AudioSamplesFromFrames(n);
            int nSamples = vi.AudioSamplesFromFrames(n + 1) - audio_stream_pos;
            int bytes = vi.BytesFromAudioSamples(nSamples);
            read_buffer = new char[bytes + 2];
            child->GetAudio(read_buffer, audio_stream_pos, nSamples, env);

            if (m_QTMovie->EncodeAudioFrame(read_buffer, nSamples, bytes) == E_FAIL) {
                //Failed to get Data
            }
            delete[]read_buffer;
        }
    } else {
        //Max number of frames have been written
        //Close Movie
        if (!bComplete) {
            delete m_QTMovie;
            bComplete = true;
        }
    }

    return src;
}
