/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbutils;

import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;

public class BusyDialog extends Dialog {

    BusyDialogWorkerThread worker = null;

    public BusyDialog(String message, BusyDialogWorkerThread worker) {
        super(message,
              null,
              null,
              0,
              Bitmap.getPredefinedBitmap(Bitmap.HOURGLASS));
        this.worker = worker;
    }

    public void display() {
        synchronized (UiApplication.getUiApplication().getAppEventLock()) {
            this.show();
        }
        worker.start();
        try {
            worker.join();
        } catch (InterruptedException e) {
        }
        synchronized (UiApplication.getUiApplication().getAppEventLock()) {
            this.close();
        }
    }
}