//#preprocess

/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import java.io.DataInputStream;
import java.io.IOException;

import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;

import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;

import org.bbweather.data.CurrentConditionsData;
//import net.rim.device.api.system.ApplicationManager;
//import net.rim.device.api.system.ApplicationDescriptor;
//#ifdef OS_COMPILE_ATLEAST_4_10
import net.rim.blackberry.api.homescreen.HomeScreen;
//#endif

import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.DrawStyle;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.FontFamily;
import net.rim.device.api.ui.Ui;
import net.rim.device.api.ui.Graphics;

import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.ApplicationDescriptor;
import java.util.Date;

import net.rim.device.api.servicebook.ServiceBook;
import net.rim.device.api.servicebook.ServiceRecord;

import net.rim.device.api.i18n.SimpleDateFormat;

//#ifdef OS_COMPILE_ATLEAST_4_30
import net.rim.device.api.system.WLANInfo;
//#endif

public class WeatherThreadManager {

    // This is my personal ident keys for weather.com. DO NOT ABUSE!
    private static final String WEATHER_SOAP_REST = "&link=xoap&prod=xoap&par=1006814500&key=ee4ffa68f8bf99cd&unit=";

    private static final String WEATHER_SOAP_URL = "http://xoap.weather.com/weather/local/";

    private static final String WEATHER_SOAP_URL_CC = "?cc=*";

    private static final String WEATHER_SOAP_URL_FORECAST = "?dayf=";

    private static final String WEATHER_SOAP_URL_HOURLY = "?hbhf=";

    //from BBToday for Location Id Search
    private static final String WEATHER_URL_SEARCH = "http://xoap.weather.com/search/search?where=";

    private static WeatherThreadManager manager = null;

    private Thread currentConditionsThread = null;

    private boolean isCCThreadRunning = false;

    private Thread forecastThread = null;

    private boolean isForecastThreadRunning = false;

    private Thread hourlyThread = null;
    private boolean isHourlyThreadRunning = false;

    public static boolean doExit = false; //for homescreen mode
    public static boolean cancelSleep = false; //for homescreen mode
    public static boolean firstOpen = false; //Used so that if no profiles are created, it only opens the Add Location screen on first open

    //added to cause BBWeather to sleep for 60 seconds on startup
    // TEMP the startup sleep time should become a user selectable option
    public static boolean isStartup = false;

    public static WeatherThreadManager getInstance() {
        if (manager == null)
            manager = new WeatherThreadManager();

        return manager;
    }

    private WeatherThreadManager() {

        currentConditionsThread = new Thread(new Runnable() {

            public void run() {

                isCCThreadRunning = true;
                BBWeatherOptions options = BBWeatherOptions.load(false);
                while (isCCThreadRunning) {
                    //Make sure this doesn't run when updating the homescreen icon via app.schedule
                    if (!doExit && !cancelSleep) {
                        try {
                            Thread.sleep(options.currentConditionsInterval * 60000);
                        } catch (Exception e) {
                        }
                    } else if (isStartup) { //added to cause BBWeather to sleep for 60 seconds on startup // TEMP the startup sleep time should become a user selectable option
                        isStartup = false;
                        try {
                            Thread.sleep(60000);
                        } catch (Exception e) {
                        }
                    }

                    if (cancelSleep)
                        cancelSleep = false; //always make sure this is reset to false

                    options = BBWeatherOptions.load(false);
                    String locationId = options.getCurrentLocationId();
                    try {
                        if (locationId == null) {
                            // If this is true, it means BBWeather is running automatically as a scheduled app
                            // Or the program was NOT just opened
                            if (doExit || !firstOpen) {
                                firstOpen = false;
                                throw new Exception("No Weather Profiles specified");
                            } else {
                                firstOpen = false;
                                //open options to add profile
                                UiApplication.getUiApplication().invokeLater(new Runnable() {
                                //synchronized (UiApplication.getEventLock()) {
                                    public void run() {
                                        BBWeatherOptionScreen optionsScreen = BBWeatherOptionScreen.getInstance();
                                        UiApplication.getUiApplication().pushScreen(optionsScreen);
                                    }
                                //};
                                });
                                throw new Exception("No Weather Profiles specified");
                            }
                        }
                        //System.out.println("*** BBWeather: currentConditionsThread " + locationId);
                        // Retrieve current conditions data from weather.com
                        String xml = getWeatherDataFromUrl(getCurrentConditionsURL(locationId));

                        // Update our weather data cache with this new data
                        WeatherDataManager.getInstance().updateCurrentConditions(locationId,xml);

                        // If current conditions screen is displayed then update
                        // with new data
                        if (!doExit) { //make sure the CurrentConditionsScreen does not get loaded
                            if (CurrentConditionsScreen.getInstance().isDisplayed())
                                CurrentConditionsScreen.getInstance().updateData();
                        }
//#ifdef OS_COMPILE_ATLEAST_4_10
                        if (options.enableHomeScreen && (options.homeScreenIcon != 0 || options.homeScreenRollover != 0)) {
                            CurrentConditionsData ccData = null;
                            ccData = WeatherDataManager.getInstance().getCurrentConditionsByLocationId(locationId);
                            String shortCutKey = options.getLocationShortcutKey(locationId);
                            if (ccData != null) {
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
                                SimpleDateFormat sdFormat;
                                String theTime;
                                String appName;
                                /*String appName = ccData.temperature + "" + ccData.unitData.temperature
                                    + " " + ccData.description
                                    + (shortCutKey == null ? "" : ", " + shortCutKey)
                                    + ", " + theTime;*/
                                /*String appName = ccData.temperature + "" + ccData.unitData.temperature
                                            + " " + ccData.description
                                            + (shortCutKey == null ? "" : ", " + shortCutKey)
                                            //+ ", " + ccData.locationData.name
                                            + ", " + ccData.lastUpdate;*/

                                String theTemp = ccData.temperature;
                                if (options.useFeelsLike) {
                                    theTemp = ccData.feelsLikeTemperature;
                                }

                                if (options.homeScreenText == 0) {
                                    appName = "BBWeather";
                                } else if (options.homeScreenText == 1) { //Conditions
                                    appName = ccData.description
                                        + (shortCutKey == null ? "" : ", " + shortCutKey);
                                } else if (options.homeScreenText == 2) { //Full
                                    appName = theTemp + "" + ccData.unitData.temperature
                                        + " " + ccData.description
                                        + (shortCutKey == null ? "" : ", " + shortCutKey);
                                } else if (options.homeScreenText == 3) { //Conditions + Time
                                    sdFormat = new SimpleDateFormat("h:mma");
                                    theTime = sdFormat.formatLocal(new Date().getTime());
                                    appName = ccData.description
                                        + (shortCutKey == null ? "" : ", " + shortCutKey)
                                        + ", " + theTime;
                                } else if (options.homeScreenText == 4) { //Full + Time
                                    sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                                    theTime = sdFormat.formatLocal(new Date().getTime());
                                    appName = theTemp + "" + ccData.unitData.temperature
                                        + " " + ccData.description
                                        + (shortCutKey == null ? "" : ", " + shortCutKey)
                                        + ", " + theTime;
                                } else { //UpDate/Time
                                    sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                                    theTime = sdFormat.formatLocal(new Date().getTime());
                                    appName = theTime;
                                }

                                HomeScreen.setName(appName);
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
                                if (options.homeScreenIcon == 1)
                                    HomeScreen.updateIcon(ccData.bitmap);
                                if (options.homeScreenRollover == 1)
                                    HomeScreen.setRolloverIcon(ccData.bitmap);

                                if (options.homeScreenIcon > 1 || options.homeScreenRollover > 1) {
                                    int[] bgData = new int[32 * 32 + 1];
                                    int[] rlData = new int[32 * 32 + 1];
                                    int[] textData = new int[32 * 32 + 1];
                                    int[] newDataIcon = new int[32 * 32 + 1];
                                    int[] newDataRL = new int[32 * 32 + 1];

                                    Bitmap bgIcon = null;
                                    Bitmap rlIcon = null;

                                    if (options.homeScreenIcon == 2)
                                        bgIcon = ccData.bitmap;
                                    else
                                        bgIcon = Bitmap.getBitmapResource("images/blank.png");

                                    if (options.homeScreenRollover == 2)
                                        rlIcon = ccData.bitmap;
                                    else
                                        rlIcon = Bitmap.getBitmapResource("images/blank.png");

                                    bgIcon.getARGB(bgData, 0, 32, 0, 0, 32, 32);
                                    rlIcon.getARGB(rlData, 0, 32, 0, 0, 32, 32);

                                    Bitmap textIcon = new Bitmap(32, 32);
                                    Graphics g = new Graphics(textIcon);
                                    g.setDrawingStyle(Graphics.DRAWSTYLE_AALINES, true);
                                    FontFamily fontFamily = FontFamily.forName(options.iconFont); //user option
                                    int pointSZ = 12;
                                    Font theFont = fontFamily.getFont(Font.BOLD, pointSZ, Ui.UNITS_pt);

                                    int width = theFont.getAdvance(theTemp + "");
                                    while (width > 30 && pointSZ > 0) {
                                        pointSZ -= 1;
                                        theFont = fontFamily.getFont(Font.BOLD, pointSZ, Ui.UNITS_pt);
                                        width = theFont.getAdvance(theTemp + "");
                                    }

                                    int height = theFont.getHeight();
                                    width = (32 - width) / 2;
                                    height = (32 - height) / 2;

                                    g.setFont(theFont);
                                    g.setColor(options.homeScreenTextColor);
                                    g.drawText(theTemp + "", width, height, DrawStyle.TOP | DrawStyle.LEFT);
                                    //g.drawText(theTemp + "" + ccData.unitData.temperature, 0, 16, DrawStyle.VCENTER | DrawStyle.HCENTER);
                                    //g.drawText(theTemp + "", 2, 16, DrawStyle.VCENTER | DrawStyle.HCENTER);
                                    textIcon.getARGB(textData, 0, 32, 0, 0, 32, 32);

                                    for (int i = 0; i < bgData.length - 1; i++) {
                                        //if ((textData[i] & 0x00FFFFFF) != 0x00FFFFFF)
                                        if (textData[i] == 0xFFFFFFFF) {
                                            newDataIcon[i] = bgData[i];
                                            newDataRL[i] = rlData[i];
                                        } else {
                                            newDataIcon[i] = textData[i];
                                            newDataRL[i] = textData[i];
                                        }
                                    }

                                    if (options.homeScreenIcon > 1) {
                                        Bitmap newIcon = new Bitmap(32, 32);
                                        newIcon.setARGB(newDataIcon, 0, 32, 0, 0, 32, 32);
                                        HomeScreen.updateIcon(newIcon);
                                    }

                                    if (options.homeScreenRollover > 1) {
                                        Bitmap newIcon = new Bitmap(32, 32);
                                        newIcon.setARGB(newDataRL, 0, 32, 0, 0, 32, 32);
                                        HomeScreen.setRolloverIcon(newIcon);
                                    }

                                    g = null;
                                }
                            } else {
                                Bitmap homeIcon = Bitmap.getBitmapResource("images/weather/na.png");
                                HomeScreen.updateIcon(homeIcon);
                                HomeScreen.setRolloverIcon(null);
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
                                HomeScreen.setName("BBWeather");
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
                                //System.out.println("*** BBWeather: HomeScreen WeatherThread Failed " + locationId);
                            }
                        }
//#endif
                    } catch (Exception e) {
//#ifdef OS_COMPILE_ATLEAST_4_10
                        Bitmap homeIcon = null;
                        if (locationId == null)
                            homeIcon = Bitmap.getBitmapResource("images/main.png");
                        else
                            homeIcon = Bitmap.getBitmapResource("images/weather/na.png");
                        SimpleDateFormat sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                        String theTime = sdFormat.formatLocal(new Date().getTime());
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
                        HomeScreen.setName("BBWeather, " + theTime);
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
                        HomeScreen.updateIcon(homeIcon);
                        HomeScreen.setRolloverIcon(null);
//#endif
                        if (!doExit) { //make sure error message does not run when in homescreen mode
                            final String msg = "Error - Current Conditions Thread:\n" + e.getMessage();
                            UiApplication.getUiApplication().invokeLater(new Runnable() {

                                public void run() {
                                    CurrentConditionsScreen.getInstance().cleanup();
                                    CurrentConditionsScreen.getInstance().getStatusField().setText(msg);
                                    //Dialog.alert(msg); //removed dialog error, since error printerd on the screen
                                }
                            });
                            //System.out.println("*** Error current conditions thread: " + e.getMessage());
                        }
                    }

                    if (doExit) {
                        // Force a reload of options from disk and check if cancelExit was set to true
                        options = options.load(true);
                        doExit = false;

                        if (!options.cancelExit) {
                            Date dtTime = new Date();
                            Date dtTimeNew = new Date();
                            dtTimeNew.setTime(dtTime.getTime() + options.currentConditionsInterval * 60000);
                            try {
                                ApplicationDescriptor template = ApplicationDescriptor.currentApplicationDescriptor();
                                String[] args = {"homeScreen"}; //Integer.toString(options.currentConditionsInterval)};
                                ApplicationDescriptor newdescriptor = new ApplicationDescriptor(template, args);

                                ApplicationManager.getApplicationManager().scheduleApplication(newdescriptor, dtTimeNew.getTime(), true);

                                //if (ApplicationManager.getApplicationManager().scheduleApplication(newdescriptor, dtTimeNew.getTime(), true))
                                    //System.out.println("*** BBWeather Schedule Success Now = " + options.currentConditionsInterval + " - " + dtTime);
                                //else
                                    //System.out.println("*** BBWeather Schedule Failed Now = " + options.currentConditionsInterval + " - " + dtTime);
                            } catch (Exception e) { //pplicationManagerException e
                                //System.out.println("*** BBWeather Schedule Exception = " + e);
                            }
                            //System.out.println("*** BBWeather Schdule = " + options.currentConditionsInterval + " - " + dtTimeNew);

                            System.exit(0);
                        } else {
                            options.cancelExit = false;
                            options.save();
                            options = BBWeatherOptions.load(true);
                        }
                    } else {
                        /*try {
                            Thread.sleep(options.currentConditionsInterval * 60000);
                        } catch (Exception e) {
                        }*/
                    }

                }
            }
        });

        forecastThread = new Thread(new Runnable() {

            public void run() {

                //run this thread only if BBWeather is not in HomeScreen Update mode
                BBWeatherOptions options = null;
                /*if (doExit) {
                    isForecastThreadRunning = false;
                } else {
                    isForecastThreadRunning = true;
                    //options = BBWeatherOptions.load(false);
                }*/

                isForecastThreadRunning = true;
                options = BBWeatherOptions.load(false);

                while (isForecastThreadRunning) {
                    try {
                        Thread.sleep(options.forecastInterval * 60000);
                    } catch (Exception e) {
                    }

                    //only run if not exiting in homescreen mode
                    if (!doExit) {
                        try {
                            String locationId = options.getCurrentLocationId();
                            if (locationId == null) {
                                // If this is true, it means BBWeather was NOT just opened
                                if (firstOpen) {
                                    firstOpen = false;
                                    //open options to add profile
                                    UiApplication.getUiApplication().invokeLater(new Runnable() {
                                    //synchronized (UiApplication.getEventLock()) {
                                        public void run() {
                                            BBWeatherOptionScreen optionsScreen = BBWeatherOptionScreen.getInstance();
                                            UiApplication.getUiApplication().pushScreen(optionsScreen);
                                        }
                                    //};
                                    });
                                }
                                throw new Exception("No Weather Profiles specified");
                            }

                            // Retrieve forecast data from weather.com
                            String xml = getWeatherDataFromUrl(getForecastURL(locationId));

                            // Update our weather data cache with this new data
                            WeatherDataManager.getInstance().updateForecast(locationId,
                                                                            xml);

                            // If forecast screen is displayed then update with new
                            // data
                            if (ForecastScreen.getInstance().isDisplayed())
                                ForecastScreen.getInstance().updateData();
                            //else if (ForecastScreenQuick.getInstance().isDisplayed())
                            // ForecastScreenQuick.getInstance().updateData();
                        } catch (Exception e) {
                            final String msg = "Error - Daily Forecast Thread:\n" + e.getMessage();
                            UiApplication.getUiApplication().invokeLater(new Runnable() {

                                public void run() {
                                    ForecastScreen.getInstance().cleanup();
                                    ForecastScreen.getInstance().getStatusField().setText(msg);
                                    //Dialog.alert(msg); //removed dialog error, since error printerd on the screen
                                }
                            });
                            //System.out.println("*** Error forecast thread: " + e.getMessage());
                        }
                    }
                }
            }
        });
        
        hourlyThread = new Thread(new Runnable() {
            public void run() {
                String locationId = null;
                isHourlyThreadRunning = true;
                BBWeatherOptions options = BBWeatherOptions.load(false);
                
                while (isHourlyThreadRunning) {
                    try {
                        Thread.sleep(options.forecastInterval * 60000);
                    } catch (Exception e) {
                    }
                    
                    if (!doExit) {
                        try {
                            locationId = options.getCurrentLocationId();
                            if (locationId == null) {
                                // If this is true, it means BBWeather was NOT just opened
                                if (firstOpen) {
                                    firstOpen = false;
                                    //open options to add profile
                                    UiApplication.getUiApplication().invokeLater(new Runnable() {
                                    //synchronized (UiApplication.getEventLock()) {
                                        public void run() {
                                            BBWeatherOptionScreen optionsScreen = BBWeatherOptionScreen.getInstance();
                                            UiApplication.getUiApplication().pushScreen(optionsScreen);
                                        }
                                    //};
                                    });
                                }
                                throw new Exception("No Weather Profiles specified");
                            }

                            // Retrieve forecast data from weather.com
                            String xml = getWeatherDataFromUrl(getHourlyURL(locationId));

                            // Update our weather data cache with this new data
                            WeatherDataManager.getInstance().updateHourly(locationId,xml);

                            // If HourlyScreen is displayed then update with new
                            // data
                            if (HourlyScreen.getInstance().isDisplayed())
                                HourlyScreen.getInstance().updateData();
                        } catch (Exception e) {
                            final String msg = "Error - Hourly Forecast Thread:\n" + e.getMessage();
                            UiApplication.getUiApplication().invokeLater(new Runnable() {

                                public void run() {
                                    HourlyScreen.getInstance().cleanup();
                                    HourlyScreen.getInstance().getStatusField().setText(msg);
                                    //Dialog.alert(msg); //removed dialog error, since error printerd on the screen
                                }
                            });
                            //System.out.println("*** Error forecast thread: " + e.getMessage());
                        }
                    }
                }
            }
        });
    }

    //Used so that if no profiles are created, it only opens the Add Location screen on first open
    public static void setFirstOpen(boolean _firstOpen) {
        firstOpen = _firstOpen;
    }

    //for use in exiting after homescreen update mode and for cancelling homescreen exit mode
    public static void setExit(boolean _doExit) {
        doExit = _doExit;
        cancelSleep = !_doExit; // The first time this is set to true, it makes sure the current conditions thread runs and tires to grab data
        cancelSleep = cancelSleep;
    }

    //added to cause BBWeather to sleep for 60 seconds on startup
    public static void setIsStartup(boolean _isStartup) {
        isStartup = _isStartup;
    }

    public void start() {
        currentConditionsThread.start();
        forecastThread.start();
        hourlyThread.start();
    }

    public void currentConditionsForceUpdate() {
        currentConditionsThread.interrupt();
    }

    public void forecastForceUpdate() {
        forecastThread.interrupt();
    }

    public void hourlyForceUpdate() {
        hourlyThread.interrupt();
    }

    private String getConnectionType() {
        String type = ";deviceside=true";
        BBWeatherOptions options = BBWeatherOptions.load(false);
        //System.out.println("*** BBWeather getConnectionType=" + options.connectionType);

        options.usingConnectionType = "TCP/APN";

        switch (options.connectionType) {
            case 0:
//#ifdef OS_COMPILE_ATLEAST_4_30
                if (WLANInfo.getWLANState() == WLANInfo.WLAN_STATE_CONNECTED) {
                    type = ";deviceside=true;interface=wifi";
                    options.usingConnectionType = "Wifi";
                }
                else
//#endif
                {
                    int i;
                    ServiceRecord[] svcRecords = ServiceBook.getSB().findRecordsByCid("IPPP");
                    if (svcRecords != null) {
                        //System.out.println("*** svcRecords");
                        int numRecords = svcRecords.length;
                        for (i = 0; i < numRecords; i++) {
                            ServiceRecord svcRecord = svcRecords[i];
                            //System.out.println("*** svcRecords[] " + i);
                            if (svcRecord.isValid() && !svcRecord.isDisabled()) {
                                //System.out.println("*** Valid");
                                if (svcRecord.getEncryptionMode() == ServiceRecord.ENCRYPT_RIM) {
                                    options.usingConnectionType = svcRecord.getName();
                                    type =  ";deviceside=false"; //BES/MDS
                                } else if (svcRecord.getName().equals("IPPP for BIBS")) {
                                    //System.out.println("*** IPPP for BIBS");
                                    options.usingConnectionType = svcRecord.getName();
                                    type =  ";deviceside=false;ConnectionUID=" + svcRecord.getUid(); //BIS
                                }
                            }
                        }
                    }
                }/* else {
                        //Did not find Wifi or
                        //Did not find any IPPP service books, use deviceside TCP with APN
                        //System.out.println("*** BBWeather - Did not find any IPPP service books, use deviceside TCP with APN");
                }*/
                break;
            case 1:
                type =  ";deviceside=false"; //BES
                options.usingConnectionType = "BES";
                break;
            case 2:
                type = ";deviceside=false;ConnectionType=mds-public"; //BIS
                options.usingConnectionType = "BIS - mds-public";
                break;
            case 3:
                //type = ";deviceside=true";
                //options.usingConnectionType = "TCP/APN";
                break;
            case 4:
                type = ";deviceside=true;interface=wifi";
                options.usingConnectionType = "Wifi";
                break;
            default:
                break;
        }

        options.save(); //to save last connection type used

        //System.out.println("*** ;deviceside=true");
        return type + ";ConnectionTimeout=60000"; //added params for connection timeout
    }

    private synchronized String getCurrentConditionsURL(String locationId) {

        // Find location ID data
        BBWeatherOptions options = BBWeatherOptions.load(false);
        BBWeatherOptionsLocationData data = options.getLocationData(locationId);

        String url = WEATHER_SOAP_URL + data.id + WEATHER_SOAP_URL_CC
                + WEATHER_SOAP_REST + data.units;

        /*if (options.disableMDSProxy)
            url += ";deviceside=true";
        else
            url += ";deviceside=false";*/

        url += getConnectionType();

        //System.out.println("*** url=" + url);
        return url;
    }

    private synchronized String getForecastURL(String locationId) {

        // Find location ID data
        BBWeatherOptions options = BBWeatherOptions.load(false);
        BBWeatherOptionsLocationData data = options.getLocationData(locationId);

        String url = WEATHER_SOAP_URL + data.id + WEATHER_SOAP_URL_FORECAST
                + data.forecastDays + WEATHER_SOAP_REST + data.units;
        /*if (options.disableMDSProxy)
            url += ";deviceside=true";
        else
            url += ";deviceside=false";*/

        url += getConnectionType();

        //System.out.println("*** url=" + url);
        return url;
    }

    private synchronized String getHourlyURL(String locationId) {
        BBWeatherOptions options = BBWeatherOptions.load(false);
        BBWeatherOptionsLocationData data = options.getLocationData(locationId);

        String url = WEATHER_SOAP_URL + data.id + WEATHER_SOAP_URL_HOURLY
                + data.hourlyCount + WEATHER_SOAP_REST + data.units;

        url += getConnectionType();

        //System.out.println("*** url=" + url);
        return url;
    }

    //for Location ID search
    // from BBTodayPlugin.java
    private synchronized String URLEncode(String str) {
        if (str == null)
            return null;

        StringBuffer resultStr = new StringBuffer(str.length());
        char tmpChar;

        for (int ix = 0; ix < str.length(); ix++) {
            tmpChar = str.charAt(ix);
            switch (tmpChar) {
            case ' ':
                resultStr.append("%20");
                break;
            case '-':
                resultStr.append("%2D");
                break;
            case '/':
                resultStr.append("%2F");
                break;
            case ':':
                resultStr.append("%3A");
                break;
            case '=':
                resultStr.append("%3D");
                break;
            case '?':
                resultStr.append("%3F");
                break;
            case '#':
                resultStr.append("%23");
                break;
            case '\r':
                resultStr.append("%0D");
                break;
            case '\n':
                resultStr.append("%0A");
                break;
            default:
                resultStr.append(tmpChar);
                break;
            }
        }
        return resultStr.toString();
    }

    public synchronized String findLocationID(String location) {
        String retVal = null;

        try {
            String searchXML = getWeatherDataFromUrl(WEATHER_URL_SEARCH
                 + URLEncode(location) + getConnectionType()); //)
            //System.out.println("DEBUG: searchXML = " + searchXML);
            return searchXML;
        } catch (Exception e) {
            final String msg = "Error: " + e.getMessage();
            UiApplication.getUiApplication().invokeLater(new Runnable() {
                public void run() {
                    //BBWeatherOptionScreen.getInstance().getStatusField().setText(msg);
                    Dialog.alert(msg);
                }
            });
        }

        return retVal;
    }

    private String getWeatherDataFromUrl(String url) throws IOException {

        ContentConnection c = null;
        DataInputStream dis = null;

        try {
            c = (ContentConnection) Connector.open(url, Connector.READ_WRITE, true); //added params for connection timeout //Change READ to READ_WRITE for JDE v4.60
            dis = c.openDataInputStream();
            StringBuffer sb = new StringBuffer();
            int ch;
            while ((ch = dis.read()) != -1) {
                sb.append((char) ch);
            }

            //System.out.println("*** url data=\n" + sb.toString());
            return sb.toString();
        } catch (Exception e) {
            //System.out.println("BBWeather getConditionsWeatherData() Error: " + e.toString());
            throw new IOException(e.toString());
        } finally {
            if (dis != null) {
                try {
                    dis.close();
                } catch (Exception e) {
                }
            }
            if (c != null) {
                try {
                    c.close();
                } catch (Exception e) {
                }
            }
        }
    }
}
