
/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.util.Comparator;
import net.rim.device.api.util.Persistable;

public class BBWeatherOptionsLocationData implements Persistable {

    public static final Comparator LOCATION_COMPARATOR = new LocationComparator();

    public String id = null;
    public String description = null;
    public int forecastDays;
    public int hourlyCount;     public String units;
    public char shortcutKey = '\0';

    public BBWeatherOptionsLocationData() {
    }
    
    public BBWeatherOptionsLocationData(String id, String description, int forecastDays, int hourlyCount, String units, char shortcutKey) {
        this.id = id;
        this.description = description;
        this.forecastDays = forecastDays;
        this.hourlyCount = hourlyCount;
        this.units = units;
        this.shortcutKey = shortcutKey;
    }
    
    public String toString() {
        return description;
    }
    
    private static class LocationComparator implements Comparator {

        public int compare(Object o1, Object o2) {

            //return ((BBWeatherOptionsLocationData) o1).description.compareTo(((BBWeatherOptionsLocationData) o2).description); // Removed 2006-04-16, v0.75
                        // Added 2006-04-16, v0.75
                        // sort and ignore case
            String str1 = ((BBWeatherOptionsLocationData) o1).description.toLowerCase();
            String str2 = ((BBWeatherOptionsLocationData) o2).description.toLowerCase();
            return str1.compareTo(str2);
        }
    }
}
