//#preprocess
/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.blackberry.api.browser.Browser;
import net.rim.blackberry.api.browser.BrowserSession;
import net.rim.device.api.system.Characters;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.MainScreen;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.component.ButtonField;

import org.bbweather.utils.IconUtils;

import net.rim.blackberry.api.homescreen.HomeScreen;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.ApplicationDescriptor;
import java.util.Date;
import java.lang.Character;

import net.rim.device.api.ui.Graphics;
import net.rim.device.api.system.Display;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.system.Bitmap;

import net.rim.device.api.ui.FontFamily;
import net.rim.device.api.ui.Ui;

//#ifdef OS_COMPILE_ATLEAST_4_70
//import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.TouchEvent;
import net.rim.device.api.ui.TouchGesture;
//#endif

public abstract class AbstractWeatherScreen extends MainScreen {

    // Removed prod=xoap&
    private static final String URL_WEATHER_COM = "http://www.weather.com/?par=1006814500";

    protected Font defaultFont = null;

    protected Font defaultFontBold = null;

    protected Font defaultFontItalicBold = null;

    protected Font defaultFontLess4 = null;

    protected Font defaultFontMore6 = null;

    protected Font defaultFontLess4Bold = null;

    protected Font defaultFontMore6Bold = null;

    // This field has a dual purpose. It displays status messages while weather
    // is being retrieved and the location name once retrieval is finished
    protected RichTextField locationNameField = null;

    protected VerticalFieldManager managerRoot = null;

    protected LabelField lastUpdateField = null;

    protected LabelField attributionField = null;

    // Stop someone pressing space key so many times to cause overflow problems
    protected static boolean isProcessingKey = false;

//#ifdef OS_COMPILE_ATLEAST_4_70
    protected stormBtnMgr btnMgr = null;
    protected ButtonField button1 = null;
    protected ButtonField button2 = null;
    //protected ObjectChoiceField locationField = null;
//#endif

    protected int screenID = 0;

    protected AbstractWeatherScreen() {
        //removed Manager.HORIZONTAL_SCROLL to fix a bug with the Storm that allowed horizontal scroll past edge of page
        super(Manager.NO_VERTICAL_SCROLL | DEFAULT_MENU | DEFAULT_CLOSE);

        BBWeatherOptions options = BBWeatherOptions.load(false);

        locationNameField = new RichTextField(null, Field.NON_FOCUSABLE); // Field.FOCUSABLE NON_FOCUSABLE

//#ifdef OS_COMPILE_ATLEAST_4_70
        if (screenID == 0)
            btnMgr = new stormBtnMgr("Daily", "Hourly");
        else if (screenID == 1)
            btnMgr = new stormBtnMgr("Hourly", "Current");
        else
            btnMgr = new stormBtnMgr("Current", "Daily");
        button1 = btnMgr.getLeftButton();
        button2 = btnMgr.getRightButton();

        //button1.setChangeListener(button1Press);
        //button2.setChangeListener(button2Press);

        try {
            FontFamily fontFamily = FontFamily.forName(options.mainFont);
            Font theFont = fontFamily.getFont(Font.PLAIN, 7, Ui.UNITS_pt);
            button1.setFont(theFont);
            button2.setFont(theFont);
        } catch (Exception e) {
        }

        if (options.stormButtons)
            add(btnMgr);
//#endif

        add(locationNameField);
    }

    public abstract void updateData();

    public RichTextField getStatusField() {
        return locationNameField;
    }

    protected void onVisibilityChange(boolean visible) {
        if (visible) {
            updateData();
//#ifdef OS_COMPILE_ATLEAST_4_70
            setStormButtons();
//#endif
        }
    }

    protected void makeMenu(Menu menu, int instance) {

        // Add Location menu items
        final BBWeatherOptions options = BBWeatherOptions.load(false);
        if ((options.locationData != null) && (options.locationData.length > 1)) {
            for (int i = 0; i < options.locationData.length; i++) {
                final int index = i;
                MenuItem item = new MenuItem(options.locationData[index].description, i, 100) {

                    public void run() {
                        BBWeatherOptions theOptions = BBWeatherOptions.load(false);
                        theOptions.currentLocationId = options.locationData[index].id;
                        theOptions.save();
                        updateData();
                    }
                };
                menu.add(item);
            }
        }
        
        MenuItem item;

        if (screenID == 0) {
            //Current Conditions
            item = new MenuItem("Daily Forecast", 800000000, 100) {
                public void run() {
                    displayScreen(1);
                }
            };
            menu.add(item);
            item = new MenuItem("Hourly Forecast", 800000000, 100) {
                public void run() {
                    displayScreen(2);
                }
            };
			menu.add(item);
			item = new MenuItem("Update Now", 900000000, 100) {

				public void run() {
					WeatherThreadManager.getInstance().currentConditionsForceUpdate();
				}
			};
			menu.add(item);
        } else if (screenID == 1) {
            //Daily Forecast
            item = new MenuItem("Current Conditions", 800000000, 100) {
                public void run() {
                    displayScreen(0);
                }
            };
            menu.add(item);
            item = new MenuItem("Hourly Forecast", 800000000, 100) {
                public void run() {
                    displayScreen(2);
                }
            };
			menu.add(item);
			item = new MenuItem("Update Now", 900000000, 100) {

				public void run() {
					WeatherThreadManager.getInstance().forecastForceUpdate();
				}
			};
			menu.add(item);
        } else {
            //Hourly Forecast
            item = new MenuItem("Current Conditions", 800000000, 100) {
                public void run() {
                    displayScreen(0);
                }
            };
            menu.add(item);
            item = new MenuItem("Daily Forecast", 800000000, 100) {
                public void run() {
                    displayScreen(1);
                }
            };
			menu.add(item);
			item = new MenuItem("Update Now", 900000000, 100) {

				public void run() {
					WeatherThreadManager.getInstance().hourlyForceUpdate();
				}
			};
			menu.add(item);
        }

        item = new MenuItem("Options", 900000010, 100) {

            public void run() {
                BBWeatherOptionScreen.getInstance().UpdateData();
                UiApplication.getUiApplication().pushScreen(BBWeatherOptionScreen.getInstance());
                //setStormButtons();
            }
        };
        menu.add(item);

        /*if (options.stormButtons) {
            item = new MenuItem("Storm Buttons Off", 900000100, 100) {
                public void run() {
                    setStormButtons();
                }
            };
        } else {
            item = new MenuItem("Storm Buttons On", 900000100, 100) {
                public void run() {
                    setStormButtons();
                }
            };
        }
        menu.add(item);*/
        menu.addSeparator();

        item = new MenuItem("Close", 999999998, 999) {

            public void run() {
                doClose();
            }

        };
        menu.add(item);
        menu.addSeparator();

        item = new MenuItem("Exit", 999999999, 999) {

            public void run() {
                doExit();
            }

        };
        menu.add(item);
    }

    protected boolean keyDown(int keycode, int time) {
        BBWeatherOptions options = BBWeatherOptions.load(false); //move here

        char keyChar = Keypad.map(keycode);
        switch (keyChar) {
        case Characters.ESCAPE:
            switch (options.escapeKey) {
                case 0:
                    doExit();
                    break;
                case 1:
                    doClose();
                    break;
                default: //Ask
                String[] choices = {"Exit", "Close/Minimize", "Cancel"};
                /*Dialog dialog = new Dialog("",
                                           choices,
                                           null,
                                           0,
                                           Bitmap.getPredefinedBitmap(Bitmap.QUESTION),
                                           Dialog.LIST);
                int dialogReturn = dialog.doModal();*/
                int dialogReturn = Dialog.ask("", choices, 0);
                //System.out.println("*** dialogReturn=" + dialogReturn);
                switch (dialogReturn) {
                    case 0:
                        doExit();
                        break;
                    case 1:
                        doClose();
                        break;
                    default: //Discard, cancel
                        break;
                }
                break;
            }
            return true;
        //case 268566528:
        // return false;
        default:
            //System.out.println("*** key pressed=" + keyChar);

            // See if a shortcut key was pressed
            // 2008-05-30, keep it from locking up device when there are no weather profiles
            if (options.locationData == null) return false;

            for (int i = 0; i < options.locationData.length; i++) {
                if (options.locationData[i].shortcutKey != '\0'
                        && Character.toLowerCase(options.locationData[i].shortcutKey) == Character.toLowerCase(keyChar)) {
                    // We have a match so save the location ID we want to
                    // display
                    options.currentLocationId = options.locationData[i].id;
                    options.save();
                    updateData();
                    break;
                }
            }
        }

        return super.keyDown(keycode, time);
    }

    private void doExit() {
        BBWeatherOptions options = BBWeatherOptions.load(false);
        String locationId = options.getCurrentLocationId();

//#ifdef OS_COMPILE_ATLEAST_4_10
        if (options.enableHomeScreen && locationId != null) {
            Date dtTime = new Date();
            Date dtTimeNew = new Date();
            dtTimeNew.setTime(dtTime.getTime() + options.currentConditionsInterval * 60000);
            try {
                ApplicationDescriptor template = ApplicationDescriptor.currentApplicationDescriptor();
                String[] args = {"homeScreen"}; //Integer.toString(options.currentConditionsInterval)};
                ApplicationDescriptor newdescriptor = new ApplicationDescriptor(template, args);
                ApplicationManager.getApplicationManager().scheduleApplication(newdescriptor, dtTimeNew.getTime(), true);
                //if (ApplicationManager.getApplicationManager().scheduleApplication(newdescriptor, dtTimeNew.getTime(), true))
                    //System.out.println("*** BBWeather Schedule Success Now = " + options.currentConditionsInterval + " - " + dtTime);
                //else
                    //System.out.println("*** BBWeather Schedule Failed Now = " + options.currentConditionsInterval + " - " + dtTime);
            } catch (Exception e /*ApplicationManagerException e*/) {
                //System.out.println("*** BBWeather Schedule Exception = " + e);
            }
            //System.out.println("*** BBWeather Schdule = " + options.currentConditionsInterval + " - " + dtTimeNew);
        } else {
            //System.out.println("*** BBWeather Exit");
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
            HomeScreen.setName("BBWeather");
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
            HomeScreen.updateIcon(IconUtils.getBitmap("/images/main.png"));
            HomeScreen.setRolloverIcon(null);
        }
//#endif
        options.cancelExit = false; //always make sure options.CancelExit = false
        options.save();

        System.exit(0);
    }

    private void doClose() {
        UiApplication.getUiApplication().popScreen(this);
        UiApplication.getUiApplication().requestBackground();
    }

    protected Manager getAttributionInfo() {

        VerticalFieldManager managerRoot = new VerticalFieldManager(Field.FIELD_HCENTER)/* {
            // Added 2006-04-16, v0.76
            // Page Up/Down
            protected int nextFocus(int direction, boolean alt) {
                int index = this.getFieldWithFocusIndex();
                if (alt) {
                    /*if(direction > 0) {
                        // Action to perform if trackwheel is rolled up.
                        //forecastData.numberDays
                        //holder.headerField
                        String test;
                        test = "g";
                    }
                    else {
                        // Action to perform if trackwheel is rolled down.
                        String test;
                        test = "g";
                    }*
                    /*int idx = -1;
                    while ((idx = super.nextFocus(direction, alt)) != -1) {
                        Field field = super.getField(idx);
                        if (field instanceof LabelField) {
                            String test;
                            test = "g";
                        }
                    }*
                    int idx = -1;
                    idx = getVerticalScroll();
                    idx = getVirtualHeight();
                    idx = getVisibleHeight();
                    idx = 5;
                    index+=1;
                }
                if (index == this.getFieldWithFocusIndex())
                    return super.nextFocus(direction, alt);
                else
                    return index;
            }
        }*/;

        BitmapField logoField = new BitmapField(IconUtils.getBitmap("/images/weather/TWClogo_32px.png"),
                                                Field.FIELD_HCENTER | Field.NON_FOCUSABLE); //changed to NON_FOCUSABLE
        managerRoot.add(logoField);
        attributionField = new LabelField("Weather data provided by weather.com",
                                          Field.FIELD_HCENTER | Field.FOCUSABLE) {

            protected boolean trackwheelClick(int status, int time) {

                BrowserSession session = Browser.getDefaultSession();
                session.displayPage(URL_WEATHER_COM);
                return true;
            }
        };
        managerRoot.add(attributionField);

        return managerRoot;
    }

    protected boolean initFonts() { //changed void to boolean
        BBWeatherOptions options = BBWeatherOptions.load(false);
        /*defaultFont = Font.getDefault().derive(Font.PLAIN);
        defaultFontBold = defaultFont.derive(Font.BOLD);
        defaultFontItalicBold = defaultFont.derive(Font.ITALIC | Font.BOLD);
        defaultFontLess4 = defaultFont.derive(Font.PLAIN, defaultFont.getHeight() + options.fontSize); // 4);
        defaultFontMore6 = defaultFont.derive(Font.PLAIN, defaultFont.getHeight() + 10 + options.fontSize); // 6);
        defaultFontLess4Bold = defaultFont.derive(Font.BOLD, defaultFont.getHeight() + options.fontSize); // 4);
        defaultFontMore6Bold = defaultFont.derive(Font.BOLD, defaultFont.getHeight() + 10 + options.fontSize); // 6);//*/

        try {
            FontFamily fontFamily = FontFamily.forName(options.mainFont);
            defaultFont = fontFamily.getFont(Font.PLAIN, options.fontSize, Ui.UNITS_pt);
            defaultFontBold = defaultFont.derive(Font.BOLD);
            defaultFontItalicBold = defaultFont.derive(Font.ITALIC | Font.BOLD);
            defaultFontLess4 = defaultFont.derive(Font.PLAIN, defaultFont.getHeight() - 4);
            defaultFontMore6 = defaultFont.derive(Font.PLAIN, defaultFont.getHeight() + 6);
            defaultFontLess4Bold = defaultFont.derive(Font.BOLD, defaultFont.getHeight() - 4);
            defaultFontMore6Bold = defaultFont.derive(Font.BOLD, defaultFont.getHeight() + 6);
        } catch (Exception e) {
            return false;
        }

        return true;
    }

    protected String stackString(String inString) {
        String temp = inString;
        int startIdx = 0;
        String retVal = "";
        int dividerIdx = temp.indexOf(" /", startIdx);

        if (dividerIdx != -1) {
            while (dividerIdx != -1) {
                retVal += temp.substring(startIdx, dividerIdx) + "/";
                startIdx = dividerIdx + 2;
                dividerIdx = temp.indexOf(" /", startIdx);
            }
            retVal += temp.substring(startIdx);
        } else {
            retVal = inString;
        }

        return retVal.replace(' ', '\n');
    }

    protected void removeManagerRoot() {
        hideManagerRoot();
        managerRoot.deleteAll();
        managerRoot = null;
    }

    protected void displayManagerRoot() {
        add(managerRoot);
    }

    protected void hideManagerRoot() {
        if (managerRoot != null)
            if (managerRoot.getScreen() != null)
                delete(managerRoot);
    }
    
    protected void displayScreen(int id) {
        final int _id = id;
        UiApplication.getUiApplication().invokeLater(new Runnable() {
            public void run() {
                UiApplication.getUiApplication().popScreen(AbstractWeatherScreen.this);
                if (_id == 0) {
                    if (!CurrentConditionsScreen.getInstance().isDisplayed())
                        UiApplication.getUiApplication().pushScreen(CurrentConditionsScreen.getInstance());
                } else if (_id == 1) {
                    if (!ForecastScreen.getInstance().isDisplayed())
                        UiApplication.getUiApplication().pushScreen(ForecastScreen.getInstance());
                } else {
                    if (!HourlyScreen.getInstance().isDisplayed())
                        UiApplication.getUiApplication().pushScreen(HourlyScreen.getInstance());
                }
            }
        });
    }

//#ifdef OS_COMPILE_ATLEAST_4_70
    private void setStormButtons() {
        BBWeatherOptions options = BBWeatherOptions.load(false);
        if (!options.stormButtons && btnMgr.isVisible()) {
            delete(btnMgr);
        } else if (options.stormButtons && !btnMgr.isVisible()) {
            insert(btnMgr, 0);
        }

        //options.stormButtons = !options.stormButtons;
        //options.save();
    }

    /*protected FieldChangeListener button1Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            if (screenID == 0) {
                //Current Conditions
                displayScreen(2); //Hourly
            } else if (screenID == 1) {
                //Daily Forecast
                displayScreen(0); //Current
            } else {
                //Hourly Forecast
                displayScreen(1); //Daily
            }
        }
    };
    protected FieldChangeListener button2Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            if (screenID == 0) {
                //Current Conditions
                displayScreen(1); //Daily
            } else if (screenID == 1) {
                //Daily Forecast
                displayScreen(2); //Hourly
            } else {
                //Hourly Forecast
                displayScreen(0); //Current
            }
            //ButtonField buttonField = (ButtonField) field;
            //System.out.println("Button pressed: " + buttonField.getLabel());
        }
    };*/

    public static class FixedWidthButtonField extends ButtonField {
        private int _width;

        FixedWidthButtonField(int width) {
            super();
            _width = width;
        }

        FixedWidthButtonField(int width, long style) {
            super(style);
            _width = width;
        }

        FixedWidthButtonField(int width, String label) {
            super(label);
            _width = width;
        }

        FixedWidthButtonField(int width, String label, long style) {
            super(label, style);
            _width = width;
        }

        public int getPreferredWidth() {
            return _width;
        }

        public int getPreferredHeight() {
            return 40;
        }
    }

    private static class stormBtnMgr extends HorizontalFieldManager {
        private VerticalFieldManager leftMgr;
        private VerticalFieldManager rightMgr;
        private ButtonField leftBtn;
        private ButtonField rightBtn;

        private String labelA;
        private String labelB;

        public stormBtnMgr(String _labelA, String _labelB) {
            super(Field.NON_FOCUSABLE | USE_ALL_WIDTH);

            labelA = _labelA;
            labelB = _labelB;

            createBtns();
        }

        private void createBtns() {
            leftBtn = new ButtonField(labelA, Field.FIELD_LEFT | ButtonField.CONSUME_CLICK | Field.FOCUSABLE) {
                protected void layout(int width, int height) {
                    int w = width > getPreferredWidth() ? getPreferredWidth() : width;
                    int h = height > getPreferredHeight() ? getPreferredHeight() : height;
                    setExtent(w, h);
                    super.layout(w, h);
                }
            };
            rightBtn = new ButtonField(labelB, Field.FIELD_RIGHT | ButtonField.CONSUME_CLICK | Field.FOCUSABLE) {
                protected void layout(int width, int height) {
                    int w = width > getPreferredWidth() ? getPreferredWidth() : width;
                    int h = height > getPreferredHeight() ? getPreferredHeight() : height;
                    setExtent(w, h);
                    super.layout(w, h);
                }
            };

            leftMgr = new VerticalFieldManager(Field.NON_FOCUSABLE);
            rightMgr = new VerticalFieldManager(Manager.USE_ALL_WIDTH | Field.NON_FOCUSABLE);

            leftMgr.add(leftBtn);
            super.add(leftMgr);
            rightMgr.add(rightBtn);
            super.add(rightMgr);
        }

        public ButtonField getLeftButton() {
            return leftBtn;
        }

        public ButtonField getRightButton() {
            return rightBtn;
        }
    }

    protected void ChangeProfile(boolean fw) {
        BBWeatherOptions options = BBWeatherOptions.load(false);
        if ((options.locationData != null) && (options.locationData.length > 1)) {
            String currentLoc = options.getCurrentLocationId();
            for (int i = 0; i < options.locationData.length; i++) {
                if (currentLoc == options.locationData[i].id) {
                    if (fw) {
                        //forward
                        if (i + 1 >= options.locationData.length)
                            options.currentLocationId = options.locationData[0].id;
                        else
                            options.currentLocationId = options.locationData[i + 1].id;
                    } else {
                        if (i == 0)
                            options.currentLocationId = options.locationData[options.locationData.length - 1].id;
                        else
                            options.currentLocationId = options.locationData[i - 1].id;
                    }
                    options.save();
                    updateData();
                    break;
                }
            }
        }
    }

    protected boolean touchEvent(TouchEvent ev) {
        boolean consume = false;

        TouchGesture tg = ev.getGesture();
        if (tg != null) {
            if (tg.getEvent() == tg.SWIPE) {
                //int magnitude = tg.getSwipeMagnitude();

                switch(tg.getSwipeDirection()) {
                    case TouchGesture.SWIPE_NORTH:
                        ChangeProfile(false); //Backward
                        break;
                    case TouchGesture.SWIPE_SOUTH:
                        ChangeProfile(true); //Forward
                        break;
                    case TouchGesture.SWIPE_EAST:
                        if (screenID == 0) {
                            //Current Conditions
                            displayScreen(2); //Hourly
                        } else if (screenID == 1) {
                            //Daily Forecast
                            displayScreen(0); //Current
                        } else {
                            //Hourly Forecast
                            displayScreen(1); //Daily
                        }
                        break;
                    case TouchGesture.SWIPE_WEST:
                        if (screenID == 0) {
                            //Current Conditions
                            displayScreen(1); //Daily
                        } else if (screenID == 1) {
                            //Daily Forecast
                            displayScreen(2); //Hourly
                        } else {
                            //Hourly Forecast
                            displayScreen(0); //Current
                        }
                        break;
                }
                consume = true;
            }
        }
        if (consume)
            return true;
        else
            return super.touchEvent(ev);
    }
//#endif
}
