//#preprocess

/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.system.Characters;
import net.rim.device.api.ui.ContextMenu;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EditField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.NumericChoiceField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.ObjectListField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.FullScreen;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.container.MainScreen;

//from BBToday for Location Id Search
import java.io.ByteArrayInputStream;
import net.rim.device.api.xml.parsers.DocumentBuilder;
import net.rim.device.api.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import org.bbutils.ColorChoiceField;

import org.bbweather.data.LocationData;

//#ifdef OS_COMPILE_ATLEAST_4_10
import net.rim.blackberry.api.homescreen.HomeScreen;
//#endif
import net.rim.device.api.system.Bitmap;

import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.FontFamily;

import net.rim.device.api.ui.Ui;

public class BBWeatherOptionScreen extends MainScreen {

    private static BBWeatherOptionScreen screen = null;

    private static boolean isDirty = false;

    private static FieldChangeListener FIELD_CHANGE_LISTENER = new AllFieldChangeListener();

    private BBWeatherOptions options = null;

    private LocationListField locationField = null;

    private NumericChoiceField ccIntervalField = null;

    private NumericChoiceField forecastIntervalField = null;

    private ObjectChoiceField connectionTypeField = null;
    private LabelField lastConnectionTypeField = null;

    private ColorChoiceField currentTempField = null;

    private ColorChoiceField highTempField = null;

    private ColorChoiceField lowTempField = null;

    private ObjectChoiceField defaultScreenField = null;
    private CheckboxField activeOnStartupField = null;
    private CheckboxField enableHomeScreenField = null;
    private ObjectChoiceField HomeScreenTextField = null;
    private ColorChoiceField homeScreenTextColorField = null;
    private ObjectChoiceField HomeScreenIconField = null;
    private ObjectChoiceField HomeScreenRolloverField = null;
    private ObjectChoiceField iconFontField = null;
    private CheckboxField useFeelsLikeField = null;
    //private ObjectChoiceField updateHomeScreenField = null;
    private ObjectChoiceField escapeKeyField = null;
    private ObjectChoiceField hourlyScreenTypeField = null;
    //private ObjectChoiceField HomeScreenLocationField = null;
    //private NumericChoiceField HomeScreenLocationTimeoutField = null;
    private NumericChoiceField fontSizeField = null;
    private ObjectChoiceField mainFontField = null;

//#ifdef OS_COMPILE_ATLEAST_4_70
    private CheckboxField stormButtonField = null;
//#endif

    public Font optionFont;

    public static BBWeatherOptionScreen getInstance() {
        if (screen == null)
            screen = new BBWeatherOptionScreen();

        return screen;
    }

    public void UpdateData() {
        try {
            locationField.set(options.locationData);
            ccIntervalField.setSelectedValue(options.currentConditionsInterval);
            forecastIntervalField.setSelectedValue(options.forecastInterval);
            defaultScreenField.setSelectedIndex(options.defaultScreen);
            hourlyScreenTypeField.setSelectedIndex(options.hourlyScreenType);
            enableHomeScreenField.setChecked(options.enableHomeScreen);
            HomeScreenIconField.setSelectedIndex(options.homeScreenIcon);
            HomeScreenRolloverField.setSelectedIndex(options.homeScreenRollover);
            HomeScreenTextField.setSelectedIndex(options.homeScreenText);
            homeScreenTextColorField.setSelectedColor(options.homeScreenTextColor);
            iconFontField.setSelectedIndex(options.iconFont);
            useFeelsLikeField.setChecked(options.useFeelsLike);
            activeOnStartupField.setChecked(options.activeOnStartup);
            connectionTypeField.setSelectedIndex(options.connectionType);
            lastConnectionTypeField.setText(options.usingConnectionType);
            escapeKeyField.setSelectedIndex(options.escapeKey);
            fontSizeField.setSelectedValue(options.fontSize);
            mainFontField.setSelectedIndex(options.mainFont);
            currentTempField.setSelectedColor(options.currentTempColor);
            highTempField.setSelectedColor(options.highTempColor);
            lowTempField.setSelectedColor(options.lowTempColor);
//#ifdef OS_COMPILE_ATLEAST_4_70
            stormButtonField.setChecked(options.stormButtons);
//#endif
            /*FontFamily fontFamily = Font.getDefault().getFontFamily();
            optionFont = fontFamily.getFont(Font.PLAIN,
                                            options.fontSize > 9 ? 9 : options.fontSize < 6 ? 6 : options.fontSize,
                                            Ui.UNITS_pt);

            locationField.setFont(optionFont);
            locationField.setFont(optionFont);
            ccIntervalField.setFont(optionFont);
            forecastIntervalField.setFont(optionFont);
            defaultScreenField.setFont(optionFont);
            connectionTypeField.setFont(optionFont);
            lastConnectionTypeField.setFont(optionFont);
            currentTempField.setFont(optionFont);
            highTempField.setFont(optionFont);
            lowTempField.setFont(optionFont);
            activeOnStartupField.setFont(optionFont);
            enableHomeScreenField.setFont(optionFont);
            HomeScreenTextField.setFont(optionFont);
            HomeScreenIconField.setFont(optionFont);
            HomeScreenRolloverField.setFont(optionFont);
            iconFontField.setFont(optionFont);
            escapeKeyField.setFont(optionFont);
            hourlyScreenTypeField.setFont(optionFont);
            fontSizeField.setFont(optionFont);
            mainFontField.setFont(optionFont);*/

            isDirty = false;
        } catch (Exception e) {
            System.out.println("*** BBWeather UpdateData Options Exception = " + e);
        }
    }

    public BBWeatherOptionScreen() {
        super(DEFAULT_MENU | DEFAULT_CLOSE);

        setTitle("BBWeather Options");

        isDirty = false;

        options = BBWeatherOptions.load(false);

        add(new LabelField("Current Profiles:"));
        add(new SeparatorField());

        locationField = new LocationListField();
        locationField.set(options.locationData);
        add(locationField);
        add(new SeparatorField());
        // Spacing
        add(new LabelField(" "));

        activeOnStartupField = new CheckboxField("Activate on Startup", options.activeOnStartup);
        activeOnStartupField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(activeOnStartupField);

        String[] choices5 = {
            "Auto",
            "BES",
            "BIS",
            "Local TCP/APN",
            "Wifi"
        };

        connectionTypeField = new ObjectChoiceField("ConnectionType", choices5, options.connectionType);

        connectionTypeField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(connectionTypeField);

        String usingConnectionType = "    Last = " + (options.usingConnectionType == null ? "" : options.usingConnectionType);
        lastConnectionTypeField = new LabelField(usingConnectionType);
        add(lastConnectionTypeField);

        String[] choices3 = {
            "Exit",
            "Close/Minimize",
            "Ask"
        };
        escapeKeyField = new ObjectChoiceField("Escape Key Function", choices3, options.escapeKey);
        escapeKeyField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(escapeKeyField);

        add(new SeparatorField());

        ccIntervalField = new NumericChoiceField("Current & Homescreen Poll Interval (mins): ",
                                                 30,
                                                 8 * 30,
                                                 30,
                                                 0);
        ccIntervalField.setSelectedValue(options.currentConditionsInterval);
        ccIntervalField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(ccIntervalField);

        forecastIntervalField = new NumericChoiceField("Forecast Poll Interval (mins): ",
                                                       120,
                                                       8 * 30,
                                                       30,
                                                       0);
        forecastIntervalField.setSelectedValue(options.forecastInterval);
        forecastIntervalField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(forecastIntervalField);

        choices3[0] = "Current Conditions";
        choices3[1] = "Daily Forecast";
        choices3[2] = "Hourly Forecast";

        defaultScreenField = new ObjectChoiceField("Default Screen: ", choices3, options.defaultScreen);
        defaultScreenField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(defaultScreenField);

        choices3[0] = "Text Only";
        choices3[1] = "Text + Icons 2";
        choices3[2] = "Text + Icons 3";
        hourlyScreenTypeField = new ObjectChoiceField("Hourly Forecast Display: ", choices3, options.hourlyScreenType);
        hourlyScreenTypeField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(hourlyScreenTypeField);

        /*
        choices2[0] = "Last Profile";
        choices2[1] = "Cell/GPS";
        HomeScreenLocationField = new ObjectChoiceField("Homescreen Location: ", choices2, options.homeScreenLocation);
        HomeScreenLocationField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(HomeScreenLocationField);

        HomeScreenLocationTimeoutField = new NumericChoiceField("Homescreen Cell/GPS Timeout: ",
                                                 0,
                                                 180,
                                                 15,
                                                 15);
        HomeScreenLocationTimeoutField.setSelectedValue(options.homeScreenLocationTimeout);
        HomeScreenLocationTimeoutField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(HomeScreenLocationTimeoutField);
        */

        add(new SeparatorField());

        enableHomeScreenField = new CheckboxField("Enable HomeScreen Update", options.enableHomeScreen);
        enableHomeScreenField.setChangeListener(FIELD_CHANGE_LISTENER/*new FieldChangeListener() {
            public void fieldChanged(Field field, int context) {
                if (((CheckboxField) field).getChecked()) {
                    //updateHomeScreenField.setEditable(true);
                    HomeScreenIconField.setEditable(true);
                    HomeScreenRolloverField.setEditable(true);
                } else {
                    //updateHomeScreenField.setEditable(false);
                    HomeScreenIconField.setEditable(false);
                    HomeScreenRolloverField.setEditable(false);
                }
                isDirty = true;
            }
        }*/);
        add(enableHomeScreenField);

        String[] choices4 = {
            "None",
            "Conditions",
            "Conditions + Temp",
            "Temp"
        };
        HomeScreenIconField = new ObjectChoiceField("Homescreen Icon: ", choices4, options.homeScreenIcon);
        HomeScreenIconField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(HomeScreenIconField);

        HomeScreenRolloverField = new ObjectChoiceField("Homescreen Rollover: ", choices4, options.homeScreenRollover);
        HomeScreenRolloverField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(HomeScreenRolloverField);

        String[] choices6 = {
            "BBWeather",
            "Conditions",
            "Conditions + Temp",
            "Conditions + Time",
            "Conditions + Temp + Time",
            "UpDate/Time"
        };

        HomeScreenTextField = new ObjectChoiceField("Homescreen Text: ", choices6, options.homeScreenText);
        HomeScreenTextField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(HomeScreenTextField);

        homeScreenTextColorField = new ColorChoiceField("Homescreen Text Color: ", options.homeScreenTextColor);
        homeScreenTextColorField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(homeScreenTextColorField);


        FontFamily fontList[] = FontFamily.getFontFamilies();
        String[] fontChoices = new String[fontList.length];

        for (int i = 0; i < fontList.length; i++) {
            fontChoices[i] = fontList[i].getName();
        }

        iconFontField = new ObjectChoiceField("Homescreen Icon Font: ", fontChoices, options.iconFont);
        iconFontField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(iconFontField);

        useFeelsLikeField = new CheckboxField("Use Feels Like Temp", options.useFeelsLike);
        useFeelsLikeField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(useFeelsLikeField);
        add(new SeparatorField());

        fontSizeField = new NumericChoiceField("Base Font Size: ", 5, 12, 1, 0);
        fontSizeField.setSelectedValue(options.fontSize);
        fontSizeField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(fontSizeField);

        mainFontField = new ObjectChoiceField("Weather Font: ", fontChoices, options.mainFont == null ? fontChoices[0] : options.mainFont);
        mainFontField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(mainFontField);

        currentTempField = new ColorChoiceField("Current Temp Color: ", options.currentTempColor);
        currentTempField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(currentTempField);

        highTempField = new ColorChoiceField("High Temp Color: ", options.highTempColor);
        highTempField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(highTempField);

        lowTempField = new ColorChoiceField("Low Temp Color: ", options.lowTempColor);
        lowTempField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(lowTempField);
//#ifdef OS_COMPILE_ATLEAST_4_70
        stormButtonField = new CheckboxField("Storm Buttons Enabled", options.stormButtons);
        stormButtonField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(stormButtonField);
//#endif
        /*FontFamily fontFamily = Font.getDefault().getFontFamily();
        optionFont = fontFamily.getFont(Font.PLAIN,
                                        options.fontSize > 9 ? 9 : options.fontSize < 6 ? 6 : options.fontSize,
                                        Ui.UNITS_pt);

        locationField.setFont(optionFont);
        locationField.setFont(optionFont);
        ccIntervalField.setFont(optionFont);
        forecastIntervalField.setFont(optionFont);
        defaultScreenField.setFont(optionFont);
        connectionTypeField.setFont(optionFont);
        lastConnectionTypeField.setFont(optionFont);
        currentTempField.setFont(optionFont);
        highTempField.setFont(optionFont);
        lowTempField.setFont(optionFont);
        activeOnStartupField.setFont(optionFont);
        enableHomeScreenField.setFont(optionFont);
        HomeScreenTextField.setFont(optionFont);
        HomeScreenIconField.setFont(optionFont);
        HomeScreenRolloverField.setFont(optionFont);
        iconFontField.setFont(optionFont);
        escapeKeyField.setFont(optionFont);
        hourlyScreenTypeField.setFont(optionFont);
        fontSizeField.setFont(optionFont);
        mainFontField.setFont(optionFont);*/

        //Open Add Location screen if there are no locations
        if (options.getCurrentLocationId() == null)
            locationField.AddLocation();
    }

    protected void makeMenu(Menu menu, int instance) {

        MenuItem item = new MenuItem("Save", 900000000, 100) {
            public void run() {
                doSave();
                doClose();
            }
        };
        menu.add(item);
        menu.addSeparator();

        item = new MenuItem("Close", 999999999, 999) {
            public void run() {
                doClose();
            }

        };
        menu.add(item);
    }

    protected boolean keyDown(int keycode, int time) {
        switch (Keypad.map(keycode)) {
        case Characters.ESCAPE:
            doClose();
            return true;
        }

        return super.keyDown(keycode, time);
    }

    private void doSave() {
        //System.out.println("*** Saving options");
        int numLocations = locationField.getSize();
        BBWeatherOptionsLocationData[] locations = new BBWeatherOptionsLocationData[numLocations];

        // Save our new locations
        boolean foundCurrentLocation = false;
        for (int i = 0; i < numLocations; i++) {
            locations[i] = (BBWeatherOptionsLocationData) locationField.get(locationField,
                                                                            i);
            // Is our current location valid anymore?
            if (locations[i].id.equals(options.currentLocationId))
                foundCurrentLocation = true;
        }
        // If current location is not valid then remove
        if (!foundCurrentLocation)
            options.currentLocationId = null;
        options.locationData = locations;

        options.currentConditionsInterval = ccIntervalField.getSelectedValue();
        options.forecastInterval = forecastIntervalField.getSelectedValue();
        options.hourlyScreenType = hourlyScreenTypeField.getSelectedIndex();
        options.defaultScreen = defaultScreenField.getSelectedIndex();
        options.connectionType = connectionTypeField.getSelectedIndex();
        options.currentTempColor = currentTempField.getSelectedColor();
        options.highTempColor = highTempField.getSelectedColor();
        options.lowTempColor = lowTempField.getSelectedColor();

        options.activeOnStartup = activeOnStartupField.getChecked();
        options.enableHomeScreen = enableHomeScreenField.getChecked();
        options.homeScreenText = HomeScreenTextField.getSelectedIndex();
        options.homeScreenTextColor = homeScreenTextColorField.getSelectedColor();
        options.homeScreenIcon = HomeScreenIconField.getSelectedIndex();
        options.homeScreenRollover = HomeScreenRolloverField.getSelectedIndex();
        options.iconFont = iconFontField.toString(); //iconFontField.getChoice();
        options.useFeelsLike = useFeelsLikeField.getChecked();
        options.escapeKey = escapeKeyField.getSelectedIndex();
        //options.HomeScreenLocation = HomeScreenLocationField.getSelectedIndex();
        //options.HomeScreenLocationTimeout = HomeScreenLocationTimeoutField.getSelectedValue();
        options.fontSize = fontSizeField.getSelectedValue();
        options.mainFont = mainFontField.toString(); //iconFontField.getChoice();
//#ifdef OS_COMPILE_ATLEAST_4_70
        options.stormButtons = stormButtonField.getChecked();
//#endif
        options.save();

        isDirty = false;
//#ifdef OS_COMPILE_ATLEAST_4_10
        if (options.homeScreenIcon == 0) {
            Bitmap homeIcon = Bitmap.getBitmapResource("images/main.png");
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
            HomeScreen.setName("BBWeather");
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
            HomeScreen.updateIcon(homeIcon);
        }

        if (options.homeScreenRollover == 0)
            HomeScreen.setRolloverIcon(null);


//#endif
    }

    private void doClose() {
        int retVal = Dialog.DISCARD;
        if (isDirty) {
            retVal = Dialog.ask(Dialog.D_SAVE, "Changes made!");

            switch (retVal) {
                case Dialog.CANCEL:
                    break;
                case Dialog.SAVE:
                    doSave();
                case Dialog.DISCARD:
                    isDirty = false;
                    break;
            }
        }

        if (retVal != Dialog.CANCEL) {
            UiApplication.getUiApplication().popScreen(this);
        }
    }

    private static class AllFieldChangeListener implements FieldChangeListener {

        public void fieldChanged(Field field, int context) {
            isDirty = true;

            // Need to add something to update the homeScreenLocation choice field and also keep the current selection
        }
    }

    private static class LocationListField extends ObjectListField {

        public LocationListField() {
            super();
        }

        protected void makeContextMenu(ContextMenu contextMenu) {
            MenuItem item = new MenuItem("Add", 200000, 10) {

                public void run() {
                    BBWeatherLocationScreen screen = new BBWeatherLocationScreen(null);
                    UiApplication.getUiApplication().pushModalScreen(screen);
                    BBWeatherOptionsLocationData location = screen.getLocationData();
                    if (location != null) {
                        insert(getSize(), location);
                        isDirty = true;
                    }
                }
            };
            contextMenu.addItem(item);

            item = new MenuItem("Edit", 200005, 10) {

                public void run() {
                    int index = getSelectedIndex();
                    BBWeatherOptionsLocationData location = (BBWeatherOptionsLocationData) get(LocationListField.this,
                                                                                               index);
                    BBWeatherLocationScreen screen = new BBWeatherLocationScreen(location);
                    UiApplication.getUiApplication().pushModalScreen(screen);
                    location = screen.getLocationData();
                    //System.out.println("****** ret location=" + location);
                    if (location != null) {
                        delete(index);
                        insert(index, location);
                        setSelectedIndex(index);
                        isDirty = true;
                    }
                }
            };
            contextMenu.addItem(item);

            item = new MenuItem("Delete", 200010, 10) {

                public void run() {
                    int index = getSelectedIndex();
                    if (index >= 0) {
                        if (Dialog.ask(Dialog.D_YES_NO, "Are you sure?") == Dialog.YES) {
                            //System.out.println("*** Deleting index: " + index);
                            delete(index);
                            isDirty = true;
                        }
                    }
                }
            };

            contextMenu.addItem(item);
        }

        public void AddLocation() {
            BBWeatherLocationScreen screen = new BBWeatherLocationScreen(null);
            UiApplication.getUiApplication().pushModalScreen(screen);
            BBWeatherOptionsLocationData location = screen.getLocationData();
            if (location != null) {
                insert(getSize(), location);
                isDirty = true;
            }
        }

        private static class BBWeatherLocationScreen extends FullScreen {
            private EditField idField;
            private EditField descriptionField;

            private BBWeatherOptionsLocationData locationData = null;

            final NumericChoiceField forecastDaysField;
            final NumericChoiceField hourlyCountField;
            final ObjectChoiceField unitsField;
            final EditField shortcutField;

            private static boolean isDirtyLoc = false;

            private static FieldChangeListener FIELD_CHANGE_LISTENER_LOC = new AllFieldChangeListener();
            private static class AllFieldChangeListener implements FieldChangeListener {
                public void fieldChanged(Field field, int context) {
                    if (context >= 0)
                        isDirtyLoc = true;
                    //System.out.println("****** fieldChanged=" + context); //2147483648
                }
            }

            protected boolean keyDown(int keycode, int time) {
                switch (Keypad.map(keycode)) {
                    case Characters.ESCAPE:
                        String id = idField.getText().trim();
                        String description = descriptionField.getText().trim();

                        if (isDirtyLoc && (id.equals("") || description.equals(""))) {
                            if (Dialog.ask(Dialog.D_YES_NO, "Cancel Changes and Exit?", Dialog.YES) == Dialog.YES)
                                doClose();
                        } else {
                            if (isDirtyLoc) {
                                String[] choices = {"Save Changes and Exit", "Cancel Changes and Exit", "Cancel"};
                                /*Dialog dialog = new Dialog("",
                                                           choices,
                                                           null,
                                                           0,
                                                           Bitmap.getPredefinedBitmap(Bitmap.QUESTION),
                                                           Dialog.LIST);*/
                                //int dialogReturn = dialog.doModal();
                                int dialogReturn = Dialog.ask("", choices, 0);
                                //System.out.println("*** dialogReturn=" + dialogReturn);
                                switch (dialogReturn) {
                                    case 0:
                                        doSave();
                                    case 1:
                                        doClose();
                                        break;
                                    default: //Discard, cancel
                                        break;
                                }
                            } else {
                                doClose();
                            }
                        }
                        return true;
                }

                return super.keyDown(keycode, time);
            }

            private void doClose() {
                UiApplication.getUiApplication().popScreen(BBWeatherLocationScreen.this);
            }

            private void doSave() {
                String id = idField.getText().trim();
                String description = descriptionField.getText().trim();
                if (!id.equals("") && !description.equals("")) {
                    String shortcutKey = shortcutField.getText().trim();
                    int forecastDays = forecastDaysField.getSelectedValue();
                    int hourlyCount = hourlyCountField.getSelectedValue();
                    int index = unitsField.getSelectedIndex();
                    String units = (index == 0 ? "s" : "m");
                    locationData = new BBWeatherOptionsLocationData(id,
                                                                    description,
                                                                    forecastDays,
                                                                    hourlyCount,
                                                                    units,
                                                                    (shortcutKey.equals("")
                                                                            ? '\0'
                                                                            : shortcutKey.charAt(0)));
                    //System.out.println("****** locationdata=" + locationData);
                }
            }

            public BBWeatherLocationScreen(BBWeatherOptionsLocationData location) {

                super(DEFAULT_MENU | DEFAULT_CLOSE);

                isDirtyLoc = false;

                /*final EditField*/ idField = new EditField("Location ID: ",
                                                        (location == null
                                                                ? null
                                                                : location.id));
                idField.setChangeListener(FIELD_CHANGE_LISTENER_LOC);
                add(idField);
                /* final EditField*/ descriptionField = new EditField("Description: ",
                                                                 (location == null
                                                                         ? null
                                                                         : location.description));
                descriptionField.setChangeListener(FIELD_CHANGE_LISTENER_LOC);
                add(descriptionField);

                /*final NumericChoiceField*/ forecastDaysField = new NumericChoiceField("Forecast Days: ",
                                                                                    2,
                                                                                    10,
                                                                                    1,
                                                                                    0);
                forecastDaysField.setSelectedValue((location == null ? 5
                        : location.forecastDays));
                forecastDaysField.setChangeListener(FIELD_CHANGE_LISTENER_LOC);
                add(forecastDaysField);

                hourlyCountField = new NumericChoiceField("hourly Forecast Count: ",
                                                                                    10,
                                                                                    24,
                                                                                    1,
                                                                                    0);
                hourlyCountField.setSelectedValue((location == null ? 10
                        : location.hourlyCount));
                hourlyCountField.setChangeListener(FIELD_CHANGE_LISTENER_LOC);
                add(hourlyCountField);

                String[] choices = new String[] { "Standard", "Metric" };
                /*final ObjectChoiceField*/ unitsField = new ObjectChoiceField("Units: ",
                                                                           choices,
                                                                           (location == null
                                                                                   ? 0
                                                                                   : (location.units == "s"
                                                                                           ? 0
                                                                                           : 1)));
                unitsField.setChangeListener(FIELD_CHANGE_LISTENER_LOC);
                add(unitsField);

                /*final EditField*/ shortcutField = new EditField("Shortcut Key: ",
                                                              (location == null
                                                                      ? ""
                                                                      : (location.shortcutKey == '\0'
                                                                              ? ""
                                                                              : location.shortcutKey
                                                                                      + "")),
                                                              1,
                                                              Field.EDITABLE);
                shortcutField.setChangeListener(FIELD_CHANGE_LISTENER_LOC);
                add(shortcutField);

                ButtonField okButton = new ButtonField("OK",
                                                       ButtonField.CONSUME_CLICK);
                okButton.setChangeListener(new FieldChangeListener() {

                    public void fieldChanged(Field field, int context) {
                        String id = idField.getText().trim();
                        String description = descriptionField.getText().trim();
                        if (!id.equals("") && !description.equals("")) {
                            String shortcutKey = shortcutField.getText().trim();
                            int forecastDays = forecastDaysField.getSelectedValue();
                            int hourlyCount = hourlyCountField.getSelectedValue();
                            int index = unitsField.getSelectedIndex();
                            String units = (index == 0 ? "s" : "m");
                            locationData = new BBWeatherOptionsLocationData(id,
                                                                            description,
                                                                            forecastDays,
                                                                            hourlyCount,
                                                                            units,
                                                                            (shortcutKey.equals("")
                                                                                    ? '\0'
                                                                                    : shortcutKey.charAt(0)));
                            //System.out.println("****** locationdata=" + locationData);
                            UiApplication.getUiApplication().popScreen(BBWeatherLocationScreen.this);
                        }
                    }
                });
                //okButton.setChangeListener(FIELD_CHANGE_LISTENER);
                ButtonField cancelButton = new ButtonField("Cancel",
                                                           ButtonField.CONSUME_CLICK);
                cancelButton.setChangeListener(new FieldChangeListener() {

                    public void fieldChanged(Field field, int context) {
                        UiApplication.getUiApplication().popScreen(BBWeatherLocationScreen.this);
                    }
                });
                //cancelButton.setChangeListener(FIELD_CHANGE_LISTENER);
                HorizontalFieldManager horizontalManager = new HorizontalFieldManager(Field.FIELD_HCENTER);
                horizontalManager.add(okButton);
                horizontalManager.add(cancelButton);
                add(horizontalManager);
            }

            public BBWeatherOptionsLocationData getLocationData() {
                return locationData;
            }

            //for Location ID search
            // from WeatherDataManager.java
            private Document parseXMLPacket(String xml) throws Exception {

                Document document = null;
                ByteArrayInputStream bis = null;

                try {
                    bis = new ByteArrayInputStream(xml.getBytes());
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setIgnoringElementContentWhitespace(true);
                    factory.setAllowUndefinedNamespaces(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    document = builder.parse(bis);
                } finally {
                    if (bis != null)
                        bis.close();
                }

                return document;
            }

            //from BBToday
            protected void makeMenu(Menu menu, int instance) {
                MenuItem item = new MenuItem("Lookup Location ID", 100000, 100) {

                    public void run() {

                        Thread searchThread = new Thread(new Runnable() {

                            public void run() {
                                try {
                                    //System.out.println("DEBUG: locationData.id = " + idField.getText());
                                    String searchXML = WeatherThreadManager.getInstance().findLocationID(idField.getText());

                                    Document document = parseXMLPacket(searchXML);
                                    Element root = document.getDocumentElement();
                                    final NodeList locs = root.getElementsByTagName("loc");

                                    if (locs.getLength() > 1) {
                                        // If we only have more than one loc
                                        // then let the user choose which one
                                        int numLocs = locs.getLength();
                                        final Object[] locations = new Object[numLocs];
                                        final Object[] ids = new Object[numLocs];
                                        for (int i = 0; i < numLocs; i++) {
                                            Element loc = (Element) locs.item(i);
                                            locations[i] = loc.getFirstChild().getNodeValue();
                                            ids[i] = loc.getAttribute("id");
                                        }
                                        UiApplication.getUiApplication().invokeLater(new Runnable() {
                                            public void run() {
                                                int choice = Dialog.ask("Select Location ID:",
                                                                        locations,
                                                                        0);
                                                idField.setText((String) ids[choice]);
                                                descriptionField.setText((String) locations[choice]);
                                            }
                                        });
                                    } else if (locs.getLength() == 0) {
                                        UiApplication.getUiApplication().invokeLater(new Runnable() {
                                            public void run() {
                                                Dialog.inform("No Location ID found");
                                            }
                                        });
                                    } else {
                                        UiApplication.getUiApplication().invokeLater(new Runnable() {
                                            public void run() {
                                                Element loc = (Element) locs.item(0);
                                                idField.setText(loc.getAttribute("id"));
                                                descriptionField.setText(loc.getFirstChild().getNodeValue());
                                            }
                                        });
                                    }
                                } catch (Exception e) {
                                    //System.out.println("*** Error searching for location ID: " + e.getMessage());
                                }
                            }
                        });
                        searchThread.start();
                        /*try {
                            searchThread.join();
                        } catch (InterruptedException e) {
                        }*/
                    }
                };
                menu.add(item);
            }
        }
    }
}
