/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;
import net.rim.device.api.ui.Color;
import net.rim.device.api.util.Persistable;
import net.rim.device.api.util.Arrays; // Added 2006-04-16, v0.75

public class BBWeatherOptions {

    // org.bbweather.BBWeatherOptions$BBWeatherOptionsData
    public static final long KEY = 0x97c6942f336ca0e4L;

    private static BBWeatherOptions options = null;

    public int currentConditionsInterval = 30;

    public int forecastInterval = 120;

    public BBWeatherOptionsLocationData[] locationData = null;

    public String currentLocationId = null;

    public int connectionType = 0;

    public int currentTempColor = Color.CADETBLUE;

    public int highTempColor = Color.DARKRED;

    public int lowTempColor = Color.DARKCYAN;

    public boolean activeOnStartup = false;
    public boolean enableHomeScreen = false;
    public int homeScreenText = 3;
    public int homeScreenTextColor = Color.BLACK;;
    public int homeScreenIcon = 3;
    public int homeScreenRollover = 1; //Conditions
    public boolean useFeelsLike = false;
    //public int homeScreenLocation = 0;
    public int escapeKey = 0;
    public boolean cancelExit = false;
    public String usingConnectionType = null;
    public String iconFont = "BBCondensed";

    public int hourlyScreenType = 1;
    //public int homeScreenLocation = 0; //0 = last, 1 = Cell/GPS
    //public int homeScreenLocationTimeout = 30; //use for Cell/GPS
    public int fontSize = 7;
    public String mainFont = null;
    
    public int defaultScreen = 0;
//#ifdef OS_COMPILE_ATLEAST_4_70
    public boolean stormButtons = false;
//#endif
    public void save() {

        try {
            PersistentObject record = PersistentStore.getPersistentObject(KEY);
            BBWeatherOptionsData data = new BBWeatherOptionsData();
            data.currentConditionsInterval = currentConditionsInterval;
            data.forecastInterval = forecastInterval;
            Arrays.sort(locationData, BBWeatherOptionsLocationData.LOCATION_COMPARATOR); // Added 2006-04-16, v0.75
            data.locationData = locationData;
            data.currentLocationId = currentLocationId;
            data.connectionType = connectionType;
            data.currentTempColor = currentTempColor;
            data.highTempColor = highTempColor;
            data.lowTempColor = lowTempColor;

            data.defaultScreen = defaultScreen;
            data.activeOnStartup = activeOnStartup;
            data.enableHomeScreen = enableHomeScreen;
            data.homeScreenText = homeScreenText;
            data.homeScreenTextColor = homeScreenTextColor;
            data.homeScreenIcon = homeScreenIcon;
            data.homeScreenRollover = homeScreenRollover;
            data.useFeelsLike = useFeelsLike;
            //data.homeScreenLocation = homeScreenLocation;
            data.escapeKey = escapeKey;
            data.cancelExit = cancelExit;
            data.usingConnectionType = usingConnectionType;
            data.iconFont = iconFont;
            data.hourlyScreenType = hourlyScreenType;
            //data.homeScreenLocation = homeScreenLocation;
            //data.homeScreenLocationTimeout = homeScreenLocationTimeout;
            data.fontSize = fontSize;
            data.mainFont = mainFont;
//#ifdef OS_COMPILE_ATLEAST_4_70
            data.stormButtons = stormButtons;
//#endif
            record.setContents(data);
            record.commit();
        } catch (Exception e) {
            //System.out.println("*** Exception saving options: " + e.getMessage());
        }
    }

    public static BBWeatherOptions load(boolean refresh) {
        if (options == null) {
            options = new BBWeatherOptions();
            refresh = true;
        }

        //BBWeatherOptions options = new BBWeatherOptions();
        if (refresh) {
            try {
                PersistentObject record = PersistentStore.getPersistentObject(KEY);
                BBWeatherOptionsData data = (BBWeatherOptionsData) record.getContents();
                if (data != null) {
                    options.currentConditionsInterval = data.currentConditionsInterval;
                    options.forecastInterval = data.forecastInterval;
                    options.locationData = data.locationData;
                    options.currentLocationId = data.currentLocationId;
                    options.connectionType = data.connectionType;
                    options.currentTempColor = data.currentTempColor;
                    options.highTempColor = data.highTempColor;
                    options.lowTempColor = data.lowTempColor;

                    options.defaultScreen = data.defaultScreen;
                    options.activeOnStartup = data.activeOnStartup;
                    options.enableHomeScreen = data.enableHomeScreen;
                    options.homeScreenText = data.homeScreenText;
                    options.homeScreenTextColor = data.homeScreenTextColor;
                    options.homeScreenIcon = data.homeScreenIcon;
                    options.homeScreenRollover = data.homeScreenRollover;
                    options.useFeelsLike = data.useFeelsLike;
                    //options.homeScreenLocation = data.homeScreenLocation;
                    options.escapeKey = data.escapeKey;
                    options.cancelExit = data.cancelExit;
                    options.usingConnectionType = data.usingConnectionType;
                    options.iconFont = data.iconFont;
                    options.hourlyScreenType = data.hourlyScreenType;
                    //options.homeScreenLocation = data.homeScreenLocation;
                    //options.homeScreenLocationTimeout = data.homeScreenLocationTimeout;
                    options.fontSize = data.fontSize;
                    options.mainFont = data.mainFont;
//#ifdef OS_COMPILE_ATLEAST_4_70
                    options.stormButtons = data.stormButtons;
//#endif
                }
            } catch (Exception e) {
                //System.out.println("*** Exception loading options: " + e.getMessage());
            }
        }

        return options;
    }

    public String getCurrentLocationId() {

        String currentId = null;

        if (currentLocationId != null) {
            // Return currently displayed location ID
            currentId = currentLocationId;
        } else {
            // Return first in list
            if ((locationData != null) && (locationData.length > 0))
                currentId = locationData[0].id;
        }

        return currentId;
    }

    public String getLocationShortcutKey(String locationId) {
        String theKey = null;

        BBWeatherOptionsLocationData data = getLocationData(locationId);

        if (locationData != null && data.shortcutKey != '\0') {
            theKey = String.valueOf(data.shortcutKey);
        }

        return theKey;
    }

    public BBWeatherOptionsLocationData getLocationData(String locationId) {

        BBWeatherOptionsLocationData data = null;

        if (locationData != null) {
            for (int i = 0; i < locationData.length; i++) {
                if (locationData[i].id.equals(locationId)) {
                    data = locationData[i];
                    break;
                }
            }
        }

        return data;
    }

    private static class BBWeatherOptionsData implements Persistable {

        public int VERSION = 1;

        public int currentConditionsInterval;

        public int forecastInterval;

        public BBWeatherOptionsLocationData[] locationData;

        public String currentLocationId;

        public int connectionType;

        public int currentTempColor;

        public int highTempColor;

        public int lowTempColor;

        public int defaultScreen;
        public boolean activeOnStartup;
        public boolean enableHomeScreen;
        public int homeScreenText;
        public int homeScreenTextColor;
        public int homeScreenIcon;
        public int homeScreenRollover;
        public boolean useFeelsLike;
        //public int homeScreenLocation;
        public int escapeKey;
        public boolean cancelExit;
        public String usingConnectionType;
        public String iconFont;
        public int hourlyScreenType;
        //public int homeScreenLocation;
        //public int homeScreenLocationTimeout;
        public int fontSize;
        public String mainFont;
//#ifdef OS_COMPILE_ATLEAST_4_70
        public boolean stormButtons;
//#endif
    }
}
