/*
 crypto.h
 Cryptographic functions for TC container

 Copyright (c) 2006 Josh Harris
	
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	2006-10-18 - JHH
		* Original release
*/

#include <windows.h>

#include "tomcrypt.h"
#ifdef OTFExplorer_ICC
#pragma comment(lib,"./LibTomCrypt/tomcrypt_icc")
#else
#pragma comment(lib,"./LibTomCrypt/tomcrypt")
#endif

#define OTFExplorer

#define DISK_IV_SIZE				32
#define SECTOR_SIZE					512

#define TC_HASH_COUNT				3
#define TC_MODE_COUNT				2
#define TC_CIPHER_COUNT				6

#define OTF_AES						0
#define OTF_BLOWFISH				1
#define OTF_CAST5					2
#define OTF_SERPENT					3
#define OTF_TWOFISH					4
#define OTF_DES3					5
#define OTF_AES_TWOFISH				6
#define OTF_AES_TWOFISH_SERPENT		7
#define OTF_SERPENT_AES				8
#define OTF_SERPENT_TWOFISH_AES		9
#define OTF_TWOFISH_SERPENT			10

#define OTF_RIPEMD160				0
#define OTF_SHA1					1
#define OTF_WHIRLPOOL				2

#define OTF_LRW						0
#define OTF_CBC						1

#define OTF_ENCRYPT					0
#define OTF_DECRYPT					1

byte FlipBits(byte a);
void FlipBytes(byte *in, byte *out, int size);
void FlipBytesST(byte *in, int size);
void MirrorBytes(byte *in, byte *out, int size);

typedef struct
{
	symmetric_ECB ci_ecb[3];
	byte lrwKey[16];

	int enc_type;
	int cipher_idx[3];
	int cipher_count;

	int hash_idx;
	int mode_idx;

	INT64 m_i64Offset;
	BOOL bHidden;
	BOOL bHeader;

	byte BLK_T[16];
	byte lrwIdx[16];
	byte temp[16];

} OTFE_CONTEXT, *POTFE_CONTEXT;

int OTFE_Decrypt_Header(byte *intext, byte *plaintext, int len, byte *pwd, int pwd_len);
int OTFE_Block(OTFE_CONTEXT *ctx, int dir, byte *intext, byte *outtext, int len, INT64 idx);
int OTFE_LRW(OTFE_CONTEXT *ctx, int dir, byte *intext, byte *outtext, int len, INT64 idx);
int OTFE_ECB(int dir, byte *intext, byte *outtext, int len, symmetric_ECB *ecb);
int OTFE_Encrypt_Header(byte *intext, byte *outtext, int len, byte *pwd, int pwd_len);
