/*
 disc.cpp
 Functions for reading data from a file handle with/without encryption/decryption

 Copyright (c) 2006 Josh Harris
	
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	2006-10-18 - JHH
		* Original release
*/

#include "disc.h"

#ifdef OTFEXPLORER
#include "../../crypto.h"
extern OTFE_CONTEXT *crypt_ctx;
#endif

BOOL _FAT_disc_readSectors (HANDLE disc, u32 sector, u32 numSectors, void* buffer)
{
	DWORD dwResult;
	LARGE_INTEGER m_i64Pos;

#ifdef OTFEXPLORER
	m_i64Pos.QuadPart = crypt_ctx->m_i64Offset + (INT64)sector * BYTES_PER_READ;
#else
	m_i64Pos.QuadPart = (INT64)sector * BYTES_PER_READ;
#endif

	dwResult = SetFilePointer(disc, m_i64Pos.LowPart, &m_i64Pos.HighPart, FILE_BEGIN);

#ifdef OTFEXPLORER
	byte *ciphertext = new byte[BYTES_PER_READ];
	byte *plaintext = (byte *)buffer;
	INT64 idx;
char test[512];
	for (u32 i = 0; i < numSectors; i++) {
		idx = 1 + (INT64)(sector+i) * BYTES_PER_READ / crypt_ctx->ci_ecb[0].blocklen;
		if (!ReadFile(disc, ciphertext, BYTES_PER_READ, &dwResult, NULL))
			break;

		if (!OTFE_Block(crypt_ctx, OTF_DECRYPT, ciphertext, &plaintext[i*BYTES_PER_READ], BYTES_PER_READ, idx))
			break;

memcpy(test, &plaintext[i*BYTES_PER_READ], BYTES_PER_READ);
	}

	delete [] ciphertext;

	

	if (i == numSectors)
		return TRUE;
	else
		return FALSE;
#else
	return ReadFile(disc, buffer, numSectors * BYTES_PER_READ, &dwResult, NULL);
#endif
}

BOOL _FAT_disc_writeSectors (HANDLE disc, u32 sector, u32 numSectors, const void* buffer)
{
	DWORD dwResult;
	LARGE_INTEGER m_i64Pos;

#ifdef OTFEXPLORER
	m_i64Pos.QuadPart = crypt_ctx->m_i64Offset + (INT64)sector * BYTES_PER_READ;
#else
	m_i64Pos.QuadPart = (INT64)sector * BYTES_PER_READ;
#endif

	dwResult = SetFilePointer(disc, m_i64Pos.LowPart, &m_i64Pos.HighPart, FILE_BEGIN);

#ifdef OTFEXPLORER
	byte *ciphertext = new byte[BYTES_PER_READ];
	byte *plaintext = (byte *)buffer;
	INT64 idx;
	for (u32 i = 0; i < numSectors; i++) {
		idx = 1 + (INT64)(sector+i) * BYTES_PER_READ / crypt_ctx->ci_ecb[0].blocklen;

		if (!OTFE_Block(crypt_ctx, OTF_ENCRYPT, &plaintext[i*BYTES_PER_READ], ciphertext, BYTES_PER_READ, idx))
			break;

		if (!WriteFile(disc, ciphertext, BYTES_PER_READ, &dwResult, NULL))
			break;
	}

	delete [] ciphertext;

	if (i == numSectors)
		return TRUE;
	else
		return FALSE;
#else
	return WriteFile(disc, buffer, numSectors * BYTES_PER_READ, &dwResult, NULL);
#endif
}