#pragma once

#ifndef __OMFMOVIE_H
#define __OMFMOVIE_H

#include <Windows.h>
#include <stdlib.h>
#include <math.h>
#include <vector>
using namespace std;

// OMF Includes
#define OMFI_JPEG_CODEC
#include "omPublic.h"
#include "omMedia.h"
#include "omEffect.h"
#include "omDefs.h"
#include "omUtils.h"
#include "omMobMgt.h"

#define DATA_TYPE_IDAT		0	//RGBA, CDCI and DV
#define DATA_TYPE_JPEG		1
#define DATA_TYPE_MPG2		2
#define DATA_TYPE_TIFF		3
#define DATA_TYPE_WAV		4
#define DATA_TYPE_AIFF		5
#define DATA_TYPE_UNKNOWN	20

#define CODEC_TYPE_RGBA		0
#define CODEC_TYPE_CDCI		1
#define CODEC_TYPE_JPEG		2
#define CODEC_TYPE_DVC		3
#define CODEC_TYPE_DVCP		4
#define CODEC_TYPE_MPG2		5
#define CODEC_TYPE_TIFF		6
#define CODEC_TYPE_WAV		7
#define CODEC_TYPE_AIFF		8

//CODEC_RGBA_VIDEO
//CODEC_CDCI_VIDEO
//CODEC_JPEG_VIDEO
//CODEC_TIFF_VIDEO
#define CODEC_MPG2_VIDEO "MPG2"


//jpeglib
extern "C" {
    #include "jpeg/jpeglib.h"
    #include "jpeg/jerror.h"
}
#include <setjmp.h>

//Cedocida DV
#include "cedocidaDV/inttypes.h"
#include "cedocidaDV/decode.h"
#include "cedocidaDV/encode.h"
#include "cedocidaDV/config.h"

//libmpeg2
extern "C" {
    #include "mpeg2dec/include/mpeg2.h"
	#include "mpeg2dec/include/mpeg2convert.h"
}

///////////////////////////////////////////////////////////////////////////////
typedef struct
{
	omfRational_t editRate;
	omfInt32 nameSize;
	omfString name;
	omfPosition_t origin;
	omfTrackID_t trackID;
	omfSegObj_t segment;
} omfTrackInfo_t;

typedef struct // _FramePos
{
	omfUInt32 field1;
	omfUInt32 field2;
	omfUInt32 NextFrame;
} FramePos;

///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//for jpeg library - handling buffered input for decompression
static void init_source (j_decompress_ptr cinfo) { return; }
static boolean fill_input_buffer (j_decompress_ptr cinfo) { return 1; }
static void skip_input_data (j_decompress_ptr cinfo, long num_bytes) {
	if (num_bytes <= 0) return;
	cinfo->src->next_input_byte+=num_bytes;
	cinfo->src->bytes_in_buffer-=num_bytes;
}
static boolean resync_to_restart (j_decompress_ptr cinfo, int desired) { return 1; }
static void term_source (j_decompress_ptr cinfo) { return; }

struct my_error_mgr {
	struct jpeg_error_mgr pub;	/* "public" fields */
	jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

static void my_error_exit (j_common_ptr cinfo)
{
	/* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
	my_error_ptr myerr = (my_error_ptr) cinfo->err;

	/* Always display the message. */
	/* We could postpone this until after returning, if we chose. */
	(*cinfo->err->output_message) (cinfo);

	/* Return control to the setjmp point */
	longjmp(myerr->setjmp_buffer, 1);
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


class COmfMovieDec
{
	omfErr_t OMFError;
	omfSessionHdl_t OMFSession;
	omfHdl_t OMFFileHdl;
	omfFileRev_t OMFFileRev;
	int OMFVersion;
	omfObject_t OMFHeader, OMFObject;
	omfUID_t headMediaID;

	char *strStatus;
	char FileName[MAX_PATH];
	bool bSessionStarted;

	omfNumSlots_t mOMFNumMobs;

	omfInt32 m_iNumMedia, m_iNumDefs, m_iNumClassDC;

	//omfNumTracks_t vNumTracks, aNumTracks;
	//omfNumSlots_t vNumSlots, aNumSlots;

	//omfmMediaOpen
		//omfMediaHdl_t vMediaPtr, aMediaPtr;
		//omfMediaCriteria_t vMediaCrit, aMediaCrit;

	omfObject_t vMediaObject;
	omfProperty_t vMediaIDProperty;
	omfDDefObj_t vMediaDatakind;
	omfUniqueName_t IDATpropName;

	omfBool bReadMedia, bForceUseDataValue;
	bool bValidSourceMediaMob;
	omfUInt32 numBytes, numBytesRead, nBlockSize;
	omfPosition_t OMFOffset;

	//Video Properties
		omfFrameLayout_t frameLayout;
		omfPosition_t zeroPos, fourPos;
		omfUInt32 StoredHeight, StoredWidth;
		omfUInt32 DisplayHeight, DisplayWidth;
		omfUInt32 SampledHeight, SampledWidth;
		omfInt32 SampledXOffset, SampledYOffset;
		omfInt32 DisplayXOffset, DisplayYOffset;
		omfInt32 alphaTransparency;
		omfInt32 alignmentFactor;
		omfRational_t aspectRatio, fps;
		omfLength_t frameCount;
		omfLength_t FrameIndexOffset;
		omfUInt32 m_iFirstFrameOffset;

		FramePos m_FramePos;
		vector<FramePos> m_vFramePos;

	//Video Properties - Extended
		omfInt32 componentWidth;
		omfUInt32 horizontalSubsampling;
		omfColorSiting_t colorSiting;
		omfUInt32 blackReferenceLevel;
		omfUInt32 whiteReferenceLevel;
		omfUInt32 colorRange;
		omfInt16 paddingBits;
		omfInt32 videoLineMap[2];

	int m_iFieldOrder; //m_iFieldOrder

	int m_iCodec; //curFrame, DVType, Mpeg2Type;
	bool bFirstTime, bNeedFrameOffset;
	int m_iDecompressFrameSize;

	FILE *omfFile; //mpeg2File
	FILE *infoFile;
	bool bInfo;
	char infoFileName[MAX_PATH];
	omfUInt32 omfFileLength;//mpeg2FileLength;

	//omfFrameLayout_t AAFFrameLayout;

	struct jpeg_decompress_struct cinfo;
    struct jpeg_source_mgr jsrc;
    struct my_error_mgr jerr;

	mpeg2dec_t *mpeg2decoder;
    const mpeg2_info_t *mpeg2info;
    const mpeg2_sequence_t *mpeg2sequence;
    mpeg2_state_t mpeg2state;

	//jpeg row data
	uint8_t** rows;

	int ReadOMFHeader();
		omfErr_t ReadOMFDataDef(omfObject_t obj);
		omfErr_t ReadOMFClassDC(omfObject_t obj);
		int ReadOMFMediaData(omfObject_t obj, omfUID_t inMediaID);
	int ReadOMFMobs();
		omfErr_t ReadOMFCompositionMob(omfObject_t OMFMob);
		omfErr_t ReadOMFMasterMob(omfObject_t OMFMob);
		omfErr_t ReadOMFFileMob(omfObject_t OMFMob);
			omfErr_t ReadOMFRGBAObject();
			omfErr_t ReadOMFCDCIObject();
		omfErr_t ReadOMFTapeMob(omfObject_t OMFMob);
		omfErr_t ReadOMFFilmMob(omfObject_t OMFMob);
		omfErr_t ReadOMFUnknownSourceMob(omfObject_t OMFMob);
	bool InitializeDataRead(omfUInt32 frameNum);
	bool ReadOMFFrameIndex(); //vector<FramePos> *frameVec
	int jpeg_Decompress(char *jpgData, uint8_t **outputRows, long jpgSize, int row_stride, J_COLOR_SPACE colorModel);
	omfErr_t GetTrackInfo(omfHdl_t file, omfMobObj_t mob, omfMSlotObj_t slot, omfTrackInfo_t *mTrackInfo);

public:
	COmfMovieDec();
	~COmfMovieDec(void);
	void InitVariables();
	int OpenMovie(char *strFileName); //HRESULT
	bool ReadOMFData(omfUInt32 frameNum, char *pBuffer, size_t *bufSize1, size_t *bufSize2);
	char *OMFGetLastError() {
		if (strStatus)
			return strStatus;
		else
			return "No Error";
	}

	bool SetInfoFile(char *strName);
	void SetFieldOrder(int order) {m_iFieldOrder = order;}

	omfFrameLayout_t GetFrameLayout() {return frameLayout;}
	int GetCodec() {return m_iCodec;}
	int GetDecompressedSize() {return m_iDecompressFrameSize;}
	omfUInt32 GetStoredWidth() {return StoredWidth;}
	omfUInt32 GetStoredHeight() {return StoredHeight;}
	omfUInt32 GetDisplayWidth() {return DisplayWidth;}
	omfUInt32 GetDisplayHeight() {return DisplayHeight;}
	omfUInt16 GetDisplayXOffset() {return DisplayXOffset;}
	omfUInt16 GetDisplayYOffset() {return DisplayYOffset;}
	omfRational_t GetAspectRatio() {return aspectRatio;}
	omfRational_t GetFPS() {return fps;}
	omfLength_t GetFrameCount() {return frameCount;}
	omfUInt32 GetBlackLevel() {return blackReferenceLevel;}
	omfUInt32 GetWhiteLevel() {return whiteReferenceLevel;}
};

/*
	omfiMobGetNumTracks

	if (OMFFileRev == kOmfRev2x) {
		OMFPropertyID = OMHEADMediaData; // OMMediaData OMIDATImageData
		numMedia = omfsLengthObjRefArray(OMFFileHdl, OMFHeader, OMFPropertyID);
	} else {
		OMFPropertyID = OMMediaData;
		numMedia = omfsLengthObjIndex(OMFFileHdl, OMFHeader, OMFPropertyID);
	}
*/
#endif