///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <stdlib.h>
#include <math.h>
#include <objbase.h>
#include <vfw.h>

#include "./core/avisynth.h"

#include "levels.h"

// OMF Includes
#include "OmfMovie.h"

class OMFInput : public IClip
{
	VideoInfo vi;
	PVideoFrame dst;
	COmfMovieDec *m_OmfMovie;
	char FileName[MAX_PATH];
	char *strStatus;
	char* pBuffer;
	bool bInfo, m_iAdjustLevels;
	Levels mLevels;
	int m_iFieldOrder, m_iCodec;
	omfFrameLayout_t frameLayout;
	size_t m_lBlockSize1, m_lBlockSize2;
	int m_iDisplayXOffset, m_iDisplayYOffset;
	UINT32 m_iStoredWidth, m_iStoredHeight;

	//char *pField1, *pField2;
	//omfUInt32 mFieldLength1, mFieldLength2;

public:
	OMFInput(const char name[], const int _order, const bool _levels, const bool _info, IScriptEnvironment* env);
	virtual ~OMFInput();

// avisynth virtual functions
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
	bool __stdcall GetParity(int n);  // return field parity if field_based, else parity of first field in frame
	void __stdcall GetAudio(void* buf, __int64 start, __int64 count, IScriptEnvironment* env) {};  // start and count are in samples
	const VideoInfo& __stdcall GetVideoInfo();
	void __stdcall SetCacheHints(int cachehints,int frame_range) {};
};

class OMFOutput : public GenericVideoFilter
{
	VideoInfo vi;
	char FileName[512];
	char strFormat[10];
	int pitch, rowsize, height, width;

public:
	OMFOutput(PClip _child, const char name[], const char format[], IScriptEnvironment* env);
	virtual ~OMFOutput();

// avisynth virtual functions
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

AVSValue __cdecl Create_OMFInput(AVSValue args, void* user_data, IScriptEnvironment* env) {
	return new OMFInput(
	args[0].AsString(),     //Filename
	args[1].AsInt(-1),	//FieldOrder
	args[2].AsInt(0),  //Expand Levels 16-235 to 0-255
	args[3].AsInt(0),  //Display Fileinfo
	env);
}

AVSValue __cdecl Create_OMFOutput(AVSValue args, void* user_data, IScriptEnvironment* env) {
	return new OMFOutput(
	args[0].AsClip(),
	args[1].AsString(),     //Filename
	args[2].AsString("1:1"),
	env);
}

extern "C" __declspec(dllexport) const char* __stdcall AvisynthPluginInit2(IScriptEnvironment* env)
{
	env->AddFunction("OMFInput","[file]s[order]i[levels]i[info]i",Create_OMFInput,0);
	//env->AddFunction("OMFOutput","c[file]s[format]s",Create_OMFOutput,0);
	return 0;
}
