#include "stdafx.h"
#include "QTMovie.h"

//Moved vectors out of CQTMovieDec Class
//When m_vFrameBuffer was part of CQTMovieDec, UpdateFrameBuffer
//and IsFrameInBuffer would crash when audio = 5.1
myFrameBuffer m_sFrameBuffer;
vector < myFrameBuffer > m_vFrameBuffer;

bool SortByDisplayTime(const mpegFrameInfo & S1, const mpegFrameInfo & S2)
{
    return S1.mTime < S2.mTime;
}

bool SortByDecodeTime(const mpegFrameInfo & S1, const mpegFrameInfo & S2)
{
    return S1.mTimeDec < S2.mTimeDec;
}

bool SortByDisplayTime2(const frameInfo & S1, const frameInfo & S2)
{
    return S1.mTime < S2.mTime;
}

typedef struct {
    byte *pData;
    long height;
    long width;
    long rowsize;
    OSType pixelFormat;

    Track videoTrack;
    float pixelsPerSecond;      // the scale
    float startTimeInSeconds;   // the time of the left edge of the visible portion of the chart

    ICMDecompressionSessionRef decompressionSession;    // Used to decode frames as thumbnails.
    long lastDecompressedSampleDescIndex;
    SInt64 lastDecompressedSampleNumber;
    OSStatus lastDecompressionError;
} frameDataStruct;

frameDataStruct frameData;

CQTMovieDec::CQTMovieDec()
{
    OSErr err = noErr;

    m_Movie = NULL;
    m_vTrack = NULL;
    m_resRefNum = 0;
    m_GWorld = NULL;
    GWorldDataPtr = NULL;
    m_sFrameBuffer.data = NULL;
    pDataCompressed = NULL;
    m_imageDesc = NULL;
    m_seqID = NULL;
    m_decompressedData = NULL;
    m_decompressedDataPtr = NULL;
    m_compressedData = NULL;
    m_compressedDataPtr = NULL;
    inputAudioPtr = NULL;
    inputAudio = NULL;
    outputAudio = NULL;
    outputAudioPtr = NULL;
    m_lRawFrameSize = 0;
    m_lPrevFrameNum = -1;
    m_lLastFrameDecodeIdx = -1;
    audioType = 0;

    converter = NULL;
    ioData = NULL;

    hic = NULL;
    pbiSrc = NULL;
#ifdef QT_ICM
    decompressionSession = NULL;
#endif

#ifdef QTMOVIE_QT7
    bAudioExtractionApi = true;
#else
    bAudioExtractionApi = false;
#endif

    QTVersion7 = false;
    bIsLoaded = false;
    sprintf(strStatus, "No Error");

    err = InitializeQTML(kInitializeQTMLDisableDirectSound); //kInitializeQTMLDisableDirectSound kInitializeQTMLNoSoundFlag
    if (err != noErr) {
        sprintf(strStatus, "Unable to Initialize Quicktime Environment %d", err);
        return;
    }

    err = EnterMovies();
    if (err != noErr) {
        TerminateQTML();
        sprintf(strStatus, "Unable to Initialize Quicktime EnterMovies %d", err);
        return;
    }

    bIsLoaded = true;

    long version;
    OSErr result;

    result = Gestalt(gestaltQuickTime, &version);
    if ((result == noErr) && (version >= 0x07000000)) { //0x05020000 = 5.0.2
        QTVersion7 = true;
    }
}

////////////////////////////////////////////////////////////////////////////////

CQTMovieDec::~CQTMovieDec()
{
    if (converter) {
        SoundConverterClose(converter);
        converter = NULL;
    }

    if (m_seqID) {
        CDSequenceEnd(m_seqID);
        m_seqID = NULL;
    }

    if (m_iMode == 0) {
        //MoviesTask(m_Movie, 0);
        //StopMovie(m_Movie);
    }
#ifdef QT_VFW
    if (hic) {
        ICDecompressEnd(hic);
        ICClose(hic);
        if (pbiSrc)
            free(pbiSrc);
    }
#endif

#ifdef QT_ICM
    if (decompressionSession) {
        ICMDecompressionSessionFlush(decompressionSession);
        ICMDecompressionSessionRelease(decompressionSession);
        decompressionSession = NULL;
    }
#endif

    QTFreeMemory();
    ExitMovies();
    //TerminateQTML();
}

////////////////////////////////////////////////////////////////////////////////

void CQTMovieDec::QTFreeMemory()
{
    int i;
#ifdef QT_DSHOW
    QT_FREE_DSHOW(pME);
    QT_FREE_DSHOW(pMS);
    QT_FREE_DSHOW(pMP);
    QT_FREE_DSHOW(pMC);
    QT_FREE_DSHOW(pBA);
    QT_FREE_DSHOW(pBV);
    QT_FREE_DSHOW(pVW);
    QT_FREE_DSHOW(pFS);
    QT_FREE_DSHOW(d_pGraph);
#endif

#ifdef QT_ICM
    //QT_FREE_BUFFER(frameData.pData);
#endif

    QT_FREE_BUFFER(GWorldDataPtr);
    QT_FREE_BUFFER(m_sFrameBuffer.data);
    QT_FREE_BUFFER(pDataCompressed);

    QT_FREE_HANDLE(m_imageDesc);
    QT_FREE_HANDLE(inputAudio);
    QT_FREE_HANDLE(outputAudio);
    QT_FREE_HANDLE(m_decompressedData);

    for (i = 0; i < m_vFrameBuffer.size(); i++)
        QT_DELETE_BUFFER(m_vFrameBuffer[i].data);

    m_vFrameBuffer.clear();
    m_vKeyframes.clear();
    m_vFrameInfo.clear();
    m_vFrameInfoDisplay.clear();
    m_vFrameInfoDecode.clear();

    if (m_resRefNum) {
        CloseMovieFile(m_resRefNum);
        m_resRefNum = 0;
    }
    if (m_Movie) {
        DisposeMovie(m_Movie);
        m_Movie = NULL;
    }
    if (m_GWorld) {
        DisposeGWorld(m_GWorld);
        m_GWorld = NULL;
    }

    if (m_AudioExtractor) {
        MovieAudioExtractionEnd(m_AudioExtractor);
        m_AudioExtractor = NULL;

        if (ioData) {
            for (i = 0; i < ioData->mNumberBuffers; i++) {
                QT_FREE_BUFFER(ioData->mBuffers[i].mData);
                //QT_FREE_BUFFER(chan[i]);
            }
            free(ioData);
            ioData = NULL;
        }
    }

    if (sampleTable) {
        QTSampleTableRelease(sampleTable);
        sampleTable = NULL;
    }
}

////////////////////////////////////////////////////////////////////////////////

char *CQTMovieDec::GetErrorMessage()
{
    return strStatus;
}

////////////////////////////////////////////////////////////////////////////////

HRESULT CQTMovieDec::OpenMovie(char *strFileName, QTCodecInfo mCodec, int vTrackIdx, int aTrackIdx)
{
    OSErr err = noErr;

    m_CodecInfo = mCodec;

    c2pstrcpy(m_FileName, strFileName);
    FSMakeFSSpec(0, 0, m_FileName, &m_fileSpec);

    err = OpenMovieFile(&m_fileSpec, &m_resRefNum, fsRdPerm);
    if (err != noErr) {
        sprintf(strStatus, "Unable to Open Movie, err=%d :\n %s", err, strFileName);
        QTFreeMemory();
        return E_FAIL;
    }

    err = NewMovieFromFile(&m_Movie, m_resRefNum, nil, nil, newMovieActive, nil);
    if (err != noErr) {
        sprintf(strStatus, "NewMovieFromFile Error:\n %s", strFileName);
        QTFreeMemory();
        return E_FAIL;
    }

    /*unsigned flags = 0;
       flags |= hintsOffscreen | hintsAllowBlacklining | hintsDontDraw | hintsAllowInterlace | hintsDontUseVideoOverlaySurface;
       flags |= hintsPlayingEveryFrame;
       SetMoviePlayHints(m_Movie, flags, -1);
       PrePrerollMovie(m_Movie, 0, GetMoviePreferredRate(m_Movie), 0, 0);
       PrerollMovie(m_Movie, 0, GetMoviePreferredRate(m_Movie));
       SetMovieRate(m_Movie, GetMoviePreferredRate(m_Movie)); */

    //SetMoviePlayHints(m_Movie, hintsScrubMode, hintsScrubMode);
    SetMoviePlayHints(m_Movie, hintsAllowInterlace, hintsAllowInterlace);
    //SetMoviePlayHints(m_Movie, hintsAllowBlacklining, hintsAllowBlacklining);
    if (m_CodecInfo.quality > 0)
        SetMoviePlayHints(m_Movie, hintsHighQuality, hintsHighQuality);
    else
        SetMoviePlayHints(m_Movie, 0, hintsHighQuality);

    Track m_Track;
    Media m_Media;
    OSType mediaType;

    m_iTrackCount = 0;
    m_vTrackCount = 0;
    m_aTrackCount = 0;

    m_vMediaFrameCount = 0;
    m_vMovieFrameCount = 0;
    m_vTrackDur = 0;
    m_vMediaDur = 0;
    m_vMovieDur = GetMovieDuration(m_Movie);
    m_MovieTimeScale = GetMovieTimeScale(m_Movie);

    m_iTrackCount = GetMovieTrackCount(m_Movie);

    for (int i = 1; i <= m_iTrackCount; i++) {
        m_Track = GetMovieIndTrack(m_Movie, i);
        m_Media = GetTrackMedia(m_Track);

        GetMediaHandlerDescription(m_Media, &mediaType, nil, nil);
        if (mediaType == VideoMediaType) {
            m_vTrackCount++;
            if (m_vTrackCount == vTrackIdx) {
                if (m_CodecInfo.quality > 0)
                    SetMediaPlayHints(m_Media, hintsHighQuality, hintsHighQuality);
                else
                    SetMediaPlayHints(m_Media, 0, hintsHighQuality);

                m_vTrack = m_Track;
                m_vMedia = m_Media;

                m_vTrackFrame.left = 0;
                m_vTrackFrame.top = 0;
                m_vTrackRot = 0.0;
                GetMovieBox(m_Movie, &m_vTrackFrame);   //This gets the display size
                GetTrackMatrix(m_vTrack, &m_vTrackMatrix);      //RotateMatrix

                double pi = atan(1.0) * 4.0;    //M_PI
                m_vTrackRot =
                    (float) (atan2(FixedToFloat(m_vTrackMatrix.matrix[0][1]), FixedToFloat(m_vTrackMatrix.matrix[0][0]))
                             * 180.0 / pi);
                //if (m_vTrackFrame.bottom * FixedToFloat(m_vTrackMatrix.matrix[1][1]))
                //float display_aspect = (m_vTrackFrame.right * FixedToFloat(m_vTrackMatrix.matrix[0][0])) / (m_vTrackFrame.bottom * FixedToFloat(m_vTrackMatrix.matrix[1][1]));

              /*
              2011/03/30 trying to fix rotated movies, such as those shot on iPhone
              none of this seemed to work
              // instead, turned off //m_vTrackFrame.right = (**m_imageDesc).width; for mode = 0

              if (rotation != 0 && m_iMode != 0) {
                 //RotateMatrix(&m_vTrackMatrix, FloatToFixed(-rotation),
                 //   Long2Fix((long)(m_vTrackFrame.left + m_vTrackFrame.right) / 2),
                 //   Long2Fix((long)(m_vTrackFrame.top + m_vTrackFrame.bottom) / 2));
                 RotateMatrix(&m_vTrackMatrix,
                 FloatToFixed(-rotation),
                 Long2Fix((long)(m_vTrackFrame.right - m_vTrackFrame.left)) / 2,
                 Long2Fix((long)(m_vTrackFrame.bottom - m_vTrackFrame.top)) / 2);
                 SetTrackMatrix(m_vTrack, &m_vTrackMatrix);
                 short temp = m_vTrackFrame.bottom;
                 m_vTrackFrame.bottom = m_vTrackFrame.right;
                 m_vTrackFrame.right = temp;
               }


              Rect rotatedBounds;
              MatrixRecord matrix;
              SetIdentityMatrix(&matrix);
              // rotate about the center of the image
              RotateMatrix(&matrix, Long2Fix(0),
              Long2Fix((long)(m_vTrackFrame.left + m_vTrackFrame.right) / 2),
              Long2Fix((long)(m_vTrackFrame.top + m_vTrackFrame.bottom) / 2));
              RotateMatrix(&m_vTrackMatrix,
              Long2Fix(-90),
              Long2Fix((long)(m_vTrackFrame.right - m_vTrackFrame.left)) / 2,
              Long2Fix((long)(m_vTrackFrame.bottom - m_vTrackFrame.top)) / 2);
              // get the rotated image bounds
              rotatedBounds = m_vTrackFrame;
              TransformRect(&matrix, &m_vTrackFrame, NULL);
              SetTrackMatrix(m_vTrack, &matrix);

              //TransformRect(&m_vTrackMatrix, &m_vTrackFrame, nil); //FixedPoint *fpp

              //MatrixRecord matrixRecord;
              //SetIdentityMatrix(&matrixRecord);
              //SetTrackMatrix(m_vTrack, &matrixRecord);
              */

                m_vMediaFrameCount = GetMediaSampleCount(m_vMedia);
                m_vTrackDur = GetTrackDuration(m_vTrack);
                m_vMediaDur = GetMediaDuration(m_Media);
                m_vMediaTimeScale = GetMediaTimeScale(m_vMedia);
                SetMovieTimeScale(m_Movie, m_vMediaTimeScale);
                m_MovieTimeScale = GetMovieTimeScale(m_Movie);

                if (QTVersion7) {
                    m_vMediaSampleDuration = ((float) m_MovieTimeScale / (float) m_vMediaTimeScale) * (float) GetMediaDecodeDuration(m_vMedia) / (float) m_vMediaFrameCount;
                    m_SampleDuration = m_vMediaSampleDuration;
                } else {
                    m_vMediaSampleDuration = ((float) m_MovieTimeScale / (float) m_vMediaTimeScale) * (float) m_vMediaDur / (float) m_vMediaFrameCount; //2008-12-17
                    m_SampleDuration = m_vMediaSampleDuration;
                }

                TimeValue endTime;
                m_vTrackStartTime = GetTrackOffset(m_vTrack);
                endTime = GetTrackDuration(m_vTrack);
                m_vTrackIncrement = m_vMediaSampleDuration;     //2008-12-17(float)m_MovieTimeScale * m_vMediaSampleDuration / (float)m_vMediaTimeScale;

                m_imageDesc = (ImageDescriptionHandle) NewHandleClear(sizeof(ImageDescription));
                GetMediaSampleDescription(m_vMedia, 1, (SampleDescriptionHandle) m_imageDesc);

                if (m_iMode != 0) {
                    m_vTrackFrame.right = (**m_imageDesc).width;
                    m_vTrackFrame.bottom = (**m_imageDesc).height;
                }

                m_vMovieFrame = m_vTrackFrame;

                //Reset the Movie's display box to the same dimensions as the m_imageDesc
                //Sometimes the display size does not match the actual pixel dimensions stored in m_imageDesc
                SetMovieBox(m_Movie, &m_vTrackFrame);

                if (m_iMode == 0) {
                    //make sure right and bottom are now set to actual width and height
                    m_vMovieFrame.right -= m_vMovieFrame.left;
                    m_vMovieFrame.bottom -= m_vMovieFrame.top;
                    m_vMovieFrame.left = 0;
                    m_vMovieFrame.top = 0;
                }

                depth = (**m_imageDesc).depth;
                m_CodecInfo.m_iFourCC = (**m_imageDesc).cType;

                if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVdv') ||
                    m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvc ') || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvcp'))
                    bIsDV25 = true;

                p2cstrcpy(m_CodecInfo.CodecName, (**m_imageDesc).name);
            }
        } else if (mediaType == SoundMediaType) {
            //Temporarily disable audio if less than QT 7
            if (!QTVersion7)
                continue;

            m_aTrackCount++;
            if (m_aTrackCount == aTrackIdx) {
                m_aTrack = m_Track;
                m_aMedia = m_Media;
                m_aMediaSampleCount = GetMediaSampleCount(m_aMedia);
                m_aMediaDur = GetMediaDuration(m_aMedia);
                m_aTrackDur = GetTrackDuration(m_aTrack);

                m_aMediaTimeScale = GetMediaTimeScale(m_aMedia);
                m_AudioTimeBase = GetMovieTimeBase(m_Movie);

                /* create a description of the source sound so we can convert it later */
                source_sound_description = (SoundDescriptionV1Handle) NewHandle(0);
                //assert(source_sound_description != NULL); /* out of memory */

                GetMediaSampleDescription(m_aMedia, 1, (SampleDescriptionHandle) source_sound_description);

                source_sound_description_extension = NewHandle(0);
                //assert(source_sound_description_extension != NULL); /* out of memory */

                err = GetSoundDescriptionExtension((SoundDescriptionHandle) source_sound_description,
                                                   &source_sound_description_extension, siDecompressionParams);

                if (err == noErr) {

                    /* copy extension to atom format description if we have an extension */
                    source_sound_description_extension_size = GetHandleSize(source_sound_description_extension);
                    HLock(source_sound_description_extension);

                    source_sound_decomp_atom = (AudioFormatAtom *)
                        NewPtr(source_sound_description_extension_size);
                    //assert(source_sound_decomp_atom != NULL); /* out of memory */

                    BlockMoveData(*source_sound_description_extension,
                                  source_sound_decomp_atom, source_sound_description_extension_size);

                    HUnlock(source_sound_description_extension);
                } else {
                    source_sound_decomp_atom = NULL;
                }

                atom = source_sound_decomp_atom;
                source_format.flags = 0;
                source_format.format = (*source_sound_description)->desc.dataFormat;
                source_format.numChannels = (*source_sound_description)->desc.numChannels;
                source_format.sampleSize = (*source_sound_description)->desc.sampleSize;
                //source_format.sampleRate = UInt16((*source_sound_description)->desc.sampleRate >> 16);
                source_format.sampleRate = (*source_sound_description)->desc.sampleRate;
                source_format.sampleCount = GetMediaSampleCount(m_aMedia);
                source_format.buffer = NULL;
                source_format.reserved = 0;

                dest_format.flags = 0;
                //kSoundNotCompressed k16BitLittleEndianFormat
                dest_format.format = kSoundNotCompressed;
                dest_format.numChannels = (*source_sound_description)->desc.numChannels;
                dest_format.sampleSize = 16;    //(*source_sound_description)->desc.sampleSize;
                dest_format.sampleRate = (*source_sound_description)->desc.sampleRate;  //rate44khz
                dest_format.sampleCount = source_format.sampleCount;
                dest_format.buffer = NULL;
                dest_format.reserved = 0;

                DisposeHandle(source_sound_description_extension);
                DisposeHandle((Handle) source_sound_description);
            }
        }
    }

    return S_OK;
}

////////////////////////////////////////////////////////////////////////////////

bool CQTMovieDec::SetFormat(OSType mFormat, int mRaw, int mMode, float mGamma, int mOrder)
{
    //if (mFormat == k24BGRAPixelFormat || mFormat == k32BGRAPixelFormat) {
    m_pixelFormat = mFormat;
    rowOrder = mOrder;
    m_iRaw = mRaw;
    m_iMode = mMode;
    m_fGamma = mGamma;
    return true;
    //}
}

////////////////////////////////////////////////////////////////////////////////

#ifdef QT_DSHOW
int CQTMovieDec::InitDShow(char *strFourCC)
{
    HRESULT hr;
    if (d_pGraph)
        return S_OK;

    hr = CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, IID_IGraphBuilder, (void **) &d_pGraph);

    return S_OK;
}
#endif

#ifdef QT_VFW
int CQTMovieDec::Init_VFW(char *strFourCC)
{
    int mColorSpaceArray[4];
    int mColorSpace = -1;
    pbiSrc = (BITMAPINFOHEADER *) malloc(sizeof(BITMAPINFOHEADER));

    pbiSrc->biSize = sizeof(BITMAPINFOHEADER);
    pbiSrc->biWidth = m_vMovieFrame.right;
    pbiSrc->biHeight = m_vMovieFrame.bottom;
    pbiSrc->biPlanes = 1;
    pbiSrc->biBitCount = (**m_imageDesc).depth;

    pbiSrc->biSizeImage = 0;
    pbiSrc->biXPelsPerMeter = 0;
    pbiSrc->biYPelsPerMeter = 0;
    pbiSrc->biClrUsed = 0;
    pbiSrc->biClrImportant = 0;

    // try to decompress to YV12, YUY2, RGB32, and RGB24 in turn
    memset(&biDst, 0, sizeof(BITMAPINFOHEADER));
    biDst.biSize = sizeof(BITMAPINFOHEADER);
    biDst.biWidth = pbiSrc->biWidth;
    biDst.biHeight = pbiSrc->biHeight;
    biDst.biPlanes = 1;

    if (m_pixelFormat == k32BGRAPixelFormat) {  //RGB32
        mColorSpaceArray[0] = 1;
        mColorSpaceArray[1] = 0;
        mColorSpaceArray[2] = 2;
        mColorSpaceArray[3] = 3;
    } else if (m_pixelFormat == kYUVSPixelFormat) {     //YUY2
        mColorSpaceArray[0] = 2;
        mColorSpaceArray[1] = 3;
        mColorSpaceArray[2] = 0;
        mColorSpaceArray[3] = 1;
    } else if (m_pixelFormat == kYUV420PixelFormat) {   //YV12
        mColorSpaceArray[0] = 3;        //kMpegYUV420CodecType
        mColorSpaceArray[1] = 2;
        mColorSpaceArray[2] = 0;
        mColorSpaceArray[3] = 1;
    } else if (m_pixelFormat == k2vuyPixelFormat) {     //2VUY
        mColorSpaceArray[0] = 4;
        mColorSpaceArray[1] = 2;
        mColorSpaceArray[2] = 0;
        mColorSpaceArray[3] = 1;
    } else {                    //RGB24
        mColorSpaceArray[0] = 0;
        mColorSpaceArray[1] = 1;
        mColorSpaceArray[2] = 2;
        mColorSpaceArray[3] = 3;
    }

    int fourCC_Count = 1;
    if (strcmp(strFourCC, "") != 0 && strcmp(strFourCC, " ") != 0 && strcmp(strFourCC, "  ") != 0) {
        pbiSrc->biCompression = mmioStringToFOURCC(strFourCC, 0);
    } else {
        //Standardize the fourCC codes
        if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVdv')
            || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvc ')
            || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvcp')
            || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvpp'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('dv25');
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dv5n')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dv5p'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('dv50');
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVRn')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVDJ')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVRn')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('jpeg')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('mjpa')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('mjpb'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('mjpg');
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AV1x')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVUI')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('2Vuy')
                 || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('2vuy'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('uyvy');
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('yuv2'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('yuvu');     //YUYV, +YVYU, +UYVY, +VYUY
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('png '))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('mpng');
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('mp4v'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('XVID');
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('rle '))
            m_CodecInfo.m_iFourCC = 0x524C4534; //0x34454C52; RLE4
        else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('raw ')) {
            if (m_pixelFormat == k32BGRAPixelFormat)
                m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('RGB3');
            else if (m_pixelFormat == k2vuyPixelFormat)
                m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('2vuy');
            else if (m_pixelFormat == kYUV420PixelFormat)
                m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('yv12');
            else
                m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('RGB2');
        } else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('avc1'))
            m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('H264');

        pbiSrc->biCompression = MAKEFOURCC((m_CodecInfo.m_iFourCC & 0xFF000000) >> 24,
                                           (m_CodecInfo.m_iFourCC & 0x00FF0000) >> 16,
                                           (m_CodecInfo.m_iFourCC & 0x0000FF00) >> 8,
                                           (m_CodecInfo.m_iFourCC & 0x000000FF));
    }

    for (int h = 0; h < fourCC_Count; h++) {
        for (int i = 0; i < 4; i++) {
            if (mColorSpaceArray[i] == 0) {
                //RGB24
                biDst.biCompression = BI_RGB;
                biDst.biBitCount = 24;
                biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 3;
            } else if (mColorSpaceArray[i] == 1) {
                //RGB32
                biDst.biCompression = BI_RGB;
                biDst.biBitCount = 32;
                biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 4;
            } else if (mColorSpaceArray[i] == 2) {
                //YUY2
                biDst.biCompression = MAKEFOURCC('Y', 'U', 'Y', '2');   //'2YUY';
                biDst.biBitCount = 16;
                biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 2;
            } else if (mColorSpaceArray[i] == 4) {
                //YUY2
                biDst.biCompression = MAKEFOURCC('2', 'V', 'U', 'Y');   //'YUV2';
                biDst.biBitCount = 16;
                biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 2;
            } else {
                //YV12
                biDst.biCompression = MAKEFOURCC('Y', 'V', '1', '2');   //'21VY';
                biDst.biBitCount = 12;
                biDst.biSizeImage = biDst.biWidth * biDst.biHeight * biDst.biBitCount / 8;
            }

            hic = ICLocate(ICTYPE_VIDEO, NULL, pbiSrc, &biDst, ICMODE_DECOMPRESS);
            if (hic) {
                mColorSpace = mColorSpaceArray[i];
                if (mColorSpace == 0)
                    m_pixelFormat = k24BGRPixelFormat;
                else if (mColorSpace == 1)
                    m_pixelFormat = k32BGRAPixelFormat;
                else if (mColorSpace == 2)
                    m_pixelFormat = kYUVSPixelFormat;
                else if (mColorSpace == 3)
                    m_pixelFormat = kYUV420PixelFormat;
                else if (mColorSpace == 4)
                    m_pixelFormat = kYUV420PixelFormat;
                break;
            }
        }
        if (hic)
            break;
    }

    m_CodecInfo.m_iFourCC = MAKEFOURCC((pbiSrc->biCompression & 0xFF000000) >> 24,
                                       (pbiSrc->biCompression & 0x00FF0000) >> 16,
                                       (pbiSrc->biCompression & 0x0000FF00) >> 8, (pbiSrc->biCompression & 0x000000FF));

    if (!hic) {
        sprintf(strStatus, "Did not find a suitable %c%c%c%c codec",
                (m_CodecInfo.m_iFourCC & 0xFF000000) >> 24,
                (m_CodecInfo.m_iFourCC & 0x00FF0000) >> 16,
                (m_CodecInfo.m_iFourCC & 0x0000FF00) >> 8, (m_CodecInfo.m_iFourCC & 0x000000FF));
        return -1;
    }

    LRESULT result = ICDecompressBegin(hic, pbiSrc, &biDst);
    if (result != ICERR_OK) {
        sprintf(strStatus, "Unable to begin %c%c%c%c decompression, err = %d",
                (m_CodecInfo.m_iFourCC & 0xFF000000) >> 24,
                (m_CodecInfo.m_iFourCC & 0x00FF0000) >> 16,
                (m_CodecInfo.m_iFourCC & 0x0000FF00) >> 8, (m_CodecInfo.m_iFourCC & 0x000000FF), result);
        ICClose(hic);
        return -1;
    }

    m_CodecInfo.m_iFourCC = MAKEFOURCC((pbiSrc->biCompression & 0xFF000000) >> 24,
                                       (pbiSrc->biCompression & 0x00FF0000) >> 16,
                                       (pbiSrc->biCompression & 0x0000FF00) >> 8, (pbiSrc->biCompression & 0x000000FF));

    bVFW = true;
    return mColorSpace;
}
#endif

static void MyDecompressCompletionProc(OSErr result, short flags, long refcon)
{
}

///ICM/////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
#ifdef QT_ICM

static void releaseAndUnlockThis(void *info, const void *data, size_t size)
{
    CVPixelBufferRef pixelBuffer = (CVPixelBufferRef) info;

    CVPixelBufferUnlockBaseAddress(pixelBuffer, 0);
    CVBufferRelease(pixelBuffer);
}

static void QT_ICM_Decode_Frame(void *decompressionTrackingRefCon,
                                OSStatus result,
                                ICMDecompressionTrackingFlags decompressionTrackingFlags,
                                CVPixelBufferRef pixelBuffer,
                                TimeValue64 displayTime,
                                TimeValue64 displayDuration,
                                ICMValidTimeFlags validTimeFlags, void *reserved, void *sourceFrameRefCon)
{
    OSStatus err = noErr;
    if (kICMDecompressionTracking_ReleaseSourceData & decompressionTrackingFlags) {
        free(sourceFrameRefCon);
    }

    if ((kICMDecompressionTracking_EmittingFrame & decompressionTrackingFlags) && pixelBuffer) {
        size_t width, height, rowBytes;
        void *baseAddr = NULL;
        CVPixelBufferLockBaseAddress(pixelBuffer, 0);

        rowBytes = CVPixelBufferGetBytesPerRow(pixelBuffer);
        baseAddr = CVPixelBufferGetBaseAddress(pixelBuffer);
        width = CVPixelBufferGetWidth(pixelBuffer);
        height = CVPixelBufferGetHeight(pixelBuffer);

        byte *pTemp = (byte *) baseAddr;

        int offset1 = 0;
        int offset2 = 0;
        if (frameData.rowsize == rowBytes) {
            if (frameData.pixelFormat == k24RGBPixelFormat) {
                for (int h = 0; h < frameData.height; h++) {
                    offset1 = frameData.rowsize * h;
                    for (int w = 0; w < frameData.rowsize; w += 3) {
                        frameData.pData[offset1 + w] = pTemp[offset1 + w + 2];
                        frameData.pData[offset1 + w + 1] = pTemp[offset1 + w + 1];
                        frameData.pData[offset1 + w + 2] = pTemp[offset1 + w];
                    }
                }
            } else if (frameData.pixelFormat == k32ARGBPixelFormat) {
                for (int h = 0; h < frameData.height; h++) {
                    offset1 = frameData.rowsize * h;
                    for (int w = 0; w < frameData.rowsize; w += 4) {
                        frameData.pData[offset1 + w] = pTemp[offset1 + w + 3];
                        frameData.pData[offset1 + w + 1] = pTemp[offset1 + w + 2];
                        frameData.pData[offset1 + w + 2] = pTemp[offset1 + w + 1];
                        frameData.pData[offset1 + w + 3] = pTemp[offset1 + w];
                    }
                }
            } else {
                memcpy(frameData.pData, pTemp, frameData.height * rowBytes);
            }
        } else if (frameData.rowsize < rowBytes) {
            if (frameData.pixelFormat == k24RGBPixelFormat) {
                for (int h = 0; h < frameData.height; h++) {
                    offset1 = frameData.rowsize * h;
                    offset2 = rowBytes * h;
                    for (int w = 0; w < frameData.rowsize; w += 3) {
                        frameData.pData[offset1 + w] = pTemp[offset2 + w + 2];
                        frameData.pData[offset1 + w + 1] = pTemp[offset2 + w + 1];
                        frameData.pData[offset1 + w + 2] = pTemp[offset2 + w];
                    }
                }
            } else if (frameData.pixelFormat == k32ARGBPixelFormat) {
                for (int h = 0; h < frameData.height; h++) {
                    offset1 = frameData.rowsize * h;
                    offset2 = rowBytes * h;
                    for (int w = 0; w < frameData.rowsize; w += 4) {
                        frameData.pData[offset1 + w] = pTemp[offset2 + w + 3];
                        frameData.pData[offset1 + w + 1] = pTemp[offset2 + w + 2];
                        frameData.pData[offset1 + w + 2] = pTemp[offset2 + w + 1];
                        frameData.pData[offset1 + w + 3] = pTemp[offset2 + w];
                    }
                }
            } else {
                for (int i = 0; i < frameData.height; i++) {
                    memcpy(&frameData.pData[i * frameData.rowsize], pTemp, frameData.rowsize);
                    pTemp += rowBytes;
                }
            }
        }
    }
}

//From Quicktime
//http://developer.apple.com/qa/qa2005/qa1443.html
// Utility to set a SInt32 value in a CFDictionary
OSStatus SetNumberValue(CFMutableDictionaryRef inDict, CFStringRef inKey, SInt32 inValue)
{
    CFNumberRef number = CFNumberCreate(NULL, kCFNumberSInt32Type, &inValue);
    if (!number)
        return -1;

    CFDictionarySetValue(inDict, inKey, number);
    CFRelease(number);

    return noErr;
}

// Utility to add a SInt32 value in a CFDictionary
OSStatus AddNumberValue(CFMutableDictionaryRef inDict, CFStringRef inKey, SInt32 inValue)
{
    CFNumberRef number = CFNumberCreate(NULL, kCFNumberSInt32Type, &inValue);
    if (!number)
        return -1;

    CFDictionaryAddValue(inDict, inKey, number);
    CFRelease(number);

    return noErr;
}

// http://developer.apple.com/samplecode/ExampleIPBCodec/listing4.html
// Utility to add a double to a CFMutableinDict.
OSStatus addDoubleToDictionary(CFMutableDictionaryRef inDict, CFStringRef inKey, double inValue)
{
    CFNumberRef number = CFNumberCreate(NULL, kCFNumberDoubleType, &inValue);
    if (!number)
        return -1;

    CFDictionaryAddValue(inDict, inKey, number);
    CFRelease(number);

    return noErr;
}

OSStatus CQTMovieDec::createDecompressionSession(ImageDescriptionHandle imageDesc,
                                                 int width,
                                                 int height,
                                                 OSType pixelFormat,
                                                 ICMDecompressionTrackingCallback trackingCallback,
                                                 void *trackingRefCon,
                                                 ICMDecompressionSessionRef * decompressionSessionOut)
{
    OSStatus err = noErr;
    CFNumberRef number = NULL;
    CFMutableDictionaryRef pixelBufferAttributes = NULL;
    ICMDecompressionSessionOptionsRef sessionOptions = NULL;
    ICMDecompressionTrackingCallbackRecord trackingCallbackRecord;

    //Pixel Buffer attributes
    pixelBufferAttributes = CFDictionaryCreateMutable(NULL, 0,
                                                      &kCFTypeDictionaryKeyCallBacks, &kCFTypeDictionaryValueCallBacks);
    if (pixelBufferAttributes == NULL) {
        MessageBox(NULL, "error: pixelBufferAttributes", "", MB_OK);
    }
    //Failed
    //kYVU9PixelFormat
    //kYUV411PixelFormat
    //kYVYU422PixelFormat
    //kUYVY422PixelFormat
    //kYUV211PixelFormat
    //FOUR_CHAR_CODE('YV12')
    //

    //k32ARGBPixelFormat k24BGRPixelFormat kYUV420PixelFormat
    //pixelFormat = kYUV211PixelFormat ;
    //Success
    //k32ARGBPixelFormat
    //k24BGRPixelFormat
    //kYUVSPixelFormat              YUYV
    //kYUVUPixelFormat              UYVY
    //k2vuyPixelFormat              UYVY
    //k422YpCbCr8PixelFormat        UYVY
    //kYUV420PixelFormat            UYVY
    //
    //
    OSType pixelFormat2 = kYUV420PixelFormat;

    pixelFormat2 = pixelFormat;

    if (pixelFormat2 == k24BGRPixelFormat)
        pixelFormat2 = k24RGBPixelFormat;       //k24RGBPixelFormat
    else if (pixelFormat2 == k32BGRAPixelFormat)
        pixelFormat2 = k32ARGBPixelFormat;      //k32ARGBPixelFormat

    frameData.pixelFormat = pixelFormat2;

    err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferPixelFormatTypeKey, pixelFormat2);
    err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferWidthKey, width);
    err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferHeightKey, height);

    // This changes the display gamma for mode=3
    // the following causes YUY2 dvc codec to decompress corretly
    if (m_fGamma > 0) {
        err = addDoubleToDictionary(pixelBufferAttributes, kCVImageBufferGammaLevelKey, m_fGamma);
        CFDictionaryAddValue(pixelBufferAttributes, kCVImageBufferYCbCrMatrixKey,
                             kCVImageBufferYCbCrMatrix_ITU_R_601_4);
    }

#if 0
Disable, Doesn't Work???
    NCLCColorInfoImageDescriptionExtension nclc;

    err = ICMImageDescriptionGetProperty(imageDesc,
                                         kQTPropertyClass_ImageDescription,
                                         kICMImageDescriptionPropertyID_NCLCColorInfo, sizeof(nclc), &nclc, NULL);
    if (noErr == err) {
        // Assume NTSC
        nclc.colorParamType = kVideoColorInfoImageDescriptionExtensionType;
        nclc.primaries = kQTPrimaries_SMPTE_C;
        nclc.transferFunction = kQTTransferFunction_ITU_R709_2; //kQTTransferFunction_ITU_R709_2 kQTTransferFunction_Unknown
        nclc.matrix = kQTMatrix_ITU_R_601_4;    //kQTMatrix_ITU_R_601_4 kQTMatrix_Unknown
        ICMImageDescriptionSetProperty(imageDesc,
                                       kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_NCLCColorInfo,
                                       sizeof(nclc), &nclc);

        Fixed gammalevel;
        ICMImageDescriptionGetProperty(imageDesc,
                                       kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_GammaLevel,
                                       sizeof(gammalevel), &gammalevel, NULL);

        gammalevel = kQTUsePlatformDefaultGammaLevel;
        //gammalevel = kQTCCIR601VideoGammaLevel;

        ICMImageDescriptionSetProperty(imageDesc,
                                       kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_GammaLevel,
                                       sizeof(gammalevel), &gammalevel);

        err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
                                                        kQTPropertyClass_ICMDecompressionSessionOptions,
                                                        kICMImageDescriptionPropertyID_NCLCColorInfo,
                                                        sizeof(nclc), &nclc);
    }
#endif

    trackingCallbackRecord.decompressionTrackingCallback = trackingCallback;
    trackingCallbackRecord.decompressionTrackingRefCon = trackingRefCon;

    CodecQ codecAccuracy = m_CodecInfo.quality;  //codecLowQuality codecHighQuality
    ICMFieldMode fieldMode = kICMFieldMode_BothFields;  //kICMFieldMode_DeinterlaceFields kICMFieldMode_BothFields, kICMFieldMode_TopFieldOnly, kICMFieldMode_BottomFieldOnly
    err = ICMDecompressionSessionOptionsCreate(NULL, &sessionOptions);

    // set accuracy
    err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
                                                    kQTPropertyClass_ICMDecompressionSessionOptions,
                                                    kICMDecompressionSessionOptionsPropertyID_Accuracy,
                                                    sizeof(CodecQ), &codecAccuracy);

    // set field mode
    err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
                                                    kQTPropertyClass_ICMDecompressionSessionOptions,
                                                    kICMDecompressionSessionOptionsPropertyID_FieldMode,
                                                    sizeof(ICMFieldMode), &fieldMode);

    err = ICMDecompressionSessionCreate(NULL, imageDesc, sessionOptions,
                                        (CFDictionaryRef) pixelBufferAttributes, &trackingCallbackRecord,
                                        decompressionSessionOut);

    if (err) {
        fprintf(stderr, "ICMDecompressionSessionCreate failed(%d)", err);
    }

    if (pixelBufferAttributes)
        CFRelease(pixelBufferAttributes);
    if (sessionOptions)
        ICMDecompressionSessionOptionsRelease(sessionOptions);

    return err;
}
#endif
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

// Create a string that describes interesting sample flags.
static CFStringRef createStringForMediaSampleFlags(MediaSampleFlags sampleFlags)
{
    CFMutableStringRef str = NULL;
    str = CFStringCreateMutable(NULL, 0);

    if (0 == (mediaSampleNotSync & sampleFlags))
        CFStringAppend(str, CFSTR("sync\r"));
    if (mediaSampleDroppable & sampleFlags)
        CFStringAppend(str, CFSTR("droppable\r"));
    if (mediaSamplePartialSync & sampleFlags)
        CFStringAppend(str, CFSTR("partial sync\r"));
    return str;
}

HRESULT CQTMovieDec::InitializeGraphics(int audio, char *strFourCC, bool Yuv2Rgb, int dither, float vfrFPS)
{
    OSErr err = noErr;
    m_iDither = dither;
    audioType = audio;

    TimeValue64 offset1;
    SInt64 flags = 0;
    vector < mpegFrameInfo > m_vFrameInfo;
    mpegFrameInfo localFrameInfo;
    long myFrameCount = 0;
    SInt64 i;
    int j;
    bool bVfr = false;

    TimeValue Lowest_A, Lowest_B, Lowest_C;
    Lowest_A = Lowest_B = Lowest_C = 0;

    if (m_vTrackCount == 0)
        goto SETUP_AUDIO;

    bContainsDisplayOffsets = MediaContainsDisplayOffsets(m_vMedia);
    sampleTable = NULL;

    // Get the media sample table, use it for IBP codecs
    CopyMediaMutableSampleTable(m_vMedia, 0, NULL, 0, 0, (QTMutableSampleTableRef *) & sampleTable);

    // Assume codec is IFrame only
    // It will be changed if it finds a frame that is not a keyframe in the sample table
    bIFrameOnly = true;

    // Only use the sample table for IBP codecs and not Mode 0(QTMOVIE_MODE_MTASK)
    //              because if it is used on a ref movie, it will return all video frames
    //              from the source, not just the ones selected in the ref movie
    // This means that IBP ref movies currently do not work
    // Need to figure out how to determine what files are ref movies
    // Also, ref movies, currently return the correct audio samples through VDub,
    //              but the incorrect audio length, they return the full uncut audio length
    // Causes problems in other programs if seeking to time beyond what the ref movie contains
    bUseSampleTable = false;

    if (!sampleTable || m_iMode == 0) {
        short myFlags;
        OSType myTypes[1];
        myTypes[0] = VisualMediaCharacteristic;
        myFlags = nextTimeStep + nextTimeEdgeOK;
        TimeValue myCurTime64 = 0, myDur64 = 0;

        //GetMediaNextInterestingDisplayTime(m_vMedia, myFlags, (TimeValue64)0, fixed1, &myCurTime64, &myDur64);
        GetMovieNextInterestingTime(m_Movie, myFlags, 1, myTypes, (TimeValue) 0, fixed1, (TimeValue *) & myCurTime64,
                                    (TimeValue *) & myDur64);

        myFlags = nextTimeStep;

        localFrameInfo.mTimeDec = 0;
        localFrameInfo.mDurDec = 0;
        localFrameInfo.mFlags = 0;
        localFrameInfo.mOffset = 0;
        localFrameInfo.bKeyframe = true;

        while (myCurTime64 >= 0) {
            myFrameCount++;

            if (myDur64 > m_vMediaSampleDuration)
                bVfr = true;

            // Skip first and last frame
            if (myFrameCount > 1 && myFrameCount < m_vMediaFrameCount && myDur64 > 0) {
                if (myDur64 < Lowest_A || Lowest_A == 0) {
                    Lowest_B = Lowest_A;
                    Lowest_A = myDur64;
                } else if ((myDur64 < Lowest_B || Lowest_B == 0) && myDur64 != Lowest_A) {
                    Lowest_C = Lowest_B;
                    Lowest_B = myDur64;
                } else if ((myDur64 < Lowest_C || Lowest_C == 0) && myDur64 != Lowest_B && myDur64 != Lowest_A) {
                    Lowest_C = myDur64;
                }
            }

            localFrameInfo.mTime = myCurTime64;
            localFrameInfo.mDur = myDur64;
            localFrameInfo.idx = myFrameCount;
            m_vFrameInfo.push_back(localFrameInfo);

            //GetMediaNextInterestingDisplayTime(m_vMedia, nextTimeMediaSample, myCurTime64, fixed1, &myCurTime64, &myDur64);
            GetMovieNextInterestingTime(m_Movie, myFlags, 1, myTypes, (TimeValue) myCurTime64, fixed1,
                                        (TimeValue *) & myCurTime64, (TimeValue *) & myDur64);
        }
    }

    if (sampleTable && m_vFrameInfo.size() < 2) {
        m_vFrameInfo.clear();
        bUseSampleTable = true;

        TimeValue start = GetMediaDisplayStartTime(m_vMedia);
        TimeValue decodetime = GetMediaAdvanceDecodeTime(m_vMedia);

        TimeValue64 myCurTime64 = 0, myDur64 = 0;

        myFrameCount = 0;
        // Loop through all the frames(sample) in the movie
        SInt64 numSamples = QTSampleTableGetNumberOfSamples(sampleTable);
        for (i = 1; i <= numSamples; i++) {
            // Get the DisplayOffset and flags for this frame
            offset1 = QTSampleTableGetDisplayOffset(sampleTable, i);
            flags = QTSampleTableGetSampleFlags(sampleTable, i);

            // Get the MediaDisplay Time
            SampleNumToMediaDisplayTime(m_vMedia, i, &myCurTime64, &myDur64);

            localFrameInfo.mTime = myCurTime64;
            localFrameInfo.mDur = myDur64;
            localFrameInfo.idx = i - 1;
            localFrameInfo.mOffset = offset1;
            localFrameInfo.mFlags = flags;

            if (myDur64 > m_vMediaSampleDuration) {
                bVfr = true;
            }

            //Keep a running list of the three lowest frame display durations
            // Skip first and last frame
            if (i > 1 && i < m_vMediaFrameCount && myDur64 > 0) {
                if (myDur64 < Lowest_A || Lowest_A == 0) {
                    Lowest_B = Lowest_A;
                    Lowest_A = myDur64;
                } else if ((myDur64 < Lowest_B || Lowest_B == 0) && myDur64 != Lowest_A) {
                    Lowest_C = Lowest_B;
                    Lowest_B = myDur64;
                } else if ((myDur64 < Lowest_C || Lowest_C == 0) && myDur64 != Lowest_B && myDur64 != Lowest_A) {
                    Lowest_C = myDur64;
                }
            }

            // Get the MediaDecode Time
            SampleNumToMediaDecodeTime(m_vMedia, i, &myCurTime64, &myDur64);

            localFrameInfo.mTimeDec = myCurTime64;
            localFrameInfo.mDurDec = myDur64;
            localFrameInfo.bKeyframe = !(flags & mediaSampleNotSync);

            if (!(flags & mediaSampleNotSync) || (flags & mediaSampleDoesNotDependOnOthers)) {
                m_vKeyframes.push_back(i - 1);
            } else {
                bIFrameOnly = false;
            }

            // Store the frame in our Display frame vector
            m_vFrameInfo.push_back(localFrameInfo);
        }

        // Sort by display time
        sort(m_vFrameInfo.begin(), m_vFrameInfo.end(), SortByDisplayTime);
    }

    if (vfrFPS == 0 && bVfr) {
        //Guess the frameRate and m_vMediaSampleDuration
        float durFPS_A, durFPS_B, durFPS_C;
        durFPS_A = durFPS_B = durFPS_C = 0;

        vfrFPS = (float) m_vMediaFrameCount *(float) m_vMediaTimeScale / (float) m_vMediaDur;

        if (Lowest_A > 0)
            durFPS_A = (float) m_vMediaTimeScale / (float) Lowest_A;
        if (Lowest_B > 0)
            durFPS_B = (float) m_vMediaTimeScale / (float) Lowest_B;
        if (Lowest_C > 0)
            durFPS_C = (float) m_vMediaTimeScale / (float) Lowest_C;

        float diff = durFPS_A - vfrFPS;
        if (diff > abs(durFPS_B - vfrFPS)) {
            diff = durFPS_B - vfrFPS;
            m_vMediaSampleDuration = Lowest_B;
            vfrFPS = durFPS_B;

            if (diff > abs(durFPS_C - vfrFPS)) {
                diff = durFPS_C - vfrFPS;
                m_vMediaSampleDuration = Lowest_C;
                vfrFPS = durFPS_C;
            }
        } else if (diff > abs(durFPS_C - vfrFPS)) {
            diff = durFPS_C - vfrFPS;
            m_vMediaSampleDuration = Lowest_C;
            vfrFPS = durFPS_C;
        } else if (durFPS_A > 0) {
            m_vMediaSampleDuration = Lowest_A;
            vfrFPS = durFPS_A;
        }
    } else if (vfrFPS != 0) {
        if (vfrFPS < 0)
            vfrFPS = -vfrFPS;

        m_vMediaSampleDuration = m_vMediaTimeScale / vfrFPS;
    }

    myFrameCount = 0;
    for (i = 0; i < m_vFrameInfo.size(); i++) {
        localFrameInfo.mTime = m_vFrameInfo[i].mTime;
        localFrameInfo.mDur = m_vFrameInfo[i].mDur;
        localFrameInfo.mTimeDec = m_vFrameInfo[i].mTimeDec;
        localFrameInfo.mDurDec = m_vFrameInfo[i].mDurDec;
        localFrameInfo.mFlags = m_vFrameInfo[i].mFlags;
        localFrameInfo.mOffset = m_vFrameInfo[i].mOffset;
        localFrameInfo.bKeyframe = m_vFrameInfo[i].bKeyframe;

        if (m_vFrameInfo[i].mDur > m_vMediaSampleDuration) {
            bVfr = true;
            int count = 0.5 + ((float) m_vFrameInfo[i].mDur / m_vMediaSampleDuration);
            for (j = 0; /*i < count && myCount * vfrFPS < myCurTime + myDur64 */ ; j++) {
                myFrameCount++;

                localFrameInfo.idx = i;

                m_vFrameInfoDisplay.push_back(localFrameInfo);
                m_vFrameInfoDecode.push_back(localFrameInfo);

                if (j + 1 >= count)
                    break;
            }
        } else {
            myFrameCount++;
            localFrameInfo.idx = i;

            m_vFrameInfoDisplay.push_back(localFrameInfo);
            m_vFrameInfoDecode.push_back(localFrameInfo);
        }
    }

    // Sort by decode time
    sort(m_vFrameInfoDecode.begin(), m_vFrameInfoDecode.end(), SortByDecodeTime);

    m_vFrameInfo.clear();

    // Make sure there is not an empty frame in m_vFrameInfoDisplay
    if (m_vMediaFrameCount > 1 && myFrameCount < 2) {
        m_vFrameInfoDisplay.clear();
        m_vMovieFrameCount = m_vMediaFrameCount;
    } else {
        m_vMovieFrameCount = myFrameCount;
    }

    if (vfrFPS < 0) {
        char strTemp[MAX_PATH];
        p2cstrcpy(strTemp, m_FileName);
        strcat(strTemp, "_samples.txt");
        FILE *stream = fopen(strTemp, "wb");

        TimeBase tb = GetMovieTimeBase(m_Movie);
        if (stream) {
            fprintf(stream, "m_vTrackStartTime = %d, myCountVisual = %d, m_vMediaFrameCount = %d, m_vTrackIncrement = %0.5f\n" "m_MovieTimeScale = %d, m_vMediaTimeScale = %d, m_SampleDuration = %0.2f, m_vMediaSampleDuration = %0.2f\n" "movierate=%0.2f, m_vMovieDur=%d, myCurTime=%d\n" "m_vTrackDur=%d, m_vMediaDur=%d, m_vFrameInfoSize=%d\n" "m_iTrackCount = %d, m_vTrackCount = %d, m_aTrackCount = %d\n" "m_aMediaDur = %d, m_aTrackDur = %d, m_aMediaTimeScale = %d\n" "dest_format.sampleCount = %d, m_aMediaSampleCount = %d\n\n", (int) m_vTrackStartTime, myFrameCount, m_vMediaFrameCount, m_vTrackIncrement, m_MovieTimeScale, m_vMediaTimeScale, m_SampleDuration, m_vMediaSampleDuration, FixedToFloat(GetMovieRate(m_Movie)), m_vMovieDur, 0, m_vTrackDur, m_vMediaDur, m_vFrameInfoDisplay.size(), m_iTrackCount, m_vTrackCount, m_aTrackCount, m_aTrackCount, m_aMediaDur, m_aTrackDur,  m_aMediaTimeScale, dest_format.sampleCount, m_aMediaSampleCount);

            fprintf(stream, "MediaTimeScale = %u / m_vMediaSampleDuration = %f, m_SampleDuration = %f"
                    "\tMovieTimeScale = %u\tTrackIncrement = %f\n\n",
                    m_vMediaTimeScale, m_vMediaSampleDuration, m_SampleDuration, m_MovieTimeScale, m_vTrackIncrement);
            fprintf(stream, "m_vMediaDur = %u / m_vMediaFrameCount = %u"
                    "\tGetMediaDecodeDuration = %u\n\n",
                    m_vMediaDur, m_vMediaFrameCount, GetMediaDecodeDuration(m_vMedia));
            fprintf(stream, "fps = %0.3f\n\n", (float) m_MovieTimeScale / (float) m_vMediaSampleDuration);
            fprintf(stream, "fps = %0.3f\n\n",
                    (10000.0 * (double) GetMediaSampleCount(m_vMedia) * (double) GetMediaTimeScale(m_vMedia)) /
                    (10000.0 * (double) GetMediaDisplayDuration(m_vMedia)));
            for (int i = 0; i < m_vFrameInfoDisplay.size(); i++) {
                fprintf(stream, "Display\t%0.5u\t\t=\t\tDecode\t%0.5I64d"
                        "\t\t\tTime\t%0.7u\t%0.7u"
                        "\t\t\tDur\t%0.7u\t%0.7u"
                        "\tKeyframe\t%0.1u"
                        "\toffset\t%d"
                        "\tflags\t%I64d\n",
                        i, m_vFrameInfoDisplay[i].idx,
                        m_vFrameInfoDisplay[i].mTime,
                        m_vFrameInfoDisplay[i].mTimeDec,
                        m_vFrameInfoDisplay[i].mDur,
                        m_vFrameInfoDisplay[i].mDurDec,
                        m_vFrameInfoDisplay[i].bKeyframe ? 1 : 0,
                        m_vFrameInfoDisplay[i].mOffset, m_vFrameInfoDisplay[i].mFlags);
            }
            fprintf(stream, "\n\n\nDecode\n\n");
            for (int i = 0; i < m_vFrameInfoDecode.size(); i++) {
                fprintf(stream, "Decode\t%0.5u\t\t=\t\tDisplay\t%0.5I64d"
                        "\t\t\tTime\t%0.7u\t%0.7u"
                        "\t\t\tDur\t%0.7u\t%0.7u"
                        "\tKeyframe\t%0.1u"
                        "\toffset\t%d"
                        "\tflags\t%I64d\n",
                        i, m_vFrameInfoDecode[i].idx,
                        m_vFrameInfoDecode[i].mTimeDec,
                        m_vFrameInfoDecode[i].mTime,
                        m_vFrameInfoDecode[i].mDurDec,
                        m_vFrameInfoDecode[i].mDur,
                        m_vFrameInfoDecode[i].bKeyframe ? 1 : 0,
                        m_vFrameInfoDecode[i].mOffset, m_vFrameInfoDecode[i].mFlags);
            }
        }
        fclose(stream);
        stream = NULL;
    }

#ifdef QT_VFW
    bVFW = false;
    //if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('avc1')) {
    if (m_iMode == 4) {
        if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVdv')
            || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvc ')
            || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvcp')
            || m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvpp')) {
            long numberOfSamples = 0;
            err = GetMediaSample(m_vMedia, NULL, maxCompressedSize, &m_lRawFrameSize, 0, NULL, NULL, NULL,      //sampleDescriptionH,
                                 NULL, 1,       //maxNumberOfSamples
                                 &numberOfSamples, NULL);

            if (m_lRawFrameSize > 144000) {
                m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('dv50');
            }
        }

        int mColor = Init_VFW(strFourCC);
        if (mColor == -1)
            goto TerminateQuickTime;
    }
    //}
#endif

    float mMult = 3;
    int m_iMod = 16, m_iModWidth;
    if (m_pixelFormat == k32BGRAPixelFormat) {
        mMult = 4;
        m_iMod = 4;
    } else if (m_pixelFormat == kYUVSPixelFormat || m_pixelFormat == k2vuyPixelFormat) {
        mMult = 2;
        m_iMod = 8;
    } else if (m_pixelFormat == kYUV420PixelFormat || m_pixelFormat == kMpegYUV420CodecType) {
        mMult = 12 / 8;
        m_iMod = 16;
    }

    if ((m_vMovieFrame.right % m_iMod) != 0) {
        m_iModWidth = (floor(1.0 * m_vMovieFrame.right / m_iMod) + 1) * m_iMod;
    } else
        m_iModWidth = m_vMovieFrame.right;

    m_iModRowsize = m_iModWidth * mMult;
    m_Rowsize = m_vMovieFrame.right * mMult;

    if (m_pixelFormat == k422YpCbCr10CodecType) {
        m_Rowsize = ((m_vMovieFrame.right + 47) / 48) * 128;
        m_iModRowsize = ((m_vMovieFrame.right + 47) / 48) * 128;
    }

    maxCompressedSize = m_vMovieFrame.right * m_vMovieFrame.bottom * 4.5;

    GWorldDataPtr = (byte *) malloc(m_vMovieFrame.bottom * m_iModRowsize);
    pDataCompressed = (byte *) malloc(m_vMovieFrame.bottom * m_iModRowsize);

    err = QTNewGWorldFromPtr(&m_GWorld, m_pixelFormat, &m_vTrackFrame, NULL,    //CTabHandle cTable,
                             NULL,      //GDHandle aGDevice,
                             0, //GWorldFlags flags noNewDevice
                             (void *) GWorldDataPtr,    //void *baseAddr,        pData
                             m_iModRowsize);

    m_PixMap = GetGWorldPixMap(m_GWorld);

    Fixed pixGammaRequest = QTGetPixMapHandleRequestedGammaLevel(m_PixMap);
    Fixed pixGamma = QTGetPixMapHandleGammaLevel(m_PixMap);

    if (m_fGamma == 0)
        m_fGamma = FixedToFloat(pixGamma);

    if (m_fGamma > 0) {
        QTSetPixMapHandleRequestedGammaLevel(m_PixMap, FloatToFixed(m_fGamma));
        //pixGammaRequest = QTGetPixMapHandleRequestedGammaLevel(m_PixMap);
        //pixGamma = QTGetPixMapHandleGammaLevel(m_PixMap);
        //sprintf(strStatus, "Change to %02f, Request %02f, Gamma %02f", m_fGamma, FixedToFloat(pixGammaRequest), FixedToFloat(pixGamma));
    }
    //else if (m_fGamma < 0) {
    //    QTSetPixMapHandleRequestedGammaLevel(m_PixMap, kQTUsePlatformDefaultGammaLevel);
    //}

    if (noErr == err)
        // call LockPixels to prevent the base address for
        // an offscreen pixel image from being moved while you
        // draw into or copy from its pixel map
        LockPixels(m_PixMap);

    if (err != noErr) {
        sprintf(strStatus, "Unable to Create New GWorld, error: %d, width=%d, height=%d, rowsize=%d",
                err, m_vMovieFrame.right, m_vMovieFrame.bottom, m_Rowsize);
        goto TerminateQuickTime;
    }

    SetMovieGWorld(m_Movie, m_GWorld, nil);

    CompressorComponent compressor;
    DecompressorComponent decompressor = NULL;
    err = FindCodec(m_CodecInfo.m_iFourCC, anyCodec, &compressor, &decompressor);
    memset(m_DecoderCodecInfo.CodecName, 0, sizeof(m_DecoderCodecInfo.CodecName));
    memset(m_DecoderCodecInfo.strFourCC, 0, sizeof(m_DecoderCodecInfo.strFourCC));
    m_DecoderCodecInfo.m_iFourCC = m_CodecInfo.m_iFourCC;

    if (decompressor && m_CodecInfo.m_iFourCC != FOUR_CHAR_CODE('raw ')) {
        CodecInfo info;
        err = GetCodecInfo(&info, m_CodecInfo.m_iFourCC, decompressor);
        memcpy(m_DecoderCodecInfo.CodecName, &info.typeName[1], info.typeName[0]);

        CodecNameSpecListPtr list;
        err = GetCodecNameList(&list, 1);
        for (int i = 0; i < list->count; i++) {
            char name[32];
            memset(name, 0, sizeof(name));
            memcpy(name, &(list->list[i].typeName[1]), list->list[i].typeName[0]);
            if (strcmp(m_DecoderCodecInfo.CodecName, name) == 0) {
                m_DecoderCodecInfo.m_iFourCC = list->list[i].cType;
                break;
            }
        }
    }
#ifndef QT_ICM
    //Make sure that ICM mode is not selected here
    if (m_iMode == 3)
        m_iMode = 2;
#endif

    if (m_iRaw != 0 && m_iMode == 1) {
        m_compressedData = NewHandle(maxCompressedSize);
        if (m_compressedData == NULL) {
            sprintf(strStatus, "Unable to Allocate Memory");
            goto TerminateQuickTime;
        }
        MoveHHi(m_compressedData);
        HLock(m_compressedData);
        m_compressedDataPtr = StripAddress(*m_compressedData);
        //Get one sample and check size to see if it seems to be uncompressed

        long numberOfSamples = 0;
        err = GetMediaSample(m_vMedia, m_compressedData, maxCompressedSize, &m_lRawFrameSize, 0, NULL, NULL, NULL,
                             NULL, 1,
                             &numberOfSamples, NULL);

        long m_lRequestedFrameSize;
        if (m_iRaw == QTMOVIE_RAW_MODE_V210)
            m_lRequestedFrameSize = m_vMovieFrame.right * m_vMovieFrame.bottom * 8 / 3;
        else if (m_iRaw == QTMOVIE_RAW_MODE_RGB)
            m_lRequestedFrameSize = m_vMovieFrame.right * m_vMovieFrame.bottom * 3;
        else if (m_iRaw == QTMOVIE_RAW_MODE_ARGB)
            m_lRequestedFrameSize = m_vMovieFrame.right * m_vMovieFrame.bottom * 4;
        else
            m_lRequestedFrameSize = m_vMovieFrame.right * m_vMovieFrame.bottom * 2;

        if (m_iRaw < QTMOVIE_RAW_MODE_YUV2) {
            if (m_lRawFrameSize < m_lRequestedFrameSize) {
                //Cannot decode raw
                sprintf(strStatus, "\nError retrieving uncompressed data.\n"
                        "Does not appear to be in %s format\n"
                        "Requested frame size is: %d\n"
                        "Actual Frame size is: %d\n",
                        (m_iRaw == QTMOVIE_RAW_MODE_RGB ? "RGB" :
                        (m_iRaw == QTMOVIE_RAW_MODE_ARGB ? "RGBA" :
                        (m_iRaw == QTMOVIE_RAW_MODE_UYVY ? "UYVY" :
                        (m_iRaw == QTMOVIE_RAW_MODE_V210 ? "V210" :
                        (m_iRaw == QTMOVIE_RAW_MODE_YUYV ? "YUYV" :
                        (m_iRaw == QTMOVIE_RAW_MODE_YVYU ? "YVYU" :
                        (m_iRaw == QTMOVIE_RAW_MODE_VYUY ? "VYUY" : "YUV2"))))))),
                        m_lRequestedFrameSize, m_lRawFrameSize);
                goto TerminateQuickTime;
                //} else if (m_lRawFrameSize > (m_vMovieFrame.right * m_vMovieFrame.bottom * 3)) {
            } else if (m_lRawFrameSize > (m_lRequestedFrameSize * 1.33)) {
                // 2005-01-09, changed max value for allowed raw frame size from
                // (width * height * 3) to(m_lRequestedFrameSize * 1.33)
                // this should allow room for 10bit video
                //Cannot decode raw
                sprintf(strStatus, "\nError retrieving uncompressed data.\n"
                        "Does not appear to be in %s format\n"
                        "Requested frame size is: %d\n"
                        "Actual Frame size is: %d\n",
                        (m_iRaw == QTMOVIE_RAW_MODE_RGB ? "RGB" :
                        (m_iRaw == QTMOVIE_RAW_MODE_ARGB ? "RGBA" :
                        (m_iRaw == QTMOVIE_RAW_MODE_UYVY ? "UYVY" :
                        (m_iRaw == QTMOVIE_RAW_MODE_V210 ? "V210" :
                        (m_iRaw == QTMOVIE_RAW_MODE_YUYV ? "YUYV" :
                        (m_iRaw == QTMOVIE_RAW_MODE_YVYU ? "YVYU" :
                        (m_iRaw == QTMOVIE_RAW_MODE_VYUY ? "VYUY" : "YUV2"))))))),
                        m_lRequestedFrameSize, m_lRawFrameSize);
                goto TerminateQuickTime;
            }
        }/* else { //AYUV AND YUVA
            if (m_lRawFrameSize < (m_vMovieFrame.right * m_vMovieFrame.bottom * 4)) {
                sprintf(strStatus, "\nError retrieving uncompressed data.\n"
                "Does not appear to be in %s format\n"
                "Requested frame size is: %d\n"
                "Actual Frame size is: %d\n",
                (m_iRaw == 5 ? "AYUV" :
                (m_iRaw == 6 ? "YUVA" : "???")),
                (m_vMovieFrame.right * m_vMovieFrame.bottom * 4),
                m_lRawFrameSize);
                goto TerminateQuickTime;
            } else if (m_lRawFrameSize > (m_vMovieFrame.right * m_vMovieFrame.bottom * 4.5)) {
                sprintf(strStatus, "\nError retrieving uncompressed data.\n"
                "Does not appear to be in %s format\n"
                "Requested frame size is: %d\n"
                "Actual Frame size is: %d\n",
                (m_iRaw == 5 ? "AYUV" :
                (m_iRaw == 6 ? "YUVA" : "???")),
                (m_vMovieFrame.right * m_vMovieFrame.bottom * 4),
                m_lRawFrameSize);
                goto TerminateQuickTime;
            }
        } */
    } else if (m_iMode == 2 || m_iMode == 4) {
        m_iRaw = 0;

        m_compressedData = NewHandle(maxCompressedSize);
        if (m_compressedData == NULL) {
            sprintf(strStatus, "Unable to Allocate Memory");
            goto TerminateQuickTime;
        }
        MoveHHi(m_compressedData);
        HLock(m_compressedData);
        m_compressedDataPtr = StripAddress(*m_compressedData);

        //m_PixMap = GetGWorldPixMap(myDestGWorld);
        if (!LockPixels(m_PixMap)) {
            sprintf(strStatus, "Unable to lock PixMap");
            goto TerminateQuickTime;
        }
        m_lRowBytes = QTGetPixMapHandleRowBytes(m_PixMap);
        m_decompressedDataPtr = GetPixBaseAddr(m_PixMap);

        if (m_iMode == 2) {
            err = DecompressSequenceBeginS(&m_seqID,    // pointer to field to receive
                                           // unique ID for sequence
                                           m_imageDesc, // handle to image description
                                           // structure
                                           NULL,        // pointer to compressed image
                                           // data(used
                                           // for preflight)
                                           0,   // image data size
                                           m_GWorld,    // port for the DESTINATION image
                                           NULL,        // grahics device handle, if
                                           // port is set, set
                                           // this to NULL
                                           NULL,        // source rectangle defining
                                           // the portion of the image
                                           // to decompress - NULL for
                                           // the entire source image
                                           NULL,        //&rMatrix,           // transformation matrix
                                           srcCopy,     // transfer mode specifier
                                           (RgnHandle) NULL,    // clipping region in dest.
                                           // coordinate system to use as
                                           // a mask
                                           0,   // flags
                                           m_CodecInfo.quality, // accuracy in decompression //codecHighQuality
                                           m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('raw ') ? anyCodec : decompressor);  // compressor identifier or
            // special identifiers
            // ie. bestSpeedCodec, bestFidelityCodec

            if (err != noErr) {
                sprintf(strStatus, "Error with DecompressSequenceBeginS: %d", err);
                goto TerminateQuickTime;
            }
        }
    } else if (m_iMode == 3) {
        m_iRaw = 0;
#ifdef QT_ICM
        frameData.pData = (byte *) malloc(maxCompressedSize);
        //frameData.pData = NULL;
        frameData.height = m_vMovieFrame.bottom;
        frameData.rowsize = m_Rowsize;
        frameData.width = m_vMovieFrame.right;

        err = createDecompressionSession(m_imageDesc,
                                         m_vMovieFrame.right, m_vMovieFrame.bottom, m_pixelFormat,
                                         QT_ICM_Decode_Frame, NULL, &decompressionSession);
#endif
    } else {
        m_iRaw = 0;
    }

  SETUP_AUDIO:
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
#ifdef QTMOVIE_QT6
    if (audioType && m_aTrackCount > 0 && !bAudioExtractionApi) {
        //SoundConverterOpen for QT6

        // This next code sets up the SoundConverter component
        err = SoundConverterOpen(&source_format, &dest_format, &converter);

        if (err != noErr) {
            sprintf(strStatus, "SoundConverterOpen Error: %d", err);
            goto TerminateQuickTime;
        }

        err = SoundConverterSetInfo(converter, siCompressionChannels, &dest_format.numChannels);
        // ignore this error, since some codecs don't use this selector(makes QDesign work)

        err = SoundConverterSetInfo(converter, siDecompressionParams, atom);
        if (err == siUnknownInfoType) {
            /* ignore */
        } else if (err != noErr) {
            /* real err */
            sprintf(strStatus, "SoundConverterSetInfo Error: %d", err);
            goto TerminateQuickTime;
        }

        err = SoundConverterGetInfo(converter, siCompressionParams, &outputAudio);
        // if any compression params were passed back, send it to the sound converter now
        if (err == noErr) {
            HLockHi(outputAudio);
            err = SoundConverterSetInfo(converter, siCompressionParams, *outputAudio);
            HUnlock(outputAudio);
            //Failif (myErr != noErr, Bail);
        } else {
            // no audio atom list to deal with, so set to NULL
            outputAudio = NULL;
        }

        inputFrames = 2147483648;
        outputBytes = inputBytes = 0;
        err = SoundConverterGetBufferSizes(converter, kTargetBytes, &inputFrames, &inputBytes, &outputBytes);

        CompressionInfo DestCompInfo;
        err = SoundConverterGetInfo(converter, siCompressionFactor, &DestCompInfo);
        if (err != noErr) {
            err =
                GetCompressionInfo(fixedCompression, dest_format.format, dest_format.numChannels,
                                   dest_format.sampleSize, &DestCompInfo);
        }
        // myBytesPerFrame is not filled in by GetInfo, so we set it here
        DestCompInfo.bytesPerFrame = DestCompInfo.bytesPerPacket * dest_format.numChannels;

        inputAudio = NewHandle(inputBytes);
        if (inputAudio == NULL) {
            sprintf(strStatus, "Unable to Allocate inputAudio Memory");
            goto TerminateQuickTime;
        }
        MoveHHi(inputAudio);
        HLock(inputAudio);
        inputAudioPtr = StripAddress(*inputAudio);
        outputAudio = NewHandle(outputBytes);
        if (outputAudio == NULL) {
            sprintf(strStatus, "Unable to Allocate outputAudio Memory");
            goto TerminateQuickTime;
        }
        MoveHHi(outputAudio);
        HLock(outputAudio);
        outputAudioPtr = StripAddress(*outputAudio);

        //inputAudioPtr = NewPtrClear(inputBytes);
        //outputAudioPtr = NewPtrClear(outputBytes);

        err = SoundConverterBeginConversion(converter);
        if (err != noErr) {
            sprintf(strStatus, "SoundConverterBeginConversion Error: %d", err);
            goto TerminateQuickTime;
        }
    }
#endif

    ///////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////
    //Audio
    m_AudioExtractor = NULL;
    if (audioType && m_aTrackCount > 0 && bAudioExtractionApi) {
        //QTMOVIE_QT7
        if (!SetUpMovieAudioExtraction())
            goto TerminateQuickTime;
    }

    //Must Clear this for some reason
    //When I have 6 channel audio, the first call to IsFrameInBuffer
    //returns m_vFrameBuffer.size() = 6293
    m_vFrameBuffer.clear();

    return S_OK;

    TerminateQuickTime:

    QTFreeMemory();
    return E_FAIL;
}

bool CQTMovieDec::SetUpMovieAudioExtraction()
{
    OSErr err = noErr;
    int i;

    if (m_AudioExtractor) {
        MovieAudioExtractionEnd(m_AudioExtractor);
        m_AudioExtractor = NULL;

        if (ioData) {
            for (i = 0; i < ioData->mNumberBuffers; i++) {
                QT_FREE_BUFFER(ioData->mBuffers[i].mData);
            }
            free(ioData);
            ioData = NULL;
        }
    }

    MovieAudioExtractionBegin(m_Movie, 0, &m_AudioExtractor);

    if (audioType == 2) {
        Boolean allChannelsDiscrete = true;     //2010-09-15
        // disable mixing of audio channels
        err = MovieAudioExtractionSetProperty(m_AudioExtractor,
                                              kQTPropertyClass_MovieAudioExtraction_Movie,
                                              kQTMovieAudioExtractionMoviePropertyID_AllChannelsDiscrete,
                                              sizeof(allChannelsDiscrete), &allChannelsDiscrete);
    }

    AudioChannelLayout *layout = NULL;
    UInt32 size = 0;
    err = MovieAudioExtractionGetPropertyInfo(m_AudioExtractor,
                                              kQTPropertyClass_MovieAudioExtraction_Audio,
                                              kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
                                              NULL, &size, NULL);
    if (err == noErr) {
        // Allocate memory for the channel layout
        layout = (AudioChannelLayout *) calloc(1, size);
        if (layout == nil) {
            err = memFullErr;
            sprintf(strStatus, "Unable to Allocate outputAudio Memory");
            return false;
        }
        // Get the layout for the current extraction configuration.
        // This will have already been expanded into channel descriptions.
        err = MovieAudioExtractionGetProperty(m_AudioExtractor,
                                              kQTPropertyClass_MovieAudioExtraction_Audio,
                                              kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
                                              size, layout, nil);

        if (layout->mChannelLayoutTag == kAudioChannelLayoutTag_MPEG_5_1_B
            || layout->mChannelLayoutTag == kAudioChannelLayoutTag_MPEG_5_1_C
            || layout->mChannelLayoutTag == kAudioChannelLayoutTag_MPEG_5_1_D
            || layout->mChannelLayoutTag == kAudioChannelLayoutTag_Hexagonal) {
            layout->mChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_1_A;
        }

        err = MovieAudioExtractionSetProperty(m_AudioExtractor,
                                              kQTPropertyClass_MovieAudioExtraction_Audio,
                                              kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
                                              sizeof(layout), layout);
    }

    err = MovieAudioExtractionGetProperty(m_AudioExtractor,
                                          kQTPropertyClass_MovieAudioExtraction_Audio,
                                          kQTMovieAudioExtractionAudioPropertyID_AudioStreamBasicDescription,
                                          sizeof(m_ASBD), &m_ASBD, nil);

    dest_format.sampleCount = m_ASBD.mSampleRate * (Float64) GetMediaDuration(m_aMedia) / (Float64) m_aMediaTimeScale;

    m_ASBD.mFormatID = kAudioFormatLinearPCM;   //kAudioFormatFlagIsSignedInteger
    m_ASBD.mFormatFlags = kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked    //kAudioFormatFlagIsFloat
        | kAudioFormatFlagIsNonInterleaved | kAudioFormatFlagsNativeEndian;
    if (m_ASBD.mBitsPerChannel > 16)
        m_ASBD.mBitsPerChannel = sizeof(SInt16) * 8;

    m_ASBD.mBytesPerPacket = m_ASBD.mBitsPerChannel / 8;        //per channel
    m_ASBD.mFramesPerPacket = 1;
    m_ASBD.mBytesPerFrame = m_ASBD.mBitsPerChannel / 8; //per channel

    dest_format.numChannels = m_ASBD.mChannelsPerFrame;
    dest_format.sampleSize = m_ASBD.mBitsPerChannel;
    dest_format.sampleRate = (int) m_ASBD.mSampleRate << 16;

    err = MovieAudioExtractionSetProperty(m_AudioExtractor,
                                          kQTPropertyClass_MovieAudioExtraction_Audio,
                                          kQTMovieAudioExtractionAudioPropertyID_AudioStreamBasicDescription,
                                          sizeof(m_ASBD), &m_ASBD);

    UInt32 ioNumFrames = QT_MAX_AUDIO_SAMPLES;  //m_ASBD.mSampleRate / 2;
    UInt32 outFlags = 0;

    ioData = (AudioBufferList *) calloc(1, sizeof(AudioBufferList) + m_ASBD.mChannelsPerFrame * sizeof(AudioBuffer));
    if (ioData == NULL)
        return false;

    ioData->mNumberBuffers = m_ASBD.mChannelsPerFrame;
    for (int i = 0; i < ioData->mNumberBuffers; i++) {
        ioData->mBuffers[i].mNumberChannels = 1;
        ioData->mBuffers[i].mDataByteSize = ioNumFrames * m_ASBD.mBytesPerFrame; // / m_ASBD.mChannelsPerFrame;
        ioData->mBuffers[i].mData = (byte *) malloc(ioData->mBuffers[i].mDataByteSize);
        if (ioData->mBuffers[i].mData == NULL)
            return false;
    }

    return true;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
bool CQTMovieDec::UpdateFrameBuffer(byte * pBuffer, long frame, bool bForward)
{

    if (m_vFrameBuffer.size() > 7) {
        if (bForward) {
            delete[]m_vFrameBuffer.begin()->data;
            m_vFrameBuffer.erase(m_vFrameBuffer.begin());
        } else {
            delete[]m_vFrameBuffer.end()->data;
            m_vFrameBuffer.erase(m_vFrameBuffer.end());
        }
    }

    m_vFrameBuffer.resize(m_vFrameBuffer.size() + 1);
    m_vFrameBuffer[m_vFrameBuffer.size() - 1].data = new byte[m_vMovieFrame.bottom * m_Rowsize];
    memcpy(m_vFrameBuffer[m_vFrameBuffer.size() - 1].data, pBuffer, m_vMovieFrame.bottom * m_Rowsize);
    m_vFrameBuffer[m_vFrameBuffer.size() - 1].frame = frame;

    return true;
}

int CQTMovieDec::IsFrameInBuffer(long frame)
{

    for (int i = 0; i < m_vFrameBuffer.size(); i++) {
        if (m_vFrameBuffer[i].frame == frame) {
            return i;
        }
    }
    return -1;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
int ConvertPixFormat(byte * apData, Ptr am_compressedDataPtr, int am_iRaw, int am_iDither, Rect am_vTrackFrame,
                     long am_lRawFrameSize, QTCodecInfo am_CodecInfo)
{
    int m_lBytesReturned = 0;

    int offset, curSample, i;
    if (am_iRaw == QTMOVIE_RAW_MODE_RGB) {
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 3;
        curSample = offset;
        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int w = 0; w < am_vTrackFrame.right; w++, curSample += 3) {
                apData[curSample - offset] = (byte) am_compressedDataPtr[curSample + 2];
                apData[curSample + 1 - offset] = (byte) am_compressedDataPtr[curSample + 1];
                apData[curSample + 2 - offset] = (byte) am_compressedDataPtr[curSample + 0];
            }
        }
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 3;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_ARGB) {
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 4;
        curSample = offset;
        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int w = 0; w < am_vTrackFrame.right; w++, curSample += 4) {
                apData[curSample - offset] = (byte) am_compressedDataPtr[curSample + 3];
                apData[curSample + 1 - offset] = (byte) am_compressedDataPtr[curSample + 2];
                apData[curSample + 2 - offset] = (byte) am_compressedDataPtr[curSample + 1];
                apData[curSample + 3 - offset] = (byte) am_compressedDataPtr[curSample + 0];
            }
        }
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 4;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_YUYV) {       //yuyv
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
        memcpy(apData, &am_compressedDataPtr[offset], am_vTrackFrame.right * am_vTrackFrame.bottom * 2);
        return am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_YUV2) {
        //yuyv - u & v are signed integers
        //apData = new byte[am_vTrackFrame.right * am_vTrackFrame.bottom * 4];
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
        curSample = offset;

        //From http://www.bitjazz.com/sheervideo/about/testset.shtml
        //Y' = floor(y' x 219 / 255 + 16.5)
        //Cb = floor(cb x 224 / 254 + 128.5)
        //Cr = floor(cr x 224 / 254 + 128.5)
        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0, i = 0; h < am_vTrackFrame.right / 2; h++, i += 6, curSample += 4) {
                apData[curSample - offset] = (byte) am_compressedDataPtr[curSample + 0] + 0;      // y0  y0 0
                apData[curSample + 1 - offset] = (byte) am_compressedDataPtr[curSample + 1] + 127;        // u0  u0 1
                apData[curSample + 2 - offset] = (byte) am_compressedDataPtr[curSample + 2] + 0;  // y1  y1 2
                apData[curSample + 3 - offset] = (byte) am_compressedDataPtr[curSample + 3] + 127;        // v0  v0 3

                // From http://developer.apple.com/quicktime/icefloe/dispatch019.html#schemeB
                // Scheme B: "Video-Range" Mapping with Unsigned Y�, Offset Binary Cb, Cr
                /*
                   apData[curSample - offset]   = floor(
                   (int)am_compressedDataPtr[curSample + 0] * 219 / 255 + 16.5);   // y0  y0 0
                   apData[curSample+1 - offset] = floor(
                   (int)am_compressedDataPtr[curSample + 1] * 224 / 254 + 128.5);   // u0  u0 1
                   apData[curSample+2 - offset] = floor(
                   (int)am_compressedDataPtr[curSample + 2] * 219 / 255 + 16.5);   // y1  y1 2
                   apData[curSample+3 - offset] = floor(
                   (int)am_compressedDataPtr[curSample + 3] * 224 / 254 + 128.5);   // v0  v0 3
                 */

                // Scheme A: "Wide-Range" Mapping with Unsigned Y�, Two's Complement Cb, Cr
            }
        }
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_UYVY) {
        //2vuy
        //uyvy 8 bit
        //apData = new byte[am_vTrackFrame.right * am_vTrackFrame.bottom * 4];

        if (am_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AV1x')) {
            if (am_vTrackFrame.bottom == 576) {  //PAL
                offset = 30720;
            } else if (am_vTrackFrame.bottom == 486) {   //NTSC
                offset = 21056;
            } else {
                offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
            }
        } else if (am_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVUI')) {
            if (am_vTrackFrame.bottom == 576) {  //PAL
                offset = 23040;
            } else if (am_vTrackFrame.bottom == 486) {   //NTSC
                offset = 14400;
            } else {
                offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
            }
        } else {
            offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
        }

        curSample = offset;

        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0; h < am_vTrackFrame.right / 2; h++, curSample += 4) {
                apData[curSample - offset] = (byte) am_compressedDataPtr[curSample + 1];  // y0  u0 1
                apData[curSample + 1 - offset] = (byte) am_compressedDataPtr[curSample + 0];      // u0  y0 0
                apData[curSample + 2 - offset] = (byte) am_compressedDataPtr[curSample + 3];      // y1  v0 3
                apData[curSample + 3 - offset] = (byte) am_compressedDataPtr[curSample + 2];      // v0  y1 2
            }
        }
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_V210) {
        //2vuy
        //uyvy 10 bit
        offset = am_lRawFrameSize - (16 * am_vTrackFrame.right * am_vTrackFrame.bottom / 6);
        curSample = offset;
        int curSampleSrc = offset;

        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0; h < am_vTrackFrame.right / 2; h += 3, curSampleSrc += 16, curSample += 12) {
                // y0
                apData[curSample - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 2] & 0x0F) << 4)        //00001111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 1] & 0xF0) >> 4);     //11110000
                // u0  Cb
                apData[curSample + 1 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 1] & 0x03) << 6)    //00000011
                    | (((byte) am_compressedDataPtr[curSampleSrc + 0] & 0xFC) >> 2);     //11111100
                // y1
                apData[curSample + 2 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 5] & 0x03) << 6)    //00000011
                    | (((byte) am_compressedDataPtr[curSampleSrc + 4] & 0xFC) >> 2);     //11111100
                // v0  Cr
                apData[curSample + 3 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 3] & 0x3F) << 2)    //00111111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 2] & 0xC0) >> 6);     //11000000

                // y2
                apData[curSample + 4 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 7] & 0x3F) << 2)    //00111111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 6] & 0xC0) >> 6);     //11000000
                // u1  Cb
                apData[curSample + 5 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 6] & 0x0F) << 4)    //00001111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 5] & 0xF0) >> 4);     //11110000
                // y3
                apData[curSample + 6 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 10] & 0x0F) << 4)   //00001111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 9] & 0xF0) >> 4);     //11110000
                // v1  Cr
                apData[curSample + 7 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 9] & 0x03) << 6)    //00000011
                    | (((byte) am_compressedDataPtr[curSampleSrc + 8] & 0xFC) >> 2);     //11111100

                // y4
                apData[curSample + 8 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 13] & 0x03) << 6)   //00000011
                    | (((byte) am_compressedDataPtr[curSampleSrc + 12] & 0xFC) >> 2);    //11111100
                // u2  Cb
                apData[curSample + 9 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 11] & 0x3F) << 2)   //00111111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 10] & 0xC0) >> 6);    //11000000
                // y5
                apData[curSample + 10 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 15] & 0x3F) << 2)  //00111111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 14] & 0xC0) >> 6);    //11000000
                // v2  Cr
                apData[curSample + 11 - offset] = (((byte) am_compressedDataPtr[curSampleSrc + 14] & 0x0F) << 4)  //00001111
                    | (((byte) am_compressedDataPtr[curSampleSrc + 13] & 0xF0) >> 4);    //11110000

                //Use 2 least significant bits for rounding
                //If equal 2 or 3, round up
                if (am_iDither == 1) {
                    // y0
                    if (apData[curSample - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 1] & 0x0C) >> 2) > 1)
                        apData[curSample - offset]++;    //00001100
                    // u0  Cb
                    if (apData[curSample + 1 - offset] < 255
                        && ((byte) am_compressedDataPtr[curSampleSrc + 0] & 0x03) > 1)
                        apData[curSample + 1 - offset]++;        //00000011
                    // y1
                    if (apData[curSample + 2 - offset] < 255
                        && ((byte) am_compressedDataPtr[curSampleSrc + 4] & 0x03) > 1)
                        apData[curSample + 2 - offset]++;        //00000011
                    // v0  Cr
                    if (apData[curSample + 3 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 2] & 0x30) >> 4) > 1)
                        apData[curSample + 3 - offset]++;        //00110000

                    // y2
                    if (apData[curSample + 4 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 6] & 0x30) >> 4) > 1)
                        apData[curSample + 4 - offset]++;        //00110000
                    // u1  Cb
                    if (apData[curSample + 5 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 5] & 0x0C) >> 2) > 1)
                        apData[curSample + 5 - offset]++;        //00001100
                    // y3
                    if (apData[curSample + 6 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 9] & 0x0C) >> 2) > 1)
                        apData[curSample + 6 - offset]++;        //00001100
                    // v1  Cr
                    if (apData[curSample + 7 - offset] < 255
                        && ((byte) am_compressedDataPtr[curSampleSrc + 8] & 0x03) > 1)
                        apData[curSample + 7 - offset]++;        //00000011

                    // y4
                    if (apData[curSample + 8 - offset] < 255
                        && ((byte) am_compressedDataPtr[curSampleSrc + 12] & 0x03) > 1)
                        apData[curSample + 8 - offset]++;        //00000011
                    // u2  Cb
                    if (apData[curSample + 9 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 10] & 0x30) >> 4) > 1)
                        apData[curSample + 9 - offset]++;        //00110000
                    // y5
                    if (apData[curSample + 10 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 14] & 0x30) >> 4) > 1)
                        apData[curSample + 10 - offset]++;       //00110000
                    // v2  Cr
                    if (apData[curSample + 11 - offset] < 255
                        && (((byte) am_compressedDataPtr[curSampleSrc + 13] & 0x0C) >> 2) > 1)
                        apData[curSample + 11 - offset]++;       //00001100
                }
            }
        }
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_YVYU) {
        //yvyu
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
        curSample = offset;

        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0, i = 0; h < am_vTrackFrame.right / 2; h++, i += 6, curSample += 4) {
                apData[curSample - offset] = (byte) am_compressedDataPtr[curSample + 0];  // y0  y0 0
                apData[curSample + 1 - offset] = (byte) am_compressedDataPtr[curSample + 3];      // u0  v0 3
                apData[curSample + 2 - offset] = (byte) am_compressedDataPtr[curSample + 2];      // y1  y1 2
                apData[curSample + 3 - offset] = (byte) am_compressedDataPtr[curSample + 1];      // v0  u0 1
            }
        }
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_VYUY) {
        //vyuy
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
        curSample = offset;

        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0, i = 0; h < am_vTrackFrame.right / 2; h++, i += 6, curSample += 4) {
                apData[curSample - offset] = (byte) am_compressedDataPtr[curSample + 1];  // y0  v0 1
                apData[curSample + 1 - offset] = (byte) am_compressedDataPtr[curSample + 2];      // u0  y0 2
                apData[curSample + 2 - offset] = (byte) am_compressedDataPtr[curSample + 3];      // y1  u1 3
                apData[curSample + 3 - offset] = (byte) am_compressedDataPtr[curSample + 0];      // v0  y0 0
            }
        }
    /*} else if (am_iRaw == QTMOVIE_RAW_MODE_AYUV) { //ayuv
                                   apData = new byte[am_vTrackFrame.right * am_vTrackFrame.bottom * 4.5];
                                   offset = am_lRawFrameSize - am_vTrackFrame.right*am_vTrackFrame.bottom * 4;
                                   curSample = offset;
                                   i = 0;

                                   if (1){ //progressive
                                   *for (int row = 0; row < am_vTrackFrame.bottom; row++) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //a1y1u1v1  a2y2u2v2  a3y3u3v3  a4y4u4v4
                                   //  1 2 3     5         9 1011    13
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  y0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  u0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 3];   // y1  v1 3
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 5];   // v0  u0 5
                                   }
                                   }*
                                   for (int row = 0; row < am_vTrackFrame.bottom; row++) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  v0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  y0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 5];   // y1  u0 5
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 0];   // v0  y1 0
                                   }
                                   }
                                   } else { //interlaced
                                   curSample = offset / 2;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row+=2) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  v0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  y0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 5];   // y1  u0 5
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 0];   // v0  y1 0
                                   }
                                   i += am_vTrackFrame.right * 2;
                                   }

                                   curSample += offset / 2;
                                   i = am_vTrackFrame.right * 2;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row+=2) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  v0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  y0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 5];   // y1  u0 5
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 0];   // v0  y1 0
                                   }
                                   i += am_vTrackFrame.right * 2;
                                   }
                                   }

                                   curSample /= 2;
                                   offset /= 2;
                                   } else if (am_iRaw == QTMOVIE_RAW_MODE_AYUV) { //ayuv planar
                                   apData = new byte[am_vTrackFrame.right * am_vTrackFrame.bottom * 4.5];
                                   offset = am_lRawFrameSize - am_vTrackFrame.right*am_vTrackFrame.bottom * 4;
                                   curSample = offset;
                                   i = 0;

                                   if (1){ //progressive
                                   *for (int row = 0; row < am_vTrackFrame.bottom; row++) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //a1y1u1v1  a2y2u2v2  a3y3u3v3  a4y4u4v4
                                   //  1 2 3     5         9 1011    13
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  y0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  u0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 3];   // y1  v1 3
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 5];   // v0  u0 5
                                   }
                                   }*
                                   //Y
                                   i = 0;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row++) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=2) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 0];   // y0  v0 1
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 1];   // y1  u0 5
                                   }
                                   }
                                   //U
                                   i = 0;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row++) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample++) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample];   // u0  y0 2
                                   }
                                   }
                                   //V
                                   i = 0;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row++) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample++) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample];   // v0  y1 0
                                   }
                                   }
                                   } else { //interlaced
                                   curSample = offset / 2;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row+=2) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  v0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  y0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 5];   // y1  u0 5
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 0];   // v0  y1 0
                                   }
                                   i += am_vTrackFrame.right * 2;
                                   }

                                   curSample += offset / 2;
                                   i = am_vTrackFrame.right * 2;
                                   for (int row = 0; row < am_vTrackFrame.bottom; row+=2) {
                                   for (int h = 0; h < am_vTrackFrame.right / 2; h++, i+=4, curSample+=8) {
                                   //v1y1u1a1  v2y2u2a2  v3y3u3a3  v4y4u4a4
                                   //0 1 2       5       9 1011      14
                                   apData[i]   = (byte)am_compressedDataPtr[curSample + 1];   // y0  v0 1
                                   apData[i+1] = (byte)am_compressedDataPtr[curSample + 2];   // u0  y0 2
                                   apData[i+2] = (byte)am_compressedDataPtr[curSample + 5];   // y1  u0 5
                                   apData[i+3] = (byte)am_compressedDataPtr[curSample + 0];   // v0  y1 0
                                   }
                                   i += am_vTrackFrame.right * 2;
                                   }

                                   curSample /= 2;
                                   offset /= 2;
                                   }*/
    } else if (am_iRaw == QTMOVIE_RAW_MODE_YUVA) {
        //yuyva
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 4;
        curSample = offset;
        i = 0;

        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0; h < am_vTrackFrame.right / 2; h++, i += 4, curSample += 4) {
                //y1u1v1a1  y2u2v2a2  y3u3v3a3  y4u4v4a4
                //0 1 2     4         8 9 10    12
                apData[i] = (byte) am_compressedDataPtr[curSample + 0];   // y0  y0 0
                apData[i + 1] = (byte) am_compressedDataPtr[curSample + 1];       // u0  u0 1
                apData[i + 2] = (byte) am_compressedDataPtr[curSample + 2];       // y1  v1 2
                apData[i + 3] = (byte) am_compressedDataPtr[curSample + 4];       // v0  u0 4
            }
        }

        //curSample /= 2;
        //offset /= 2;
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    } else if (am_iRaw == QTMOVIE_RAW_MODE_UYVYA) {
        //uyvya
        offset = am_lRawFrameSize - am_vTrackFrame.right * am_vTrackFrame.bottom * 4;
        curSample = offset;
        i = 0;

        for (int row = 0; row < am_vTrackFrame.bottom; row++) {
            for (int h = 0; h < am_vTrackFrame.right / 2; h++, i += 4, curSample += 4) {
                //y1u1v1a1  y2u2v2a2  y3u3v3a3  y4u4v4a4
                //0 1 2     4         8 9 10    12
                apData[i] = (byte) am_compressedDataPtr[curSample + 1];   // y0  u0 1
                apData[i + 1] = (byte) am_compressedDataPtr[curSample + 0];       // u0  y0 0
                apData[i + 2] = (byte) am_compressedDataPtr[curSample + 3];       // y1  v0 3
                apData[i + 3] = (byte) am_compressedDataPtr[curSample + 2];       // v0  y1 2
            }
        }

        //curSample /= 2;
        //offset /= 2;
        m_lBytesReturned = am_vTrackFrame.right * am_vTrackFrame.bottom * 2;
    }

    return m_lBytesReturned;
}

int CQTMovieDec::ReadVideoFrame(long frameNum, byte * pData, int dst_pitch)
{
    OSErr err = noErr;

    TimeValue time, frameNumTime, sampleTime = 0, durationPerSample = 0;
    TimeValue myTrackOffset;
    long sampleDescriptionIndex = 0, numberOfSamples = 1, maxNumberOfSamples = 1;
    long frameNumCurrent = frameNum, curFrame = -1;
    bool bFoundIFrame = true;
    short sampleflags = 0;
    long m_lBytesReturned = 0;

    // 2005-01-03, if GetMovieNextInterestingTime failed to get frame times
    // fall back to manual method of determining frame time
    if (frameNum >= m_vFrameInfoDisplay.size()) {
        frameNumTime = (frameNum * m_vTrackIncrement) + m_vTrackStartTime;
        //2008-12-19 time = TrackTimeToMediaTime(frameNumTime, m_vTrack);
    } else {
        frameNumTime = m_vFrameInfoDisplay[frameNum].mTime;     //m_vFrameInfoDisplay
        if (bUseSampleTable || m_iMode == 0)
            time = frameNumTime;
        else
            time = TrackTimeToMediaTime(frameNumTime, m_vTrack);
    }

    if (m_iRaw > 0) {
        // 2005-01-03, if GetMovieNextInterestingTime failed to get frame times
        // fall back to manual method of determining frame time
        //time = TrackTimeToMediaTime(frameNumTime, m_vTrack);

        err = GetMediaSample(m_vMedia, m_compressedData, maxCompressedSize,     //long maxSizeToGrow,
                             &m_lRawFrameSize, time,    //m_vFrameInfoDisplay[frameNum].mTime //time
                             &sampleTime, &durationPerSample, NULL,     //sampleDescriptionH,
                             &sampleDescriptionIndex, maxNumberOfSamples, &numberOfSamples, &sampleflags);

        m_lBytesReturned = ConvertPixFormat(pData, m_compressedDataPtr, m_iRaw, m_iDither, m_vMovieFrame, m_lRawFrameSize, m_CodecInfo);
        
        return m_lBytesReturned;
    }
#ifdef QT_ICM
    if (m_iMode == 3) {
        SInt64 syncSampleNumber, nextSampleNumber, targetSampleNumber, syncSampleNumberDis, targetSampleNumberDisplay;
        TimeValue64 targetDecodeTime, syncDecodeTime;
        TimeValue64 targetDisplayTime, syncDisplayTime, sampleDisplayTime;
        int m_iInitCount = 5;

        targetSampleNumber = m_vFrameInfoDisplay[frameNum].idx + 1;     //targetSampleNumber = frameNum + 1; //2008-12-20

        SampleNumToMediaDecodeTime(m_vMedia, targetSampleNumber, &targetDecodeTime, NULL);

        //targetDecodeTime = m_vFrameInfoDecode[frameNum].mTimeDec;
        //targetDisplayTime = m_vFrameInfoDisplay[frameNum].mTime;
        SampleNumToMediaDisplayTime(m_vMedia, targetSampleNumber, &targetDisplayTime, NULL);
        SampleNumToMediaDecodeTime(m_vMedia, targetSampleNumber + 1, &targetDisplayTime, NULL);
        MediaDisplayTimeToSampleNum(m_vMedia, targetDisplayTime, &targetSampleNumberDisplay, NULL, NULL);

        if (frameNum == 0) {
            targetSampleNumberDisplay = 1;
            m_iInitCount = 0;
        }

        SampleNumToMediaDisplayTime(m_vMedia, targetSampleNumberDisplay, &targetDisplayTime, NULL);

        GetMediaNextInterestingDecodeTime(m_vMedia,
                                          nextTimeSyncSample | nextTimeEdgeOK,
                                          targetDecodeTime, -fixed1, &syncDecodeTime, NULL);

        MediaDecodeTimeToSampleNum(m_vMedia, syncDecodeTime, &syncSampleNumber, NULL, NULL);

        // Pick the starting point.
        if (((m_lLastFrameDecodeIdx + 1 <= targetSampleNumber)
             && (syncSampleNumber < m_lLastFrameDecodeIdx + 1))
            /*|| m_lPrevFrameNum + 1 == frameNum */
            ) {
            nextSampleNumber = m_lLastFrameDecodeIdx + 1;
        } else {
            nextSampleNumber = syncSampleNumber;
            if (m_lPrevFrameNum + 1 != frameNum) {
                ICMDecompressionSessionFlush(decompressionSession);
                m_iInitCount = 0;
            }
        }

        FILE *stream = NULL; //debug
        //stream = fopen("ICM_Decode.txt", "at");
        if (stream)
            fprintf(stream, "FrameNum = %d, m_lLastFrameDecodeIdx = %d\n", frameNum, m_lLastFrameDecodeIdx);

        for (; (nextSampleNumber <= targetSampleNumber && nextSampleNumber < m_vMovieFrameCount)
             || m_iInitCount < 5; nextSampleNumber++) {
            TimeValue64 sampleDecodeTime;
            ByteCount sampleDataSize = 0;
            MediaSampleFlags sampleFlags = 0;
            UInt8 *sampleData = NULL;
            ICMFrameTimeRecord frameTime = { 0 };

            // Get the frame's data size and sample flags.
            SampleNumToMediaDecodeTime(m_vMedia, nextSampleNumber, &sampleDecodeTime, NULL);
            SampleNumToMediaDisplayTime(m_vMedia, nextSampleNumber, &sampleDisplayTime, NULL);

            //sampleDecodeTime = m_vFrameInfoDecode[nextSampleNumber-1].mTimeDec;
            //sampleDisplayTime = m_vFrameInfoDecode[nextSampleNumber-1].mTime;
            err = GetMediaSample2(m_vMedia, NULL, 0, &sampleDataSize, sampleDecodeTime,
                                  NULL, NULL, NULL, NULL, NULL, 1, NULL, &sampleFlags);

            if (stream)
                fprintf(stream, "\tnextSampleNumber = %u", nextSampleNumber);
            if (stream)
                fprintf(stream, ", targetSampleNumber = %u", targetSampleNumber);
            if (stream)
                fprintf(stream, ", nextDecode = %u", sampleDecodeTime);

            // We can skip droppable frames before the target.
            //if ((nextSampleNumber != targetSampleNumber) && (mediaSampleDroppable & sampleFlags))
            //if ((sampleDisplayTime != targetDisplayTime) && (mediaSampleDroppable & sampleFlags)
            if ((nextSampleNumber != targetSampleNumber) && (mediaSampleDroppable & sampleFlags)
                && (m_iInitCount == 5)) {
                if (stream)
                    fprintf(stream, "\t Droppable\n");
                continue;
            }

            if (stream)
                fprintf(stream, ", sampleDisplayTime = %u", sampleDisplayTime);
            if (stream)
                fprintf(stream, ", targetSampleNumberDisplay = %u", targetSampleNumberDisplay);
            if (stream)
                fprintf(stream, ", targetDisplayTime = %u\n", targetDisplayTime);
            if (stream)
                fflush(stream);

            // Load the frame.
            sampleData = (UInt8 *) malloc(sampleDataSize);
            err = GetMediaSample2(m_vMedia, sampleData, sampleDataSize, NULL, sampleDecodeTime,
                                  NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL);

            // Set up an immediate decode request -- we don't care about frame times, we just need to pass a flag.
            frameTime.recordSize = sizeof(ICMFrameTimeRecord);
            *(TimeValue64 *) & frameTime.value = sampleDisplayTime;     //sampleDecodeTime;
            frameTime.scale = m_vMediaTimeScale;        //GetMediaTimeScale(m_vMedia);
            frameTime.rate = fixed1;
            frameTime.frameNumber = nextSampleNumber;

            // If we haven't reached the target sample, tell the session not to emit the frame.
            //if (nextSampleNumber != targetSampleNumber)
            //      frameTime.flags = icmFrameTimeDoNotDisplay;

            frameTime.flags |= icmFrameTimeIsNonScheduledDisplayTime;
            //frameTime.flags = icmFrameTimeDecodeImmediately;
            //frameTime.flags |= icmFrameTimeHasDecodeTime;
            //frameTime.decodeTime = time;

            // Decode the frame.
            err = ICMDecompressionSessionDecodeFrame(decompressionSession,
                                                     sampleData, sampleDataSize, NULL, &frameTime, sampleData);
                                                     
            if (stream)
                fprintf(stream, "\t\tnextSampleNumber = %d\n", nextSampleNumber);
                
            m_lLastFrameDecodeIdx = nextSampleNumber;

            //Make sure to grab a few extra frames when first opening a movie
            if (m_iInitCount < 5) {
                m_iInitCount++;
            }
            //if (sampleDisplayTime == targetDisplayTime)
            //    break;
        }
        if (stream)
            fclose(stream);
            
        // Pull decoded frame out.
        ICMDecompressionSessionSetNonScheduledDisplayTime(decompressionSession, targetDisplayTime, m_vMediaTimeScale, 0);

        //memset(pData, 0, m_Rowsize * m_vMovieFrame.bottom);
        if (frameData.pData) {
            //memcpy(pData, frameData.pData, m_vMovieFrame.bottom * m_Rowsize); // R2007-07-17
            // 2007-07-17
            int i, j;
            if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
                for (i = m_vMovieFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
                    memcpy(&pData[j * dst_pitch], &frameData.pData[i * m_Rowsize], m_Rowsize);
                }
            } else {
                if (m_pixelFormat == k2vuyPixelFormat) {
                    //2vuy
                    char *temp = new char[m_Rowsize * m_vMovieFrame.bottom];

                    for (i = 0; i < m_vMovieFrame.bottom; i++) {
                        memcpy(&temp[i * dst_pitch], &frameData.pData[i * m_Rowsize], m_Rowsize);
                    }

                    m_lBytesReturned =
                        ConvertPixFormat(pData, temp, QTMOVIE_RAW_MODE_UYVY, m_iDither, m_vMovieFrame,
                                         m_Rowsize * m_vMovieFrame.bottom, m_CodecInfo);
                    delete temp;
                    m_lPrevFrameNum = frameNum;
                    return m_lBytesReturned;
                }

                for (i = 0; i < m_vMovieFrame.bottom; i++) {
                    memcpy(&pData[i * dst_pitch], &frameData.pData[i * m_Rowsize], m_Rowsize);
                }
            }
        }

        m_lPrevFrameNum = frameNum;

        return m_Rowsize * m_vMovieFrame.bottom;
    }
#endif //QT_ICM

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

    if (m_iMode == 2 || m_iMode == 4) { //2 = SequenceDecompress    4 = VFW
        // 2005-01-03, if GetMovieNextInterestingTime failed to get frame times
        // fall back to manual method of determining frame time
        //time = TrackTimeToMediaTime(frameNumTime, m_vTrack);
        //time = TrackTimeToMediaDisplayTime(frameNumTime, m_vTrack);
        //time = frameNumTime;// = m_vFrameInfoDisplay[frameNum].mTime;

        //if (m_CodecInfo.m_iFourCC != FOUR_CHAR_CODE('avc1')
        //      && m_CodecInfo.m_iFourCC != FOUR_CHAR_CODE('mp4v')) {
        if (bIFrameOnly) {
            err = GetMediaSample(m_vMedia, m_compressedData, maxCompressedSize, //long maxSizeToGrow,
                                 &m_lRawFrameSize, time,        //m_vFrameInfoDisplay[frameNum].mTime //time
                                 &sampleTime, &durationPerSample, NULL, //sampleDescriptionH,
                                 &sampleDescriptionIndex, maxNumberOfSamples, &numberOfSamples, &sampleflags);
            if (err != noErr) {
                sprintf(strStatus, "ReadVideoFrame Error - GetMedia: err= %d", err);
                return 0;
            }
#ifdef QT_VFW
            if (bVFW) {
                DWORD dwFlags = 0;
                //if (!keyframe)
                //dwFlags |= ICDECOMPRESS_NOTKEYFRAME;
                //if (preroll)
                //      dwFlags |= ICDECOMPRESS_PREROLL;
                //BlockMoveData(m_compressedDataPtr, pDataCompressed, m_lRawFrameSize);
                //DWORD mErr = ICDecompress(hic, dwFlags,
                //      pbiSrc, (char *)pDataCompressed, &biDst, (char *)pData);
                //char *temp = new char[m_Rowsize * m_vMovieFrame.bottom + 1];
                pbiSrc->biSizeImage = m_lRawFrameSize;  //2007-01-21 Added
                //DWORD mErr = ICDecompress(hic, 0, pbiSrc, (byte *)m_compressedDataPtr, &biDst, pData); // R2007-07-17
                DWORD mErr;

                // 2007-07-17
                if (m_iModRowsize == m_Rowsize == dst_pitch) {
                    //2vuy
                    mErr = ICDecompress(hic, 0, pbiSrc, (byte *) m_compressedDataPtr, &biDst, pData);
                } else {
                    mErr = ICDecompress(hic, 0, pbiSrc, (byte *) m_compressedDataPtr, &biDst, GWorldDataPtr);
                    for (int i = 0; i < m_vMovieFrame.bottom; i++) {
                        memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_Rowsize], m_Rowsize);
                    }
                }

                return m_Rowsize * m_vMovieFrame.bottom;
            } else {
#endif
                err = DecompressSequenceFrameWhen(m_seqID, m_compressedDataPtr, m_lRawFrameSize, 0, NULL, NULL, NULL);
                /*decomParams.data = (Ptr)m_compressedData;//m_compressedDataPtr;
                   decomParams.bufferSize = m_Rowsize * m_vMovieFrame.bottom + 1;
                   decomParams.frameNumber = frameNum;
                   ComponentResult cres = ImageCodecBandDecompress(decompInstance, &decomParams); */
#ifdef QT_VFW
            }
#endif

            if (err != noErr) {
                sprintf(strStatus, "ReadVideoFrame Error - DecompressSequenceFrameWhen: err= %d", err);
                return 0;
            }
        } else {                // if (bContainsDisplayOffsets) {
            int isFrameInBuffer = -1;
            MediaSampleFlags sampleflags = 0;
            TimeValue64 sampleTime = 0, durationPerSample = 0;
            ItemCount sampleDescriptionIndex = 0, numberOfSamples = 1, maxNumberOfSamples = 1;

            //isFrameInBuffer = IsFrameInBuffer(frameNum);

            SInt64 flags;
            ULONG DecodeIndexCurFrame = m_vFrameInfoDisplay[frameNum].idx;
            if (frameNum == 0) {
                m_lLastFrameDecodeIdx = -1;

            } else if (m_lPrevFrameNum + 1 == frameNum) {

                //Don't need to change anything
                //Will get decode time of m_lLastFrameDecodeIdx + 1
                //m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].mTimeDec
            } else {            //if (m_lLastFrameDecodeIdx + 1 < DecodeIndexCurFrame) {
                isFrameInBuffer = IsFrameInBuffer(frameNum);

                if (isFrameInBuffer != -1) {
                    //BlockMoveData(m_vFrameBuffer[isFrameInBuffer].data, pData, m_Rowsize * m_vMovieFrame.bottom);
                    memcpy(pData, m_vFrameBuffer[isFrameInBuffer].data, m_Rowsize * m_vMovieFrame.bottom);    // R2007-07-17
                    // 2007-07-17
                    int i, j;
                    if (m_iModRowsize == m_Rowsize == dst_pitch
                        && m_pixelFormat != k32BGRAPixelFormat && m_pixelFormat != k24BGRPixelFormat) {
                        memcpy(pData, m_vFrameBuffer[isFrameInBuffer].data, m_Rowsize * m_vMovieFrame.bottom);
                    } else if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
                        for (i = m_vMovieFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
                            memcpy(&pData[j * dst_pitch], &m_vFrameBuffer[isFrameInBuffer].data[i * m_iModRowsize],
                                   m_Rowsize);
                        }
                    } else {
                        if (m_pixelFormat == k2vuyPixelFormat) {
                            //2vuy
                            char *temp = new char[m_Rowsize * m_vMovieFrame.bottom];

                            for (i = 0; i < m_vMovieFrame.bottom; i++) {
                                memcpy(&temp[i * dst_pitch], &m_vFrameBuffer[isFrameInBuffer].data[i * m_iModRowsize],
                                       m_Rowsize);
                            }

                            m_lBytesReturned =
                                ConvertPixFormat(pData, temp, QTMOVIE_RAW_MODE_UYVY, m_iDither, m_vMovieFrame,
                                                 m_Rowsize * m_vMovieFrame.bottom, m_CodecInfo);
                            delete temp;
                            m_lPrevFrameNum = frameNum;
                            return m_lBytesReturned;
                        }

                        for (i = 0; i < m_vMovieFrame.bottom; i++) {
                            memcpy(&pData[i * dst_pitch], &m_vFrameBuffer[isFrameInBuffer].data[i * m_iModRowsize],
                                   m_Rowsize);
                        }
                    }
                    m_lPrevFrameNum = frameNum;
                    return m_Rowsize * m_vMovieFrame.bottom;
                }

                for (int i = m_vKeyframes.size() - 1; i >= 0; i--) {
                    if (m_vKeyframes[i] <= frameNum) {
                        if (m_lLastFrameDecodeIdx > frameNum) {
                            m_lLastFrameDecodeIdx = m_vKeyframes[i] - 1;
                        } else {
                            if (m_vKeyframes[i] > m_lLastFrameDecodeIdx) {
                                m_lLastFrameDecodeIdx = m_vKeyframes[i] - 1;
                            }
                        }
                        break;
                    }
                }
            }

            do {
                if (m_lLastFrameDecodeIdx + 1 > m_vFrameInfoDecode.size())
                    break;

                if ((mediaSampleDroppable & m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].mFlags)
                    && (m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].idx != frameNum)
                    && (abs(frameNum - m_lLastFrameDecodeIdx) >= 5)) {
                    m_lLastFrameDecodeIdx++;
                    continue;
                }

                time = m_vFrameInfoDisplay[m_lLastFrameDecodeIdx + 1].mTimeDec;

                err = GetMediaSample2(m_vMedia, (UInt8 *) pDataCompressed,      //GWorldDataPtr
                                      maxCompressedSize,        //long maxSizeToGrow,
                                      (ByteCount *) & m_lRawFrameSize, time,    //m_vFrameInfoDisplay[frameNum].mTime //time
                                      (TimeValue64 *) & sampleTime, (TimeValue64 *) & durationPerSample, NULL, NULL,    //sampleDescriptionH,
                                      (ItemCount *) & sampleDescriptionIndex,
                                      maxNumberOfSamples,
                                      (ItemCount *) & numberOfSamples, (MediaSampleFlags *) & sampleflags);

                if (err != noErr) {
                    sprintf(strStatus, "ReadVideoFrame Error - GetMedia: err= %d", err);
                    return NULL;
                }

#ifdef QT_VFW
                if (bVFW) {
                    DWORD dwFlags = 0;

                    if (!m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].bKeyframe) {
                        dwFlags |= ICDECOMPRESS_NOTKEYFRAME;
                    } else if (m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].bKeyframe) {
                        dwFlags |= ICDECOMPRESS_HURRYUP | ICDECOMPRESS_PREROLL;
                    }
                    pbiSrc->biSizeImage = m_lRawFrameSize;      //2007-01-21 Added
                    //DWORD mErr = ICDecompress(hic, dwFlags, pbiSrc, pDataCompressed, &biDst, pData); // R2007-07-17
                    DWORD mErr;

                    // 2007-07-17
                    if (m_iModRowsize == m_Rowsize == dst_pitch) {
                        mErr = ICDecompress(hic, dwFlags, pbiSrc, pDataCompressed, &biDst, pData);
                    } else {
                        mErr = ICDecompress(hic, dwFlags, pbiSrc, pDataCompressed, &biDst, GWorldDataPtr);
                        for (int i = 0; i < m_vMovieFrame.bottom; i++) {
                            memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_Rowsize], m_Rowsize);
                        }
                    }

                    if (mErr) {
                        char str[512];
                        sprintf(str, "Init_VFW 3, %d, Size=%d", mErr, m_lRawFrameSize);
                        MessageBox(NULL, str, "", MB_OK);
                    }
                    m_lPrevFrameNum = frameNumCurrent;
                    m_lLastFrameDecodeIdx++;
                    return m_Rowsize * m_vMovieFrame.bottom;
                } else {
#endif
                    //memset(GWorldDataPtr, 0, m_vMovieFrame.bottom * m_Rowsize);

                    //BlockMoveData(pDataCompressed, m_compressedDataPtr, m_lRawFrameSize);
                    err = DecompressSequenceFrameWhen(m_seqID,
                                                      (Ptr) pDataCompressed, m_lRawFrameSize, 0, NULL, NULL, NULL);

#ifdef QT_VFW
                }
#endif

                if (err != noErr) {
                    sprintf(strStatus, "ReadVideoFrame Error - DecompressSequenceFrameWhen: err= %d", err);
                    return NULL;
                }

                //Add decompressed frame to buffer
                //only use for avc1, broken on the mp4v sample I tried
                if (bContainsDisplayOffsets && (abs(frameNum - m_lLastFrameDecodeIdx) < 5)) {
                    int test = 0;

                    m_sFrameBuffer.frame = m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].idx;
                    UpdateFrameBuffer(GWorldDataPtr, m_sFrameBuffer.frame, true);
                    test = 1;
                }
                m_lLastFrameDecodeIdx++;

            } while (m_lLastFrameDecodeIdx < frameNum + 4);

            isFrameInBuffer = IsFrameInBuffer(frameNum);

            if (isFrameInBuffer != -1) {
                //BlockMoveData(m_vFrameBuffer[isFrameInBuffer].data, pData, m_Rowsize * m_vMovieFrame.bottom);
                //memcpy(pData, m_vFrameBuffer[isFrameInBuffer].data, m_Rowsize * m_vMovieFrame.bottom); // R2007-07-17

                // 2007-07-17
                int i, j;
                if (m_iModRowsize == m_Rowsize == dst_pitch
                    && m_pixelFormat != k32BGRAPixelFormat && m_pixelFormat != k24BGRPixelFormat) {
                    memcpy(pData, m_vFrameBuffer[isFrameInBuffer].data, m_Rowsize * m_vMovieFrame.bottom);
                } else if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
                    for (i = m_vMovieFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
                        memcpy(&pData[j * dst_pitch], &m_vFrameBuffer[isFrameInBuffer].data[i * m_iModRowsize],
                               m_Rowsize);
                    }
                } else {
                    for (i = 0; i < m_vMovieFrame.bottom; i++) {
                        memcpy(&pData[i * dst_pitch], &m_vFrameBuffer[isFrameInBuffer].data[i * m_iModRowsize],
                               m_Rowsize);
                    }
                }

                m_lPrevFrameNum = frameNum;
                return m_Rowsize * m_vMovieFrame.bottom;
            }                   /* else {
                                   memset(pData, 0, m_Rowsize * m_vMovieFrame.bottom);
                                   return m_Rowsize * m_vMovieFrame.bottom;
                                   } */
        }

        // Pull decoded frame out.
        //ICMDecompressionSessionSetNonScheduledDisplayTime(
        //      decompressionSession, time, m_vMediaTimeScale, 0);
        //decompressionSession, m_vFrameInfoDisplay[frameNum].mTime, m_vMediaTimeScale, 0);

        m_lPrevFrameNum = frameNum;
#ifdef QT_VFW
        if (!bVFW) {
#endif
            /*if (m_iModRowsize == m_Rowsize) // R2007-07-17
               BlockMoveData(GWorldDataPtr, pData, m_Rowsize * m_vMovieFrame.bottom);
               else {
               for (int i = 0; i < m_vMovieFrame.bottom; i++) {
               //memcpy(&GWorldDataPtr[i * frameData.rowsize], pTemp, frameData.rowsize);
               memcpy(&pData[i * m_Rowsize], &GWorldDataPtr[i * m_iModRowsize], m_Rowsize);
               //GWorldDataPtr += m_iModRowsize;
               }
               } */

            // 2007-07-17
            int i, j;
            if (m_iModRowsize == m_Rowsize == dst_pitch
                && m_pixelFormat != k32BGRAPixelFormat && m_pixelFormat != k24BGRPixelFormat) {
                BlockMoveData(GWorldDataPtr, pData, m_Rowsize * m_vMovieFrame.bottom);
            } else if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
                for (i = m_vMovieFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
                    memcpy(&pData[j * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_Rowsize);
                }
            } else {
                for (i = 0; i < m_vMovieFrame.bottom; i++) {
                    memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_Rowsize);
                }
            }
#ifdef QT_VFW
        }
#endif

        return m_Rowsize * m_vMovieFrame.bottom;
    } else if (m_iMode == 0) {
        //SetMovieTimeValue(m_Movie, (TimeValue)(*pCurrent*ts/1000/10000i64));

        // 2005-01-03, if GetMovieNextInterestingTime failed to get frame times
        // fall back to manual method of determining frame time
        //time = TrackTimeToMediaDisplayTime(frameNumTime, m_vTrack);
        SetMovieTimeValue(m_Movie, frameNumTime);
        //SetMovieTimeValue(m_Movie, m_vMediaSampleDuration * frameNum);
        //SetMovieTimeValue(m_Movie, m_vFrameInfo); //m_vFrameInfo frameNumTime

        //UpdateMovie(m_Movie);
        MoviesTask(m_Movie, 0L);

        // 2007-07-17
        int i, j;
        if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
            for (i = m_vMovieFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
                memcpy(&pData[j * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_Rowsize);
            }
        } else {
            if (m_pixelFormat == k2vuyPixelFormat) {
                //2vuy
                char *temp = new char[m_Rowsize * m_vMovieFrame.bottom];

                for (i = 0; i < m_vMovieFrame.bottom; i++) {
                    memcpy(&temp[i * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_Rowsize);
                }

                m_lBytesReturned =
                    ConvertPixFormat(pData, temp, QTMOVIE_RAW_MODE_UYVY, m_iDither, m_vMovieFrame,
                                     m_Rowsize * m_vMovieFrame.bottom, m_CodecInfo);
                delete temp;

                return m_lBytesReturned;
            }

            for (i = 0; i < m_vMovieFrame.bottom; i++) {
                memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_Rowsize);
            }
        }

        return m_Rowsize * m_vMovieFrame.bottom;
    }

    //Should never get here
    return 0;
}

////////////////////////////////////////////////////////////////////////////////

long CQTMovieDec::ReadAudioFrame(byte * pData, __int64 frameNum, __int64 count, unsigned long *m_lBytesConverted)
{
    OSErr err = noErr;

    if (bAudioExtractionApi) {
        if (frameNum == 0)
            SetUpMovieAudioExtraction();

        UInt32 ioNumFrames = 4096;
        UInt32 FramesRead = 0;
        int frames_left = (int) count;
        UInt32 outFlags = 0;
        TimeRecord timeRec;

        timeRec.scale = GetAudioSampleRate();
        timeRec.base = NULL;
        timeRec.value.hi = 0;
        timeRec.value.lo = frameNum;

        err = MovieAudioExtractionSetProperty(m_AudioExtractor,
                                              kQTPropertyClass_MovieAudioExtraction_Movie,
                                              kQTMovieAudioExtractionMoviePropertyID_CurrentTime,
                                              sizeof(TimeRecord), &timeRec);

        while (frames_left > 0 && !(outFlags & kQTMovieAudioExtractionComplete)
               && ioNumFrames != 0) {
            ioNumFrames = QT_MAX_AUDIO_SAMPLES;
            err = MovieAudioExtractionFillBuffer(m_AudioExtractor, &ioNumFrames, (AudioBufferList *) ioData, &outFlags);

            if (noErr != noErr) {
                sprintf(strStatus, "\nUnable to read audio samples: err = %d\n", err);
                return 0;
            }

            for (int i = 0; i < (ioNumFrames > frames_left ? frames_left : ioNumFrames) * m_ASBD.mBytesPerFrame;
                 i += m_ASBD.mBytesPerFrame) {
                for (int c = 0; c < ioData->mNumberBuffers; c++) {
                    //memcpy(pData, &chan[c][i], m_ASBD.mBytesPerFrame);
                    byte *tData = reinterpret_cast < byte * >(ioData->mBuffers[c].mData);
                    memcpy(pData, &tData[i], m_ASBD.mBytesPerFrame);

                    //memcpy(pData, &ioData->mBuffers[c].mData[i], m_ASBD.mBytesPerFrame);
                    pData += m_ASBD.mBytesPerFrame;
                }
            }

            FramesRead += ioNumFrames > frames_left ? frames_left : ioNumFrames;
            frames_left -= ioNumFrames;
        }

        if (outFlags & kQTMovieAudioExtractionComplete)
            SetUpMovieAudioExtraction();

        return FramesRead;
    }
#ifdef QTMOVIE_QT6
    else {
        int buffersize = 44100 * 16;
        OSErr err = noErr;
        //PtrToHand(pData, &hSound, buffersize);

        long m_lBytesRead = 0;
        __int64 curFrame = 0;
        UInt32 readCount = 0;

        TimeValue time = frameNum, sampleTime = 0, durationPerSample = 0;
        TimeValue myTrackOffset;
        long sampleDescriptionIndex = 0, numberOfSamples = 1, maxNumberOfSamples = 1;
        unsigned long numberOfSamplesConverted = 0, TotalSamplesConverted = 0, m_lTotalBytesConverted = 0;
        short sampleflags = 0;
        // Set the timebase time to the step of the sequence to be rendered
        //SetTimeBaseValue(gTimeBase, frameNum, m_MovieTimeScale);

        /*SampleDescriptionHandle sampleDescriptionH;
           sampleDescriptionH = (SampleDescriptionHandle)NewHandleClear(sizeof(SampleDescription)); */

        //myTrackOffset = GetTrackOffset(m_aTrack);
        //time = TrackTimeToMediaTime(frameNum * m_MediaSampleDuration, m_aTrack);
        //time = TrackTimeToMediaTime(frameNum, m_aTrack);

        if (count > inputFrames)
            readCount = inputFrames;
        else
            readCount = (UInt32) count;

        do {
            if ((curFrame + readCount) > count)
                readCount = count - curFrame;

            curFrame += readCount;

            err = GetMediaSample(m_aMedia, inputAudio, 2000000, //inputBytes,                   //long maxSizeToGrow,
                                 &m_lBytesRead, 0, &sampleTime, &durationPerSample, NULL,       //sampleDescriptionH,
                                 0, readCount, &numberOfSamples, 0);

            if (m_lBytesRead == 0) {
                *m_lBytesConverted = 0;
                sprintf(strStatus, "Unable to read audio samples");
                return 0;
            }

            char *buffer = *inputAudio;

            err = SoundConverterConvertBuffer(converter, buffer, numberOfSamples,
                                              (Ptr) pData, &numberOfSamplesConverted, m_lBytesConverted);
            pData += (UInt32) m_lBytesConverted;

            //SoundConverterConvertBuffer(myConverter, *theSourceHandle + myDataOffset, mySourceFrames, myDestPtr, &myDestFrames, &myDestBytes);
            //PtrAndHand(myDestPtr, theDestHandle, myDestBytes);

            if (err != noErr) {
                sprintf(strStatus,
                        "SoundConverterConvertBuffer Error numberOfSamples=%d, m_lBytesRead = %d, durationPerSample = %d, sampleTime=%d",
                        numberOfSamples, m_lBytesRead, durationPerSample, sampleTime);
                pData = NULL;
                return 0;
            }
        } while (curFrame < count);

        //memcpy(pData, (byte *)outputAudio, *m_lBytesConverted);
        //pData = (byte *)outputAudioPtr;
        return numberOfSamplesConverted;
    }
#endif
    return 0;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

CQTMovieEnc::CQTMovieEnc()
{
    OSErr err = noErr;

    m_Movie = NULL;
    m_vTrack = NULL;
    m_aTrack = NULL;
    m_vMedia = NULL;
    m_aMedia = NULL;
    m_resRefNum = 0;
    m_GWorld = NULL;
    GWorldDataPtr = NULL;
    m_GDHandle = NULL;
    m_Port = NULL;
    m_imageDesc = NULL;
    m_compressedData = NULL;
    m_compressedDataPtr = NULL;
    hSound = nil;
    hSoundDesc = NULL;
    m_seqID = NULL;

    SyncFlag = 0;

    bIsLoaded = false;
    sprintf(strStatus, "No Error");

    err = InitializeQTML(0);
    //kInitializeQTMLDisableDirectSound kInitializeQTMLNoSoundFlag
    if (err != noErr) {
        TerminateQTML();
        sprintf(strStatus, "Unable to Initialize Quicktime Environment %d", err);
        return;
    }

    if (EnterMovies() == noErr)
        bIsLoaded = true;
}

////////////////////////////////////////////////////////////////////////////////

CQTMovieEnc::~CQTMovieEnc()
{
    short resId = movieInDataForkResID;

    if (m_seqID) {
        CDSequenceEnd(m_seqID);
        m_seqID = NULL;
    }

    if (stdCompression) {
        SCCompressSequenceEnd(stdCompression);
        CloseComponent(stdCompression);
    }

    if (m_CodecInfo.quality > 0) {
        long trackHints;
        long ignore1, ignore2, ignore3;

        GetTrackLoadSettings(m_vTrack, &ignore1, &ignore2, &ignore3, &trackHints);
        //trackHints ^= hintsHighQuality; // on/off and so on or off
        trackHints |= hintsHighQuality; // always on

        SetTrackLoadSettings(m_vTrack, ignore1, ignore2, ignore3, trackHints);
        SetMediaPlayHints(m_vMedia, trackHints, hintsHighQuality);
    }

    if (m_vMedia)
        EndMediaEdits(m_vMedia);
    if (m_vTrack)
        InsertMediaIntoTrack(m_vTrack, kTrackStart,     //track start time
                             kMediaStart,       // media start time
                             GetMediaDuration(m_vMedia), fixed1);

    if (m_aMedia)
        EndMediaEdits(m_aMedia);
    if (m_aTrack)
        InsertMediaIntoTrack(m_aTrack, kTrackStart,     // track start time
                             kMediaStart,       // media start time
                             GetMediaDuration(m_aMedia), kFix1);

    if (m_Movie)
        AddMovieResource(m_Movie, m_resRefNum, &resId, m_FileName);

    QTFreeMemory();
    ExitMovies();
    TerminateQTML();
}

////////////////////////////////////////////////////////////////////////////////

void CQTMovieEnc::QTFreeMemory()
{
    if (GWorldDataPtr) {
        free(GWorldDataPtr);
        GWorldDataPtr = NULL;
    }

    if (hSoundDesc != NULL) {
        DisposeHandle((Handle) hSoundDesc);
        hSoundDesc = NULL;
    }
    if (hSound) {
        DisposeHandle(hSound);
        hSound = NULL;
    }

    if (m_imageDesc) {
        DisposeHandle((Handle) m_imageDesc);
        m_imageDesc = NULL;
    }
    if (m_compressedData) {
        DisposeHandle(m_compressedData);
        m_compressedData = NULL;
    }
    if (m_resRefNum) {
        CloseMovieFile(m_resRefNum);
        m_resRefNum = 0;
    }
    if (m_Movie) {
        DisposeMovie(m_Movie);
        m_Movie = NULL;
    }
    if (m_Port) {
        SetGWorld(m_Port, m_GDHandle);
        m_Port = NULL;
    }
    if (m_GWorld) {
        DisposeGWorld(m_GWorld);
        m_GWorld = NULL;
    }
}

////////////////////////////////////////////////////////////////////////////////

void CQTMovieEnc::SetFormat(OSType mFormat, int mOrder)
{
    m_pixelFormat = mFormat;
    rowOrder = mOrder;
}

////////////////////////////////////////////////////////////////////////////////

char *CQTMovieEnc::GetErrorMessage()
{
    return strStatus;
}

////////////////////////////////////////////////////////////////////////////////
HRESULT CQTMovieEnc::Initialize(char *strFileName, int width, int height,
                                int fps_numerator, int fps_denominator, int rowsize, QTCodecInfo mCodec, int raw,
                                char *strSettings)
{
    OSErr err = noErr;

    bool bShowDialog = false;

    m_vTrackFrame.left = 0;
    m_vTrackFrame.top = 0;
    m_vTrackFrame.right = width;
    m_vTrackFrame.bottom = height;
    m_MovieTimeScale = fps_numerator;
    m_SampleDuration = fps_denominator;

    m_Rowsize = rowsize;
    m_iRaw = raw;
    bFristFrame = true;

    float mMult = 3;
    int m_iMod = 16, m_iModWidth;
    if (m_pixelFormat == k32BGRAPixelFormat) {
        mMult = 4;
        m_iMod = 4;
    } else if (m_pixelFormat == kYUVSPixelFormat) {
        mMult = 2;
        m_iMod = 8;
    } else if (m_pixelFormat == kYUV420PixelFormat || m_pixelFormat == kMpegYUV420CodecType) {
        mMult = 12 / 8;
        m_iMod = 16;
    }

    if ((m_vTrackFrame.right % m_iMod) != 0) {
        m_iModWidth = (floor(1.0 * m_vTrackFrame.right / m_iMod) + 1) * m_iMod;
    } else
        m_iModWidth = m_vTrackFrame.right;

    m_iModRowsize = m_iModWidth * mMult;
    m_Rowsize = m_vTrackFrame.right * mMult;

    GWorldDataPtr = (char *) calloc(height, m_iModRowsize);     //(width * height, m_Rowsize / width);

    err = QTNewGWorldFromPtr(&m_GWorld, m_pixelFormat, &m_vTrackFrame, NULL,    //CTabHandle cTable,
                             NULL,      //GDHandle aGDevice,
                             NULL,      //GWorldFlags flags,
                             (void *) GWorldDataPtr,    //void *baseAddr,        pData
                             m_Rowsize);        //long rowBytes);

    if (err != noErr) {
        sprintf(strStatus, "CQTMovieEnc, Unable to Create New GWorld: %d", err);
        goto TerminateQuickTime;
    }


    m_PixMap = GetGWorldPixMap(m_GWorld);
    
#if 0
Disable, Doesn't Work???
    // gamma 1 attempt
    float m_fGamma = -1;
    Fixed pixGammaRequest = QTGetPixMapHandleRequestedGammaLevel(m_PixMap);
    Fixed pixGamma = QTGetPixMapHandleGammaLevel(m_PixMap);

    if (m_fGamma == 0)
        m_fGamma = FixedToFloat(pixGamma);

    if (m_fGamma > 0) {
        QTSetPixMapHandleRequestedGammaLevel(m_PixMap, FloatToFixed(m_fGamma));
        /*pixGammaRequest = QTGetPixMapHandleRequestedGammaLevel(m_PixMap);
           pixGamma = QTGetPixMapHandleGammaLevel(m_PixMap);
           sprintf(strStatus, "Change to %02f, Request %02f, Gamma %02f",
           m_fGamma, FixedToFloat(pixGammaRequest), FixedToFloat(pixGamma));
           MessageBox(NULL, strStatus, "2", MB_OK); */
    }
#endif

    if (!LockPixels(m_PixMap)) {
        sprintf(strStatus, "Unable to lock PixMap");
        goto TerminateQuickTime;
    }

    c2pstrcpy(m_FileName, strFileName);

    m_CodecInfo = mCodec;

    if (mCodec.m_iFourCC == 0) {
        bShowDialog = true;
        memset(m_CodecInfo.strFourCC, 0, sizeof(mCodec.strFourCC));
        strcpy(m_CodecInfo.strFourCC, "mjpa");
    }
    //CodecFlags codecflags;
    m_CodecInfo.m_iFourCC =
        FOUR_CHAR_CODE_M(m_CodecInfo.strFourCC[0], m_CodecInfo.strFourCC[1],
                         m_CodecInfo.strFourCC[2], m_CodecInfo.strFourCC[3]);

    myExporter = NULL;
    QTAtomContainer compressorData = NULL;
    Boolean bCanceled = false;
    myExporter = OpenDefaultComponent(MovieExportType, kQTFileTypeMovie);

    err = OpenADefaultComponent(MovieExportType, kQTFileTypeMovie, &myExporter);        //kQTFileTypeMovie kQTFileTypeAVI kQTFileTypeMP4

    stdCompression = 0;

    stdCompression = OpenDefaultComponent(StandardCompressionType, StandardCompressionSubType);
    if (!stdCompression) {
        sprintf(strStatus, "Cannot open stdCompression");
        goto TerminateQuickTime;
    }

    SCSpatialSettings mSCSpatial = { m_CodecInfo.m_iFourCC,
        anyCodec, 32, m_CodecInfo.quality
    };
    SCTemporalSettings mSCTemporal = { m_CodecInfo.quality,
        FloatToFixed(float (m_MovieTimeScale) / m_SampleDuration), m_CodecInfo.m_iKeyframeRate
    };
    SCDataRateSettings mSCDataRate = { m_CodecInfo.m_iDataRate, 0, m_CodecInfo.quality };

    err = (OSErr) SCSetInfo(stdCompression, scSpatialSettingsType, &mSCSpatial);
    err = (OSErr) SCSetInfo(stdCompression, scTemporalSettingsType, &mSCTemporal);
    err = (OSErr) SCSetInfo(stdCompression, scDataRateSettingsType, &mSCDataRate);
    //err = (OSErr)SCSetInfo(stdCompression, scColorTableType, &mSCDataRate);

    SCGetSettingsAsAtomContainer(stdCompression, &compressorData);
    if (!bShowDialog) {
        MovieExportSetSettingsFromAtomContainer(myExporter, compressorData);
    }

    Str255 szAtomFileName;
    FSSpec m_atomFile;
    short fileRefNum = 0;
    long mSize = GetHandleSize(compressorData);
    Handle hAtom;
    FILE *atomSettings = NULL;

    if (strlen(strSettings) > 0) {
        c2pstrcpy(szAtomFileName, strSettings);
        err = FSMakeFSSpec(0, 0, szAtomFileName, &m_atomFile);
        atomSettings = fopen(strSettings, "rb");
    }

    if (atomSettings) {
        fseek(atomSettings, 0, SEEK_END);
        mSize = ftell(atomSettings);
        fclose(atomSettings);

        hAtom = NewHandle(mSize);

        if (err == noErr)
            err = FSpOpenDF(&m_atomFile, fsRdPerm, &fileRefNum);

        if (err == noErr)
            err = FSRead(fileRefNum, &mSize, *hAtom);

        if (err == noErr)
            bShowDialog = false;

        if (fileRefNum != 0)
            err = FSClose(fileRefNum);

        SCSetSettingsFromAtomContainer(stdCompression, (QTAtomContainer) hAtom);
        MovieExportSetSettingsFromAtomContainer(myExporter, (QTAtomContainer) hAtom);

        QT_FREE_HANDLE(hAtom);
    }

    if (bShowDialog) {

#if 1 //audio and video
        MovieExportDoUserDialog(myExporter, NULL, NULL, 0, 0, &bCanceled);
        if (err == scUserCancelled || bCanceled) {
            sprintf(strStatus, "User cancelled compression dialog");
            goto TerminateQuickTime;
        }

        err = MovieExportGetSettingsAsAtomContainer(myExporter, &compressorData);
        if (err != noErr) {
            sprintf(strStatus, "Failed MovieExportGetSettingsAsAtomContainer compressorData (%d)", err);
            goto TerminateQuickTime;
        }
        err = SCSetSettingsFromAtomContainer(stdCompression, compressorData);
        if (err != noErr) {
            sprintf(strStatus, "Failed SCSetSettingsFromAtomContainer stdCompression (%d)", err);
            goto TerminateQuickTime;
        }

        ComponentInstance stdCompressionAudio =
            OpenDefaultComponent(StandardCompressionType, StandardCompressionSubTypeAudio);
        if (!stdCompressionAudio) {
            sprintf(strStatus, "Cannot open stdCompressionAudio");
            goto TerminateQuickTime;
        }

        err = SCSetSettingsFromAtomContainer(stdCompressionAudio, compressorData);
        if (err != noErr) {
            sprintf(strStatus, "Failed SCSetSettingsFromAtomContainer stdCompressionAudio (%d)", err);
            goto TerminateQuickTime;
        }

        ByteCount size = 0;
        err = QTGetComponentProperty(stdCompressionAudio,
                                     kQTPropertyClass_SCAudio,
                                     kQTSCAudioPropertyID_SoundDescription, sizeof(hSoundDesc), &hSoundDesc, &size);
        if (err != noErr) {
            sprintf(strStatus, "Failed QTGetComponentProperty Audio (%d)", err);
            goto TerminateQuickTime;
        }

        CloseComponent(stdCompressionAudio);
#else //This doesn't do audio export
        err = SCRequestSequenceSettings(stdCompression);
        if (err == scUserCancelled) {
            sprintf(strStatus, "User cancelled compression dialog");
            goto TerminateQuickTime;
        }

        SCGetSettingsAsAtomContainer(stdCompression, &compressorData);
        MovieExportSetSettingsFromAtomContainer(myExporter, compressorData);
#endif

    }

    if (bShowDialog && strSettings) {
        fileRefNum = 0;
        mSize = GetHandleSize(compressorData);

        FSpDelete(&m_atomFile);

        err = FSpCreate(&m_atomFile, FOUR_CHAR_CODE('RTM '), FOUR_CHAR_CODE('Pref'), smSystemScript);
        if (err == noErr)
            err = FSpOpenDF(&m_atomFile, fsWrPerm, &fileRefNum);        //fsRdWrPerm

        //if (err == noErr)
        //      err = SetFPos(fileRefNum, fsFromStart, 0);

        if (err == noErr)
            err = FSWrite(fileRefNum, &mSize, *compressorData);

        //if (err == noErr)
        //      err = SetFPos(fileRefNum, fsFromStart, mSize);

        // resize the file to the number of bytes written
        //if (err == noErr)
        //      err = SetEOF(fileRefNum, mSize);

        // close the file
        if (fileRefNum != 0)
            err = FSClose(fileRefNum);
    }

    err = (OSErr) SCGetInfo(stdCompression, scSpatialSettingsType, &mSCSpatial);
    m_CodecInfo.m_iFourCC = mSCSpatial.codecType;
    sprintf(m_CodecInfo.strFourCC, "%c%c%c%c\0",
            (m_CodecInfo.m_iFourCC & 0xFF000000) >> 24,
            (m_CodecInfo.m_iFourCC & 0x00FF0000) >> 16,
            (m_CodecInfo.m_iFourCC & 0x0000FF00) >> 8, (m_CodecInfo.m_iFourCC & 0x000000FF));

    err = FindCodec(m_CodecInfo.m_iFourCC, anyCodec, &compressor, &decompressor);
    if (err != noErr) {
        sprintf(strStatus, "\nUnable to find a valid compression codec for %s (err = %d)\n", m_CodecInfo.strFourCC,
                err);
        goto TerminateQuickTime;
    }
    if (compressor == NULL) {
        sprintf(strStatus, "\nUnable to find a valid compression codec for %s\n", m_CodecInfo.strFourCC);
        goto TerminateQuickTime;
    }

    m_imageDesc = (ImageDescriptionHandle) NewHandle(4);
    if (m_imageDesc == NULL) {
        sprintf(strStatus, "Unable to Allocate Memory Handle");
        goto TerminateQuickTime;
    }
    
#if 0
Disable, Doesn't Work???
    // gamma 2 attempt
    NCLCColorInfoImageDescriptionExtension nclc;

    err = ICMImageDescriptionGetProperty(m_imageDesc,
                                         kQTPropertyClass_ImageDescription,
                                         kICMImageDescriptionPropertyID_NCLCColorInfo, sizeof(nclc), &nclc, NULL);
    if (noErr == err) {
        // Assume NTSC
        char testing[512];
        sprintf(testing, "Compress\ncolorParamType=%d, primaries=%d, transferFunction=%d, matrix=%d",
                nclc.colorParamType, nclc.primaries, nclc.transferFunction, nclc.matrix);
        MessageBox(NULL, testing, "", MB_OK);
    }
    nclc.colorParamType = kVideoColorInfoImageDescriptionExtensionType;
    nclc.primaries = kQTPrimaries_SMPTE_C;
    nclc.transferFunction = kQTTransferFunction_Unknown;        //kQTTransferFunction_ITU_R709_2 kQTTransferFunction_Unknown
    nclc.matrix = kQTMatrix_Unknown;    //kQTMatrix_ITU_R_601_4 kQTMatrix_Unknown
    ICMImageDescriptionSetProperty(m_imageDesc,
                                   kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_NCLCColorInfo,
                                   sizeof(nclc), &nclc);

    Fixed gammalevel;
    ICMImageDescriptionGetProperty(m_imageDesc,
                                   kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_GammaLevel,
                                   sizeof(gammalevel), &gammalevel, NULL);

    gammalevel = kQTUsePlatformDefaultGammaLevel;
    //gammalevel = kQTCCIR601VideoGammaLevel;
    gammalevel = FloatToFixed(20);

    ICMImageDescriptionSetProperty(m_imageDesc,
                                   kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_GammaLevel,
                                   sizeof(gammalevel), &gammalevel);

    //err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
    //                                      kQTPropertyClass_ICMDecompressionSessionOptions,
    //                                      kICMImageDescriptionPropertyID_NCLCColorInfo,
    //                                      sizeof(nclc),
    //                                      &nclc);
#endif

    err = SCCompressSequenceBegin(stdCompression,       //stdCompression, myExporter
                                  m_PixMap, &m_vTrackFrame, &m_imageDesc);

    if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVUI')) {
        if (m_vTrackFrame.bottom == 576)        // PAL
            m_iRawExtras = 16;
        else                    //NTSC
            m_iRawExtras = 10;

        QT_FREE_BUFFER(GWorldDataPtr);
        GWorldDataPtr = (char *) calloc(m_vTrackFrame.bottom + m_iRawExtras + 1, m_Rowsize);
    } else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AV1x')) {
        if (m_vTrackFrame.bottom == 576)        // PAL
            m_iRawExtras = 22;  //for NTSC 486
        else                    //NTSC
            m_iRawExtras = 16;

        QT_FREE_BUFFER(GWorldDataPtr);
        GWorldDataPtr = (char *) calloc(m_vTrackFrame.bottom + m_iRawExtras, m_Rowsize);
    }

    return S_OK;

  TerminateQuickTime:

    QTFreeMemory();
    return E_FAIL;
}

////////////////////////////////////////////////////////////////////////////////

HRESULT CQTMovieEnc::CreateMovie()
{
    OSErr err = noErr;
    err = FSMakeFSSpec(0, 0, m_FileName, &m_fileSpec);
    if (err != noErr && err != fnfErr) {
        char strTemp[MAX_PATH];
        p2cstrcpy(strTemp, m_FileName);
        sprintf(strStatus, "\nError with FSMakeFSSpec:\n %s, err = %d\n", strTemp, err);
        QTFreeMemory();
        return E_FAIL;
    }

    err = CreateMovieFile(&m_fileSpec, FOUR_CHAR_CODE('TVOD'), smCurrentScript,
                          createMovieFileDeleteCurFile | createMovieFileDontCreateResFile, &m_resRefNum, &m_Movie);

    if (err != noErr) {
        // CreateMovieFile sometimes mysteriously fails with -43. It has happened sometimes when writing to a network drive mapped to a drive letter
        // Some forums on the internet had users that suggested to just make the same calls over again and it will work
        // And it has in my test cases...
        err = FSMakeFSSpec(0, 0, m_FileName, &m_fileSpec);
        if (err != noErr && err != fnfErr) {
            char strTemp[MAX_PATH];
            p2cstrcpy(strTemp, m_FileName);
            sprintf(strStatus, "\nError with FSMakeFSSpec:\n %s, err = %d\n", strTemp, err);
            QTFreeMemory();
            return E_FAIL;
        }

        err = CreateMovieFile(&m_fileSpec, FOUR_CHAR_CODE('TVOD'), smCurrentScript,
                              createMovieFileDeleteCurFile | createMovieFileDontCreateResFile, &m_resRefNum, &m_Movie);

        if (err != noErr) {
            char strTemp[MAX_PATH];
            p2cstrcpy(strTemp, m_FileName);
            sprintf(strStatus, "\nUnable to Create Movie:\n %s, err = %d %d\n", strTemp, err, m_resRefNum);
            QTFreeMemory();
            return E_FAIL;
        }
    }

    SetMovieTimeScale(m_Movie, m_MovieTimeScale);

    return S_OK;
}

////////////////////////////////////////////////////////////////////////////////

HRESULT CQTMovieEnc::CreateVideoTrack()
{
    if (m_Movie == NULL) {
        sprintf(strStatus, "Unable to CreateVideoTrack, MovieFile not created");
        return E_FAIL;
    }

    OSErr err = noErr;
    long maxCompressedSize = m_vTrackFrame.right * m_vTrackFrame.bottom * 4;

    m_vTrack = NewMovieTrack(m_Movie, FixRatio(m_vTrackFrame.right, 1), //Do not cast to(short) - Overflow occurs
                             FixRatio(m_vTrackFrame.bottom, 1), 0);
    if (m_vTrack == NULL) {
        sprintf(strStatus, "Unable to CreateVideoTrack");
        goto TerminateQuickTime;
    }

    m_vMedia = NewTrackMedia(m_vTrack, VideoMediaType, GetMovieTimeScale(m_Movie),      //m_MovieTimeScale, //Video Time Scale
                             nil, 0);
    if (m_vMedia == NULL) {
        sprintf(strStatus, "Unable to CreateTrackMedia");
        goto TerminateQuickTime;
    }

    err = GetMaxCompressionSize(m_GWorld->portPixMap, &m_vTrackFrame, kMgrChoose,       // let ICM choose depth
                                m_CodecInfo.quality,    //VIDEO_CODEC_QUALITY,
                                m_CodecInfo.m_iFourCC,  //VIDEO_CODEC_TYPE,
                                compressor,     //(CompressorComponent) anyCodec,
                                &maxCompressedSize);
    if (err != noErr) {
        sprintf(strStatus, "Unable to Get Compression Size, %d", err);
        goto TerminateQuickTime;
    }

    m_compressedData = NewHandle(maxCompressedSize);
    if (m_compressedData == NULL) {
        sprintf(strStatus, "Unable to Allocate Memory");
        goto TerminateQuickTime;
    }

    MoveHHi(m_compressedData);
    HLock(m_compressedData);
    m_compressedDataPtr = StripAddress(*m_compressedData);

    err = BeginMediaEdits(m_vMedia);
    if (err != noErr) {
        sprintf(strStatus, "Unable to to Begin MediaEdits, %d", err);
        goto TerminateQuickTime;
    }

    return S_OK;

  TerminateQuickTime:

    QTFreeMemory();
    return E_FAIL;
}

////////////////////////////////////////////////////////////////////////////////

HRESULT CQTMovieEnc::CreateAudioTrack(int channels, int sampleRate, int bits, bool isFloat)
{
    OSStatus err;
#ifdef QTMOVIE_QT7
    if (m_Movie == NULL) {
        sprintf(strStatus, "Unable to CreateAudioTrack, MovieFile not created");
        return E_FAIL;
    }

    if (hSoundDesc == NULL) {
        long lDataOffset;
        long lDataSize;
        long lNumSamples;
        /*hSound = GetResource(soundListRsrc, 128);
           if (hSound == nil) {
           //sprintf(strStatus, "Unable to get hSound resource, err = %d", ResError());
           //return E_FAIL;
           } */

        hSoundDesc = (SoundDescriptionHandle) NewHandle(4);
        AudioStreamBasicDescription m_ASBD;
        m_ASBD.mSampleRate = sampleRate;
        m_ASBD.mFormatID = kAudioFormatLinearPCM;
        //m_ASBD.mFormatFlags = (isFloat ? kAudioFormatFlagIsFloat : kAudioFormatFlagIsSignedInteger) | kAudioFormatFlagIsPacked
        //      | kAudioFormatFlagIsBigEndian; //kAudioFormatFlagsNativeEndian

        m_ASBD.mFormatFlags = (isFloat ? kAudioFormatFlagIsFloat : kAudioFormatFlagIsSignedInteger) | kAudioFormatFlagIsPacked | kAudioFormatFlagsNativeEndian; //kAudioFormatFlagsNativeEndian

        m_ASBD.mChannelsPerFrame = channels;    //2
        m_ASBD.mBytesPerPacket = bits * channels / 8;
        m_ASBD.mFramesPerPacket = 1;
        m_ASBD.mBytesPerFrame = bits * channels / 8;
        m_ASBD.mBitsPerChannel = bits;

        /*
           #define Float64ToUnsignedFixed(f64SampleRate) ((UnsignedFixed) (((f64SampleRate) * 65536.0) + 0.5))
           (**sampleDescriptionH).sampleRate = Float64ToUnsignedFixed(streamDesc.mSampleRate);
         */

        err = QTSoundDescriptionCreate(&m_ASBD, //AudioStreamBasicDescription    *inASBD,
                                       NULL,    //AudioChannelLayout             *inLayout,
                                       0,       //ByteCount                      inLayoutSize,
                                       NULL,    //void                           *inMagicCookie
                                       0,       //ByteCount                      inMagicCookieSize
                                       kQTSoundDescriptionKind_Movie_LowestPossibleVersion,     //QTSoundDescriptionKind         kQTSoundDescriptionKind_Movie_AnyVersion
                                       &hSoundDesc);    //SoundDescriptionHandle         *outSoundDesc);

        /*(**hSoundDesc).sampleRate = 48000;
           (**hSoundDesc).numChannels = 2;
           (**hSoundDesc).sampleSize = 32; */
    }

    m_aTrack = NewMovieTrack(m_Movie, 0, 0, kFullVolume);
    if (m_aTrack == NULL) {
        sprintf(strStatus, "Unable to CreateAudioTrack");
        goto TerminateQuickTime;
    }

    //FixRound((**hSoundDesc).sampleRate)
    m_aMedia = NewTrackMedia(m_aTrack, SoundMediaType, sampleRate, nil, 0);
    if (m_aMedia == NULL) {
        sprintf(strStatus, "Unable to CreateAudioMedia");
        goto TerminateQuickTime;
    }

    err = BeginMediaEdits(m_aMedia);

    return S_OK;

  TerminateQuickTime:

    QTFreeMemory();
    return E_FAIL;
#else
    return S_OK;
#endif
}

////////////////////////////////////////////////////////////////////////////////

HRESULT CQTMovieEnc::EncodeVideoFrame(char *pData, int src_pitch)
{
    OSErr err = noErr;
    long compressedsize = 0;
    UInt8 similarity = 0;

    if (m_iRaw == 0) {
        /*if (rowOrder == RowOrderBottomUp) {
           for (int h=m_vTrackFrame.bottom-1, i=0; h>=0; h--, i++) {
           memcpy(&GWorldDataPtr[i*m_Rowsize], &pData[h*m_Rowsize], m_Rowsize);
           }
           } else {
           memcpy(GWorldDataPtr, pData, m_vTrackFrame.bottom * m_Rowsize);
           } */
        // 2007-07-17
        int i, j;
        if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
            for (i = m_vTrackFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
                memcpy(&GWorldDataPtr[j * m_Rowsize], &pData[i * src_pitch], m_Rowsize);
            }
        } else {
            for (i = 0; i < m_vTrackFrame.bottom; i++) {
                memcpy(&GWorldDataPtr[i * m_Rowsize], &pData[i * src_pitch], m_Rowsize);
            }
        }

        err = SCCompressSequenceFrame(stdCompression,   //stdCompression,
                                      m_PixMap, &m_vTrackFrame, &m_compressedData, &compressedsize, &SyncFlag);

        (**m_imageDesc).dataSize = compressedsize;

        if (err != noErr) {
            sprintf(strStatus, "Unable to encode Video Frame, error: %d", err);
            return E_FAIL;
        }

        err = AddMediaSample(m_vMedia, m_compressedData, kNoOffset,     // no offset in data
                             compressedsize,    //compressedsize
                             m_SampleDuration,  //
                             (SampleDescriptionHandle) m_imageDesc, kAddOneVideoSample, // one sample
                             SyncFlag,  //kSyncSample self-contained samples
                             nil);
    } else {
        //Raw
        //Compress first frame just to get image desription stuff
        if (bFristFrame) {
            bFristFrame = false;
            err = SCCompressSequenceFrame(stdCompression,       //stdCompression,
                                          m_PixMap, &m_vTrackFrame, &m_compressedData, &compressedsize, &SyncFlag);
        }
        int curSample = 0;

        compressedsize = (**m_imageDesc).dataSize = m_vTrackFrame.bottom * m_Rowsize;

        if (m_iRaw == QTMOVIE_RAW_MODE_YUYV) {
            //yuy2
            memcpy(GWorldDataPtr, pData, compressedsize);
        } else if (m_iRaw == QTMOVIE_RAW_MODE_YUV2) {
            //yuv2 Apple Component
            for (int row = 0; row < m_vTrackFrame.bottom; row++) {
                for (int h = 0; h < m_vTrackFrame.right / 2; h++, curSample += 4) {
                    GWorldDataPtr[curSample] = 0xFF & (int) (255 * (pData[curSample + 0] - 16.5) / 219);        // y0  u0 1
                    GWorldDataPtr[curSample + 1] = 0;   //pData[curSample + 1] - 127;
                    GWorldDataPtr[curSample + 2] = 0xFF & (int) (255 * (pData[curSample + 2] - 16.5) / 219);    // y1  v0 3
                    GWorldDataPtr[curSample + 1] = 0;   //pData[curSample + 3] - 127;
                }
            }
        } else if (m_iRaw == QTMOVIE_RAW_MODE_UYVY) {   //2Vuy
            int offset = curSample;

            //AddExtra Blank rows for AV1x and AVUI codecs
            if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AV1x')) {
                if (m_vTrackFrame.bottom == 576) {      //PAL
                    compressedsize = (**m_imageDesc).dataSize = m_vTrackFrame.bottom * m_Rowsize + 30720;

                    for (int row = 0; row < 1920; row++, curSample += 4) {      //         1664 / 8 = 208
                        GWorldDataPtr[curSample] = 0;
                        GWorldDataPtr[curSample + 1] = 0;
                        GWorldDataPtr[curSample + 2] = 0;
                        GWorldDataPtr[curSample + 3] = 0;       //PAL 7680 / 4 =                1920 / 8 = 240
                    }
                    for (int row = 0; row < 5760; row++, curSample += 4) {      //         3600 / 8 = 450
                        GWorldDataPtr[curSample] = 0x80;
                        GWorldDataPtr[curSample + 1] = 0x10;
                        GWorldDataPtr[curSample + 2] = 0x80;
                        GWorldDataPtr[curSample + 3] = 0x10;    //PAL 23040 / 4=             5760 / 8 = 720
                    }
                } else {        //NTSC
                    compressedsize = (**m_imageDesc).dataSize = m_vTrackFrame.bottom * m_Rowsize + 21056;

                    for (int row = 0; row < 1664; row++, curSample += 4) {      //         1664 / 8 = 208
                        GWorldDataPtr[curSample] = 0;
                        GWorldDataPtr[curSample + 1] = 0;
                        GWorldDataPtr[curSample + 2] = 0;
                        GWorldDataPtr[curSample + 3] = 0;       //PAL 7680 / 4 =                1920 / 8 = 240
                    }
                    for (int row = 0; row < 3600; row++, curSample += 4) {      //         3600 / 8 = 450
                        GWorldDataPtr[curSample] = 0x80;
                        GWorldDataPtr[curSample + 1] = 0x10;
                        GWorldDataPtr[curSample + 2] = 0x80;
                        GWorldDataPtr[curSample + 3] = 0x10;    //PAL 23040 / 4=             5760 / 8 = 720
                    }
                }
                offset = 0;
            } else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVUI')) {
                compressedsize = (**m_imageDesc).dataSize = (m_vTrackFrame.bottom + m_iRawExtras) * m_Rowsize + 4;
                for (int row = 0; row < m_vTrackFrame.right * m_iRawExtras / 2; row++, curSample += 4) {
                    GWorldDataPtr[curSample] = 0x80;
                    GWorldDataPtr[curSample + 1] = 0x10;
                    GWorldDataPtr[curSample + 2] = 0x80;
                    GWorldDataPtr[curSample + 3] = 0x10;
                }
            }

            for (int row = 0; row < m_vTrackFrame.bottom; row++) {
                for (int h = 0; h < m_vTrackFrame.right / 2; h++, curSample += 4, offset += 4) {
                    GWorldDataPtr[curSample] = pData[offset + 1];       // y0  u0 1
                    GWorldDataPtr[curSample + 1] = pData[offset + 0];   // u0  y0 0
                    GWorldDataPtr[curSample + 2] = pData[offset + 3];   // y1  v0 3
                    GWorldDataPtr[curSample + 3] = pData[offset + 2];   // v0  y1 2
                }
            }

            if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVUI')) {
                GWorldDataPtr[curSample++] = 0xFF;
                GWorldDataPtr[curSample++] = 0xFF;
                GWorldDataPtr[curSample++] = 0xFF;
                GWorldDataPtr[curSample++] = 0xD9;
            }
        } else if (m_iRaw == QTMOVIE_RAW_MODE_YVYU) {
            for (int row = 0; row < m_vTrackFrame.bottom; row++) {
                for (int h = 0; h < m_vTrackFrame.right / 2; h++, curSample += 4) {
                    GWorldDataPtr[curSample] = pData[curSample + 0];    // y0  y0 0
                    GWorldDataPtr[curSample + 1] = pData[curSample + 3];        // u0  v0 3
                    GWorldDataPtr[curSample + 2] = pData[curSample + 2];        // y1  y1 2
                    GWorldDataPtr[curSample + 3] = pData[curSample + 1];        // v0  u0 1
                }
            }
        } else if (m_iRaw == QTMOVIE_RAW_MODE_VYUY) {
            for (int row = 0; row < m_vTrackFrame.bottom; row++) {
                for (int h = 0; h < m_vTrackFrame.right / 2; h++, curSample += 4) {
                    GWorldDataPtr[curSample] = pData[curSample + 1];    // y0  v0 1
                    GWorldDataPtr[curSample + 1] = pData[curSample + 2];        // u0  y0 2
                    GWorldDataPtr[curSample + 2] = pData[curSample + 3];        // y1  u1 3
                    GWorldDataPtr[curSample + 3] = pData[curSample + 0];        // v0  y0 0
                }
            }
        }

        Handle m_RawData;       // = NewHandle(compressedsize);
        PtrToHand(GWorldDataPtr, &m_RawData, compressedsize);
        SyncFlag = 0;

        err = AddMediaSample(m_vMedia, m_RawData, kNoOffset,    // no offset in data
                             compressedsize,    //compressedsize
                             m_SampleDuration,  //
                             (SampleDescriptionHandle) m_imageDesc, kAddOneVideoSample, // one sample
                             SyncFlag,  //kSyncSample self-contained samples
                             nil);

        DisposeHandle(m_RawData);
    }

    if (err != noErr) {
        sprintf(strStatus, "Unable to add Video Sample, error: %d", err);
        return E_FAIL;
    }

    return S_OK;
}

////////////////////////////////////////////////////////////////////////////////

HRESULT CQTMovieEnc::EncodeAudioFrame(char *pData, long m_lNumSamples, int buffersize)
{
    OSErr err;
    //int buffersize = m_lNumSamples * (**hSoundDesc).sampleSize * (**hSoundDesc).numChannels;
    //PtrToHand(pData, &hSound, buffersize);

    Handle AudioBuffer = NULL;
    AudioBuffer = NewHandle(buffersize);
    //BlockMove(pData, *AudioBuffer, buffersize);
    err = PtrToHand(pData, &AudioBuffer, buffersize);

    err = AddMediaSample(m_aMedia, AudioBuffer, kNoOffset,      //lDataOffset, // offset in data
                         buffersize,    //buffersize,
                         kSoundSampleDuration,  // duration of each sound
                         // sample
                         (SampleDescriptionHandle) hSoundDesc, m_lNumSamples,   //m_lNumSamples,
                         0,     // self-contained samples
                         nil);

    if (err != noErr) {
        sprintf(strStatus, "Unable to add Audio Samples, %d, %d", err, buffersize);
        MessageBox(NULL, strStatus, "", MB_OK);
        return E_FAIL;
    }

    DisposeHandle(AudioBuffer);

    return S_OK;
}

////////////////////////////////////////////////////////////////////////////////
