/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbcorrector;

import java.util.Enumeration;
import java.util.Hashtable;

import net.rim.device.api.ui.component.ActiveAutoTextEditField;

public class SpellResult {

    private static SpellResult spellResult = null;

    // A map containing SpellData objects keyed on ActiveAutoTextEditField
    // fields
    public Hashtable fieldMap = new Hashtable();

    public static SpellResult getInstance() {

        if (spellResult == null) {
            spellResult = new SpellResult();
        }

        return spellResult;
    }

    public void clear(ActiveAutoTextEditField field) {

        int hashCode = field.hashCode();
        //System.out.println("*** Removing spell data for field hash=" + hashCode);
        fieldMap.remove(new Integer(hashCode));
        outputKeys();
        field.scanForActiveRegions();
    }

    public void outputKeys() {

        //System.out.println("*** SpellResult fieldmap size=" + fieldMap.size());
        for (Enumeration keys = fieldMap.keys(); keys.hasMoreElements();) {
            Integer key = (Integer) keys.nextElement();
            //System.out.println("*** SpellResult fieldmap key=" + key);
        }
    }

    public static class SpellData {

        int textLen = -1;

        SpellError[] spellErrors = null;

        public static class SpellError {

            String wordError = null;

            int position = -1;

            String[] suggestions = null;
        }
    }

    public static class SpellDataHolder {
        public SpellData spellData = null;
    }
}
