<?php
	$text = $_POST['check'];
	$lang = $_POST['lang'];

	//BBCorrector sends data via POST
	//but in case it is run via web URL with Get
	//Try this
	if ( empty($text) ) {
		$text = $_GET['check'];
		$lang = $_GET['lang'];
	} else {
		//Remove UTF8 formatting from POST encoded data
		$text = utf8_decode($text);
	}

	//If no text is found exit with an error
	if ( empty($text) ) {
		print "Error: No Text to Check";
		exit;
	}

	//If a language is not selected, the default language in the aspell setp is used
	if ( !empty($lang) ) {
		$lang = " --lang=" . $lang;
	}
	//$lang = " --lang=en";

	$tmpFile = tempnam("/", "bbCorrector"); //Linux
	//$tmpFile = tempnam("C:/Apache2/php/tmp", "spelltext"); //Win32

	//--dont-ignore-accents
	// . ' --encoding="UTF-8"'
	$aspellcmd = "cat $tmpFile | aspell -a --ignore-case" . $lang; //Linux
	//$aspellcmd = 'cat ' . $tmpFile . ' | "C:/Apache2/Aspell/bin/aspell.exe" -a --ignore-case' . $lang; //Win32

	//Remove extra escape backslashes that were added by PHP
	$text = stripslashes($text);

	//Write formatted data to temp file
	if ($mFile = fopen($tmpFile,"w")) {
		$textArray = explode("\n",$text);
		// Force Aspell to check whole line via ! ^ contol character
		fwrite($mFile,"!\n");
		foreach($textArray as $key=>$value) {
			fwrite($mFile,"^$value\n", strlen($value) + 2);
		}
	}
	fclose($mFile);

	$xmlPacket = '<spell-results>';

	//Run Aspell
	//$mAspellOutput = shell_exec($aspellcmd);
	$mAspellOutputArray = array();
	$mAspell = 0;
	$mAspellOutput = exec($aspellcmd . ' 2>&1', &$mAspellOutputArray, &$mAspell);
	/*$mAspell = popen($aspellcmd . ' 2>&1', 'r');
	//echo "'$handle'; " . gettype($handle) . "\n";
	$mAspellOutput = '';
	while (!feof($mAspell)) {
		$mAspellOutput .= fread($mAspell, 1024);
	}
	pclose($mAspell);*/

	//Error returned by Aspell, exit
	if ($mAspell != 0) {
		$xmlPacket .= "<exception>BBCorrector Server has encountered an error (" . $mAspellOutput . ")</exception>";
		$xmlPacket .= "</spell-results>\n";
		echo $xmlPacket;

		//Delete temp file
		$mDeleteOutput = unlink($tmpFile);
		exit;
	}

	//Delete temp file
	$mDeleteOutput = unlink($tmpFile);

	//parse $mAspellOutput
	//$mAspellOutputArray = explode("\n",$mAspellOutput);

	$lineIdx = -1;
	$charCount = 0;

	foreach($mAspellOutputArray as $key=>$value) {
		if (substr($value,0,1) == "&") { //There is an error with suggestion
			$corVals = explode(" ",$value);
			$word = $corVals[1];
			$posAbsolute = substr($corVals[3],0,-1) - 1 + $charCount;
			$startPos = strpos($value,":") + 2;
			$suggestion = substr($value,$startPos);
			$suggestionArray = explode(", ",$suggestion);

			// Start error element
			$xmlPacket .= "<error>";

			// Add word element which contains original misspelled word
			$xmlPacket .= "<word>$word</word>";
			$xmlPacket .= "<position>$posAbsolute</position>";

			// Add each suggestion
			foreach ($suggestionArray as $key=>$value) {
				$xmlPacket .= "<suggest>$value</suggest>";
			}

			// Close error element
			$xmlPacket .= "</error>";
		} elseif (substr($value,0,1) == "#") { //There is an error but no suggestion
			$corVals = explode(" ",$value);
			$word = $corVals[1];
			$posAbsolute= $corVals[2] - 1;

			// Start error element
			$xmlPacket .= "<error>";

			// Add word element which contains original misspelled word
			$xmlPacket .= "<word>$word</word>";
			$xmlPacket .= "<position>$posAbsolute</position>";

			// Close error element
			$xmlPacket .= "</error>";
		} elseif (substr($value,0,1) == "*") {//No error
		} elseif (substr($value,0,1) == "@") {//Apsell About Line
		} else {
			$lineIdx++;
			$charCount += strlen($textArray[$lineIdx]) + 1;
		}
	}

	$xmlPacket .= "</spell-results>\n";

	print $xmlPacket;
?>