/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbcorrector;

import net.rim.blackberry.api.menuitem.ApplicationMenuItemRepository;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.RuntimeStore;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.util.StringPatternRepository;

/**
 * @author Chris Miles
 *
 * BBCorrector is a client/server based Spell Checking application
 * for the BlackBerry device. It adds 2 system wide menu options
 * to allow you to perform a spell check on any compatible field
 * in any BlackBerry application. These menu options are "Spelling"
 * and "Spelling Suggestion".
 */
public class BBCorrector extends UiApplication {

    public BBCorrector() {
        pushScreen(new BBCorrectorOptionScreen());
    }

    public static void main(String[] args) {

        try {
            // If we are starting up then register our replyto menu items
            // otherwise we should display the BBReply configuration screen
            if (ApplicationManager.getApplicationManager().inStartup()) {
                registerMenuItem();
                CorrectorStringPattern stringPattern = new CorrectorStringPattern();
                StringPatternRepository.addPattern(stringPattern);
                RuntimeStore.getRuntimeStore().put(CorrectorActiveFieldCookie.ID,
                                                   new CorrectorActiveFieldCookieFactory());
            } else {
                //System.out.println("*** Start BBCorrector GUI application");
                BBCorrector BBCorrector = new BBCorrector();
                BBCorrector.enterEventDispatcher();
            }
        } catch (Exception e) {
            //System.out.println("*** Error: " + e.getMessage());
        }

    }

    private static void registerMenuItem() {
        //System.out.println("*** Registering BBCorrector menuitem");
        CheckSpellingMenuItem menuItem = new CheckSpellingMenuItem();
        ApplicationMenuItemRepository amir = ApplicationMenuItemRepository.getInstance();
        amir.addMenuItem(ApplicationMenuItemRepository.MENUITEM_ADDRESSCARD_EDIT, menuItem);
        amir.addMenuItem(ApplicationMenuItemRepository.MENUITEM_CALENDAR_EVENT, menuItem);
        amir.addMenuItem(ApplicationMenuItemRepository.MENUITEM_EMAIL_EDIT, menuItem);
        amir.addMenuItem(ApplicationMenuItemRepository.MENUITEM_GROUPADDRESS_EDIT, menuItem);
        amir.addMenuItem(ApplicationMenuItemRepository.MENUITEM_MEMO_EDIT, menuItem);
        amir.addMenuItem(ApplicationMenuItemRepository.MENUITEM_TASK_EDIT, menuItem);
    }
}
