/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbcorrector;

import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;
//import net.rim.device.api.util.Persistable; // Removed 2006-04-02, v1.2
import net.rim.device.api.util.*; // Added 2006-04-02, v1.2, Persistable, Comparator, Arrays

public class BBCorrectorOptions {

    // org.bbcorrector.BBCorrectorOptions$BBCorrectorOptionsData
    public static final long KEY = 0x94ea353f74e26a8bL;

    public String urlCorrectorServer = null;

    public String username = null;

    public String password = null;

    public boolean disableMDSProxy = false;

    public boolean useGoogle = false; // Added 2006-03-25, v1.2

    public String language = null; // Added 2006-03-25, v1.2

    public boolean bAutoAdvance = false; // Added 2006-03-25, v1.2

    public String [] mvDictionary = null; // Added 2006-04-02, v1.2

    private static Comparator mDictionarySort; // Added 2006-04-02, v1.2

    public void save() {

        try {
            // Added 2006-04-02, v1.2
            if (mvDictionary == null)
                mvDictionary = new String[0];

            PersistentObject record = PersistentStore.getPersistentObject(KEY);
            BBCorrectorOptionsData data = new BBCorrectorOptionsData();
            data.urlCorrectorServer = urlCorrectorServer;
            data.username = username;
            data.password = password;
            data.disableMDSProxy = disableMDSProxy;
            data.useGoogle = useGoogle; // Added 2006-03-25, v1.2
            data.language = language; // Added 2006-03-25, v1.2
            data.bAutoAdvance = bAutoAdvance; // Added 2006-03-25, v1.2
            if (mvDictionary.length > 0) // Added 2006-04-02, v1.2
                Arrays.sort(mvDictionary, mDictionarySort); // Added 2006-04-02, v1.2
            data.mvDictionary = mvDictionary; // Added 2006-03-25, v1.2
            record.setContents(data);
            record.commit();
        } catch (Exception e) {
            System.out.println("*** Exception saving options: "
                    + e.getMessage());
        }
    }

    public static BBCorrectorOptions load() {

        BBCorrectorOptions options = new BBCorrectorOptions();
        try {
            PersistentObject record = PersistentStore.getPersistentObject(KEY);
            BBCorrectorOptionsData data = (BBCorrectorOptionsData) record.getContents();
            if (data != null) {
                options.urlCorrectorServer = data.urlCorrectorServer;
                options.username = data.username;
                options.password = data.password;
                options.disableMDSProxy = data.disableMDSProxy;
                options.useGoogle = data.useGoogle; // Added 2006-03-25, v1.2
                options.language = data.language; // Added 2006-03-25, v1.2
                options.bAutoAdvance = data.bAutoAdvance; // Added 2006-03-25, v1.2
                options.mvDictionary = data.mvDictionary; // Added 2006-03-25, v1.2
            } else {
                // Added 2006-04-02, v1.2
                // Setup a few defaults
                if (options.mvDictionary == null)
                    options.mvDictionary = new String[0];
            }
        } catch (Exception e) {
            System.out.println("*** Exception loading options: "
                    + e.getMessage());
        }

        return options;
    }

    private static class BBCorrectorOptionsData implements Persistable {

        public int VERSION = 1;

        public String urlCorrectorServer;

        public String username;

        public String password;

        public boolean disableMDSProxy;

        public boolean useGoogle; // Added 2006-03-25, v1.2

        public String language; // Added 2006-03-25, v1.2

        public boolean bAutoAdvance; // Added 2006-03-25, v1.2

        public String [] mvDictionary; // Added 2006-04-02, v1.2
    }

    // Added 2006-04-02, v1.2
    // Sort Dictionary Array alphabetically
    // Convert to lowercase first, so it is case insensitive
    static {
        mDictionarySort = new Comparator() {
            public int compare( Object o1, Object o2 ) {
                String str1 = ((String) o1).toLowerCase();
                String str2 = ((String) o2).toLowerCase();
                return str1.compareTo(str2);
            }
        };
    }
}
