/*******************************************************************************
 * Copyright (C) 2006 Josh Harris
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/

// Added 2006-03-25, v1.2

package org.bbcorrector;

/*import net.rim.device.api.system.*;
import net.rim.device.api.ui.*;
import net.rim.device.api.ui.component.*;
import net.rim.device.api.ui.container.*;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.util.Arrays;
import net.rim.device.api.system.Characters;
import net.rim.device.api.util.CharacterUtilities;
import net.rim.device.api.util.StringUtilities;*/

import net.rim.device.api.system.*;
import net.rim.device.api.ui.*;
import net.rim.device.api.ui.component.*;
import net.rim.device.api.ui.container.*;
import net.rim.device.api.util.*;

import java.util.Vector;

public class BBCorrectorSpellingDialog extends PopupScreen {
    //private static FieldChangeListener FIELD_CHANGE_LISTENER = new AllFieldChangeListener();
    //private static TrackwheelListener TRACK_WHEEL_LISTENER = new TrackwheelClickListener();

    private UiApplication mMainApp;
    private ActiveAutoTextEditField mTextBodyField;
    private SpellResult.SpellData spellData = null;
    private SpellResult.SpellData.SpellError spellError = null;
    private BBCorrectorOptions options;
    private int mCurrentErrorIdx = 0;

    private HorizontalFieldManager mButtonManager;
    private RichTextField mOriginalWord;
    private ListField mSuggestionField;
    private ListCallback mSuggestionCallback = null;
    private BasicEditField mNewWordField;
    private ButtonField mIgnore;
    private ButtonField mIgnoreAll;
    private ButtonField mAdd;
    private ButtonField mCancel;
    private boolean bCancelled;

    // Setup popup screen, add managers, buttons, etc.
    public BBCorrectorSpellingDialog() {
        super(new VerticalFieldManager());

        //ensureRegionVisible getBounds getContentRect getExtent getHeight getVirtualHeight getVisibleHeight

        mMainApp = UiApplication.getUiApplication();
        mTextBodyField = (ActiveAutoTextEditField)mMainApp.getActiveScreen().getLeafFieldWithFocus();
        options = BBCorrectorOptions.load();

        // Field.USE_ALL_WIDTH | Field.FIELD_HCENTER |
        VerticalFieldManager mManager = (VerticalFieldManager)getDelegate();
        mOriginalWord = new RichTextField("WordToCheck", Field.NON_FOCUSABLE | Field.READONLY);
        mManager.add(mOriginalWord);

        mManager.add(new SeparatorField());

        mNewWordField = new BasicEditField();
        mManager.add(mNewWordField);

        mButtonManager = new HorizontalFieldManager();
        mIgnore = new ButtonField("Ignore");
        mIgnoreAll = new ButtonField("Ignore All");
        mAdd = new ButtonField("Add");
        mCancel = new ButtonField("Cancel");
        mButtonManager.add(mIgnore);
        mButtonManager.add(mIgnoreAll);
        mButtonManager.add(mAdd);
        mButtonManager.add(mCancel);

        mManager.add(mButtonManager);

        mManager.add(new SeparatorField());

        VerticalFieldManager mManagerList = new VerticalFieldManager(Manager.VERTICAL_SCROLL);
        mSuggestionField = new ListField(0, Field.FOCUSABLE) {
            /*public void onFocus (int direction) {
                super.setFocus();
            }*/
            /*public void onUnfocus() {
                super.removeFocus();
            }*/
        };
        mSuggestionField.setEmptyString("*No Suggestions*", DrawStyle.HCENTER);
        mSuggestionCallback = new ListCallback();
        mSuggestionField.setCallback(mSuggestionCallback);
        //mSuggestionField.setChangeListener(FIELD_CHANGE_LISTENER);
        mManagerList.add(mSuggestionField);
        mManager.add(mManagerList);

        super.setFieldWithFocus(mSuggestionField);
    }

    /*protected boolean keyDown(int keycode, int time) {
        switch (Keypad.map(keycode)) {
        case Characters.ESCAPE:
            doExit();
            break;
        case Characters.DELETE:
        case Characters.LATIN_CAPITAL_LETTER_D:
        case Characters.LATIN_SMALL_LETTER_D:
            doDelete();
            break;
        case Characters.LATIN_CAPITAL_LETTER_I:
        case Characters.LATIN_SMALL_LETTER_I:
            doInsert();
            break;
        case Characters.LATIN_CAPITAL_LETTER_C:
        case Characters.LATIN_SMALL_LETTER_C:
            doClearDictionairy();
            break;
        }
        return true;
    }*/

    public void show(SpellResult.SpellData mData, int idx) {
        spellData = mData;
        mCurrentErrorIdx = idx;
        createSuggestions();
        mMainApp.pushModalScreen(this);
    }

    private void createSuggestions() {
        mSuggestionCallback.erase(mSuggestionField);
        if (spellData != null) {
            spellError = spellData.spellErrors[mCurrentErrorIdx];
            if (spellError != null) {
                mOriginalWord.setText(spellError.wordError);
                if (spellError.suggestions != null) {
                    for (int i = 0; i < spellError.suggestions.length; i++) {
                        mSuggestionField.insert(0);
                        mSuggestionCallback.insert(spellError.suggestions[i], 0);
                    }
                    mSuggestionField.setSelectedIndex(0);
                }
            }
        }

        mNewWordField.setText("");
    }

    protected boolean trackwheelClick(int status, int time) {
        // Which field has focus?
        Field field = this.getLeafFieldWithFocus();
        if (field.equals(mNewWordField)) {
            doAction(0, null); //Manual Replace
            return true;
        } else if (field.equals(mIgnore)) {
            doAction(2, null);
            return true;
        } else if (field.equals(mIgnoreAll)) {
            doAction(3, null);
            return true;
        } else if (field.equals(mAdd)) {
            doAction(4, null);
            return true;
        } else if (field.equals(mCancel)) {
            doCancel();
            return true;
        } else if (field.equals(mSuggestionField)) {
            doAction(1, null); //Sugessted Replace
            return true;
        }
        return false;
    }

    protected boolean keyChar(char c, int status, int time) {
        Field field = this.getLeafFieldWithFocus();
        switch(c) {
            case Characters.ESCAPE:
                doCancel();
                return true;
            case Characters.ENTER:
                if (field.equals(mNewWordField)) {
                    doAction(0, null); //Manual Replace
                    return true;
                } else if (field.equals(mIgnore)) {
                    doAction(2, null);
                    return true;
                } else if (field.equals(mIgnoreAll)) {
                    doAction(3, null);
                    return true;
                } else if (field.equals(mAdd)) {
                    doAction(4, null);
                    return true;
                } else if (field.equals(mCancel)) {
                    doCancel();
                    return true;
                } else if (field.equals(mSuggestionField)) {
                    doAction(1, null); //Sugessted Replace
                    return true;
                }
                break;
            /*case Characters.LATIN_SMALL_LETTER_A:
            case Characters.LATIN_CAPITAL_LETTER_A:
                if (field.equals(mSuggestionField)) {
                    doAction(5, null); //Sugessted Replace All
                    return true;
                }
                break;
            case Characters.LATIN_SMALL_LETTER_S:
            case Characters.LATIN_CAPITAL_LETTER_S:
                if (!field.equals(mNewWordField)) {
                    super.getDelegate().setFieldWithFocus(mSuggestionField);
                    super.setFieldWithFocus(mSuggestionField);
                    setFieldWithFocus(mSuggestionField);
                    mSuggestionField.setFocus();
                    mSuggestionField.select(true);
                    mSuggestionField.invalidate();
                    mButtonManager.invalidate();
                    super.invalidate();
                    return true;
                }
                break;
            case Characters.LATIN_SMALL_LETTER_B:
            case Characters.LATIN_CAPITAL_LETTER_B:
                if (!field.equals(mNewWordField)) {
                    mButtonManager.setFieldWithFocus(mIgnore);
                    super.getDelegate().setFieldWithFocus(mButtonManager);
                    mButtonManager.setFocus();
                    mIgnore.setFocus();
                    mIgnore.select(true);
                    return true;
                }
                break;
            case Characters.LATIN_SMALL_LETTER_M:
            case Characters.LATIN_CAPITAL_LETTER_M:
                if (!field.equals(mNewWordField)) {
                    super.getDelegate().setFieldWithFocus(mNewWordField);
                    mNewWordField.setFocus();
                    mNewWordField.select(true);
                    return true;
                }
                break;*/
            default:
                break;
        }
        return super.keyChar(c, status, time);
    }

    private void doAction(int mAction, String mAllWord) {
        if (bCancelled
                || (mSuggestionField.getSize() == 0 && mAction == 1))
            return;

        SpellResult.SpellData.SpellError spellError = null;
        spellError = spellData.spellErrors[mCurrentErrorIdx];
        int mArraySizeDif = 0;
        String newWord;

        if (mAction == 0) { // Manual
            newWord = mNewWordField.getText();
        } else if (mAction == 1) { // Suggested Replace
            newWord = (String)mSuggestionCallback.get(mSuggestionField, mSuggestionField.getSelectedIndex());
        } else if (mAllWord != null) {
            newWord = mAllWord;
            mAction = 1;
        } else {
            newWord = null;
        }

        // do action for manual or suggested replace
        if (mAction < 2) {
            String oldWord = spellError.wordError;

            // Make sure that starting position is the beginning of misspelled word
            mTextBodyField.setCursorPosition(spellError.position);

            int startPos = mTextBodyField.getCursorPosition();
            int endPos = startPos + oldWord.length();
            //int fieldEndPos = mTextBodyField.getTextLength() - 1;

            mTextBodyField.select(true);
            mTextBodyField.setCursorPosition(endPos);

            mTextBodyField.selectionDelete();
            mTextBodyField.select(false);

            mTextBodyField.insert(newWord);

            Arrays.remove(spellData.spellErrors, spellError);

            // We need to adjust overall text length
            int adjustValue = newWord.length()
                    - oldWord.length();
            spellData.textLen += adjustValue;

            // We also need to adjust the offsets of the errors
            // after this one
            for (int i = mCurrentErrorIdx; i < spellData.spellErrors.length; i++) {
                spellData.spellErrors[i].position += adjustValue;
            }
            mTextBodyField.setDirty(true);
        } else if (mAction == 2) {
            //Ignore
            Arrays.remove(spellData.spellErrors, spellError);
        } else if (mAction == 3) {
            //Ignore All
            mArraySizeDif = 0;
            SpellResult.SpellData.SpellError curError = null;
            int mLength = spellData.spellErrors.length;
            for (int i = mCurrentErrorIdx, p = 0; i >= 0 && i < mLength; i++, p++) {
                curError = spellData.spellErrors[i];
                if (curError.wordError.equalsIgnoreCase(spellError.wordError)) {
                    Arrays.remove(spellData.spellErrors, curError);
                    mLength--;
                    i--;
                    if (p < mCurrentErrorIdx)
                        mArraySizeDif++;
                }
            }
        } else if (mAction == 4) {
            //Add
            Arrays.add(options.mvDictionary, spellError.wordError);
            options.save();
            doAction(3, null);
            return;
        } else if (mAction == 5) {
            // Replace All
            mArraySizeDif = 0;
            SpellResult.SpellData.SpellError curError = null;
            int mLength = spellData.spellErrors.length;
            newWord = (String)mSuggestionCallback.get(mSuggestionField, mSuggestionField.getSelectedIndex());
            for (int i = mCurrentErrorIdx, p = 0; i >= 0 && i < mLength; i++, p++) {
                curError = spellData.spellErrors[i];
                if (curError.wordError.equalsIgnoreCase(spellError.wordError)) {
                    //Arrays.remove(spellData.spellErrors, curError);
                    doAction(5, newWord);
                    mLength--;
                    i--;
                    if (p < mCurrentErrorIdx)
                        mArraySizeDif++;
                }
            }
        }

        if (options.bAutoAdvance) {
            int nextErrorPos = 0;
            if (mCurrentErrorIdx - mArraySizeDif < spellData.spellErrors.length) {
                nextErrorPos = spellData.spellErrors[mCurrentErrorIdx - mArraySizeDif].position;
                createSuggestions();
            }
            mTextBodyField.setCursorPosition(nextErrorPos);

            // Reached last misspelled word, so cancel the dialog
            if (nextErrorPos == 0) {
                doCancel();
            }
        } else {
            doCancel();
            return;
        }
    }

    private void doCancel() {
        // Do this so that the highlight regions come back
        mTextBodyField.scanForActiveRegions();
        mTextBodyField.getScreen().removeFocus();
        mTextBodyField.setFocus();

        mMainApp.popScreen(this);
        bCancelled = true;
    }

    private static class ListCallback implements ListFieldCallback {
        private Vector listElements = new Vector();

        public void drawListRow(ListField list, Graphics g, int index, int y, int w) {
            String text = (String)listElements.elementAt(index);
            g.drawText(text, 0, y, 0, w);
        }

        public Object get(ListField list, int index) {
            return listElements.elementAt(index);
        }

        public int getPreferredWidth(ListField list) {
            return Graphics.getScreenWidth();
        }

        public int indexOfList(ListField list, String p, int s) {
            return listElements.indexOf(p, s);
        }

        public void insert(String toInsert, int index) {
            listElements.addElement(toInsert);
        }

        /*public void delete(ListField list, int index) {
            if (index < listElements.size()) {
                list.delete(index);
                listElements.removeElementAt(index);
            }
        }*/

        public void erase(ListField list) {
            for (int i = 0; i < listElements.size(); i++) {
                list.delete(0);
            }
            listElements.removeAllElements();
        }
    }

    public boolean isCancelled() {
        return bCancelled;
    }

    /*public String getNewWord() {
        return mNewWordField.getText();
    }*/
}
