/*******************************************************************************
 * Copyright (C) 2006 Josh Harris
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/

 // Added 2006-03-25, v1.2

package org.bbcorrector;

import net.rim.device.api.system.*;
import net.rim.device.api.ui.*;
import net.rim.device.api.ui.component.*;
import net.rim.device.api.ui.container.*;

public class BBCorrectorDictionaryDialog extends PopupScreen {
    private UiApplication mMainApp = null;
    private BasicEditField mNewWordField = null;
    private ButtonField mOK = null;
    private ButtonField mCancel = null;
    private boolean bCancelled = false;

    // Setup the popup screen, add managers, buttons, etc.
    public BBCorrectorDictionaryDialog() {
        super(new VerticalFieldManager());

        mMainApp = UiApplication.getUiApplication();

        VerticalFieldManager mManager = (VerticalFieldManager)getDelegate();
        mManager.add(new RichTextField("Add New Word", Field.NON_FOCUSABLE | Field.READONLY));

        mNewWordField = new BasicEditField();
        mManager.add(mNewWordField);

        //HorizontalFieldManager.FIELD_HCENTER | HorizontalFieldManager.USE_ALL_WIDTH
        HorizontalFieldManager mHManager = new HorizontalFieldManager();
        mOK = new ButtonField("OK");
        mCancel = new ButtonField("Cancel");
        mHManager.add(mOK);
        mHManager.add(mCancel);

        mManager.add(mHManager);
    }

    public void show() {
        mMainApp.pushModalScreen(this);
    }

    // Check if user clicked trackwheel and which button was selected
    // do appropriate action
    protected boolean trackwheelClick(int status, int time) {
        Field field = this.getLeafFieldWithFocus();
        if (field.equals(mOK)) {
            doOK();
            return true;
        } else if (field.equals(mCancel)) {
            doCancel();
            return true;
        }
        return false;
    }

    private void doOK() {
        mMainApp.popScreen(this);
        bCancelled = false;
    }

    private void doCancel() {
        mMainApp.popScreen(this);
        bCancelled = true;
    }

    // Check if user type Escape or Enter and do appropriate action
    protected boolean keyChar(char c, int status, int time) {
        switch(c) {
            case Characters.ESCAPE:
                doCancel();
                return true;
            case Characters.ENTER:
                doOK();
                return true;
        }
        return super.keyChar(c, status, time);
    }

    public boolean isCancelled() {
        return bCancelled;
    }

    // Return the new word entered by the user
    public String getNewWord() {
        return mNewWordField.getText();
    }
}
