/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbcorrector;

import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.ActiveAutoTextEditField;
import net.rim.device.api.ui.component.ActiveFieldCookie;
import net.rim.device.api.ui.component.CookieProvider;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Status;
import net.rim.device.api.util.Arrays;
import net.rim.device.api.util.CharacterUtilities;

public class CorrectorActiveFieldCookie implements ActiveFieldCookie {

    // com.BBCorrector.CorrectorActiveFieldCookie.ID
    public static final long ID = 0x58f6188be08553a2L;

    private String pattern;

    public BBCorrectorOptions options = null; // Moved Here 2006-03-25, v1.2

    public CorrectorActiveFieldCookie(String region) {
        pattern = region;
    }

    public MenuItem getFocusVerbs(final CookieProvider provider,
                                  final java.lang.Object context,
                                  java.util.Vector items) {
        options = BBCorrectorOptions.load(); // Movied Here 2006-03-25, v1.2
        MenuItem mi = new MenuItem("Spelling Suggestion", 6, 100) {

            public void run() {
                //doSuggestionAction((ActiveAutoTextEditField) provider); // Removed 2006-03-25, v1.2

                // Added 2006-03-25, v1.2
                ActiveAutoTextEditField field = (ActiveAutoTextEditField) provider;
                Integer key = new Integer(field.hashCode());
                SpellResult.SpellData spellData = (SpellResult.SpellData) SpellResult.getInstance().fieldMap.get(key);

                // We have spelling data for this field cookie, so now find
                // which error this corresponds to
                int currentPos = field.getCursorPosition();
                int spellErrorPos = 0;

                for (int i = 0; i < spellData.spellErrors.length; i++) {
                    if ((currentPos >= spellData.spellErrors[i].position)
                            && (currentPos <= (spellData.spellErrors[i].position + spellData.spellErrors[i].wordError.length()))) {
                        spellErrorPos = i;
                        break;
                    }
                }

                BBCorrectorSpellingDialog dialog = new BBCorrectorSpellingDialog();
                dialog.show(spellData, spellErrorPos);
                if (dialog.isCancelled()) {
                    return;
                }
            }
        };

        items.addElement(mi);

        // Default choice MenuItem
        return mi;
    }

    public boolean invokeApplicationKeyVerb() {
        // Not sure when this is called???
        return false;
    }


// Removed 2006-03-25, v1.2
/*    public void doSuggestionAction(ActiveAutoTextEditField field) {

        Integer key = new Integer(field.hashCode());
        //System.out.println("*** Check spelling data for field hash=" + key);
        SpellResult.SpellData spellData = (SpellResult.SpellData) SpellResult.getInstance().fieldMap.get(key);
        // Check if we have some spelling data for this field
        if (spellData != null) {
            try {
                // We have spelling data for this field cookie, so now find
                // which error this corresponds to
                int currentPos = field.getCursorPosition();
                SpellResult.SpellData.SpellError spellError = null;
                int spellErrorPos = -1;

                // Added 2006-03-25, v1.2
                int nextDistance = 0;

                for (int i = 0; i < spellData.spellErrors.length; i++) {
                    if ((currentPos >= spellData.spellErrors[i].position)
                            && (currentPos <= (spellData.spellErrors[i].position + spellData.spellErrors[i].wordError.length()))) {
                        spellError = spellData.spellErrors[i];
                        spellErrorPos = i;

                        /*if (i+1 < spellData.spellErrors.length) {
                            nextDistance = spellData.spellErrors[i+1].position - spellData.spellErrors[i].position;
                        }*/
/*                        break;
                    }
                }

                // If we found one then continue
                if (spellError != null) {
                    int numSuggestions = spellError.suggestions.length;
                    // Removed 2006-03-23 (Josh Harris), so that the manual spell check option is displayed
                    //if (numSuggestions > 0) {
                        //                        for (int i = 0; i < numSuggestions; i++) {
                        //System.out.println("*** suggestion="
                        //                                    + spellError.suggestions[i]);
                        //                        }

                        String newWord = doSuggestion(spellError, field, nextDistance); // Changed 2006-03-25, v1.2
                        int mArraySizeDif = -1; // Added 2006-03-25, v1.2,  If the array size has changed because of ignnore all
                        // If we chose a suggestion then remove the error
                        if (newWord != null) {
                            mArraySizeDif = 0; // Added 2006-03-25, v1.2
                            if (newWord.equals("^BBCorrectorIgnoreAll^")) {
                                // Ignore All or Add to Dictionary
                                // Remove all Errors containing this spellError
                                SpellResult.SpellData.SpellError curError = null;
                                int mLength = spellData.spellErrors.length;
                                for (int i = 0, p = 0; i < mLength; i++, p++) {
                                    curError = spellData.spellErrors[i];
                                    if (StringUtilities.compareToIgnoreCase(curError.wordError, spellError.wordError) == 0) {
									if (curError.wordError.equals(spellError.wordError)) {
                                        Arrays.remove(spellData.spellErrors, curError);
                                        mLength--;
                                        i--;
                                        if (p < spellErrorPos)
                                            mArraySizeDif++;
                                    }
                                }
                                //while (Arrays.contains(spellData.spellErrors, spellError))
                                    //Arrays.remove(spellData.spellErrors, spellError);
                                field.scanForActiveRegions();
                                field.getScreen().removeFocus();
                                field.setFocus();

                                /*int mIdx
                                if (i+1 < spellData.spellErrors.length) {
                                    nextDistance = spellData.spellErrors[i+1].position - spellData.spellErrors[i].position;
                                }
                                field.setCursorPosition(nextDistance);*/
/*                            } else {
                                String oldWord = spellError.wordError;
                                Arrays.remove(spellData.spellErrors, spellError);
                                // We need to adjust overall text length
                                int adjustValue = newWord.length()
                                        - oldWord.length();
                                spellData.textLen += adjustValue;
                                // We also need to adjust the offsets of the errors
                                // after this one
                                for (int i = spellErrorPos; i < spellData.spellErrors.length; i++) {
                                    spellData.spellErrors[i].position += adjustValue;
                                }
                                field.setDirty(true);
                            }
                        }

                        // Added 2006-03-25, v1.2 AutoAdvance
                        if (options.bAutoAdvance) {
                            int nextErrorPos = 0;
                            if (spellErrorPos - mArraySizeDif < spellData.spellErrors.length)
                                nextErrorPos = spellData.spellErrors[spellErrorPos - mArraySizeDif].position;
                            field.setCursorPosition(nextErrorPos);
                        }
                    // Removed 2006-03-23 (Josh Harris), so that the manual spell check option is displayed
                    //} else
                    //    Status.show("No suggestions...");
                }
            } catch (Exception e) {
                //System.out.println("*** Error:" + e.getMessage());
            }
        }
    }

    private String doSuggestion(SpellResult.SpellData.SpellError spellError,
                                ActiveAutoTextEditField field, int nextDistance) {

        String newWord = null;

        Object[] choices = new Object[spellError.suggestions.length + 4];
        choices[0] = "[Add to Dictionary]";
        choices[1] = "[Ignore All]";
        choices[2] = "[Ignore]";
        for (int i = 0; i < spellError.suggestions.length; i++)
            choices[i + 3] = spellError.suggestions[i];
        // Added 2006-03-23 (Josh Harris), used for manually fixing the spelling of a word
        choices[spellError.suggestions.length + 3] = "[Manual]";
        Dialog dialog = new Dialog("Select Suggestion:",
                                   choices,
                                   null,
                                   2,
                                   Bitmap.getPredefinedBitmap(Bitmap.QUESTION),
                                   Dialog.LIST);
        // Added 2006-03-23 (Josh Harris), used for manually fixing the spelling of a word
        EditField mManualField = null;
        mManualField = new EditField("Manual: ",
                                     "",
                                     32,
                                     Field.EDITABLE | Field.FIELD_LEFT | BasicEditField.NO_NEWLINE);
        dialog.add(mManualField);
        ///////////////////////////////

        int dialogReturn = dialog.doModal();
        //System.out.println("*** Dialog return code: " + dialogReturn);
        // Perform the requested operation
        switch (dialogReturn) {
        case -1:
            //System.out.println("*** Cancelled dialog");
            break;
        case 0: //Add to Dictionary
            Arrays.add(options.mvDictionary, spellError.wordError);
            //BBCorrectorOptions.save();
            options.save();
            //BBCorrectorOptions.commit();
            if (nextDistance != -1) {
                //field.setCursorPosition(nextDistance + field.getCursorPosition());
            }
            //Remove this word from spellError Array
            newWord = "^BBCorrectorIgnoreAll^";
            break;
        case 1: //Ignore All
            if (nextDistance != -1) {
                //field.setCursorPosition(nextDistance + field.getCursorPosition());
            }
            newWord = "^BBCorrectorIgnoreAll^";
            break;
        case 2: //Ignore
            // changed 2006-03-25, v1.2
            if (nextDistance != -1) {
                //field.setCursorPosition(nextDistance + field.getCursorPosition());
            }
            break;
        default:
            int endPos = field.getCursorPosition();
            // changed 2006-03-25, v1.2
            int startPos = endPos;
            int fieldEndPos = field.getTextLength() - 1;
            if (endPos < fieldEndPos) {
                // Find end of word
                while (true) {
                    char c = field.charAt(++endPos);
                    if (!isWordPart(c)) {
                        --endPos;
                        break;
                    }
                    if (endPos == fieldEndPos)
                        break;
                }
            }
            // We are on the last character
            field.setCursorPosition(endPos);
/*            if (false) return null;
            field.selectionDelete();
            // Removed 2006-02-11 (Josh Harris), this caused BBCorrector on newer
            // OS's to delete 2 characters before misspelled word
                //field.backspace(pattern.length() - 1);
            // Added 2006-03-23 (Josh Harris), used for manually fixing the spelling of a word
            if (dialogReturn == spellError.suggestions.length + 3)
                newWord = mManualField.getText();
            else
                newWord = spellError.suggestions[dialogReturn - 3];
            field.insert(newWord);
            // Added 2006-02-11 (Josh Harris),
            // This is needed for newer OS's so that the highlight regions come back
                field.scanForActiveRegions();
            // Do this so that the highlight regions come back
                field.getScreen().removeFocus();
                field.setFocus();
/*        }

        return newWord;
    }

    private boolean isWordPart(char c) {
        return (CharacterUtilities.isDigit(c) || CharacterUtilities.isLetter(c) || (c == '\''));
    }
*/
}
