/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbcorrector;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.ActiveAutoTextEditField;
import net.rim.device.api.util.AbstractString;
import net.rim.device.api.util.StringPattern;

public class CorrectorStringPattern extends StringPattern {

    public CorrectorStringPattern() {
    }

    public boolean findMatch(AbstractString str,
                             int beginIndex,
                             int maxIndex,
                             StringPattern.Match match) {

        Field field = UiApplication.getUiApplication().getActiveScreen().getFieldWithFocus();
        // Check that this field is valid for Spell Checking
        if (field instanceof ActiveAutoTextEditField) {
            Integer key = new Integer(field.hashCode());
            //System.out.println("*** Check spelling data for field hash=" + key);
            SpellResult.SpellData spellData = (SpellResult.SpellData) SpellResult.getInstance().fieldMap.get(key);
            // If we have some spelling data for this field then define any
            // active fields
            if (spellData != null) {
                //System.out.println("*** Found spelling data for field hash="
                //        + key);
                // Check if length of original text has changed. If so, then
                // clear spelling data and user will need to respell
                if (spellData.textLen == str.length()) {
                    //System.out.println("*** beginidx=" + beginIndex
                    //        + " endidx=" + maxIndex);
                    for (int i = beginIndex; i < maxIndex; ++i) {
                        //char c = str.charAt(i); // Removed 2006-03-25, v1.2
                        for (int j = 0; j < spellData.spellErrors.length; j++) {
                            SpellResult.SpellData.SpellError spellError = spellData.spellErrors[j];
                            if (spellError.position < beginIndex)
                                continue;
                            //System.out.println("*** Error word="
                            //        + spellError.wordError + " position="
                            //        + spellError.position);
                            //                        for (int k = 0; k <
                            // spellError.suggestions.length; k++) {
                            //System.out.println("*** Suggestion="
                            //                                    + spellError.suggestions[k]);
                            //                        }
                            //System.out.println("***
                            // -----------------------------");
                            match.beginIndex = spellError.position;
                            match.endIndex = spellError.position
                                    + spellError.wordError.length();
                            match.prefixLength = 0;
                            match.id = CorrectorActiveFieldCookie.ID;
                            return true;
                        }
                    }
                } else {
                    // Remove spelling data for this field
                    SpellResult.getInstance().clear((ActiveAutoTextEditField)field);
                }
            }
        }
        return false;
    }
}
