/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bblight;

import java.util.Date;

import net.rim.device.api.system.Backlight;

public class BacklightController {

    // This must be > maximum polling value and < minimum backlight timeout
    // (10secs)
    private static int TOLERANCE_High = 8000;
    private static int TOLERANCE_Low = 2000; //JHH

    private static BacklightController controller = null;

    private long startOnTime = -1;

    private BacklightController() {
    }

    public static BacklightController getInstance() {

        if (controller == null)
            controller = new BacklightController();

        return controller;
    }

    public void on() {
        // We can't just blindly turn the backlight on as it resets the idle
        // state of the device
        if (!isOn()) {
            //int bright = Backlight.getBrightness();
            //Backlight.setBrightness(bright);
            Backlight.enable(true);
            startOnTime = System.currentTimeMillis();
            System.out.println("*** turn on: " + new Date(startOnTime));
        }
    }

    public void off() {
        System.out.println("*** turn off: " + new Date());
        Backlight.enable(false);
        startOnTime = -1;
    }

    private boolean isOn() {

        boolean status = false;

        // This API call does not seem to work on the actual device (7230). Due
        // to this, pressing the actual light switch on the device can cause the
        // light to not work as expected
        //        status = Backlight.isEnabled();

        long now = System.currentTimeMillis();
        long diff = now - startOnTime;
        System.out.println("*** isOn() now=" + now + " startOnTime="
                + startOnTime + " diff=" + diff);

        //JHH 2008-05-17
        int tolerance;
        BBLightOptions options = BBLightOptions.load();
        if (options.isOnWhenLocked)
            tolerance = TOLERANCE_Low;
        else
            tolerance = TOLERANCE_High;
        //*JHH

        if (startOnTime >= 0) {
            if (diff < tolerance) //JHH 2008-05-17
                status = true;
        }

        return status;
    }
}
