//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#include "stdafx.h"

#ifndef __QTMOVIEDEC_H
#define __QTMOVIEDEC_H

#ifdef QT_DSHOW
// Winmm.lib strmbase.lib Vfw32.lib
#define QT_FREE_DSHOW(x) { if (x) x->Release(); x = NULL; }
	//#include "initguid.h"
	#include <uuids.h>
	#include <strmif.h>
	#include <control.h>
	//#include <evcode.h>
	//#include <wxdebug.h>
	//#include <reftime.h>
	//#include <amvideo.h>      // IDirectDrawVideo
	//#include <mtype.h>
#endif

// VFW includes
//Vfw32.lib Winmm.lib
	#include "Vfw.h"

// Quicktime includes
#include <qtml.h>
#include <movies.h>
#include <GXMath.h>
#include <CVPixelBuffer.h>

/*#include <Gestalt.h>
#include <FixMath.h>
#include <Script.h>
#include <TextUtils.h>
#include <NumberFormatting.h>
#include <QuickTimeComponents.h>
#include <MediaHandlers.h>*/

#define FOUR_CHAR_CODE_M(w,x,y,z) (w<<24 | x<<16 | y<< 8 | z)
#define QT_FREE_BUFFER(x) { if (x) free(x); x = NULL; }
#define QT_DELETE_BUFFER(x) { if (x) delete [] x; x = NULL; }
#define QT_FREE_HANDLE(x) { if (x) DisposeHandle((Handle)x); x = NULL; }

#define QTMOVIE_MODE_AUTO		-1
#define QTMOVIE_MODE_MTASK		0
#define QTMOVIE_MODE_RAW		1
#define QTMOVIE_MODE_DESQNC		2
#define QTMOVIE_MODE_ICM		3
#define QTMOVIE_MODE_VFW		4

#define QTMOVIE_RAW_MODE_RGB	1
#define QTMOVIE_RAW_MODE_ARGB	2
#define QTMOVIE_RAW_MODE_UYVY	3
#define QTMOVIE_RAW_MODE_V210	4
#define QTMOVIE_RAW_MODE_YUYV	5
#define QTMOVIE_RAW_MODE_YVYU	6
#define QTMOVIE_RAW_MODE_VYUY	7
#define QTMOVIE_RAW_MODE_YUV2	8
#define QTMOVIE_RAW_MODE_AYUV	9
#define QTMOVIE_RAW_MODE_YUVA	10
#define QTMOVIE_RAW_MODE_UYVYA	11

#define QT_MAX_AUDIO_SAMPLES 16384

typedef struct {
	char strFourCC[5];
	CodecType m_iFourCC;
	char CodecName[50];
	CodecQ quality;
	int m_iKeyframeRate;
	int m_iDataRate;
} QTCodecInfo;

typedef struct {
	unsigned long numerator;
	unsigned long denominator;
} fpsInfo;

typedef struct {
	TimeValue mTime;
	//TimeValue mTime2;
	TimeValue mDur;
	//TimeValue mDur2;
	//ULONG idx;
} frameInfo;

typedef struct {
	TimeValue64 timePlay;
	TimeValue64 timeDecode;
	TimeValue64 durPlay;
	TimeValue64 durDecode;
	TimeValue64 mOffset;
	SInt64 mFlags;
	UInt8 mFrameType;
	ULONG idx;
	UInt32 mSize;
} mpegFrameInfo;

// ICM Stuff
typedef struct
{
	byte *pData;
	long height;
	long width;
	long rowsize;
	OSType pixelFormat;


	Track videoTrack;
	float pixelsPerSecond; // the scale
	float startTimeInSeconds; // the time of the left edge of the visible portion of the chart

	ICMDecompressionSessionRef decompressionSession; // Used to decode frames as thumbnails.
	long lastDecompressedSampleDescIndex;
	SInt64 lastDecompressedSampleNumber;
	OSStatus lastDecompressionError;
} frameDataStruct;

typedef struct {
	byte *data;
	unsigned long frame;
} myFrameBuffer;

struct MyAudioBuffer
{
    UInt32  mNumberChannels;
    UInt32  mDataByteSize;
    byte*   mData;
};
typedef struct MyAudioBuffer  MyAudioBuffer;

struct MyAudioBufferList
{
    UInt32      mNumberBuffers;
    MyAudioBuffer mBuffers[kVariableLengthArray];
};
typedef struct MyAudioBufferList  MyAudioBufferList;



class CQTMovieDec
{
	char						*strStatus;
	bool						bIsLoaded;

	// File info
	Str255						m_FileName;
	FSSpec						m_fileSpec;
	short						m_resRefNum;

	// Movie Data
	GWorldPtr					m_GWorld;
	byte						*GWorldDataPtr;
	byte						*pDataCompressed;
	Handle						m_compressedData;
	Ptr							m_compressedDataPtr;
	Handle						m_decompressedData;
	Ptr							m_decompressedDataPtr;
	PixMapHandle				m_PixMap;

	// Movie Elements
	Movie						m_Movie;
	Track						m_vTrack, m_aTrack;
	Media						m_vMedia, m_aMedia;
	Rect						m_vTrackFrame;
	int							m_iTrackCount, m_vTrackCount, m_aTrackCount;

	// Movie Element parameters
	TimeScale					m_MovieTimeScale, m_vMediaTimeScale, m_aMediaTimeScale;
	TimeBase					m_VideoTimeBase, m_AudioTimeBase;
	TimeValue					m_vTrackStartTime;
	TimeValue					m_vMovieFrameCount, m_vMediaFrameCount;
	TimeValue					m_vMovieDur, m_vMediaDur, m_aMediaDur;
	TimeValue					m_vTrackDur, m_aTrackDur;
	TimeValue					m_aMediaSampleCount;
	float						m_vTrackIncrement;
	float						m_SampleDuration, m_vMediaSampleDuration;
	int							m_iRowOrder, m_iRowsize, m_iDepth, m_iModRowsize;
	long						m_lRowBytes;
	bool						bIsDV25;

	int							m_iRaw, m_iMode, m_iDither;
	float						m_fGamma;

	// Codec and decomp stuff
	ImageDescriptionHandle		m_imageDesc;
	ImageSequence				m_seqID;
	OSType						m_pixelFormat;
	QTCodecInfo					m_CodecInfo, m_DecoderCodecInfo;

	// VFW Stuff
	bool						bVFW;
	HIC							hic;
	BITMAPINFOHEADER			*pbiSrc;
	BITMAPINFOHEADER			biDst;

	// ICM Stuff
	ICMCompletionProcRecord		mCompletionProcRecord;
	ICMDecompressionSessionRef	decompressionSession;
	long						m_lPrevFrameNum;
	SInt64						nextIFrame;
	long						m_lLastFrameDecodeIdx;

	// for IBP codecs
	QTSampleTableRef			sampleTable;
	bool						bContainsDisplayOffsets;
	bool						bUseSampleTable;
	bool						bIFrameOnly;

	// Frame info, times, etc.
	vector<long>				m_vKeyframes;
	vector<frameInfo>			m_vFrameInfo;
	vector<mpegFrameInfo>		m_vFrameInfoDisplay, m_vFrameInfoDecode; //REPLACE ibpFrameInfo
	long						maxCompressedSize, m_lRawFrameSize; //REPLACE maxFrameSizeCompressed

	// Audio stuff
	AudioFormatAtomPtr			source_sound_decomp_atom;
	SoundDescriptionV1Handle	source_sound_description;
	Handle						source_sound_description_extension;
	Size						source_sound_description_extension_size;
	Handle						data_ref;
	AudioFormatAtomPtr			atom;
	SoundComponentData			source_format;
	SoundComponentData			dest_format;
	SoundConverter				converter;
	MovieAudioExtractionRef		m_AudioExtractor;
	AudioStreamBasicDescription	m_ASBD;
	MyAudioBufferList			*ioData;

	void		QTFreeMemory();
	OSErr		InitDecodeShared();
	OSErr		InitDecodeFindCodec(CompressorComponent &compressor,
								DecompressorComponent &decompressor);
	OSErr		InitDecodeDataPointers();
	OSErr		InitDecodeMTask();
	OSErr		InitDecodeRaw();
	OSErr		InitDecodeDeSqnc(DecompressorComponent decompressor);
	OSErr	InitDecodeICM();
	OSErr		InitDecodeVFW(char *strFourCC);
	int			Init_VFW(char *strFourCC);
	int			FrameDecodeMTask(TimeValue frameNumTime, byte *pData, int dst_pitch, int *rawSize);
	int			FrameDecodeRaw() {return 0;}
	int			FrameDecodeDeSqnc(long frameNum, TimeValue frameNumTime, byte *pData, int dst_pitch, int *rawSize);
	int			FrameDecodeICM(long frameNum, TimeValue frameNumTime, byte *pData, int dst_pitch, int *rawSize);
	int			FrameDecodeVFW(long frameNum, TimeValue frameNumTime, byte *pData, int dst_pitch);

	OSStatus createDecompressionSession( 
		ImageDescriptionHandle imageDesc, 
		int width, 
		int height, 
		OSType pixelFormat,
		ICMDecompressionTrackingCallback trackingCallback,
		void *trackingRefCon,
		ICMDecompressionSessionRef *decompressionSessionOut);

	bool SetUpMovieAudioExtraction();
	bool UpdateFrameBuffer(byte *pBuffer, long frame, bool bForward);
	int IsFrameInBuffer(long frame);

public:
	CQTMovieDec();
	~CQTMovieDec(void);
	char *GetErrorMessage();
	bool ISQTInitialized() { return bIsLoaded; }

	HRESULT	OpenMovie(char *strFileName, QTCodecInfo mCodec, int vTrackIdx, int aTrackIdx);
	bool SetFormat(OSType mFormat, int mRaw, int mMode, float mGamma, int mOrder);
	void SetRowOrder(int mOrder) { m_iRowOrder = mOrder; }
	void SetVFWOutput(OSType pixelType) {
		float mMult;
		int m_iMod, m_iModWidth;

		m_pixelFormat = pixelType;

		// Setup frame byte size params, using a width that is aligned on m_iMod bytes
		if (m_pixelFormat == k32BGRAPixelFormat) {
			mMult = 4.0;
			m_iMod = 4;
			biDst.biCompression = BI_RGB;
			biDst.biBitCount = 32;
			biDst.biSizeImage = biDst.biWidth * biDst.biHeight * mMult;
			biDst.biPlanes = 1;
		} else if (m_pixelFormat == k24BGRPixelFormat) {
			mMult = 3.0;
			m_iMod = 16;
			biDst.biCompression = BI_RGB;
			biDst.biBitCount = 24;
			biDst.biSizeImage = biDst.biWidth * biDst.biHeight * mMult;
			biDst.biPlanes = 1;
		} else if (m_pixelFormat == kYUVSPixelFormat) {
			mMult = 2.0;
			m_iMod = 8;
			biDst.biCompression = MAKEFOURCC('Y','U','Y','2');
			biDst.biBitCount = 16;
			biDst.biSizeImage = biDst.biWidth * biDst.biHeight * mMult;
			biDst.biPlanes = 1;
		} else if (m_pixelFormat == kYUV420PixelFormat || m_pixelFormat == kMpegYUV420CodecType) {
			mMult = 12.0/8.0;
			m_iMod = 16;
			biDst.biCompression = biDst.biCompression = MAKEFOURCC('Y','V','1','2');;
			biDst.biBitCount = 12;
			biDst.biSizeImage = biDst.biWidth * biDst.biHeight * mMult;
			biDst.biPlanes = 3;
		}

		if ((m_vTrackFrame.right % m_iMod) != 0) {
			m_iModWidth = (floor(1.0 * m_vTrackFrame.right / m_iMod) + 1) * m_iMod;
		} else
			m_iModWidth = m_vTrackFrame.right;

		m_iModRowsize = m_iModWidth * mMult;
		m_iRowsize = m_vTrackFrame.right * mMult; }
	HRESULT InitializeGraphics(int mAudio, char *strFourCC, bool Yuv2Rgb, int dither);

	QTCodecInfo QTGetCodecInfo() { return m_CodecInfo; }
	long GetVideoDuration() { return m_vMovieFrameCount; } //m_vMediaFrameCount
	int GetDepth() { return m_iDepth; }
	long GetDisplayWidth() { return m_vTrackFrame.right; }
	long GetDisplayHeight() { return m_vTrackFrame.bottom; }
	fpsInfo GetFPS() {
		fpsInfo fps;
		fps.numerator = m_vMediaTimeScale;
		fps.denominator = m_vMediaSampleDuration;
		return fps; }
	OSType GetColorSpace() { return m_pixelFormat; }
	QTCodecInfo QTGetDecoderInfo() { return m_DecoderCodecInfo; }
	long GetRawFrameSize() { return m_lRawFrameSize; }
	SInt64 GetVTrackSize() {
		if (m_vTrack)
			return GetTrackDataSize(m_vTrack, 0, GetTrackDuration(m_vTrack)); 
		else
			return 0; }
	SInt64 GetATrackSize() {
		if (m_aTrack)
			return GetTrackDataSize(m_aTrack, 0, GetTrackDuration(m_aTrack)); 
		else
			return 0; }

	bool HasAudio() { return m_aTrackCount > 0; }
	//SoundComponentData GetAudioDescription() { return source_format; }
	int GetAudioFormat() { return source_format.format; }
	int GetAudioNumChannels() { return dest_format.numChannels; }
	int GetAudioSampleSize() { return dest_format.sampleSize; }
	int GetAudioSampleRate() { return UInt16(dest_format.sampleRate >> 16); }
	int GetAudioSampleCount() { return dest_format.sampleCount; }
	int GetBytesPerFrame() { return m_ASBD.mBytesPerFrame; }
	void GetAudioFourCC(char *fourCC) {
		sprintf(fourCC, "%c%c%c%c\0",
			(source_format.format & 0xFF000000) >> 24,
			(source_format.format & 0x00FF0000) >> 16,
			(source_format.format & 0x0000FF00) >> 8,
			(source_format.format & 0x000000FF)); }

	vector<mpegFrameInfo> GetDisplayFrameInfo() { return m_vFrameInfoDisplay; }
	vector<mpegFrameInfo> GetDecodeFrameInfo() { return m_vFrameInfoDecode; }
	vector<long> GetKeyFrames() { return m_vKeyframes; }
	bool IsIFrameOnly() { return ! bContainsDisplayOffsets; }

	int ReadVideoFrame(long frameNum, byte *pData, int dst_pitch, int *rawSize);
	long ReadAudioFrame(byte *pData, __int64 frameNum, __int64 count, unsigned int *m_iBytesConverted);
};







#endif