//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

extern myFrameBuffer				m_sFrameBuffer;
extern vector<myFrameBuffer>		m_vFrameBuffer;

OSErr CQTMovieDec::InitDecodeDeSqnc(DecompressorComponent decompressor)
{
	OSErr err;

	err = DecompressSequenceBeginS(
			&m_seqID,           // pointer to field to receive
								// unique ID for sequence
			m_imageDesc,        // handle to image description
								// structure
			NULL,               // pointer to compressed image
								// data (used
								// for preflight)
			0,                  // image data size
			m_GWorld,       // port for the DESTINATION image
			NULL,               // grahics device handle, if
								// port is set, set
								// this to NULL
			NULL,               // source rectangle defining
								// the portion of the image
								// to decompress - NULL for
								// the entire source image
			NULL,			//&rMatrix,           // transformation matrix
			srcCopy,            // transfer mode specifier
			(RgnHandle)NULL,    // clipping region in dest.
								// coordinate system to use as
								// a mask
			0,                  // flags
			m_CodecInfo.quality,   // accuracy in decompression //codecHighQuality
			m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('raw ') ? anyCodec : decompressor);          // compressor identifier or
								// special identifiers
								// ie. bestSpeedCodec, bestFidelityCodec

	if (err != noErr) {
		sprintf(strStatus, "Error with DecompressSequenceBeginS: %d", err);
		return err;
	}

	return noErr;
}

int CQTMovieDec::FrameDecodeDeSqnc(long frameNum, TimeValue frameNumTime, byte *pData, int dst_pitch, int *rawSize)
{
	OSErr err;
	int i, j;
	int frameBuffCount = 0;

	if (bContainsDisplayOffsets && (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('avc1')))
		frameBuffCount = 4;
		

	byte *decompressData = GWorldDataPtr;

	if (bIFrameOnly) {
		short sampleflags = 0;
		TimeValue sampleTime = 0, durationPerSample = 0;
		long sampleDescriptionIndex = 0, numberOfSamples = 1, maxNumberOfSamples = 1;
		err = GetMediaSample(
				m_vMedia,
				m_compressedData,
				maxCompressedSize,
				&m_lRawFrameSize,
				frameNumTime,
				&sampleTime,
				&durationPerSample,
				NULL,
				&sampleDescriptionIndex,
				maxNumberOfSamples,
				&numberOfSamples,
				(short *)&sampleflags);

		if (err != noErr) {
			sprintf(strStatus, "FrameDecodeDeSqnc Error - GetMedia: err= %d", err);
			return NULL;
		}
		if (bVFW) {
			DWORD dwFlags = 0;
			//dwFlags |= ICDECOMPRESS_NOTKEYFRAME;

			pbiSrc->biSizeImage = m_lRawFrameSize; //2007-01-21 Added
			DWORD mErr;

			mErr = ICDecompress(hic, dwFlags, pbiSrc, (byte *)m_compressedDataPtr, &biDst, GWorldDataPtr);

			if (mErr != ICERR_OK) {
				sprintf(strStatus, "ReadVideoFrame Error - ICDecompress: err= %d", mErr);
				return NULL;
			}

			// 2007-07-17
			/*if (m_iModRowsize == m_iRowsize == dst_pitch) {
				mErr = ICDecompress(hic, dwFlags, pbiSrc, pDataCompressed, &biDst, pData);
			} else {
				mErr = ICDecompress(hic, dwFlags, pbiSrc, pDataCompressed, &biDst, GWorldDataPtr);
				for (int i = 0; i < m_vTrackFrame.bottom; i++) {
					memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_iRowsize], m_iRowsize);
				}
			}

			m_lPrevFrameNum = frameNum;
			return m_iRowsize * m_vTrackFrame.bottom;*/
		} else {
			err = DecompressSequenceFrameWhen(m_seqID,
					m_compressedDataPtr, m_lRawFrameSize, 0, NULL, NULL, NULL);

			if (err != noErr) {
				sprintf(strStatus, "FrameDecodeDeSqnc Error - DecompressSequenceFrameWhen: err= %d", err);
				return NULL;
			}
		}
	} else {
		// IBP
		MediaSampleFlags sampleflags = 0;
		TimeValue64 sampleTime = 0, durationPerSample = 0;
		ItemCount sampleDescriptionIndex = 0, numberOfSamples = 1, maxNumberOfSamples = 1;
		int isFrameInBuffer = -1;

		ULONG DecodeIndexCurFrame = m_vFrameInfoDisplay[frameNum].idx;
		if (frameNum == 0) {
			m_lLastFrameDecodeIdx = -1;
		} else if (m_lPrevFrameNum + 1 == frameNum) {
			isFrameInBuffer = IsFrameInBuffer(frameNum);
		} else {
			isFrameInBuffer = IsFrameInBuffer(frameNum);
			if (isFrameInBuffer != -1) {
				// the frame is in the buffer at position isFrameInBuffer
				decompressData = m_vFrameBuffer[isFrameInBuffer].data;
			} else {
				// Need to locate and decode frame
				for (i = m_vKeyframes.size() - 1; i >= 0; i--) {
					long test = m_vKeyframes[i];
					if (m_vKeyframes[i] <= frameNum) {
						if (m_lLastFrameDecodeIdx > frameNum) {
							m_lLastFrameDecodeIdx = m_vKeyframes[i] - 1;
						} else {
							if (m_vKeyframes[i] > m_lLastFrameDecodeIdx) {
								m_lLastFrameDecodeIdx = m_vKeyframes[i] - 1;
							}
						}
						break;
					} // end if (m_vKeyframes[i] <= frameNum) {
				} // end for (i = m_vKeyframes.size() - 1; i >= 0; i--) {
			} // end (isFrameInBuffer != -1) {
		} // end (frameNum == 0) {

		if (isFrameInBuffer == -1) {
			do {
				if (m_lLastFrameDecodeIdx + 1 >= m_vFrameInfoDecode.size())
					break;

				if ( (mediaSampleDroppable & m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].mFlags)
						&& (m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].idx != frameNum)
						&& (abs(frameNum - m_lLastFrameDecodeIdx) >= 5) ) {
					m_lLastFrameDecodeIdx++;
					continue;
				}

				frameNumTime = m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].timeDecode;

				err = GetMediaSample2(
					m_vMedia,
					(UInt8*)pDataCompressed,
					maxCompressedSize,
					(ByteCount*)&m_lRawFrameSize,
					frameNumTime,
					(TimeValue64*)&sampleTime,
					(TimeValue64*)&durationPerSample,
					NULL,
					NULL,
					(ItemCount*)&sampleDescriptionIndex,
					maxNumberOfSamples,
					(ItemCount*)&numberOfSamples,
					(MediaSampleFlags*)&sampleflags);

				if (err != noErr) {
					sprintf(strStatus, "FrameDecodeDeSqnc Error - GetMedia: err= %d", err);
					return NULL;
				}

				if (bVFW) {
					DWORD dwFlags = 0;
					if (m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].mFrameType != 0)
						dwFlags |= ICDECOMPRESS_NOTKEYFRAME;
					if (m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].mFrameType == 0)
						dwFlags |= ICDECOMPRESS_HURRYUP | ICDECOMPRESS_PREROLL;

					pbiSrc->biSizeImage = m_lRawFrameSize; //2007-01-21 Added
					DWORD mErr;

					mErr = ICDecompress(hic, dwFlags, pbiSrc, pDataCompressed, &biDst, GWorldDataPtr);

					if (mErr != ICERR_OK) {
						sprintf(strStatus, "ReadVideoFrame Error - ICDecompress: err= %d", mErr);
						return NULL;
					}

				} else {
					err = DecompressSequenceFrameWhen(m_seqID,
						(Ptr)pDataCompressed, m_lRawFrameSize, 0, NULL, NULL, NULL);

					if (err != noErr) {
						sprintf(strStatus, "FrameDecodeDeSqnc Error - DecompressSequenceFrameWhen: err= %d", err);
						return NULL;
					}
				}

				// Add decompressed frame to buffer
				// only use for avc1, broken on the mp4v sample I tried
				if (bContainsDisplayOffsets
						&& abs(frameNum - m_lLastFrameDecodeIdx) < frameBuffCount) {
					m_sFrameBuffer.frame = m_vFrameInfoDecode[m_lLastFrameDecodeIdx + 1].idx;
					UpdateFrameBuffer(GWorldDataPtr, m_sFrameBuffer.frame, true);
				}

				m_lLastFrameDecodeIdx++;
				//if (m_lPrevFrameNum + 1 == frameNum)
				//if (m_vFrameInfoDecode[m_lLastFrameDecodeIdx].idx == frameNum)
				//	break;
			} while (m_lLastFrameDecodeIdx < frameNum + frameBuffCount);
		} // end (isFrameInBuffer == -1) {

		isFrameInBuffer = IsFrameInBuffer(frameNum);

		if (isFrameInBuffer != -1) {
			// the frame is in the buffer at position isFrameInBuffer
			decompressData = m_vFrameBuffer[isFrameInBuffer].data;
		}
	}

	// Need to figure out offsets for Avid Codecs in VFW mode
	int offset = 0;
	//if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVmp'))
	//	offset = 10;

	if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
		if (m_iRowOrder == 0) {// || bVFW) {
			for (i = m_vTrackFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
				memcpy(&pData[j * dst_pitch], &decompressData[i * m_iModRowsize], m_iRowsize);
			}
		} else {
			for (i = 0; i < m_vTrackFrame.bottom; i++) {
				memcpy(&pData[i * dst_pitch], &decompressData[i * m_iModRowsize], m_iRowsize);
			}
		}
	} else {
		if (m_iRowOrder == 0) {
			for (i = m_vTrackFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
				memcpy(&pData[j * dst_pitch], &decompressData[i * m_iModRowsize], m_iRowsize);
			}
		} else {
			for (i = 0; i < m_vTrackFrame.bottom; i++) {
				memcpy(&pData[i * dst_pitch], &decompressData[i * m_iModRowsize], m_iRowsize);
			}
		}
	}

	*rawSize = m_lRawFrameSize;
	m_lPrevFrameNum = frameNum;	
	return m_iRowsize * m_vTrackFrame.bottom;
}