//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

extern frameDataStruct frameData;

static void QT_ICM_Decode_Frame(
	void *decompressionTrackingRefCon,
	OSStatus result,
	ICMDecompressionTrackingFlags decompressionTrackingFlags,
	CVPixelBufferRef pixelBuffer,
	TimeValue64 displayTime,
	TimeValue64 displayDuration,
	ICMValidTimeFlags validTimeFlags,
	void *reserved,
	void *sourceFrameRefCon)
{
	OSStatus err = noErr;
	int w, h;

	if (kICMDecompressionTracking_ReleaseSourceData & decompressionTrackingFlags) {
		free(sourceFrameRefCon);
	}

	if ((kICMDecompressionTracking_EmittingFrame & decompressionTrackingFlags) && pixelBuffer) {
		size_t width, height, rowBytes;
		void *baseAddr = NULL;
		CVPixelBufferLockBaseAddress(pixelBuffer, 0);

		rowBytes = CVPixelBufferGetBytesPerRow(pixelBuffer);
		baseAddr = CVPixelBufferGetBaseAddress(pixelBuffer);
		width = CVPixelBufferGetWidth(pixelBuffer);
		height = CVPixelBufferGetHeight(pixelBuffer);

		byte *pTemp = (byte *)baseAddr;
		//frameData.pData = (byte *)baseAddr;

		int offset1 = 0;
		int offset2 = 0;
		if (frameData.rowsize == rowBytes) {
			if (frameData.pixelFormat == k24RGBPixelFormat) {
				for (h = 0; h < frameData.height; h++) {
					offset1 = frameData.rowsize * h;
					for (int w = 0; w < frameData.rowsize; w+=3) {
						frameData.pData[offset1+w]   = pTemp[offset1+w+2];
						frameData.pData[offset1+w+1] = pTemp[offset1+w+1];
						frameData.pData[offset1+w+2] = pTemp[offset1+w];
					}
				}
			} else if (frameData.pixelFormat == k32ARGBPixelFormat) {
				for (h = 0; h < frameData.height; h++) {
					offset1 = frameData.rowsize * h;
					for (w = 0; w < frameData.rowsize; w+=4) {
						frameData.pData[offset1+w]   = pTemp[offset1+w+3];	//B
						frameData.pData[offset1+w+1] = pTemp[offset1+w+2];	//G
						frameData.pData[offset1+w+2] = pTemp[offset1+w+1];	//R
						frameData.pData[offset1+w+3] = pTemp[offset1+w];	//A
					}
				}
			} else {
				memcpy(frameData.pData, pTemp, frameData.height * rowBytes);
			}
		} else if (frameData.rowsize < rowBytes) {
			if (frameData.pixelFormat == k24RGBPixelFormat) {
				for (h = 0; h < frameData.height; h++) {
					offset1 = frameData.rowsize * h;
					offset2 = rowBytes * h;
					for (w = 0; w < frameData.rowsize; w+=3) {
						frameData.pData[offset1+w]   = pTemp[offset2+w+2];
						frameData.pData[offset1+w+1] = pTemp[offset2+w+1];
						frameData.pData[offset1+w+2] = pTemp[offset2+w];
					}
				}
			} else if (frameData.pixelFormat == k32ARGBPixelFormat) {
				for (h = 0; h < frameData.height; h++) {
					offset1 = frameData.rowsize * h;
					offset2 = rowBytes * h;
					for (w = 0; w < frameData.rowsize; w+=4) {
						frameData.pData[offset1+w]   = pTemp[offset2+w+3];
						frameData.pData[offset1+w+1] = pTemp[offset2+w+2];
						frameData.pData[offset1+w+2] = pTemp[offset2+w+1];
						frameData.pData[offset1+w+3] = pTemp[offset2+w];
					}
				}
			} else {
				for (h = 0; h < frameData.height; h++) {
					memcpy(&frameData.pData[h * frameData.rowsize], &pTemp[h * rowBytes], frameData.rowsize);
				}
			}
		}

		CVPixelBufferUnlockBaseAddress(pixelBuffer, 0);
	}
}

//From Quicktime
//http://developer.apple.com/qa/qa2005/qa1443.html

// Utility to set a SInt32 value in a CFDictionary
OSStatus SetNumberValue(CFMutableDictionaryRef inDict, CFStringRef inKey, SInt32 inValue)
{
	CFNumberRef number = CFNumberCreate(NULL, kCFNumberSInt32Type, &inValue);
	if (!number)
		return -1;

	CFDictionarySetValue(inDict, inKey, number);
	CFRelease(number);

	return noErr;
}
// Utility to add a SInt32 value in a CFDictionary
OSStatus AddNumberValue(CFMutableDictionaryRef inDict, CFStringRef inKey, SInt32 inValue)
{
	CFNumberRef number = CFNumberCreate(NULL, kCFNumberSInt32Type, &inValue);
	if (! number)
		return -1;

	CFDictionaryAddValue(inDict, inKey, number);
	CFRelease(number);

	return noErr;
}

// http://developer.apple.com/samplecode/ExampleIPBCodec/listing4.html
// Utility to add a double to a CFMutableinDict.
OSStatus 
addDoubleToDictionary(CFMutableDictionaryRef inDict, CFStringRef inKey, double inValue)
{
	CFNumberRef number = CFNumberCreate( NULL, kCFNumberDoubleType, &inValue );
	if (! number) 
		return -1;

	CFDictionaryAddValue(inDict, inKey, number);
	CFRelease(number);

	return noErr;
}

OSStatus CQTMovieDec::createDecompressionSession(
		ImageDescriptionHandle imageDesc,
		int width,
		int height,
		OSType pixelFormat,
		ICMDecompressionTrackingCallback trackingCallback,
		void *trackingRefCon,
		ICMDecompressionSessionRef *decompressionSessionOut )
{
	OSStatus err = noErr;
	CFNumberRef number = NULL;
	CFMutableDictionaryRef pixelBufferAttributes = NULL;
	ICMDecompressionSessionOptionsRef sessionOptions = NULL;
	ICMDecompressionTrackingCallbackRecord trackingCallbackRecord;

	//Pixel Buffer attributes
    pixelBufferAttributes = CFDictionaryCreateMutable(NULL, 0,
			&kCFTypeDictionaryKeyCallBacks, &kCFTypeDictionaryValueCallBacks);
    if (pixelBufferAttributes == NULL) {
		sprintf(strStatus, "createDecompressionSession, CFDictionaryCreateMutable");
		return -1;
	}

	//Failed
		//kYVU9PixelFormat
		//kYUV411PixelFormat
		//kYVYU422PixelFormat
		//kUYVY422PixelFormat
		// kYUV211PixelFormat
		//FOUR_CHAR_CODE('YV12')
	//


	//k32ARGBPixelFormat k24BGRPixelFormat kYUV420PixelFormat
	//pixelFormat = kYUV211PixelFormat ;
	//Success
		//k32ARGBPixelFormat
		//k24BGRPixelFormat
		//kYUVSPixelFormat		YUYV
		//kYUVUPixelFormat		UYVY
		//k2vuyPixelFormat		UYVY
		//k422YpCbCr8PixelFormat	UYVY
		//kYUV420PixelFormat		UYVY
		//
	//
	OSType pixelFormat2 = pixelFormat;

	if (pixelFormat2 == k24BGRPixelFormat)
		pixelFormat2 = k24RGBPixelFormat; //k24RGBPixelFormat
	else if (pixelFormat2 == k32BGRAPixelFormat)
		pixelFormat2 = k32ARGBPixelFormat; //k32ARGBPixelFormat

	frameData.pixelFormat = pixelFormat2;

	err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferPixelFormatTypeKey, pixelFormat2);
		//if(err != noErr) {sprintf(strStatus, "format = %d", err);
	err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferWidthKey, width);
		//if(err != noErr) {sprintf(strStatus, "width = %d", err);
	err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferHeightKey, height);
		//if(err != noErr) {sprintf(strStatus, "height = %d", err);
	//err = SetNumberValue(pixelBufferAttributes, kCVPixelBufferBytesPerRowAlignmentKey, 2);
		//if(err != noErr) {sprintf(strStatus, "align = %d", err);
	err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferCGBitmapContextCompatibilityKey, false);
	err = AddNumberValue(pixelBufferAttributes, kCVPixelBufferCGImageCompatibilityKey, false);
	//err = SetNumberValue(pixelBufferAttributes, kCVPixelBufferExtendedPixelsTopKey, 0);
	//err = SetNumberValue(pixelBufferAttributes, kCVPixelBufferExtendedPixelsRightKey, 0);
	//err = SetNumberValue(pixelBufferAttributes, kCVPixelBufferExtendedPixelsBottomKey, 0);
	//err = SetNumberValue(pixelBufferAttributes, kCVPixelBufferExtendedPixelsLeftKey, 0);

#ifdef QT_GAMMA
	// This changes the display gamma for mode=3
	// the following causes YUY2 dvc codec to decompress corretly
	if (m_fGamma > 0) {
		//err = addDoubleToDictionary(pixelBufferAttributes, kCVImageBufferGammaLevelKey, m_fGamma);
		//CFDictionaryAddValue(pixelBufferAttributes, kCVImageBufferYCbCrMatrixKey, kCVImageBufferYCbCrMatrix_ITU_R_601_4);
	}

	NCLCColorInfoImageDescriptionExtension nclc;

	err = ICMImageDescriptionGetProperty(imageDesc, 
		kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_NCLCColorInfo, 
		sizeof(nclc), &nclc, NULL);
	if (noErr == err) {
		// Assume NTSC

		nclc.colorParamType = kVideoColorInfoImageDescriptionExtensionType;
		nclc.primaries = kQTPrimaries_SMPTE_C;
		nclc.transferFunction = kQTTransferFunction_ITU_R709_2; //kQTTransferFunction_ITU_R709_2 kQTTransferFunction_Unknown
		nclc.matrix = kQTMatrix_ITU_R_601_4; //kQTMatrix_ITU_R_601_4 kQTMatrix_Unknown
		ICMImageDescriptionSetProperty(imageDesc, 
			kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_NCLCColorInfo, 
			sizeof(nclc), &nclc);

		Fixed gammalevel;
		ICMImageDescriptionGetProperty(imageDesc, 
			kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_GammaLevel, 
			sizeof(gammalevel), &gammalevel, NULL);

		gammalevel = kQTUsePlatformDefaultGammaLevel;
		//gammalevel = kQTCCIR601VideoGammaLevel;

		//ICMImageDescriptionSetProperty(imageDesc, 
		//	kQTPropertyClass_ImageDescription, kICMImageDescriptionPropertyID_GammaLevel, 
		//	sizeof(gammalevel), &gammalevel);

		//err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
        //                                      kQTPropertyClass_ICMDecompressionSessionOptions,
        //                                      kICMImageDescriptionPropertyID_NCLCColorInfo,
        //                                      sizeof(nclc),
        //                                      &nclc);
	}
#endif

	trackingCallbackRecord.decompressionTrackingCallback = trackingCallback;
	trackingCallbackRecord.decompressionTrackingRefCon = trackingRefCon;

	CodecQ codecAccuracy = m_CodecInfo.quality;
	//codecLowQuality codecHighQuality
	ICMFieldMode fieldMode = kICMFieldMode_BothFields; //kICMFieldMode_DeinterlaceFields
	//kICMFieldMode_BothFields, kICMFieldMode_TopFieldOnly, kICMFieldMode_BottomFieldOnly
	err = ICMDecompressionSessionOptionsCreate(NULL, &sessionOptions);

	// set accuracy
    err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
                                              kQTPropertyClass_ICMDecompressionSessionOptions,
                                              kICMDecompressionSessionOptionsPropertyID_Accuracy,
                                              sizeof(CodecQ),
                                              &codecAccuracy);
		//if(err != noErr) {sprintf(test, "qaulity = %d", err);}
    // set field mode
    err = ICMDecompressionSessionOptionsSetProperty(sessionOptions,
                                              kQTPropertyClass_ICMDecompressionSessionOptions,
                                              kICMDecompressionSessionOptionsPropertyID_FieldMode,
                                              sizeof(ICMFieldMode),
                                              &fieldMode);
		//if(err != noErr) {sprintf(test, "field = %d", err);}

	err = ICMDecompressionSessionCreate( NULL, imageDesc, sessionOptions,
				(CFDictionaryRef)pixelBufferAttributes, &trackingCallbackRecord,
				decompressionSessionOut );
		//if(err != noErr) {sprintf(test, "create = %d", err);}

	//////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////
	/*err = SGGetChannelTimeScale(_channel, &_timeScale);
	require_noerr(err, bail);

	_imageDescription = (ImageDescriptionHandle)NewHandle(0);
	err = SGGetChannelSampleDescription(_channel, Handle(_imageDescription));
	require_noerr(err, bail);

	err = ICMDecompressionSessionCreateForVisualContext(NULL,
		imageDesc, NULL, _visualContext, &trackingCallbackRecord, decompressionSessionOut);*/
	//////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////

	if (err != noErr)
		sprintf(strStatus, "createDecompressionSession Error: %d", err);

	if (pixelBufferAttributes)
		CFRelease(pixelBufferAttributes);
	if (sessionOptions)
		ICMDecompressionSessionOptionsRelease(sessionOptions);

	return err;
}

OSErr CQTMovieDec::InitDecodeICM()
{
	OSErr err;

	frameData.pData = (byte *)malloc(maxCompressedSize);
	//frameData.pData = NULL;
	frameData.height = m_vTrackFrame.bottom;
	frameData.rowsize = m_iRowsize;
	frameData.width = m_vTrackFrame.right;

	err = createDecompressionSession(m_imageDesc,
				m_vTrackFrame.right, m_vTrackFrame.bottom,
				m_pixelFormat, QT_ICM_Decode_Frame, NULL,
				&decompressionSession);

	if (err != noErr)
		sprintf(strStatus, "InitDecodeICM Error: %d", err);

	return err;
}

int CQTMovieDec::FrameDecodeICM(long frameNum, TimeValue frameNumTime, byte *pData, int dst_pitch, int *rawSize)
{
	OSErr err;
	int i, j;

	SInt64 syncSampleNumber, nextSampleNumber, targetSampleNumber, targetSampleNumberDisplay;
	TimeValue64 targetDecodeTime, syncDecodeTime;
	TimeValue64 targetDisplayTime, sampleDisplayTime;
	int m_iInitCount = 5;

	targetSampleNumber = frameNum + 1;


	SampleNumToMediaDecodeTime(m_vMedia, targetSampleNumber, &targetDecodeTime, NULL);

	//targetDecodeTime = m_vFrameInfoDecode[frameNum].timeDecode;
	//targetDisplayTime = m_vFrameInfoDisplay[frameNum].timePlay;
	//SampleNumToMediaDisplayTime( m_vMedia, targetSampleNumber, &targetDisplayTime, NULL);
	SampleNumToMediaDecodeTime(m_vMedia, targetSampleNumber, &targetDisplayTime, NULL);
	MediaDisplayTimeToSampleNum(m_vMedia, targetDisplayTime, &targetSampleNumberDisplay, NULL, NULL);

	if (frameNum == 0) {
		targetSampleNumberDisplay = 1;
		//m_iInitCount = 0;
	}

	SampleNumToMediaDisplayTime(m_vMedia, targetSampleNumberDisplay, &targetDisplayTime, NULL);

	GetMediaNextInterestingDecodeTime( m_vMedia,
		nextTimeSyncSample | nextTimeEdgeOK,
		targetDecodeTime,
		-fixed1,
		&syncDecodeTime,
		NULL );

	MediaDecodeTimeToSampleNum(m_vMedia, syncDecodeTime, &syncSampleNumber, NULL, NULL);

	// Pick the starting point.
	if (((m_lLastFrameDecodeIdx + 1 <= targetSampleNumber)
			&& (syncSampleNumber < m_lLastFrameDecodeIdx + 1))
			/*|| m_lPrevFrameNum + 1 == frameNum*/) {
		nextSampleNumber = m_lLastFrameDecodeIdx + 1;
	} else {
		nextSampleNumber = syncSampleNumber;
		if (m_lPrevFrameNum + 1 != frameNum) {
			ICMDecompressionSessionFlush(decompressionSession);
			//m_iInitCount = 0;
		}
	}

	for( ; (nextSampleNumber <= targetSampleNumber && nextSampleNumber < m_vMovieFrameCount)
				|| m_iInitCount < 5; nextSampleNumber++ ) {
		TimeValue64 sampleDecodeTime;
		ByteCount sampleDataSize = 0;
		MediaSampleFlags sampleFlags = 0;
		UInt8 *sampleData = NULL;
		ICMFrameTimeRecord frameTime = {0};

		// Get the frame's data size and sample flags.  
		SampleNumToMediaDecodeTime( m_vMedia, nextSampleNumber, &sampleDecodeTime, NULL );
		SampleNumToMediaDisplayTime( m_vMedia, nextSampleNumber, &sampleDisplayTime, NULL );

		//sampleDecodeTime = m_vFrameInfoDecode[nextSampleNumber-1].timeDecode;
		//sampleDisplayTime = m_vFrameInfoDecode[nextSampleNumber-1].timePlay;
		err = GetMediaSample2( m_vMedia, NULL, 0, &sampleDataSize, sampleDecodeTime,
				NULL, NULL, NULL, NULL, NULL, 1, NULL, &sampleFlags );

		if (err != noErr) {
			sprintf(strStatus, "FrameDecodeICM GetMediaSample2 Error: %d", err);
			return 0;
		}

		if ((nextSampleNumber != targetSampleNumber) && (mediaSampleDroppable & sampleFlags)
				&& (m_iInitCount == 5)) {
			continue;
		}

		*rawSize = sampleDataSize;

		// Load the frame.
		sampleData = (UInt8 *)malloc( sampleDataSize );
		err = GetMediaSample2( m_vMedia, sampleData, sampleDataSize, NULL, sampleDecodeTime,
				NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL );

		if (err != noErr) {
			sprintf(strStatus, "FrameDecodeICM GetMediaSample2 Error: %d", err);
			return 0;
		}

		// Set up an immediate decode request -- we don't care about frame times, we just need to pass a flag.
		frameTime.recordSize = sizeof(ICMFrameTimeRecord);
		*(TimeValue64 *)&frameTime.value = sampleDisplayTime; //sampleDecodeTime;
		frameTime.scale = m_vMediaTimeScale; //GetMediaTimeScale( m_vMedia );
		frameTime.rate = fixed1;
		frameTime.frameNumber = nextSampleNumber;

		// If we haven't reached the target sample, tell the session not to emit the frame.
		//if (nextSampleNumber != targetSampleNumber)
		//	frameTime.flags = icmFrameTimeDoNotDisplay;

		frameTime.flags |= icmFrameTimeIsNonScheduledDisplayTime;

		// Decode the frame. 
		err = ICMDecompressionSessionDecodeFrame( decompressionSession, 
				sampleData, sampleDataSize, NULL, &frameTime, sampleData );

		if (err != noErr) {
			sprintf(strStatus, "ICMDecompressionSessionDecodeFrame Error: %d", err);
			return 0;
		}
		m_lLastFrameDecodeIdx = nextSampleNumber;

		//Make sure to grab a few extra frames when first opening a movie
		if (m_iInitCount < 5) {
			m_iInitCount++;
		}
	}

	// Pull decoded frame out.
	err = ICMDecompressionSessionSetNonScheduledDisplayTime(
		decompressionSession, targetDisplayTime, m_vMediaTimeScale, 0 );
	if (err != noErr) {
		sprintf(strStatus, "ICMDecompressionSessionSetNonScheduledDisplayTime Error: %d", err);
		return 0;
	}

	if (frameData.pData) {
		if (m_pixelFormat == k24BGRPixelFormat || m_pixelFormat == k32BGRAPixelFormat) {
			if (m_iRowOrder == 0 || bVFW) {
				for (i = m_vTrackFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
					memcpy(&pData[j * dst_pitch], &frameData.pData[i * m_iModRowsize], m_iRowsize);
				}
			} else {
				for (i = 0; i < m_vTrackFrame.bottom; i++) {
					memcpy(&pData[i * dst_pitch], &frameData.pData[i * m_iModRowsize], m_iRowsize);
				}
			}
		} else {
			for (i = 0; i < m_vTrackFrame.bottom; i++) {
				memcpy(&pData[i * dst_pitch], &frameData.pData[i * m_iModRowsize], m_iRowsize);
			}
		}

		m_lPrevFrameNum = frameNum;	
		return m_iRowsize * m_vTrackFrame.bottom;
	}

	return 0;
}