//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

extern myFrameBuffer				m_sFrameBuffer;
extern vector<myFrameBuffer>		m_vFrameBuffer;

int CQTMovieDec::Init_VFW(char *strFourCC)
{
	int mColorSpaceArray[4];
	int mColorSpace = -1;
	pbiSrc = (BITMAPINFOHEADER *)malloc(sizeof(BITMAPINFOHEADER));

	pbiSrc->biSize = sizeof(BITMAPINFOHEADER);
	pbiSrc->biWidth = m_vTrackFrame.right;
	pbiSrc->biHeight = m_vTrackFrame.bottom;
	pbiSrc->biPlanes = 1;
	pbiSrc->biBitCount = (**m_imageDesc).depth;
	pbiSrc->biSizeImage = 0;
	pbiSrc->biXPelsPerMeter = 0;
	pbiSrc->biYPelsPerMeter = 0;
	pbiSrc->biClrUsed = 0;
	pbiSrc->biClrImportant  = 0;

	// try to decompress to YV12, YUY2, RGB32, and RGB24 in turn
	memset(&biDst, 0, sizeof(BITMAPINFOHEADER));
	biDst.biSize = sizeof(BITMAPINFOHEADER);
	biDst.biWidth = pbiSrc->biWidth;
	biDst.biHeight = pbiSrc->biHeight;
	biDst.biPlanes = 1;

	if (m_pixelFormat == k32BGRAPixelFormat) { //RGB32
		mColorSpaceArray[0] = 1;
		mColorSpaceArray[1] = 0;
		mColorSpaceArray[2] = 2;
		mColorSpaceArray[3] = 3;
	} else if (m_pixelFormat == kYUVSPixelFormat) { //YUY2
		mColorSpaceArray[0] = 2;
		mColorSpaceArray[1] = 3;
		mColorSpaceArray[2] = 0;
		mColorSpaceArray[3] = 1;
	} else if (m_pixelFormat == kYUV420PixelFormat) { //YV12
		mColorSpaceArray[0] = 3; //kMpegYUV420CodecType
		mColorSpaceArray[1] = 2;
		mColorSpaceArray[2] = 0;
		mColorSpaceArray[3] = 1;
	} else { //RGB24
		mColorSpaceArray[0] = 0;
		mColorSpaceArray[1] = 1;
		mColorSpaceArray[2] = 2;
		mColorSpaceArray[3] = 3;
	}

	m_DecoderCodecInfo = m_CodecInfo;

	int fourCC_Count = 1;
	if (strcmp(strFourCC, "") != 0
		&& strcmp(strFourCC, " ") != 0
		&& strcmp(strFourCC, "  ") != 0 ) {
		pbiSrc->biCompression = mmioStringToFOURCC(strFourCC, 0);
	} else {
		//Standardize the fourCC codes
		if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVdv')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvc ')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvcp')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvpp'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('dv25');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dv5n')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dv5p'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('dv50');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVRn')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVDJ')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVRn')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('jpeg')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('mjpa')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('mjpb'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('mjpg');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AV1x')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVUI')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('2Vuy')
					|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('2vuy'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('uyvy');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVmp'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('mpg2');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('yuv2'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('yuv2'); //YUYV, +YVYU, +UYVY, +VYUY
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('png '))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('mpng');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('mp4v'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('mp4v');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('rle '))
			//m_CodecInfo.m_iFourCC = 0x524C4534;//0x34454C52; RLE4
			//m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('RLE8'); //0x38454C52 = 0x524C4538
			//m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('mrle');
			//m_CodecInfo.m_iFourCC = 0x524C4538;//0x38454C52; RLE8
			m_DecoderCodecInfo.m_iFourCC = 0x32315659;//0x38454C52; RLE8
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('raw ')) {
			if (m_pixelFormat == k32BGRAPixelFormat)
				m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('RGB3');
				//m_CodecInfo.m_iFourCC = 0x41424752;
			else if (m_pixelFormat == kYUVSPixelFormat)
				m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('uyvy');
			else if (m_pixelFormat == kYUV420PixelFormat)
				m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('yv12');
			else
				m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('RGB2');
				//m_CodecInfo.m_iFourCC = 0x52474232;//0x32424752;
		} else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('avc1'))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('H264');
		else if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('rle '))
			m_DecoderCodecInfo.m_iFourCC = FOUR_CHAR_CODE('RLE4');

		pbiSrc->biCompression = MAKEFOURCC(
			(m_DecoderCodecInfo.m_iFourCC & 0xFF000000) >> 24,
			(m_DecoderCodecInfo.m_iFourCC & 0x00FF0000) >> 16,
			(m_DecoderCodecInfo.m_iFourCC & 0x0000FF00) >> 8,
			(m_DecoderCodecInfo.m_iFourCC & 0x000000FF) );
	}

	for (int h = 0; h < fourCC_Count; h++) {
		for (int i = 0; i < 4; i++) {
			if (mColorSpaceArray[i] == 0) {
			//RGB24
				biDst.biCompression = BI_RGB;
				biDst.biBitCount = 24;
				biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 3;
			} else if (mColorSpaceArray[i] == 1) {
			//RGB32
				biDst.biCompression = BI_RGB;
				biDst.biBitCount = 32;
				biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 4;
			} else if (mColorSpaceArray[i] == 2) {
			//YUY2
				biDst.biCompression = MAKEFOURCC('Y','U','Y','2');//'2YUY';
				biDst.biBitCount = 16;
				//biDst.biSizeImage = ((biDst.biWidth * 2+3)&~3) * biDst.biHeight;
				biDst.biSizeImage = biDst.biWidth * biDst.biHeight * 2;
			} else {
			//YV12
				biDst.biCompression = MAKEFOURCC('Y','V','1','2'); //'21VY';
				biDst.biBitCount = 12;
				//int xwidth=(biDst.biWidth+3)&(~3);
				//biDst.biSizeImage = xwidth * biDst.biHeight + ((xwidth>>1) * biDst.biHeight);
				biDst.biSizeImage = biDst.biWidth * biDst.biHeight * biDst.biBitCount / 8;
				//biDst.biSizeImage = (biDst.biWidth * biDst.biHeight)
				//	+ (biDst.biWidth >> 1) * (biDst.biHeight >> 1) * 2;
				biDst.biPlanes = 3;
			}

			hic = ICLocate(ICTYPE_VIDEO, NULL, pbiSrc, &biDst, ICMODE_DECOMPRESS);
			if (hic) {
				// For some reason, on my system ICLocate always
				// returns successfully, even for bogus FourCC codes
				// this attmpets to detect that and reject it
				// Does not really work, though
				// Blackmagic r210 always says it can decode my format

				// Skip this compressor if it can't handle the format. 
				if (ICDecompressQuery(hic, pbiSrc, NULL) != ICERR_OK) { 
					ICClose(hic);
					hic = NULL;
					continue;
				}

				/*ICINFO icinfo;
				ICGetInfo(hic, &icinfo, sizeof(icinfo));

				if (icinfo.dwSize == icinfo.fccHandler == icinfo.dwFlags) {
					ICClose(hic);
					hic = NULL;
					continue;
				}*/

				// Make sure the VFW codec can actually decompress our video
				// Unfortunately, if you have the Black Magic Codecs installed
				// They will always succeed here
				DWORD mErr = ICDecompressBegin(hic, pbiSrc, &biDst);
				if (mErr != ICERR_OK) {
					sprintf(strStatus, "Unable to begin VFW decompression for \"%c%c%c%c\", err = %d",
						(m_DecoderCodecInfo.m_iFourCC & 0xFF000000) >> 24,
						(m_DecoderCodecInfo.m_iFourCC & 0x00FF0000) >> 16,
						(m_DecoderCodecInfo.m_iFourCC & 0x0000FF00) >> 8,
						(m_DecoderCodecInfo.m_iFourCC & 0x000000FF), mErr);
					ICClose(hic);
					hic = NULL;
					continue;
				}

				pbiSrc->biSizeImage = m_lRawFrameSize;
				mErr = ICDecompress(hic, 0, pbiSrc, pDataCompressed/*(byte *)m_compressedDataPtr*/, &biDst, GWorldDataPtr);
				if (mErr != ICERR_OK) {
					ICDecompressEnd(hic);
					ICClose(hic);
					hic = NULL;
					continue;
				}
				//}

				mColorSpace = mColorSpaceArray[i];
				if (mColorSpace == 0)
					m_pixelFormat = k24BGRPixelFormat;
				else if (mColorSpace == 1)
					m_pixelFormat = k32BGRAPixelFormat;
				else if (mColorSpace == 2)
					m_pixelFormat = kYUVSPixelFormat;
				else if (mColorSpace == 3)
					m_pixelFormat = kYUV420PixelFormat;
				break;
			}
		}
		if (hic)
			break;
	}

	m_DecoderCodecInfo.m_iFourCC = MAKEFOURCC(
		(pbiSrc->biCompression & 0xFF000000) >> 24,
		(pbiSrc->biCompression & 0x00FF0000) >> 16,
		(pbiSrc->biCompression & 0x0000FF00) >> 8,
		(pbiSrc->biCompression & 0x000000FF) );

	if (! hic) {
		sprintf(strStatus, "Did not find a suitable VFW codec for \"%c%c%c%c\"",
			(m_DecoderCodecInfo.m_iFourCC & 0xFF000000) >> 24,
			(m_DecoderCodecInfo.m_iFourCC & 0x00FF0000) >> 16,
			(m_DecoderCodecInfo.m_iFourCC & 0x0000FF00) >> 8,
			(m_DecoderCodecInfo.m_iFourCC & 0x000000FF));
		return -1;
	}

	m_DecoderCodecInfo.strFourCC[3] = (pbiSrc->biCompression & 0xFF000000) >> 24;
	m_DecoderCodecInfo.strFourCC[2] = (pbiSrc->biCompression & 0x00FF0000) >> 16;
	m_DecoderCodecInfo.strFourCC[1] = (pbiSrc->biCompression & 0x0000FF00) >> 8;
	m_DecoderCodecInfo.strFourCC[0] = (pbiSrc->biCompression & 0x000000FF);

	bVFW = true;
	return mColorSpace;
}

OSErr CQTMovieDec::InitDecodeVFW(char *strFourCC)
{
	OSErr err;

	// variables that hold quicktime frame data
	GWorldDataPtr = (byte *)malloc(m_vTrackFrame.bottom * m_vTrackFrame.right * 4.5);
	pDataCompressed = (byte *)malloc(m_vTrackFrame.bottom  * m_vTrackFrame.right * 4.5);

	m_compressedData = NewHandle(maxCompressedSize);
	if (m_compressedData==NULL) {
		sprintf(strStatus, "Unable to Allocate Memory");
		return -1;
	}

	MoveHHi(m_compressedData);
	HLock(m_compressedData);
	m_compressedDataPtr = StripAddress(*m_compressedData);

	//m_lRowBytes = QTGetPixMapHandleRowBytes(m_PixMap);
	//m_decompressedDataPtr = GetPixBaseAddr(m_PixMap);

	ItemCount numberOfSamples = 0;

	err = GetMediaSample2(
		m_vMedia,
		(UInt8*)pDataCompressed,
		maxCompressedSize,
		(ByteCount*)&m_lRawFrameSize,
		0,
		NULL, //(TimeValue64*)&sampleTime,
		NULL, //(TimeValue64*)&durationPerSample,
		NULL,
		NULL,
		NULL, //(ItemCount*)&sampleDescriptionIndex,
		1, //maxNumberOfSamples,
		&numberOfSamples,
		NULL); // (MediaSampleFlags*)&sampleflags);
	/*err = GetMediaSample (
		m_vMedia,
		m_compressedData,
		maxCompressedSize,
		&m_lRawFrameSize,
		0,
		NULL,
		NULL,
		NULL, //sampleDescriptionH,
		NULL,
		1, //maxNumberOfSamples
		&numberOfSamples,
		NULL);*/

	if (err != noErr) {
		sprintf(strStatus, "InitDecodeVFW GetMediaSample Error: %d", err);
		return -1;
	}

	if (m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('AVdv')
				|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvc ')
				|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvcp')
				|| m_CodecInfo.m_iFourCC == FOUR_CHAR_CODE('dvpp')) {

		if (m_lRawFrameSize > 144000) {
			m_CodecInfo.m_iFourCC = FOUR_CHAR_CODE('dv50');
		}
	}

	int mColor = Init_VFW(strFourCC);
	if (mColor == -1) {
		//sprintf(strStatus, "Could not init VFW\n%s", strStatus);
		return -1;
	}

	return noErr;
}
