//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

bool CQTMovieDec::SetUpMovieAudioExtraction()
{
	OSStatus err = noErr;

	if (m_AudioExtractor) {
		MovieAudioExtractionEnd(m_AudioExtractor);
		m_AudioExtractor = NULL;

		if (ioData) {
			for (int i = 0; i < ioData->mNumberBuffers; i++) {
				QT_FREE_BUFFER(ioData->mBuffers[i].mData);
			}
			free(ioData);
			ioData = NULL;
		}
	}

	MovieAudioExtractionBegin(m_Movie, 0, &m_AudioExtractor);

	AudioChannelLayout *layout = NULL;
	UInt32 size = 0;
	err = MovieAudioExtractionGetPropertyInfo(m_AudioExtractor,
		kQTPropertyClass_MovieAudioExtraction_Audio,
		kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
		NULL, &size, NULL);
	if (err == noErr) {
		// Allocate memory for the channel layout
		layout = (AudioChannelLayout *)calloc(1, size);
		if (layout == nil) {
			err = memFullErr;
			sprintf(strStatus, "Unable to Allocate outputAudio Memory");
			return false;
		}

		// Get the layout for the current extraction configuration.
		// This will have already been expanded into channel descriptions.
		err = MovieAudioExtractionGetProperty(m_AudioExtractor,
			kQTPropertyClass_MovieAudioExtraction_Audio,
			kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
			size, layout, nil);

		if (layout->mChannelLayoutTag == kAudioChannelLayoutTag_MPEG_5_1_B
				|| layout->mChannelLayoutTag == kAudioChannelLayoutTag_MPEG_5_1_C
				|| layout->mChannelLayoutTag == kAudioChannelLayoutTag_MPEG_5_1_D
				|| layout->mChannelLayoutTag == kAudioChannelLayoutTag_Hexagonal) {
			layout->mChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_1_A;
		}

		err = MovieAudioExtractionSetProperty(m_AudioExtractor,
				kQTPropertyClass_MovieAudioExtraction_Audio,
				kQTMovieAudioExtractionAudioPropertyID_AudioChannelLayout,
				size, layout);

		free(layout);
	}

	err = MovieAudioExtractionGetProperty(m_AudioExtractor,
		kQTPropertyClass_MovieAudioExtraction_Audio,
		kQTMovieAudioExtractionAudioPropertyID_AudioStreamBasicDescription,
		sizeof(m_ASBD), &m_ASBD, nil);

	dest_format.sampleCount = m_ASBD.mSampleRate * (Float64)GetMediaDuration(m_aMedia) / (Float64)m_aMediaTimeScale;

	m_ASBD.mFormatID = kAudioFormatLinearPCM; //kAudioFormatFlagIsSignedInteger
	m_ASBD.mFormatFlags = kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked //kAudioFormatFlagIsFloat
		| kAudioFormatFlagIsNonInterleaved | kAudioFormatFlagsNativeEndian;
	//m_ASBD.mFormatFlags = kAudioFormatFlagsNativeFloatPacked | kAudioFormatFlagIsNonInterleaved;
	if (m_ASBD.mBitsPerChannel > 16)
		m_ASBD.mBitsPerChannel = sizeof(SInt16) * 8;
	//m_ASBD.mChannelsPerFrame = dest_format.numChannels < 3 ? dest_format.numChannels : 2; //2
	//m_ASBD.mChannelsPerFrame = 6;
	m_ASBD.mBytesPerPacket = m_ASBD.mBitsPerChannel / 8; //per channel
	m_ASBD.mFramesPerPacket = 1;
	m_ASBD.mBytesPerFrame = m_ASBD.mBitsPerChannel / 8; //per channel

	/*m_ASBD.mFormatID = kAudioFormatLinearPCM;
	m_ASBD.mFormatFlags = kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked
		| kAudioFormatFlagIsNonInterleaved | kAudioFormatFlagsNativeEndian;
	m_ASBD.mChannelsPerFrame = dest_format.numChannels < 3 ? dest_format.numChannels : 2; //2
	m_ASBD.mBitsPerChannel = 2 * 8;
	m_ASBD.mBytesPerPacket = sizeof(SInt16) *  m_ASBD.mChannelsPerFrame / 2;
	m_ASBD.mFramesPerPacket = 1;
	m_ASBD.mBytesPerFrame = sizeof(SInt16) * m_ASBD.mChannelsPerFrame / 2;*/

	dest_format.numChannels = m_ASBD.mChannelsPerFrame;
	dest_format.sampleSize = m_ASBD.mBitsPerChannel;
	dest_format.sampleRate = (int)m_ASBD.mSampleRate << 16;

	/*sprintf(strStatus, "mFormatID=%d, mFormatFlags=%d, mBytesPerPacket=%d\n"
		"mFramesPerPacket=%d, mBytesPerFrame=%d, mChannelsPerFrame=%d\n"
		"mBitsPerChannel=%d, mSampleRate=%f, mChannelLayoutTag=%d",
		m_ASBD.mFormatID,
		m_ASBD.mFormatFlags,
		m_ASBD.mBytesPerPacket,
		m_ASBD.mFramesPerPacket,
		m_ASBD.mBytesPerFrame,
		m_ASBD.mChannelsPerFrame,
		m_ASBD.mBitsPerChannel,
		m_ASBD.mSampleRate,
		layout->mChannelLayoutTag);*/

	/*
	m_ASBD.mFormatID = kAudioFormatLinearPCM;
	m_ASBD.mFormatFlags = kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked
		| kAudioFormatFlagIsNonInterleaved;
	m_ASBD.mBytesPerFrame = sizeof(SInt16) * m_ASBD.mChannelsPerFrame;
	m_ASBD.mBytesPerPacket = m_ASBD.mBytesPerFrame;
	//m_ASBD.mChannelsPerFrame = 2;
	m_ASBD.mBitsPerChannel = 16;
	m_ASBD.mSampleRate = 44100;
	*/

	/*
	m_ASBD.mFormatFlags = kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked
		| kAudioFormatFlagsNativeEndian;
	m_ASBD.mBytesPerFrame = sizeof(SInt16) * m_ASBD.mChannelsPerFrame;
	m_ASBD.mBytesPerPacket = m_ASBD.mBytesPerFrame;
	*/

	/*
	41 = kLinearPCMFormatFlagIsFloat | kAudioFormatFlagIsPacked | kAudioFormatFlagIsNonInterleaved;
	44 = kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked | kAudioFormatFlagIsNonInterleaved;
	//Format IDs
	kAudioFormatLinearPCM = 'lpcm'
	kAudioFormatAC3 = 'ac-3'
	kAudioFormat60958AC3 ='cac3'
	kAudioFormatMPEG = 'mpeg'
	kAudioFormatAppleIMA4 = 'ima4'
	kAudioFormatMPEG4AAC = 'aac '
	kAudioFormatMPEG4CELP = 'celp'
	kAudioFormatMPEG4HVXC = 'hvxc'
	kAudioFormatMPEG4TwinVQ = 'twvq'
	kAudioFormatTimeCode = 'time'
	kAudioFormatMIDIStream = 'midi'
	kAudioFormatParameterValueStream = 'apvs'

	//Format Flags
	kAudioFormatFlagIsFloat = (1L << 0)
	kAudioFormatFlagIsBigEndian = (1L << 1)
	kAudioFormatFlagIsSignedInteger = (1L << 2)
	kAudioFormatFlagIsPacked = (1L << 3)
	kAudioFormatFlagIsAlignedHigh = (1L << 4)
	kAudioFormatFlagIsNonInterleaved = (1L << 5)
	kAudioFormatFlagsAreAllClear = (1L << 31)

	//Linear PCM flags:
	kLinearPCMFormatFlagIsFloat = kAudioFormatFlagIsFloat
	kLinearPCMFormatFlagIsBigEndian = kAudioFormatFlagIsBigEndian
	kLinearPCMFormatFlagIsSignedInteger = kAudioFormatFlagIsSignedInteger
	kLinearPCMFormatFlagIsPacked = kAudioFormatFlagIsPacked
	kLinearPCMFormatFlagIsAlignedHigh = kAudioFormatFlagIsAlignedHigh
	kLinearPCMFormatFlagIsNonInterleaved = kAudioFormatFlagIsNonInterleaved
	kLinearPCMFormatFlagsAreAllClear = kAudioFormatFlagsAreAllClear
	*/

	err = MovieAudioExtractionSetProperty( m_AudioExtractor,
			kQTPropertyClass_MovieAudioExtraction_Audio,
			kQTMovieAudioExtractionAudioPropertyID_AudioStreamBasicDescription,
			sizeof(m_ASBD),
			&m_ASBD);

	UInt32 ioNumFrames = QT_MAX_AUDIO_SAMPLES;//m_ASBD.mSampleRate / 2;
	UInt32 outFlags = 0, theSize;

	//ioData = (AudioBufferList *)calloc(1, offsetof (AudioBufferList, mBuffers[asbd.mChannelsPerFrame]));
	ioData = (MyAudioBufferList *)calloc( 1, sizeof(MyAudioBufferList) + sizeof(MyAudioBuffer) * m_ASBD.mChannelsPerFrame);

	ioData->mNumberBuffers = m_ASBD.mChannelsPerFrame;
	for (int i = 0; i < ioData->mNumberBuffers; i++) {
		ioData->mBuffers[i].mNumberChannels = 1;
		ioData->mBuffers[i].mDataByteSize = ioNumFrames * m_ASBD.mBytesPerFrame;// / m_ASBD.mChannelsPerFrame;
		ioData->mBuffers[i].mData = (byte *)malloc(ioData->mBuffers[i].mDataByteSize);
	}

	return true;
}

long CQTMovieDec::ReadAudioFrame(byte *pData, __int64 frameNum, __int64 count, unsigned int *m_iBytesConverted)
{
	OSErr err = noErr;

	*m_iBytesConverted = 0;

	//if (frameNum == 0)
	//	SetUpMovieAudioExtraction();

	UInt32 ioNumFrames = 4096;
	UInt32 FramesRead = 0;
	int frames_left = (int)count;
	UInt32 outFlags = 0;
	TimeRecord timeRec;

	timeRec.scale = GetAudioSampleRate();
	timeRec.base = NULL;
	timeRec.value.hi = 0;
	timeRec.value.lo = frameNum;

	err = MovieAudioExtractionSetProperty(m_AudioExtractor,
		kQTPropertyClass_MovieAudioExtraction_Movie,
		kQTMovieAudioExtractionMoviePropertyID_CurrentTime,
		sizeof(TimeRecord), &timeRec);

	while (frames_left > 0
			&& !(outFlags & kQTMovieAudioExtractionComplete)
			&& ioNumFrames != 0) {
		ioNumFrames = QT_MAX_AUDIO_SAMPLES;
		err = MovieAudioExtractionFillBuffer(m_AudioExtractor, &ioNumFrames,
			(AudioBufferList *)ioData, &outFlags);

		if (noErr != noErr) {
			sprintf(strStatus, "\nUnable to read audio samples: err = %d\n", err);
			return 0;
		}

		for (int i = 0; i < (ioNumFrames > frames_left ? frames_left : ioNumFrames) * m_ASBD.mBytesPerFrame; i+=m_ASBD.mBytesPerFrame) {
			for (int c = 0; c < ioData->mNumberBuffers; c++) {
				//memcpy(pData, &chan[c][i], m_ASBD.mBytesPerFrame);
				memcpy(pData, &ioData->mBuffers[c].mData[i], m_ASBD.mBytesPerFrame);
				pData += m_ASBD.mBytesPerFrame;
				*m_iBytesConverted += m_ASBD.mBytesPerFrame;
			}
		}

		FramesRead += ioNumFrames > frames_left ? frames_left : ioNumFrames;
		frames_left -= ioNumFrames;
	}

	if (outFlags & kQTMovieAudioExtractionComplete)
		SetUpMovieAudioExtraction();

	return FramesRead;
}